/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 * bdimage - aug 26/91 Doug Horn no longer works for MSC.  He is now self      
 *           employed.  Also the new server is bd_server which is Doug's
 *           xsd_server1 frozen in time for all eternity.  The source for
 *           xsd_server1 is in bd_server unchanged.  We also changed the
 *           amoco_read_data (parameter list) to stop input of unrequired
 *           (for now) header data.
 * bdimage - update april 5/91 to output xsdH and xsdI files
 *           also odd pixel width code added 
 *           xsdH info updated to latest (ie. add units)
 *           default re,ne,se now from line header
 *
 * bdimage - routine to generate rasterfile for input to xsd graphics display
 *           program.  This is release 1.01, Feb 25/91 (Kuwait independance)
 *
 * Written by Paul G. A. Garossino.  Code largely plagerized from xsd routine
 * written by Douglas Horn of MSC. For use with xsdtweak script.
 *
 */

#include <fcntl.h>
#include <cu.h>
#include <cu_defs.h>
#include <ut_defs.h>
#include <argsys.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>


/*
 * header structure for rasterfiles
 */

struct rasterfile {
        int     ras_magic;              /* magic number */
        int     ras_width;              /* width (pixels) of image */
        int     ras_height;             /* height (pixels) of image */
        int     ras_depth;              /* depth (1, 8, or 24 bits) of pixel */
        int     ras_length;             /* length (bytes) of image */
        int     ras_type;               /* type of file; see RT_* below */
        int     ras_maptype;            /* type of colormap; see RMT_* below */
        int     ras_maplength;          /* length (bytes) of following map */
};

/*
 * The header if followed by a color map for ras_maplength bytes, and then
 * the image
 */

#define RAS_MAGIC       0x59a66a95

        /* Sun supported ras_type's */

#define RT_OLD          0       /* Raw pixrect image in 68000 byte order */
#define RT_STANDARD     1       /* Raw pixrect image in 68000 byte order */
#define RT_BYTE_ENCODED 2       /* Run-length compression of bytes */
#define RT_EXPERIMENTAL 0xffff  /* Reserved for testing */

        /* Sun registered ras_maptype's */

#define RMT_RAW         2

        /* Sun supported ras_maptype's */
 
#define RMT_NONE        0       /* ras_maplength is expected to be 0 */
#define RMT_EQUAL_RGB   1       /* red[ras_maplength/3],green[],blue[] */

/*
 * NOTES:
 *      Each line of the image is rounded out to a multiple of 16 bits.
 *   This corresponds to the rounding convention used by the memory pixrect
 *   package (/usr/include/pixrect/memvar.h) of the SunWindows system.
 *      The ras_encoding field (always set to 0 by Sun's supported software)
 *   was renamed to ras_length in release 2.0.  As a result, rasterfiles
 *   of type 0 generated by the old software claim to have 0 length; for
 *   compatibility, code reading rasterfiles must be prepared to compute the
 *   true length from the width, height, and depth fields.
 */



/*
 * xsd header file structure
 */

  struct show_data {
   char time[6];
   char date[6];
   float scale_x,scale_y;
   float pick_x,pick_y;
   float axis_units[3];         /* Units for axis */
   float axis_offset[3];        /* Offsets for axis. */
   int offset;
   float scalar;                /* Offset and scalar for value returning. */
   int label_flag;              /* Indicates if labels should be drawn. */
   int axis;                    /* Indicates if axis labels are on. */
   int sort;                    /* Indicates if data is sorted. */
   char filename[1024];         /* Filename of data display. */
   char type[10];               /* Type of window (i.e. Image, Wiggle,...) */
   char comment[40];            /* Comment field. */
  };



/*
 *
 *  main program 
 *  verbose is defined global to be used in client.c
 *
 */

  int verbose;                    /* output flag */

main( argc, argv )
int argc;
char **argv;
{

  FILE *xsdout;                    /* xsd headerfile file descriptor  */
 
  struct rasterfile header;        /* rasterfile structure */
  struct show_data xdisplay;       /* headerfile structure */
  struct tm *t;                    /* time structure */
  struct stat statbuf;             /* file status structure */

  time_t second;


  int out;                        /* rasterfile file descriptor */ 
  int n;                          /* loop indices */
  int nrec;                       /* number of records */
  int ntrc;                       /* number of traces */
  int nsmp;                       /* number of samples */
  int error;                      /* error handler */
  int lheader[8192];              /* buffer for line header */
  int buf1[4];                    /* buffer to handle cray int wordsize */
  char buf[1024];                 /* buffer for unix command arguments */
  unsigned char *raster;          /* rasterfile buffer */
  unsigned char color[256];       /* colormap buffer */
  unsigned char *traceH;          /* trace header buffer */

    extern float amoco_scalar();
    extern int amoco_offset();

/* 
 * command line args
 */

  int rs;                          /* record start */
  int re;                          /* record end */
  int ri;                          /* record increment */
  int ns;                          /* trace start */
  int ne;                          /* trace end */
  int ni;                          /* trace increment */
  int ss;                          /* sample start */
  int se;                          /* sample end */
  int si;                          /* sample increment */
  float scale;                     /* scalar multiplier */
  char filein[1024];               /* input filename */
  char image[1024];                /* name of image  */
  char headname[1024];             /* xsd headerfile name */
  char machine[100];               /* machine name */
  char user[100];                  /* user name */
  char comment[100];               /* comment for xsd header file */

/*
 * set up cmdln call with defaults
 * (i just changed &argv to argv because Joe told me to)
 */

  argi4("-rs", &rs, 1, 1, &argc, argv);
  argi4("-re", &re, 0, 0, &argc, argv);
  argi4("-ri", &ri, 1, 1, &argc, argv);
  argi4("-ns", &ns, 1, 1, &argc, argv);
  argi4("-ne", &ne, 0, 0, &argc, argv);
  argi4("-ni", &ni, 1, 1, &argc, argv);
  argi4("-ss", &ss, 1, 1, &argc, argv);
  argi4("-se", &se, 0, 0, &argc, argv);
  argi4("-si", &si, 1, 1, &argc, argv);
 
  argr4("-S", &scale, 1.0, 1.0, &argc, argv);

  argstr("-N", filein, "no input filename", "no input filename", &argc, argv);
  argstr("-M", machine, "=", "=", &argc, argv);
  argstr("-I", image, "no image name", "no image name", &argc, argv);
  argstr("-H", headname, "no output xsd headerfile name", "no output headerfile name", &argc, argv);
  argstr("-U", user, "no user given", "no user given", &argc, argv);
  argstr("-C", comment, "no comment input", "no comment input", &argc, argv);

/*
 * examine command line input for necessary input, if not then kill routine
 */
 
  if( strcmp(filein,"no input filename" ) == 0 )
  {
    printf("%s FATAL\n",filein);
    exit(0);
  }
  if( strcmp(headname,"no output headerfile name" ) == 0 )
  {
    printf("%s FATAL\n",headname);
    exit(0);
  }
  if( strcmp(image,"no image name" ) == 0 )
  {
    printf("%s FATAL\n",image);
    exit(0);
  }
  if( strcmp(user,"no user given" ) == 0 )
  {
    printf("%s FATAL\n",user);
    exit(0);
  }

/*
 * organize names for header file and image subdirectory
 */

    strcpy(buf,headname);
    strcat(buf,".xsdI");
    strcat(headname,".xsdH");

/* 
 *  make new directory, change directory then open rasterfile
 */
 
  mkdir(buf,0755);
  chdir(buf);

  out=open(image,O_RDWR|O_CREAT,0666);

/*
 * start server and get data 
 */
 
#ifdef CRAY
/*
 * set machine type to 1 for Cray2
 */

  amoco_start_server(machine,user,"bd_server","1");

#else
/*
 * set machine type to 0 for Sun4
 */

  amoco_start_server(machine,user,"bd_server","0");

#endif

  amoco_color_range(54,253);
  error = amoco_read_line_header(&lheader[0],filein);

  if(error==-1)
   {
    printf(" Cannot read line header in file %s\n",filein);
    printf(" FATAL\n");
    exit(-1);
   }    

/*
 * assign defaults from line header if required
 */

   if(re == 0)
    {
      C_SAVER(lheader,"NumRec",&re,0);
    }

   if(ne == 0)
    {
      C_SAVER(lheader,"NumTrc",&ne,0);
    }

   if(se == 0)
    {
      C_SAVER(lheader,"NumSmp",&se,0);
    }

/*
 *  verbose output
 */

  if(argis("-V",&argc,argv)!=0)
   {
     printf(" filein = %s\n",filein);
     printf(" image = %s\n",image);
     printf(" headname = %s\n",headname);
     printf(" rs = %d\n",rs);
     printf(" re = %d\n",re);
     printf(" ri = %d\n",ri);
     printf(" ns = %d\n",ns);
     printf(" ne = %d\n",ne);
     printf(" ni = %d\n",ni);
     printf(" ss = %d\n",ss);
     printf(" se = %d\n",se);
     printf(" si = %d\n",si);
     printf(" xsd scale factor = %f\n",scale);
     printf(" machine = %s\n",machine);
     printf(" user = %s\n",user);
     verbose = 1;
   }

/* ----- load header data ------ */

  nrec = ((re-rs)/ri)+1;
  ntrc = ((ne-ns)/ni)+1;
  nsmp = ((se-ss)/si)+1;

  header.ras_magic=RAS_MAGIC;
  header.ras_width=nrec*ntrc;
  header.ras_height=nsmp;
  header.ras_depth=8;

/*
 * change to determine if width is even number of pixels
 */

  if (header.ras_width%2 == 0)
    header.ras_length=header.ras_width*header.ras_height;
  else
    header.ras_length=(header.ras_width+1)*header.ras_height;

  header.ras_type=RT_STANDARD;
  header.ras_maptype=RMT_EQUAL_RGB;
  header.ras_maplength=768;

/* shrink integer wordsize if on cray so that image header still
 * makes sense
 */

#ifdef CRAY

  buf1[0] = (header.ras_magic<<32)+(header.ras_width&0xffffffff);
  buf1[1] = (header.ras_height<<32) + (header.ras_depth&0xffffffff);
  buf1[2] = (header.ras_length<<32) + (header.ras_type&0xffffffff);
  buf1[3] = (header.ras_maptype<<32) + (header.ras_maplength&0xffffffff);

/*
 * write out CRAY2 header
 */

  write(out,buf1,32);

#else

/*
 * write out SUN header
 */

  write(out,header,sizeof(header));

#endif

/*
 * write out colour map
 */

  for (n=0; n<=255; n++)
  color[n]=(unsigned char)n;
  write(out,color,256);
  write(out,color,256);
  write(out,color,256);

/*
 * assign memory for rasterfile and trace header
 */

  raster=(unsigned char *)malloc(header.ras_width*header.ras_height*sizeof(char)
);
 
  traceH=(unsigned char *)malloc(1*sizeof(char));


  amoco_read_data(raster,traceH,filein,rs,re,ri,ns,ne,ni,ss,se,si,1,0,scale,0,0);

/*
 * the 1,0,scale,0,0 at the end of the amoco_read_data argument list refer to
 * the scale type,(1 = maximum 2 = fixed),offset,scale factor (which
 * is the scale factor you would enter as scalar on the xsd get data form)
 * The two zeros at the end are a sort flag (0 is the xsd default), and a 
 * trace header retrieval flag (0 is no header, 1 is get the headerf)
 *
 */

/*
 * handle odd number of pixel image problem
 */

  if (header.ras_width%2 == 0)
    write(out,raster,header.ras_width*header.ras_height*sizeof(char));
  else
    for (n=0; n<header.ras_height; n++) {
      write(out,(raster+n*header.ras_width),header.ras_width*sizeof(char));
      write(out,raster,1);
    }

/*
 * close server and rasterfile
 */

  amoco_end_server();
  close(out);

/*
 * load up xsd headerfile structure
 */

  xdisplay.offset = amoco_offset();
  xdisplay.scalar = amoco_scalar();
  xdisplay.sort = 0;
  xdisplay.axis = 1;
  xdisplay.pick_x = 1.0;
  xdisplay.pick_y = 1.0;
  xdisplay.axis_units[0] = 1.0;
  xdisplay.axis_units[1] = 1.0;
  xdisplay.axis_units[2] = 1.0;
  xdisplay.axis_offset[0] = 0.0;
  xdisplay.axis_offset[1] = 0.0;
  xdisplay.axis_offset[2] = 0.0;
  sscanf(filein,"%s\n",xdisplay.filename);
  sscanf(comment,"%s\n",xdisplay.comment);
  time(&second);
  t=localtime(&second);
  sprintf(xdisplay.time,"%02d:%02d",t->tm_hour,t->tm_min);
  sprintf(xdisplay.date,"%02d/%02d",t->tm_mon,t->tm_mday);
  sprintf(xdisplay.type,"Image");


/*
 * print xsd headerfile entries for verbose option
 */

  if(verbose)
   {
    printf("File: %s\n",xdisplay.filename);
    printf("Comment: %s\n",xdisplay.comment);
    printf("Type: %s\n",xdisplay.type);
    printf("Sort: %d\n",xdisplay.sort);
    printf("Axis: %d\n",xdisplay.axis);
    printf("Record: %d %d %d %d\n",nrec,rs,re,ri);
    printf("Trace: %d %d %d %d\n",ntrc,ns,ne,ni);
    printf("Sample: %d %d %d %d\n",nsmp,ss,se,si);
    printf("Value: %d %e\n",xdisplay.offset,xdisplay.scalar);
    printf("Scale: %f %f\n",1.0/xdisplay.pick_x,1.0/xdisplay.pick_y);
    printf("Units: %f %f %f %f %f %f\n",xdisplay.axis_units[0],
            xdisplay.axis_units[1],xdisplay.axis_units[2],
            xdisplay.axis_offset[0],xdisplay.axis_offset[1],
            xdisplay.axis_offset[2]);
    printf("Time: %s\n",xdisplay.time);
    printf("Date: %s\n",xdisplay.date);
    printf("Image: %s\n",image);
    printf("End:\n");
   }

/* 
 * change back one directory
 */

  strcpy(buf,"..");
  chdir(buf);
/*
 * determine if headerfile exists
 */

   error = stat(headname,&statbuf);

/*
 * open xsd headerfile
 */

  xsdout = fopen(headname,"a+");
  if (xsdout == NULL) {
     printf("Cannot open file %s\n",headname);
     exit(0);
  }

/*
 * if first edition of headname then put in append line for Doug's 
 * routine to be able to add images later.  This must be on the first
 * line of the header file only.
 */
  
   if (error != 0) 
    {
      error = 0;
      fprintf(xsdout,"Append: %5d\n",error);
    }

/*
 * write output header file
 */

    fprintf(xsdout,"File: %s\n",xdisplay.filename);
    fprintf(xsdout,"Comment: %s\n",xdisplay.comment);
    fprintf(xsdout,"Type: %s\n",xdisplay.type);
    fprintf(xsdout,"Sort: %d\n",xdisplay.sort);
    fprintf(xsdout,"Axis: %d\n",xdisplay.axis);
    fprintf(xsdout,"Record: %d %d %d %d\n",nrec,rs,re,ri);
    fprintf(xsdout,"Trace: %d %d %d %d\n",ntrc,ns,ne,ni);
    fprintf(xsdout,"Sample: %d %d %d %d\n",nsmp,ss,se,si);
    fprintf(xsdout,"Value: %d %e\n",xdisplay.offset,xdisplay.scalar);
    fprintf(xsdout,"Scale: %f %f\n",1.0/xdisplay.pick_x,1.0/xdisplay.pick_y);
    fprintf(xsdout,"Units: %f %f %f %f %f %f\n",xdisplay.axis_units[0],
            xdisplay.axis_units[1],xdisplay.axis_units[2],
            xdisplay.axis_offset[0],xdisplay.axis_offset[1],
            xdisplay.axis_offset[2]);
    fprintf(xsdout,"Time: %s\n",xdisplay.time);
    fprintf(xsdout,"Date: %s\n",xdisplay.date);
    fprintf(xsdout,"Image: %s\n",image);
    fprintf(xsdout,"End:\n");

/*
 *  Close output file and end
 */

  close(xsdout);
}
