C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SFOLD(NX,LX,X,ist,LSF,SF,NY,Y,nsamp)
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   
C        FORTRAN BY KEN PEACOCK  5-3-88                                 
C     SFOLD PERFORMS A SPATIAL CONVOLUTION OF A RECORD OF DATA WITH A   
C     1-D SPATIAL OPERATOR.                                             
C        INPUTS ARE...                                                  
C             NX, NUMBER OF TRACES.                                     
C             LX, LENGTH OF TRACES, SAMPLES.                            
C             X, A MATRIX OF INPUT DATA.                                
C             LSF, SPATIAL LENGTH OF FILTER, SAMPLES.                   
c             ist, start sample of filter operation
C             SF, THE SPATIAL OPERATOR.                                 
C             NY, NUMBER OF OUTPUT TRACES, NY = NX+LSF-1.               
C             Y, THE MATRIX OF OUTPUT DATA.                             
C     VERSION AS OF 5-3-88.                                             
C                                                                       
#include <f77/lhdrsz.h>
c     DIMENSION X(SZSMPM,SZSPRD),SF(*),Y(SZSMPM,SZSPRD+50)
      DIMENSION X(nsamp,nx),SF(*),Y(nsamp,ny)

#ifndef CRAYSYSTEM

      DO 5 L=ist,LX                                                       

      DO 1 J=1,NY                                                       
         Y(L,J) = 0.                                                       
1     continue

      DO 3 I=1,LSF                                                      
      IM1 = I-1                                                         
      DO 2 J=1,NX                                                       
           K = J+IM1                                                         
           Y(L,K) = Y(L,K)+SF(I)*X(L,J)                                      
2        continue
3     continue

5     continue

      RETURN                                                            
      END                                                               

#else			/* here's the Cray code */

      dimension A2(SZSMPM),B(SZSMPM+50),C(SZSMPM+50)
      DO 3 L=ist,LX                                                       
      call move(0,c,0,ny*8)
      do 5 j=1,nx
        b(nx+1-j) = x(l,j)
    5 continue
      call move(0,a2,0,nx*8)
      call move(1,a2(nx+1),sf,lsf*8)
      call move(0,a2(nx+lsf+1),0,nx*8)
      la2 = ny + nx
      call filterg(b,nx,a2,la2,c)
      do 10 i=1,ny
        y(l,i) = c(i)
   10 continue
    3 CONTINUE                                                          
      RETURN                                                            
      END                                                               

#endif
