C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ....................................................................
c
c [headerscan]  is a routine to retrieve the following header
c               information:
c	    	max time
c               gap
c		group int
c  		number of channels
c		sample rate
c 		number of records
c               number of samples
c
c
c	in addition the following is computed:
c
c		near trace flag
c                 
c 	data is output to a flat file and picked up by fetch*
c       in the xsdtweak script.
c ....................................................................
c
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c-----
 
      integer itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec
      integer     luin, lbytes, nbytes
      integer     irs,ns,dist2,gap,gint
      integer     ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer     ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer     ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum
      integer     argis,le1
      
      real        time, ggint, unitsc

      character   chgint*4
      character   ntap * 255,otap * 255,name * 9
      character*1 tr1

      logical     verbos
 
      data lbytes / 0 /
      data nbytes / 0 /
      data name/'HEADRSCAN'/
      
c
c ----- ----- PROGRAM START ----- -----
c     read program parameters from command line card image file
c
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif
c

#include <f77/open.h>

      call gcmdln(ntap,otap,le1,ns,irs,verbos)
c
c     get logical unit number for input of seismic data
c     0 = default stdin
c
      call getln(luin , ntap,'r', 0)
c
c     read line header of input
c     save certain parameters
c
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'HEADERSCAN: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'GrpInt',chgint, LINHED)
      call saver(itr, 'OrNTRC', ntrc , LINHED)
      call saver(itr, 'UnitSc', unitsc , LINHED)

      read(chgint,'(F4.0)') ggint
      gint = ifix(abs(ggint))

c build pointers to trace header entries

      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )
      call savelu ( 'DstSgn', ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     TRACEHEADER )
c
c
c  open output file
c
      open (3,file=otap(1:le1),status='unknown',err=990)
c
c
c     BEGIN PROCESSING
c
c     skip unwanted records
c
      call recskp(1,irs-1,luin,ntrc,itr)
c
c     process 2 adjacent records
c
 
c
c  skip to start trace
c
            call trcskp(irs,1,ns-1,luin,ntrc,itr)
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',irs,'  trace= ',ns
                     go to 999
                  endif

                  call saver2 ( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                 DstSgn, TRACEHEADER )
                  call saver2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                 RecNum, TRACEHEADER )
                  call saver2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :                 TrcNum, TRACEHEADER )
c
	if(verbos) then
           write(LERR,*)'DstSgn = ',DstSgn
           write(LERR,*)'RecNum = ',RecNum
           write(LERR,*)'TrcNum = ',TrcNum
	endif
c
C-----------------------------------------------------------------------TEN00500
c	do next trace
c
c
                  call rtape( luin, itr, nbytes)
c
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',irs,'  trace= ',ns+1
                     go to 999
                  endif

                  call saver2 ( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :                 dist2, TRACEHEADER )
                  call saver2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                 RecNum, TRACEHEADER )
                  call saver2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :                 TrcNum, TRACEHEADER )

c
       if(verbos) then
          write(LERR,*)'dist2 = ',dist2
          write(LERR,*)'RecNum = ',RecNum
          write(LERR,*)'TrcNum = ',TrcNum
       endif
c
c       calculate group interval
c
        gint = iabs(gint)

c -----
c
c	determine trace orientation
c
	if(iabs(dist2).gt.iabs(DstSgn)) then
		tr1 = 'n'
		gap = iabs(DstSgn)
	else
		tr1 = 'f'

		gap = iabs(DstSgn) - (ntrc -1)*iabs(gint)
		if(gap.lt.0) then
        ggint = abs(ggint)
	gap = iabs(DstSgn) -ifix(float(ntrc -1)*(ggint-0.5))
                if(gap.lt.0)gap = iabs(gap)
		endif
	endif
c
c	calculate max time
c
	time = float( ( nsamp-1 ) * nsi) * unitsc
c
c	output required data
c
	write(3,*) time
        write(3,*) gap
        write(3,*) gint
        write(3,*) ntrc
        write(3,*) nsi
        write(3,*) tr1
        write(3,*) nrec
        write(3,*) nsamp
c
c	normal termination of routine
c
  999 continue
      call lbclos ( luin )
            write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
        close(3)
      stop
c
c	error messages
c
990	write(LERR,*) ' error openning output file'
	stop
      end
C--------------START OF SUBROUTINES ------------------
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'----------------------------------------------------------------'
        write(LER,*) ' '
        write(LER,*)
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start trace number'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
C-----------------------------------------------------------------------TEN00500
     :'usage: headerscan -N[ntap] -O[otap]  -ns[ns] -rs[irs] -V '
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
c 
c
c
      subroutine gcmdln(ntap,otap,le1,ns,irs,verbos)
c
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     le1   - I*4      length of output name
c     ns    - I*4      starting trace index
c     irs   - I*4      starting record index
c     verbos  L        verbose output or not
c
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns,irs
      logical     verbos
      integer     argis
c
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            le1 = lenth(otap)
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            verbos =   (argis('-V') .gt. 0)
c 
      return
      end
