C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine readpick ( lupick, nsegs, index, rectrc, picks, record,
     :     total_picks )

#include <f77/iounit.h>

      integer lupick,nsegs,index(5000,1),nelem,count
      integer pointer, total_picks
    
      real picks(total_picks), rectrc(total_picks), rec_units, trc_units
      real samp_units

      character junk*1

      logical record

c
c ----- initialize counters -----
c
      
      count = 1
      nelem = 0
      nsegs = 1
      pointer = 0

c
c ----- rewind file -----
c

      rewind lupick

c
c ----- read past file header -----
c

      read(lupick,'(a1,4x,3f13.7)')junk,rec_units,trc_units,samp_units

c 
c ----- read past segment header -----
c

      read(lupick,'(a1)',end=900)junk

c
c ----- read first segment -----
c

 1    read(lupick,'(a1)',end=20)junk

      if(junk.ne.'S') then

         nelem = nelem + 1
         goto 1

      else

         index(nsegs,1) = nelem

         write(LERR,*) ' segment number : ', nsegs 
         write(LERR,*) ' number of elements : ', nelem 

c
c -----	advance segment register and reset element counter -----
c

         nsegs = nsegs + 1
         nelem = 0

c
c ----- start next segment -----
c

         goto 1

      endif

c
c ----- have reached end of pick file -----
c	assign number of elements for last segment

 20   index(nsegs,1) = nelem
      
      write(LERR,*) ' segment number : ', nsegs 
      write(LERR,*) ' number of elements : ', nelem 

c
c -----	now know total number of segments -----
c       and number of elements in each
c
	
      rewind lupick
c	
c ----- read and load each segment -----
c	

      read(lupick,'(a1)') ajunk

c	
c ----- SEGMENT LOOP -----
c	

      do 30 i = 1,nsegs

c
c		
c ----- read past segment header -----
c

         read(lupick,'(a1)') ajunk

c		
c ----- ELEMENT LOOP -----
c

         do 40 j = 1,index(i,1)

            if(record)then

c
c ----- multi-record single trace -----
c

               read(lupick,50,end=900)rectrc(count),picks(count)
 50            format(f12.0,14x,f12.0)

            else

c
c ----- multi-trace single record -----
c

               read(lupick,60,end=900)rectrc(count),picks(count)
 60            format(13x,f12.0,1x,f12.0)

            endif

c
c ----- advance the array element counter -----
c

            count = count + 1

 40      continue

 30   continue

 900  continue

c
c ----- sort picks into increasing order relative to rectrc()index -----
c

      do i = 1,nsegs

         pointer = pointer + 1

         call hsort2 (index(i,1),rectrc(pointer),picks(pointer))

         pointer = pointer + index(i,1) - 1

      enddo

      return
      end



