C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SlopeTime ( xsd_NumPoints, xsd_size, xsd_x_coords, 
     :     xsd_horizon_times, xsd_Segment, fx, tx, dt, dx, bail_out,    
     :     verbos )

c routine to examine the model segment requested and return
c a value of time, delta time and delta distance for the 
c analysis location on the horizon.  If the horizon does not
c exist at the analysis location the bail_out flag is set
c to .true.
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer xsd_Segment, xsd_size
      integer xsd_NumPoints(SZLNHD)

      real xsd_x_coords(xsd_size), xsd_horizon_times(xsd_size)

      real*8 fx, tx, dt, dx

      logical bail_out, verbos

c declare local variables

      integer i, pointer

      real*8 slope

c initialize variables

c determine if horizon is present at current analysis location [fx]
c if so determine time, and slope on the horizon at the analysis location

c determine location of segment in memory

      if ( xsd_segment .gt. 1 ) then
         pointer = 0 
         do i = 1, xsd_segment - 1
            pointer = pointer + xsd_NumPoints(i)
         enddo
      else
         pointer = 0
      endif

c determine if segment exists at analysis location

c function location before segment

      if ( sngl(fx) .lt. xsd_x_coords(pointer + 1) ) bail_out = .true.

c function location past segment

      if ( sngl(fx) .gt. 
     :     xsd_x_coords( pointer + xsd_NumPoints( xsd_segment ) ) ) 
     :     bail_out = .true.

c function location on segment, get required data

      if ( .not. bail_out ) then

c  find ground locations that bracket fx


         do  i = 1, xsd_NumPoints( xsd_segment )

            if ( xsd_x_coords( pointer + i ) .gt. sngl(fx) ) then

               dt = dble ( xsd_horizon_times( pointer + i ) - 
     :              xsd_horizon_times( pointer + i - 1 ) )
               dx = dble ( xsd_x_coords( pointer + i ) - 
     :              xsd_x_coords( pointer + i - 1 ) )
               slope = dt / dx
               tx = slope * 
     :              ( fx - dble( xsd_x_coords( pointer + i - 1 ) ) ) + 
     :              dble( xsd_horizon_times( pointer + i - 1 ) )

               if(verbos) then
                  write(LERR,*)' '
                  write(LERR,*)' Analysis Location ',fx
                  write(LERR,*)' Segment ',xsd_Segment
                  write(LERR,*)' -----------------------'
                  write(LERR,*)' '
                  write(LERR,*)' time = ',tx
                  write(LERR,*)' slope = ', slope
                  write(LERR,*)' '
               endif

               return

            endif
         
         enddo
      else

c no segment present at analysis location, return with bail_out flag
c set to .true.

         return
      endif

      end
