C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine VelocityInit(luvel, vel_NumFcns, vel_NumPoints, 
     :     vel_size )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer luvel, vel_NumFcns, vel_size
      integer vel_NumPoints(SZLNHD)

c declare local variables

      integer CardNumber, num_cards

c initialize variables

      vel_NumFcns = 0
      vel_size = 0
      num_cards = 0

      do while ( 1 .eq. 1 )

         read ( luvel, '(I1)', end=999, err=990 ) CardNumber
         vel_size = vel_size + 1
         num_cards = num_cards + 1

         if ( CardNumber .eq. 9 ) then
            vel_NumFcns = vel_NumFcns + 1
            vel_NumPoints(vel_NumFcns) = num_cards
            num_cards = 0
         endif
         
      enddo

 999  continue
      
      if ( vel_size .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' velocity model file appears to be empty'
         write(LERR,*)' correct model and resubmit'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVD: '
         write(LER,*)' velocity model file appears to be empty'
         write(LER,*)' correct model and resubmit'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      rewind ( luvel )

c adjust vel_size taking into account that there are a maximum of 
c 7 (t,v) entries per tdfn card      
      
      vel_size = vel_size * 7

      return

 990  continue

      write(LERR,*)' '
      write(LERR,*)' error reading velocity model file '
      write(LERR,*)' correct model and resubmit'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'TVD: '
      write(LER,*)' error reading velocity model file '
      write(LER,*)' correct model and resubmit'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop

      end

