C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln( vfile, mfile, Model_NumShots, Model_InitialShot, 
     :     Model_ShotIncrement, Data_MaxTime,
     :     Analysis_InitialShot,  Analysis_ShotIncrement, 
     :     Analysis_ShotpointEnd, c_BoatDirection, ShotInterval, 
     :     GroupInterval, Gap, OffsetFactor, Tweak, nchan, c_domain, 
     :     Model_SmoothingOrder, v0, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer Model_NumShots, Model_InitialShot
      integer Analysis_InitialShot, Analysis_ShotIncrement 
      integer Analysis_ShotpointEnd, nchan
      integer Model_SmoothingOrder

      real Model_ShotIncrement

      real*8 Data_MaxTime, ShotInterval, GroupInterval, Gap
      real*8 OffsetFactor, v0, Tweak

      character vfile*256, mfile*256, c_domain*14, c_BoatDirection*2

      logical verbos

c model parameters
c
c  -M
c  -mso
c  -mss
c  -mns
c  -msi
c
c velocity parameters
c  
c  -v0
c  -v
c  
c analysis parameters
c  
c  -ass
c  -ase
c  -asi
c  
c USP data parameters 
c  
c  -tmax
c  -gi
c  -gap
c  -si
c  -nchan
c  -dir
c  -dom
c  -tr
c  
c tvd parameters
c  
c  -tw
c  -opc
c  -sign
c  -V
c  

c parse command line

      call argi4 ( '-ase', Analysis_ShotpointEnd , 0, 0 )
      call argi4 ( '-asi', Analysis_ShotIncrement, 1, 1 )
      call argi4 ( '-ass', Analysis_InitialShot, 1, 1 )

      call argstr ( '-dir', c_BoatDirection , 'rl', 'rl' )
      call argstr ( '-dom', c_domain, 'shot', 'shot' )

      call argr8 ( '-gap', Gap, 0.d0, 0.d0 )
      call argr8 ( '-gi', GroupInterval, 12.d5, 12.d5 )

      call argi4 ( '-mns', Model_NumShots, 0, 0 )
      call argr4 ( '-msi', Model_ShotIncrement, 1.0, 1.0 )
      call argi4 ( '-mso', Model_SmoothingOrder, 0, 0 )
      call argi4 ( '-mss', Model_InitialShot, 1, 1 )
      call argstr ( '-M', mfile, ' ', ' ' )

      call argi4 ( '-nchan', nchan, 240, 240 )

      call argr8 ( '-opc', OffsetFactor, 1.d0, 1.d0 )

      call argr8 ( '-si', ShotInterval, 25.d0, 25.d0 )

      call argr8 ( '-tmax', Data_MaxTime, 0.d0 ,0.d0 )
      call argr8 ( '-tw', Tweak, 25.d0, 25.d0 )


      call argr8 ( '-v0', v0, 1500.d0, 1500.d0 )
      call argstr ( '-v', vfile, ' ', ' ' )
      verbos = ( argis('-V') .gt. 0)

c POLICEMEN if needed

      if ( Data_MaxTime .lt. 1.d0 ) then
         write(LERR,*)' '
         write(LERR,*)' You have not entered a maximum time for your'
         write(LERR,*)' model.  This is required, please use -tmax'
         write(LERR,*)' on the command line and resubmit'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVD: '
         write(LER,*)' You have not entered a maximum time for your'
         write(LER,*)' model.  This is required, please use -tmax'
         write(LER,*)' on the command line and resubmit'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      if ( c_domain .ne. 'shot' .and. c_domain .ne. 'receiver' ) then
         length = lenth(c_domain)
         write(LERR,*)' '
	 if (length .gt. 0) then
           write(LERR,*)' You have requested a solution for the ',
     :        c_domain(1:length)
	 else
           write(LERR,*)' You have not requested a solution for a ',
     :        'particular '
	 endif
         write(LERR,*)' domain.  This is illegal.  Please enter'
         write(LERR,*)' either [-dom shot] or [-dom receiver] on the'
         write(LERR,*)' command line and try again.'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVD: '
	 if (length .gt. 0) then
           write(LER,*)' You have requested a solution for the ',
     :        c_domain(1:length)
	 else
           write(LER,*)' You have not requested a solution for a ',
     :        'particular '
	 endif
         write(LER,*)' domain.  This is illegal.  Please enter'
         write(LER,*)' either [-dom shot] or [-dom receiver] on the'
         write(LER,*)' command line and try again.'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      if ( mfile .eq. ' ' ) then
         write(LERR,*)' '
         write(LERR,*)' The tvd routine is a model driven process.'
         write(LERR,*)' A -M entry is required on the command line'
         write(LERR,*)' Please enter the name of your xsd model'
         write(LERR,*)' pickfile on the command line and try again.'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVD: '
         write(LER,*)' The tvd routine is a model driven process.'
         write(LER,*)' A -M entry is required on the command line'
         write(LER,*)' Please enter the name of your xsd model'
         write(LER,*)' pickfile on the command line and try again.'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      if ( vfile .eq. ' ' ) then
         write(LERR,*)' '
         write(LERR,*)' The tvd routine is a model driven process.'
         write(LERR,*)' A -v entry is required on the command line'
         write(LERR,*)' Please enter the name of your tdfn velocity'
         write(LERR,*)' model file on the command line and try again.'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TVD: '
         write(LER,*)' The tvd routine is a model driven process.'
         write(LER,*)' A -v entry is required on the command line'
         write(LER,*)' Please enter the name of your tdfn velocity'
         write(LER,*)' model file on the command line and try again.'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

      return
      end
