C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DCBINT(N,X,U,UGRD,GX,S,FX,F0,ITYPE,SPACE,ALPHA,C,NCHAN)SUN01970
C***********************************************************************SUN01980
C     THIS SUBROUTINE CARRIES OUT LINE SEARCH ALONG THE DIRECTION OF    SUN01990
C     STEEPEST DESCENT, LOOKING FOR A MINIMUM OF A FUNCTION BY MEANS OF SUN02000
C     CUBIC INTERPOLATION.                                              SUN02010
C     THIS SUBROUTINE IS CALLED BY THE NON - LINEAR OPTIMISATION        SUN02020
C     SUBROUTINES, DFLTPL AND DBFLSH.                                   SUN02030
C     SEE FLETCHER, R AND POWELL, M.J.D., 1963, "A RAPIDLY CONVERGENT   SUN02040
C     DESCENT METHOD FOR MINIMIZATION," THE COMPUTER JOURNAL, VOL. 6,   SUN02050
C     PAGE 163.                                                         SUN02060
C*****SUBROUTINE INPUTS                                                 SUN02070
C     N = THE NUMBER OF INDEPENDENT VARIABLES.                          SUN02080
C     X = THE ARRAY OF INITIAL VALUES OF THE INDEPENDENT VARIABLES.     SUN02090
C     NC = THE NUMBER OF CONSTANTS IN THE FUNCTION, U                   SUN02100
C     C = THE ARRAY OF CONSTANTS USED IN THE FUNCTION, U                SUN02110
C     U = THE FUNCTION TO BE OPTIMISED. THIS IS AN EXTERNAL PROCEDURE   SUN02120
C         NAME IN THE MAIN PROGRAM.                                     SUN02130
C     UGRD = THE NAME OF THE SUBROUTINE THAT COMPUTES THE GRADIENT OF U.SUN02140
C            THIS IS AN EXTERNAL PROCEDURE NAME IN THE MAIN PROGRAM.    SUN02150
C     GX = THE ARRAY OF PARTIAL DERIVATIVES OF U AT THE POINT X(I).     SUN02160
C     S = THE ARRAY OF COMPONENTS IN THE SEARCH DIRECTION.              SUN02170
C     FX = THE VALUE OF U WITH VARIABLE VALUES GIVEN IN THE ARRAY, X.   SUN02180
C     F0 = THE ESTIMATED LOWER BOUND OF U.                              SUN02190
C     ITYPE = TYPE OF OPTIMISATION REQUIRED :-                          SUN02200
C             ITYPE = 1 FOR MAXIMISING                                  SUN02210
C             ITYPE = -1 FOR MINIMISING                                 SUN02220
C*****SUBROUTINE OUTPUTS                                                SUN02230
C     ALPHA = THE DISTANCE TO BE MOVED IN THE SEARCH DIRECTION TO REACH SUN02240
C             A MINIMUM                                                 SUN02250
C     SPACE = WORKING SPACE. SIZE OF SPACE = (4 * N)                    SUN02260
C*****SUBROUTINES REQUIRED                                              SUN02270
C     DZERO                                                             SUN02280
C     DMMOVE                                                            SUN02290
C     DSCAL1                                                            SUN02300
C     DMXADD                                                            SUN02310
C     DDDOT                                                             SUN02320
C*****PARTITION OF WORKING SPACE                                        SUN02330
C     SPACE(1 TO N) = THE ARRAY OF NEW VALUES OF X, XNEW(I)             SUN02340
C     SPACE(N + 1 TO 2 * N) = THE ARRAY OF VALUES OF THE POINT, Y IN    SUN02350
C                             THE SEARCH DIRECTION ON THE OTHER SIDE OF SUN02360
C                             THE MINIMUM FROM X.                       SUN02370
C     SPACE(2 * N + 1 TO 3 * N) = THE ARRAY OF PARTIAL DERIVATIVES, GY, SUN02380
C                                 OF THE FUNCTION, U AT THE POINT Y(I). SUN02390
C     SPACE(3 * N + 1 TO 4 * N) = THE ARRAY OF VALUES AT THE MINIMUM    SUN02400
C                                 POINT ALONG THE LINE BETWEEN X AND Y. SUN02410
C***********************************************************************SUN02420
C     THIS SUBROUTINE WAS WRITTEN BY M.D. BUSH, 1988                    SUN02430
C***********************************************************************SUN02440
      REAL*8 X(N),GX(N),S(N),SPACE(4 * N),C(99),U,FX,F0,ALPHA           SUN02450
      REAL*8 DOTXS,XNETA,DOTYS,XLAMB,Z,W,FALPHA,GRDYY,FY                SUN02460
      INTEGER ITYPE,IXNEW,IY,IGY,IMIN,IFLAG1,IFLAG2,IFLAG3,NCHAN        SUN02470
C***********************************************************************SUN02480
C     SET THE INITIAL ELEMENTS OF THE PARTITIONS OF THE WORKING SPACE TOSUN02490
C     FIT THE ARRAYS THAT ARE TO BE USED.                               SUN02500
C***********************************************************************SUN02510
      IXNEW = 1                                                         SUN02520
      IY = N + 1                                                        SUN02530
      IGY = IY + N                                                      SUN02540
      IMIN = IGY + N                                                    SUN02550
C***********************************************************************SUN02560
C     DETERMINE A SUITABLE VALUE OF XNETA TO GIVE A NEW POINT, Y IN THE SUN02570
C     DIRECTION OF SEARCH, SUCH THAT A MINIMUM IN THIS DIRECTION LIES   SUN02580
C     BETWEEN THE POINTS X AND Y.                                       SUN02590
C***********************************************************************SUN02600
      CALL DDDOT(N,GX,S,DOTXS)                                          SUN02610
      IF(DABS(DOTXS).EQ.DBLE(0.0).OR.DABS(DOTXS).LT.1.D-78) THEN        SUN02620
        XNETA = DBLE(1.0)                                               SUN02630
        GOTO 2                                                          SUN02640
        ELSE                                                            SUN02650
        XNETA = DMIN1(DBLE(1.0),DABS((F0 - FX) * DBLE(2.0) / DOTXS))    SUN02660
      ENDIF                                                             SUN02670
C***********************************************************************SUN02680
C     SET SEARCH STATUS FLAGS TO ZERO.                                  SUN02690
C     IFLAG1 = 1 WHEN THE SEARCH HAS NOT YET CROSSED A MINIMUM.         SUN02700
C     IFLAG2 = 1 WHEN THE SEARCH HAS CROSSED A MINIMUM BUT THE FUNCTION SUN02710
C                VALUE AT THE NEW POINT IS GREATER THAN AT THE INITIAL  SUN02720
C                POINT OF THE SEARCH.                                   SUN02730
C     IFLAG3 = 1 WHEN POINTS ON EACH SIDE OF THE MINIMUM HAVE BEEN FOUNDSUN02740
C                AND IF NECESSARY THE SUBROUTINE RETURNS THE MID - POINTSUN02750
C                OF THE TWO BRACKETING POINTS.                          SUN02760
C***********************************************************************SUN02770
      IFLAG1 = 0                                                        SUN02780
      IFLAG2 = 0                                                        SUN02790
      IFLAG3 = 0                                                        SUN02800
C***********************************************************************SUN02810
C     VERIFIES WHETHER THE MINIMUM HAS BEEN BRACKETED BY PREVIOUS VALUESSUN02820
C     AND COMMENCES THE SEARCH USING THE ALGORITHM IN THE APPENDIX OF   SUN02830
C     FLETCHER AND POWELL'S ARTICLE.                                    SUN02840
C***********************************************************************SUN02850
      XLAMB = XNETA                                                     SUN02860
    1 IF((IFLAG1 + IFLAG2).GT.1) THEN                                   SUN02870
        XNETA = (XLAMB + XNETA) / DBLE(2.0)                             SUN02880
        IFLAG1 = 0                                                      SUN02890
        IFLAG2 = 0                                                      SUN02900
        IFLAG3 = 1                                                      SUN02910
      ENDIF                                                             SUN02920
      CALL DMMOVE(N,S,SPACE(IXNEW))                                     SUN02930
      CALL DSCAL1(SPACE(IXNEW),N,XNETA)                                 SUN02940
      CALL DMXADD(X,SPACE(IXNEW),SPACE(IY),N,1)                         SUN02950
C***********************************************************************SUN02960
C     CALCULATE THE FUNCTION AND ITS GRADIENT AT THE POINT, Y.          SUN02970
C     CALCULATE THE MAGNITUDE, GRDYY OF THE GRADIENT AT Y.              SUN02980
C***********************************************************************SUN02990
      FY = U(C,SPACE(IY),NCHAN)                                         SUN03000
      CALL UGRD(C,SPACE(IY),SPACE(IGY),NCHAN)                           SUN03010
      CALL DDDOT(N,SPACE(IGY),SPACE(IGY),GRDYY)                         SUN03020
      CALL DDDOT(N,SPACE(IGY),S,DOTYS)                                  SUN03030
C***********************************************************************SUN03040
C     TEST TO SEE IF THE TOTAL ABSOLUTE GRADIENT AT THE POINT Y IS SMALLSUN03050
C     THIS OCCURS WHEN Y IS NEAR A FUNCTION MINIMUM FOR ALL VARIABLES.  SUN03060
C     IF THIS IS THE CASE THE SEARCH TERMINATES.                        SUN03070
C***********************************************************************SUN03080
      IF(GRDYY.LT.DBLE(1.0E-6)) THEN                                    SUN03090
        ALPHA = XNETA                                                   SUN03100
        GOTO 2                                                          SUN03110
C***********************************************************************SUN03120
C     TEST TO SEE IF THE FUNCTION VALUE AT THE POINT, Y ON THE OTHER    SUN03130
C     SIDE OF THE MINIMUM, IN THE SEARCH DIRECTION IS LESS THAN THE     SUN03140
C     VALUE AT X. IF THE MINIMUM HAS BEEN BRACKETED PREVIOUSLY THE      SUN03150
C     THE SEARCH WILL TERMINATE USING THE CURRENT POINT, Y AS THE NEW X.SUN03160
C     IF IT HAS NOT PREVIOUSLY BEEN CROSSED THE SEARCH WILL BE REPEATED SUN03170
C     WITH A SMALLER VALUE.                                             SUN03180
C***********************************************************************SUN03190
        ELSE IF((ITYPE.EQ.-1.AND.FY.GT.FX).OR.(ITYPE.EQ.1.AND.FY.LT.FX))SUN03200
     *THEN                                                              SUN03210
        IF(IFLAG3.EQ.1) THEN                                            SUN03220
          ALPHA = XNETA                                                 SUN03230
          GOTO 2                                                        SUN03240
        ENDIF                                                           SUN03250
        IFLAG2 = 1                                                      SUN03260
        IF(IFLAG1.EQ.0) THEN                                            SUN03270
          XLAMB = XNETA                                                 SUN03280
          XNETA = XNETA * DBLE(0.75)                                    SUN03290
        ENDIF                                                           SUN03300
        GOTO 1                                                          SUN03310
C***********************************************************************SUN03320
C     TEST TO SEE IF THE GRADIENT AT POINT Y AND THE GRADIENT AT X ARE  SUN03330
C     IN THE SAME DIRECTION. IF THEY ARE, A MINIMUM IN THE SEARCH       SUN03340
C     DIRECTION HAS NOT BEEN CROSSED. IF A MINIMUM HAS PREVIOUSLY BEEN  SUN03350
C     CROSSED AND THEY ARE IN THE SAME DIRECTION A MAXIMUM HAS ALSO BEENSUN03360
C     CROSSED AND THE SEARCH WILL TERMINATE AT THE CURRENT Y.           SUN03370
C***********************************************************************SUN03380
        ELSE IF((DOTYS * DOTXS).GT.DBLE(0.)) THEN                       SUN03390
        IF(IFLAG3.EQ.1) THEN                                            SUN03400
          ALPHA = XNETA                                                 SUN03410
          GOTO 2                                                        SUN03420
        ENDIF                                                           SUN03430
        IFLAG1 = 1                                                      SUN03440
        IF(IFLAG2.EQ.0) THEN                                            SUN03450
          XLAMB = XNETA                                                 SUN03460
          XNETA = XNETA * DBLE(1.5)                                     SUN03470
        ENDIF                                                           SUN03480
        GOTO 1                                                          SUN03490
      ENDIF                                                             SUN03500
C***********************************************************************SUN03510
C     CALCULATE ALPHA, THE SCALAR IN THE SEARCH DIRECTION THAT YIELDS A SUN03520
C     MINIMUM VALUE OF THE FUNCTION. COMPARE THE FUNCTION VALUES AND IF SUN03530
C     THE VALUE IS LESS THAN AT X OR Y THEN RETURN, IF NOT REPEAT THE   SUN03540
C     SEARCH WITH A SMALLER SCALAR.                                     SUN03550
C***********************************************************************SUN03560
      XLAMB = XNETA                                                     SUN03570
      Z = DBLE(3.0) * (FX - FY) / XLAMB + DOTXS + DOTYS                 SUN03580
      W = DSQRT(Z * Z - DOTXS * DOTYS)                                  SUN03590
      ALPHA = (DBLE(1.0) - (DOTYS + W - Z) / (DOTYS - DOTXS + DBLE(2.0) SUN03600
     ** W)) * XLAMB                                                     SUN03610
C***********************************************************************SUN03620
C     TEST TO SEE IF THE FUNCTION VALUE AT THE POINT GIVEN BY THE SEARCHSUN03630
C     SCALAR, ALPHA IS LESS THAN AT BOTH POINTS X AND Y. IF THE MINIMUM SUN03640
C     HAS BEEN BRACKETED THE SUBROUTINE WILL RETURN USING THE CURRENT   SUN03650
C     POINT Y AS THE NEW X WITH THE VALUE OF ALPHA. IF NOT THE SEARCH   SUN03660
C     WILL BE REPEATED WITH A SMALLER SCALAR.                           SUN03670
C***********************************************************************SUN03680
    2 CALL DMMOVE(N,S,SPACE(IXNEW))                                     SUN03690
      CALL DSCAL1(SPACE(IXNEW),N,ALPHA)                                 SUN03700
      CALL DMXADD(X,SPACE(IXNEW),SPACE(IMIN),N,1)                       SUN03710
      FALPHA = U(C,SPACE(IMIN),NCHAN)                                   SUN03720
      IF((ITYPE.EQ.-1.AND.FALPHA.GT.FX.OR.ITYPE.EQ.-1.AND.FALPHA.GT.FY).SUN03730
     *OR.(ITYPE.EQ.1.AND.FALPHA.LT.FX.OR.ITYPE.EQ.1.AND.FALPHA.LT.FY)) TSUN03740
     *HEN                                                               SUN03750
        IF(IFLAG3.EQ.1) THEN                                            SUN03760
          ALPHA = XNETA                                                 SUN03770
          RETURN                                                        SUN03780
        ENDIF                                                           SUN03790
        IFLAG2 = 1                                                      SUN03800
        IF(IFLAG1.EQ.0) XLAMB = XNETA                                   SUN03810
        XNETA = XNETA * DBLE(0.75)                                      SUN03820
        GOTO 1                                                          SUN03830
      ENDIF                                                             SUN03840
      RETURN                                                            SUN03850
      END                                                               SUN03860
