C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DDDOT(L,X,Y,P)
C***********************************************************************
C     THIS SUBROUTINE COMPUTES THE DOT PRODUCT OF TWO VECTORS, X AND Y.
C     THIS IS THE DOUBLE PRECISION VERSION OF SUBROUTINE DOT.
C     SEE ROBINSON "MULTICHANNEL TIME SERIES ANALYSIS", PAGE 19.
C*****SUBROUTINE INPUT.
C     L = THE LENGTH OF VECTORS X AND Y.
C     X = THE FIRST VECTOR.
C     Y = THE SECOND VECTOR.
C*****SUBROUTINE OUTPUT.
C     P = THE DOT (SCALAR) PRODUCT OF X AND Y.
C***********************************************************************
      REAL*8 X(L),Y(L)
      REAL*8 P
      P = 0.0
      IF(L.LE.0) RETURN
      DO 1 I = 1,L
    1   P = P + X(I) * Y(I)
      RETURN
      END
