C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DMMULT(A,B,C,L,M,N)                                    SUN03880
C***********************************************************************SUN03890
C     THIS SUBROUTINE MULTIPLIES TWO MATRICES A, AND B TO YIELD C       SUN03900
C     NOTE THAT A * B DOES NOT EQUAL B * A.                             SUN03910
C     THIS IS THE DOUBLE PRECISION VERSION OF SUBROUTINE MMULT.         SUN03920
C     SEE DAVIES, "STATISTICS AND DATA ANALYSIS IN GEOLOGY", PAGE 137.  SUN03930
C*****SUBROUTINE INPUTS.                                                SUN03940
C     A = THE FIRST MATRIX TO BE MULTIPLIED                             SUN03950
C     B = THE SECOND MATRIX TO BE MULTIPLIED                            SUN03960
C     L = THE NUMBER OF ROWS IN A = THE NUMBER OF ROWS IN C             SUN03970
C     M = THE NUMBER OF COLUMNS IN B = THE NUMBER OF COLUMNS IN C       SUN03980
C     N = THE NUMBER OF COLUMNS IN A = THE NUMBER OF ROWS IN B          SUN03990
C*****SUBROUTINE OUTPUTS.                                               SUN04000
C     C = THE MATRIX PRODUCT A * B                                      SUN04010
C***********************************************************************SUN04020
      REAL*8 A(L*N),B(N*M),C(L*M)                                       SUN04030
      DO 3 I = 1,L                                                      SUN04040
        DO 2 J = 1,M                                                    SUN04050
          IJ = (J - 1) * L + I                                          SUN04060
          C(IJ) = DBLE(0.0)                                             SUN04070
          DO 1 K = 1,N                                                  SUN04080
            IK = (K - 1) * L + I                                        SUN04090
            KJ = (J - 1) * N + K                                        SUN04100
C***********************************************************************SUN04110
C     CHECKS TO VERIFY WHETHER AN UNDER FLOW ERROR WILL OCCUR OWING     SUN04120
C     TO THE PRESENCE OF LARGE NEGATIVE EXPONENTS. THE LIMIT ON THE     SUN04130
C      IBM 370 IS 10E-78. NUMBERS SMALLER THAN THIS ARE SET TO ZERO.    SUN04140
C***********************************************************************SUN04150
            IF(A(IK).EQ.DBLE(0.0).OR.B(KJ).EQ.DBLE(0.0)) GOTO 1         SUN04160
            IF(DLOG10(DABS(A(IK)))+DLOG10(DABS(B(KJ))).LE.DBLE(-78.0)) GSUN04170
     *OTO 1                                                             SUN04180
            C(IJ) = C(IJ) + A(IK) * B(KJ)                               SUN04190
    1     CONTINUE                                                      SUN04200
    2   CONTINUE                                                        SUN04210
    3 CONTINUE                                                          SUN04220
      RETURN                                                            SUN04230
      END                                                               SUN04240
