C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine shotx ( Analysis_ShotPoint, sp, x, Model_NumShots, fx )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c routine to return a value of x for the current analysis shot
c location

c declare variables passed from calling routine

      integer Analysis_ShotPoint, Model_NumShots
      integer sp(SZLNHD)

      real*8 x(SZLNHD), fx

c declare local variables

      integer i

c locate shotpoint in sp() array and interpolate a coordinate 
c if necessary

      do i = 1, Model_NumShots
         if ( iabs(sp(i) - Analysis_Shotpoint) .eq. 0 ) then
            fx = x(i)
            write(LERR,*)' '
            write(LERR,*)' Processing Analysis Shotpoint ', 
     :           Analysis_Shotpoint,' at X Coordinate = ',
     :           sngl(fx)

            return
         endif
      enddo

c if we made it to here then for whatever reason the user has a
c shot indexing in sp[] that is not incrementing at unity and
c will need an interpolation. By the limits set on the model
c there is no way to have a shotpoint less than the start of the
c shotpoint arrays so I only have to search for values between
c sp[1] and sp[Model_NumShots] and since the above loop will pick 
c equalities I really only need to search for values between
c up on the two limits but not equal to them....Garossino

      do i = 2, Model_NumShots

         if ( Analysis_Shotpoint .lt. sp(i) ) then

            fx = x(i-1) + 
     :           ( dfloat( Analysis_Shotpoint - sp(i-1) ) / 
     :           dfloat( sp(i) - sp(i-1) ) ) * 
     :           ( x(i) - x(i-1) )
            return
            
         endif
      enddo

c if we make it to here then I have buggered up somehow

      write(LERR,*) ' '
      write(LERR,*) ' Garossino has buggered up the shot point '
      write(LERR,*) ' x coordinate assignment in the shotx[] '
      write(LERR,*) ' subroutine.  Give him a call and get him'
      write(LERR,*) ' to check it out with your input data'
      write(LERR,*) 'FATAL'
      write(LERR,*) ' '
      write(LER,*) ' '
      write(LER,*) 'TVD: '
      write(LER,*) ' Garossino has buggered up the shot point '
      write(LER,*) ' x coordinate assignment in the shotx[] '
      write(LER,*) ' subroutine.  Give him a call and get him'
      write(LER,*) ' to check it out with your input data'
      write(LER,*) 'FATAL'
      write(LER,*) ' '
      stop

      end
