C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( mfile, vfile, Model_NumShots, 
     :     Model_InitialShot, Model_ShotIncrement, Model_SmoothingOrder,
     :     Data_MaxTime, Analysis_InitialShot, Analysis_ShotpointEnd, 
     :     Analysis_ShotIncrement, c_BoatDirection, ShotInterval, Gap, 
     :     GroupInterval, OffsetFactor, Tweak, nchan, c_domain, 
     :     v0, verbos )

c routine to print pertinent information to the attached
c USP printout file

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer Model_NumShots, Model_InitialShot, Model_SmoothingOrder
      integer Analysis_InitialShot, Analysis_ShotIncrement
      integer Analysis_ShotpointEnd, nchan

      real Model_ShotIncrement

      real*8 Data_MaxTime, ShotInterval, GroupInterval, Gap
      real*8 OffsetFactor, v0, Tweak

      character vfile*256, mfile*256, c_domain*14, c_BoatDirection*2

      logical verbos

c declare local variables

      integer length

c initialize variables

      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' -----------------------'
      write(LERR,*)' '
      write(LERR,*)' '
      length = lenth(mfile)
      if (length .gt. 0) then
       write(LERR,*)' Structural Model [xsd pickfile]      = ', 
     :     mfile(1:length)
      else
       write(LERR,*)' Structural Model [xsd pickfile]      = ', 
     :     'N/A'
      endif
      length = lenth(vfile)
      if (length .gt. 0) then
       write(LERR,*)' Velocity Model [tdfn format]         = ', 
     :     vfile(1:length)
      else
       write(LERR,*)' Velocity Model [tdfn format]         = ', 
     :     'N/A'
      endif
      write(LERR,*)' Number of shots in model             = ',
     :     Model_NumShots
      write(LERR,*)' Initial shot in model                = ',
     :     Model_InitialShot
      write(LERR,*)' Shots index increment in model       = ',
     :     Model_ShotIncrement
      write(LERR,*)' Model horizon smoothing order        = ',
     :     Model_SmoothingOrder
      write(LERR,*)' '
      write(LERR,*)' Maximum time in target USP dataset   = ',
     :     Data_MaxTime
      write(LERR,*)' [t,v,d] Analysis shotpoint start     = ',
     : Analysis_InitialShot
      write(LERR,*)' [t,v,d] Analysis shotpoint end       = ',
     : Analysis_ShotpointEnd
      write(LERR,*)' [t,v,d] Analysis shotpoint increment = ',
     : Analysis_ShotIncrement
      write(LERR,*)' '
      write(LERR,*)' Source Direction                     = ',
     :     c_BoatDirection
      write(LERR,*)' Shotpoint interval                   = ',
     :   ShotInterval
      write(LERR,*)' Group interval                       = ',
     :     GroupInterval
      write(LERR,*)' Gap                                  = ',
     :     Gap
      write(LERR,*)' Offset factor                        = ',
     :     OffsetFactor
      write(LERR,*)' Tweak                                = ',
     :     Tweak
      write(LERR,*)' Number of channels on cable          = ',
     :     nchan
      write(LERR,*)' End point domain for solution        = ',
     :     c_domain
      write(LERR,*)' Velocity at t(0)                     = ',
     :     v0
      if (verbos) write(LERR,*)' verbose printout requested'
      write(LERR,*)' '

      return
      end

