C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tvd_Load ( lu_tvd, NumFcns, NumEntries, size, time, 
     :     velocity, dip, tvd_index, verbos )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer lu_tvd, NumFcns, size
      integer tvd_index(NumFcns), NumEntries(NumFcns)

      real time(size), velocity(size), dip(size)

      logical verbos

c declare local variables
 
      integer pointer

      character junk*1

c initialize variables

      if ( verbos ) then

         write(LERR,*)' '
         write(LERR,*)' T,V,D Model Input'
         write(LERR,*)' -----------------'
         write(LERR,*)' '
      endif


c read and load tvd function data

      rewind (lu_tvd)

c skip past file header and down to first shot point entry

      read ( lu_tvd, '(///////////////)' )

c read input t,v,d function data

      pointer = 0

      do i = 1, NumFcns

c read past line number entry

         read ( lu_tvd, '(1x,a1)' ) junk

c read shot point and number of horizons         

         read ( lu_tvd, '(12x,i7,17x,i7)' ) tvd_index(i), NumEntries(i)

         if ( verbos ) write(LERR,*)' T,V,D Index = ', tvd_index(i)

c read past title line

         read ( lu_tvd, '(//)' )

c read function

         do j = 1, NumEntries(i)

            pointer = pointer + 1
            read ( lu_tvd, '(f6.3,f7.1,f8.1)' ) time(pointer), 
     :           dip(pointer), velocity(pointer)

         enddo

         if ( verbos) then
            write(LERR,*)' '
            write(LERR,*)' Time        Velocity            Dip'
            write(LERR,*)' -----       --------           ----'
            write(LERR,'(3f12.3)')
     :           ( time(j), velocity(j), dip(j), 
     :           j= pointer - NumEntries(i)+ 1, pointer )
            write(LERR,*)' '
         endif

      enddo

      return
      end
