C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

	subroutine getxp(x,zr,g,xp)
c
c	find the P-S conversion distance
c
c	         -----------------------
c	         |       Xp  2       2
c	         | 1 + [----] (1 - G)
c	        \|       Zr
c    Xp = ---------------------------- X        (Eq.2.15)
c              ----------------------
c	          |       Xp  2       2
c	      G + | 1 + [----] (1 - G)
c	         \|       Zr
c
c	This program solves Eq.2.15
c	Eq.2.15 converges to the solution
c    It takes about 10 iterations
c    Yaohui Zhang, 1991
c
c	X : offset (input)
c	Zr: depth of horizon (input)
c	G : Vs/Vp (input)
c	Xp: conversion distance (output)
c
	if(x.eq.0.0) then
	xp=0.0
	return
	else
	endif
	xp=x/(1.0+g)
	j=0
10	continue
	j=j+1
	xpk=sqrt(1.0+(1.0-g*g)*xp*xp/(zr*zr))
	xp=x*xpk/(g+xpk)
	if(j.lt.12) go to 10
	return
	end
