C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
        subroutine preinterp(indv,np,isingle,rs,re,
     1                       inters,intere,isp,is,ie)
        dimension indv(1),inters(1),intere(1),isp(1),is(1),ie(1)
        integer rs,re
        logical ibadp
c
c       prepare the time and space interpolation table
c       
c       indv : velocity pick index array                   (input)
c       np   : Number of velocity pick segments            (input)
c       isingle: velocity flag,                            (output)
c               = 0, multi-velocities to be used
c               = 1, single velocity function to be used
c       rs,re: starting and ending records                 (input)
c       inters,intere: Nearest starting and ending         (output)
c                   avalaible velocity record index
c      isp  : interpolation flag,                          (output)
c             =0, no interpolation is needed 
c                 inters=intere=indv
c             =record index, interpolation is needed,
c                 isp is belonged to [inters,intere]
c     is,ie : interpolation address index                  (output)
c
c       check velocity and data index
c       the velocity picks must be ascent order
c
       do i=1,np
          intere(i)=0
          inters(i)=0
          isp(i)=0
          is(i)=0
          ie(i)=0
       enddo
c
       call chkascent(indv,np,ibadp)
       if(ibadp) then
           write(*,*) 'BAD record index detected the P-wave velocity'
           write(*,*) 'pick file. The record number in velocity picks'
           write(*,*) 'are not in ascent order'
c           stop 1
           return
       endif
c
c      Velocity space interpolation pre check for P-wave vel
c
c      Single velocity
c
       isingle=0
       if(np .eq. 1) then
          write(*,*) 'Single P-wave velocity or Vs/Vp is used'
          isingle=1
       else
c
c      vsii check the velocity index and prepare the
c      space interpolation table according the starting and
c      ending record index of the input data.
c
c      rs,re: start and end record of the input data (input)
c      indv : 1D array to store velocity record index (input)
c      np : Number of velocity pick segments
c      inters,intere: Nearest starting and ending avalaible velocity record index
c      isp  : =0, no interpolation is needed
c                 inters=intere=indv
c             =record index, interpolation is needed,
c                 isp is belonged to [inters,intere]
c
c          write(*,*) 'before vsii:rs,re=',rs,re
          call vsii(rs,re,indv,np,inters,intere,isp,is,ie)
       endif
       return
       end

