C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************
c P-S converted wave NMO
c Author: Yaohui Zhang, Ext3901, E&PTG
c         August, 1995
c**********************************************************************
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer   itr( SZLNHD ), lhed(SZLNHD)

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ns,ne, s, e, rs, re, vflag, gflag, ddt
      integer     it(SZSMPM),itps(SZSMPM),idt(SZSMPM), argis
      real        dtnmo(SZSMPM)
      real        vpicks(SZSMPM),gpicks(SZSMPM),g(SZSMPM)
      real        x(SZSMPM),y(SZSMPM),xp(SZSMPM),vs(SZSMPM)

      real        tp(SZSMPM),vp(SZSMPM),tps(SZSMPM)
      real        tts(SZSMPM),tte(SZSMPM),tps0(SZSMPM)
      real        ttp(SZSMPM),ttps(SZSMPM),tg(SZSMPM)

      integer     np,indv(SZSMPM),nt(SZSMPM),indptr(SZSMPM)
      integer     indg(SZSMPM),ng(SZSMPM),indgptr(SZSMPM)
      integer     is(SZSMPM),ie(SZSMPM),isp(SZSMPM)
      integer     inters(SZSMPM),intere(SZSMPM)
      integer     igs(SZSMPM),ige(SZSMPM),isg(SZSMPM)
      integer     intergs(SZSMPM),interge(SZSMPM)

      integer RecNum, ifmt_RecNum, l_RecNum, ln_RecNum
      integer TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer SrcLoc, ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer RecInd, ifmt_RecInd, l_RecInd, ln_RecInd
      integer Dphind, ifmt_Dphind, l_Dphind, ln_Dphind
      integer DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn
 
      character   ntap*120, otap*120, name*6
      character  gpikf*120, vpikf*120

      logical     verbos, DeaDTracE
      logical     heapi, heap1, heap2

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'PSNMO'/
 
c
c    initialize memory
c
       call vclr(x,1,SZSMPM)
       call vclr(y,1,SZSMPM)
       call vclr(dtnmo,1,SZSMPM)
       call vclr(vp,1,SZSMPM)
       call vclr(xp,1,SZSMPM)
       call vclr(tps,1,SZSMPM)
       call vclr(tps0,1,SZSMPM)
       call vclr(g,1,SZSMPM)
       call vclr(vpicks,1,SZSMPM)
       call vclr(gpicks,1,SZSMPM)
       call vclr(ttp,1,SZSMPM)
       call vclr(ttps,1,SZSMPM)
       call vclr(tg,1,SZSMPM)
       call vclr(vs,1,SZSMPM)
       call vclr(tte,1,SZSMPM)
       call vclr(tts,1,SZSMPM)
       call vclr(tp,1,SZSMPM)
c
c    help information
c
      if ( argis ( '-?' ) .gt. 0 .OR.
     1      argis ( '-h' ) .gt. 0 .OR.
     2      argis ( '-H' ) .gt. 0 .OR.
     3      argis( '-help' ) .gt. 0 .OR.
     4      argis( '-Help' ) .gt. 0 .OR.
     5      argis ( '-HELP' ) .gt. 0 ) then
         call help()
         stop
      endif

c
c Open up log file
c
#include <f77/open.h>

c
        call gcmdln(ntap,vpikf,gpikf,otap,iflag,
     1              ns,ne,rs,re,s,e,verbos)
c
c   Open I/O files
c   
      nptap_len = lenth(nptap)
      ngtap_len = lenth(ngtap)
      ntap_len = lenth(ntap)
      if(otap(1:1) .eq. ' ') then
	if (ntap_len .gt. 0) then
          otap = ntap(1:ntap_len)//'_psnmo'
	else
          otap = 'stdout'//'_psnmo'
	endif
      endif
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      call rtape  ( luin, itr, lbytes)

      if(lbytes .eq. 0) then
         write(LOT,*)'PSNMO: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

c
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)


      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c format values are:
c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
c        write(*,*) 'nsamp,nsi,ntrc,nrec',nsamp,nsi,ntrc,nrec
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 5, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
c
c        write(*,*) 'ns,ne,rs,re,ntrc,nrec=',ns,ne,rs,re,ntrc,nrec
        call cmdchk(ns,ne,rs,re,ntrc,nrec)
c        write(*,*) 'ns,ne,rs,re,ntrc,nrec=',ns,ne,rs,re,ntrc,nrec
c 
c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.
c 
c-----
c     modify line header to reflect actual number of traces output
c-----
c
c
c
      nreco = re - rs + 1
      ntrco = ne -ns + 1
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
      if(e .eq. 0) e=nsamp*dt*1000.0
      iidt=dt*1000
      nbeg=s/iidt+1
      nend=e/iidt+1
      if(nbeg .lt. 1) nbeg =1
      if(nend .lt. nbeg) nend = nsamp 
c
c     Determine output data trace headers
c
c       write(*,*) 'LINHED:nreco,ntrco=',nreco,ntrco
      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)
      call savew(itr, 'NumSmp', nsamp, LINHED)
      call savew(itr, 'SmpInt', iidt  , LINHED)
c
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
c 
      call wrtape ( luout, itr, lbyout  )
c      
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c
      call verbal(ntap,nsamp,nsi,ntrc,nrec,iform,
     1                 s,e,ns,ne,rs,re,otap,ntrco,nreco)
c 
       ddt=dt*1000
c
c     Read P-wave velocity picks and Vs/Vp ratio picks
c     Then create the interpolation tables.
c
         if (vpikf(1:1) .eq. ' ') then
               write(LERR,*)'Could not open velpik file ',vpikf
               write(LERR,*)'Check existence'
               vpikf = ' '
         endif

c
c   Read in P-wave velocity and Vs/Vp picks
c

c        lenvp= lenth(vpikf)
c        lenvg= lenth(gpikf)

c        velpikf = vpikf(1:lenvp)//'\0'
c        gsppikf = gpikf(1:lenvg)//'\0'

c        call get_pick_flag(velpikf,vflag)
        call get_pick_flag(vpikf,vflag)

         if (gpikf(1:1) .eq. ' ' .AND. iflag .ne. 2) then
               write(LERR,*)'Could not open velpik file ',gpikf
               write(LERR,*)'Check existence'
               gpikf = ' '
         endif

        IF(vflag .eq. -1) then
            write(*,*) 'PSNMO WAS DROWN!!!'
            write(*,*) 'Unknown pick file format of P-wave'
            write(*,*) 'velocity pick file is detected.'
            write(*,*) 'Unable to perform PSNMO.'
            write(*,*) 'Check the data file provided in -Vpik.'
            stop 1
        ENDIF
        write(*,*)
        write(*,*) 'About pick file(s):'
        if(vflag .eq. 0)
     1  write(*,*) 'Disco HANDVEL P-wave Vel pick file is detected'
        if(vflag .eq. 1)
     2  write(*,*) 't/v/ri triplets P-wave Vel pick file is detected'
        if(vflag .eq. 2)
     3  write(*,*) 'Standard XSD P-wave Vel pick file is detected'
        if(vflag .eq. 3)
     4  write(*,*) 'Standard XOS/CVD P-wave Vel pick file is detected'
        if(vflag .eq. 4)
     5  write(*,*) 'TDFN card image P-wave Vel pick file is detected'
        if(vflag .eq. 5)
     6  write(*,*) 'ProMAX P-wave Vel pick file is detected'
c

c        call read_vel_picks(velpikf,np,indv,vflag,tp,vpicks,nt,indptr)
        call read_vel_picks(vpikf,np,indv,vflag,tp,vpicks,nt,indptr)
c DBX
c        do kkk=1,np
c           write(*,*) kkk,indptr(kkk)
c        enddo
c           write(*,*) 'np,indv,nt=',np,indv(1),nt(1)
c        do kkk=1,np
c           write(*,*) 'np,indv,nt=',np,indv(kkk),nt(kkk)
c           do kkkk=1,nt(kkk)
c              write(*,*) tp(kkkk),vpicks(kkkk)
c           enddo
c        enddo
c DBX

        IF(iflag .ne. 2) then
c        call get_pick_flag(gsppikf,gflag)
        call get_pick_flag(gpikf,gflag)
c
        IF(gflag .eq. -1) then
            write(*,*) 'Fetal Error in running PSNMO!!!'
            write(*,*) 'Unknown pick file format of Vs/Vp'
            write(*,*) 'velocity ratio pick file is detected.'
            write(*,*) 'Unable to perform PSNMO.'
            write(*,*) 'Check the data file provided in -Gpik.'
            stop 2
        ENDIF
        if(gflag .eq. 0)
     1  write(*,*) 'Disco HANDVEL Vs/Vp ratio pick file is detected'
        if(gflag .eq. 1)
     2  write(*,*) 't/v/ri triplets Vs/Vp ratio pick file is detected'
        if(gflag .eq. 2)
     3  write(*,*) 'Standard XSD Vs/Vp ratio pick file is detected'
        if(gflag .eq. 3)
     4  write(*,*) 'Standard XOS/CVD Vs/Vp ratio pick file is detected'
        if(gflag .eq. 4)
     5  write(*,*) 'TDFN card image Vs/Vp ratio pick file is detected'
        if(gflag .eq. 5)
     6  write(*,*) 'ProMAX Vs/Vp ratio pick file is detected'
        write(*,*)
c

c       call read_vel_picks(gsppikf,ngp,indg,gflag,tps,gpicks,ng,indgptr)
       call read_vel_picks(gpikf,ngp,indg,gflag,tps,gpicks,ng,indgptr)
cDBX
c        do kkk=1,ngp
c           write(*,*) kkk,indgptr(kkk)
c        enddo
c
c        do kkk=1,ngp
c           write(*,*) 'ngp,indg,ng=',ngp,indg(kkk),ng(kkk)
c           do kkkk=1,ng(kkk)
c              write(*,*) tps(kkkk),gpicks(kkkk)
c           enddo
c        enddo
cDBX
           nns=0
           do kkk=1,ngp
               nns=nns+ng(kkk)
           enddo
           do kkk=1,nns
              gpicks(kkk)=gpicks(kkk)/1000.0
           enddo
        ENDIF
c
c       Now the time index and velocity picks are stored in
c       two big array, tp and vp, respectively. np is the
c       total number of record with velocity picks. nt is the
c       a one fimension integer array storing the number of picks
c       in each record. indv is a one dimension array to store
c       the record number where the velocity was picked. iv is
c       one dimension integer array as the pointers to the beginning
c       of the each velocity pick. flag is the a integer to indecate
c       the velocity pick format, 0 = disco HANDVEL format, 1 = flat
c       file, 2 = XSD pick segment. "read_vel_picks" is a C program.
c       The program can be easily modified to read any new velocity
c       format.
c       The velocity picks is a SPARC matrix and is read into a one
c       dimension array.
c  index          tp      vp         nt         iv                indv
c    1            t11     v11      nt(1)=k     iv(1)=1            indv(1)=rec1
c    2            t12     v12
c    3            t13     v13
c     ...
c    k            t1k     v1k
c    k+1          t21     v21      nt(2)=j     iv(2)=k+1          indv(2)=rec2
c    k+2          t22     v22
c    k+3          t23     v23
c     ...
c    k+j          t2k     v2j
c     ...
c     ...
c    k+j+...+1    tN1     vN1      nt(N)=M     iv(N)=k+j+...+1   indv(N)=recN
c    k+2+...+2    tN2     vN2
c    k+3+...+3    tN3     vN3
c     ...
c    k+j+...+N    tNk     vNM
c
c
c      prepare the interpolation tables for both P-wave velocity and Vs/Vp ratio
c
       write(*,*) 'P-wave velocity pick information:'
       call preinterp(indv,np,isingle,rs,re,
     1                inters,intere,isp,is,ie)
c
c      IF iflag=2, Hyperbolic NMO correction for P-wave data
c      No Vs/Vp ratio is needed.
c
       if(iflag .eq.2) go to 4098
       write(*,*)
       write(*,*) 'Vs/Vp ratio pick information:'
       call preinterp(indg,ngp,isingleg,rs,re,
     1                intergs,interge,isg,igs,ige)
       write(*,*)
4098    continue
c
c    The interpolation tables of P-wave velocity and Vs/Vp picks 
c    are ready to be used
c
c
c       write(*,*) 'rs,re=',rs,re, 'nreco,ntrco,nsamp=',nreco,ntrco,nsamp
c 
c--------------------------------------------------
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c     skip unwanted records
c-----
      if(rs .gt. 1) call recskp(1,rs-1,luin,ntrc,itr)
c 
      do 4096 jj = rs, re
c 
c----------------------
c  skip to start trace
c----------------------
c
         if(ns .gt. 1) call trcskp(jj,1,ns-1,luin,ntrc,itr)
c 
             do i=1,nsamp
                tps0(i)=(i-1)*ddt
             enddo
c
c      P-wave velocity and Vs/Vp picks time and space interpolations 
c      if necessary.
c
       call tsinterp(tp,vpicks,nt,isingle,nsamp,ddt,indptr,
     1              inters,intere,is,ie,isp,jj,ttp,y)
c
c        if(jj .eq. re) then
c       write(21,*) '"P',jj
c       do kkk=1,nsamp
c          write(21,*) ttp(kkk),y(kkk)
c       enddo
c        endif
c
       IF(iflag .ne. 2) THEN
           call tsinterp(tps,gpicks,ng,isingleg,nsamp,ddt,indgptr,
     1              intergs,interge,igs,ige,isg,jj,tg,g)
c        if(jj .eq. re) then
c       write(21,*) 
c       write(21,*) 
c       write(21,*) '"G',jj
c       do kkk=1,nsamp
c          write(21,*) tg(kkk),g(kkk)
c       enddo
c        endif
       ENDIF
        if(iflag .eq. 2) then
            do kkk=1,nsamp
               vp(kkk)=y(kkk)
            enddo
        else
            call tp2tps2(y,g,0.0,ddt,nsamp,vp,vs)
        endif
c
c     All velocities and Vs/Vp are ready for gather JJ
c      g is the Vs/Vp ratio trace in tps travel time
c      vp is the Vp(tps) trace
c      vs is the Vs(tps) trace
c
c        do kk=1,nsamp
c           write(26,*) kk,vp(kk),g(kk),vs(kk)
c        enddo
c         write(*,*) 'ns,ne=',ns,ne
         do 1024 kk = ns, ne
c 
            nbytes = 0
            call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

c------
c     use previously derived pointers to trace header values
            call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           RecNum , TRACEHEADER)
            call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1           TrcNum , TRACEHEADER)
            call saver2(lhed,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1           SrcLoc , TRACEHEADER)
            call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1           RecInd , TRACEHEADER)
            call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1           DphInd , TRACEHEADER)
c            call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
c     1           DstSgn , TRACEHEADER)
c
      call saver(itr, 'DstSgn', DstSgn , TRACEHEADER)
c
            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           stacor , TRACEHEADER)
            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           StaCor, TRACEHEADER)


            if (StaCor .eq. 30000) then
               DeaDTracE = .true.
            else
               call vmov (itr(ITHWP1), 1, x, 1,nsamp)
            endif
c***********************************************
c
c              pre-mute the data
c
c         if(nbeg .gt. 1) then
c            do 500 ijk=1,nbeg-1
c               x(ijk)=0.0
c500         continue
c         endif
c         if(nend .lt. nsamp) then
c            do 510 ijk=nend+1,nsamp
c               x(ijk)=0.0
c510         continue
c         endif
c***********************************************
c
c        get offset
c
         if(StaCor .ne. 30000) then
c         offset= iabs(DstSgn)*dmul
         offset= iabs(DstSgn)
c         write(26,*) offset
c
c          do kkk=1,nsamp
c             write(21,*) tps0(kkk),vp(kkk),g(kkk)
c          enddo
c         write(21,*) '1offset,nsamp,iidt=',offset,nsamp,iidt
         ddt=iidt
         call psnmodt(tps0,vp,offset,g,ddt,dtnmo,xp,nsamp,iflag)
c
c         write(21,*) '2offset,nsamp,iidt=',offset,nsamp,iidt
        itb=1
        ite=nsamp
c
c        write(23,*) '"trace',kk
        do 1002 I=1,nsamp
           jij=i-itb+1
           it(jij)=dtnmo(i)/iidt
c           write(23,*) tps0(i),offset,it(jij)
           if(it(jij).lt.0) it(jij)=0
1002    continue
c
c    preNMO
c
        call prenmo(it,itps,idt,itb,ite)
c
c    exec NMO correction
c
c        itmin=it(ite-1)
        call nmoex(x,y,itps,idt,itb,ite)
c
c    NMO finished
c
        else
        do 1003 i=1,nsamp
            y(i)=0.0
1003    continue
        endif 
c************************************
c
c              postNMO-muting
c
         if(nbeg .gt. 1) then
            do 500 ijk=1,nbeg-1
               y(ijk)=0.0
500         continue
         endif
         if(nend .lt. nsamp) then
            do 510 ijk=nend+1,nsamp
               y(ijk)=0.0
510         continue
         endif
c************************************
c
c             write(*,*) 'jj,kk,DstSgn',jj,kk,DstSgn
             call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               jj , TRACEHEADER)
             call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                 kk   , TRACEHEADER)
c             call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
c     1                DstSgn, TRACEHEADER)
             call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                DstSgn, TRACEHEADER)
          if(DeaDTracE) then
             call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             30000   , TRACEHEADER)
             DeaDTracE = .false.
          else
             call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 0   , TRACEHEADER)
          endif
            call vmov(y,1,itr(ITHWP1),1, nsamp)
            call wrtape(luout, itr, obytes)
1024     continue
c 
c----------------------
c  skip to end of record
c----------------------
        if(ne .lt. ntrc)  call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 
c---------------------
       jleft=re-jj
       write(*,*) '"Record',jj,' has completed',jleft,' left to be done'
4096     continue
c       write(*,*) 'rs,re=',rs,re, 'nreco,ntrco,nsamp=',nreco,ntrco,nsamp
c
c-----
c Normal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LER,*) ' '
      write(LERR,*)'PSNMO: Normal Completion'
      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'PSNMO: Normal Completion'
      write(LER,*)' '
c      write(LER,*)'Contact: Yaohui Zhang at Ext3901/E&PTG'
c      write(LER,*)'         email: yzhang@trc.amoco.com'
      write(LER,*)' '
      stop  
    
 999  continue
 
c-----
c Abnormal Completion
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'PSNMO: Abormal Completion'
      write(LERR,*)'processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'PSNMO: Abormal Completion'
      stop      
      end
 
C***********************************************************************
         subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
          write(LER,*) 
     1    '"psnmo" is a USP program to perform NMO for P-S'
          write(LER,*) 
     1    'converted wave data. '
          write(LER,*) ' '
          write(LER,*) 
     1    'users enter the following parameters,'
          write(LER,*) 
     1    'or use the default values:'
        write(LER,*) ' '
          write(LER,*)
     1 '-N[ntap]   (no default)     : input dataset filename'
          write(LER,*)
     1 '-Vpik[vpikf]   (no default)  : P-wave velocity pick file'
         write(LER,*)
     1 '-Gpik[vpikf]  (no default)  : Vs/Vp velocity pick file'
          write(LER,*)
     : ' NOTE: if nmof=2, Gpik will be ignored'
          write(LER,*)
     1 '       The pick file format is automatically detected.'
          write(LER,*)
     1 '       Vpik and Gpik accept the the following pick files:'
          write(LER,*)
     2 '       XSD like pick, Disco HANDVEL, TDFN and flat files.'
          write(LER,*)
     1 '-O[otap] (default=ntap.psnmo): output dataset filename'
          write(LER,*)
     1 '-rs[rs]    (default=first)  : start record number'
          write(LER,*)
     1 '-re[re]    (default=last)   : end record number'
          write(LER,*)
     1 '-ns[ns]    (default=first)  : start trace number'
          write(LER,*)
     1 '-ne[ne]    (default=last)   : end trace number'
          write(LER,*)
     1 '-s[s]      (default=first)  : start time (ms)'
          write(LER,*)
     1 '-e[e]      (default=last)   : end time (ms)'
          write(LER,*)
     1 '-nmof[nmof] (default=1)   : NMO indicator'
          write(LER,*)
     1 '           =1, non-hyperbolic'
          write(LER,*)
     1 '           =2, hyperbolic with V provided in Vpik'
          write(LER,*)
     1 '           =3, hyperbolic with V = sqrt(g) Vp'
          write(LER,*)
     1 '           where g given by the pick file in Gpik'
          write(LER,*)
     2 '           and Vp given by the pick file in Vpik'
          write(LER,*) ' '
        write(LER,*)'usage:  '
        write(LER,*)
     1 ' psnmo -N[ntap] -Vpik[vpikf] -Gpik[gpikf] -nmof[nmof]'
          write(LER,*)
     2 '       -rs[ns] -re[ne] -ns[ns] -ne[ne] -s[s] -e[e] '
        write(LER,*)
     3 '       -O[otap]'
        write(LER,*) ' '
        write(LER,*) 'Contact: Yaohui Zhang/Ext3901, E&PTG'
        write(LER,*) '         Email: yzhang@trc.amoco.com'
        write(LER,*)
     :'************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,vpikf,gpikf,otap,nmof,
     1                  ns,ne,rs,re,s,e,verbos)
c-----
c     get command arguments
c
c     ntap  - C*120    Seismic data input file name
c     vpikf - C*120    P-wave velocity input file name
c     gpikf - C*120    Vs/Vp ratio input file name
c     otap  - C*120    output file name
c     nmof  - I*4      NMO indicator: =1, non-hyperbolic
c                                     =2, hyperboblic with V=Vp
c                                     =3, hyperboblic with V=sqrt(g)Vp
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     rs    - I*4      starting record index
c     re    - I*4      ending record index
c     s     - I*4      starting time (ms)
c     e     - I*4      ending time (ms)
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), vpikf*(*), gpikf*(*), otap*(*)
      integer     ns, ne, rs, re, s, e
      logical     verbos
      integer     argis
 
            call argi4 ( '-e', e ,   0  ,  0    )

            call argstr( '-Gpik', gpikf, ' ', ' ' )

            call argi4 ( '-nmof', nmof,  1  , 1    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argstr( '-N', ntap, ' ', ' ' )

            call argstr( '-O', otap, ' ', ' ' )

            call argi4 ( '-rs', rs ,   0  ,  0    )
            call argi4 ( '-re', re ,   0  ,  0    )

            call argi4 ( '-s', s ,   0  ,  0    )

            call argstr( '-Vpik', vpikf, ' ', ' ' )

            verbos =   (argis('-V') .gt. 0)
 
      return
      end
 
C***********************************************************************
      subroutine verbal(ntap,nsamp,nsi,ntrc,nrec,iform,
     1                  s,e,ns,ne,rs,re,otap,ntrco,nreco)
c-----
c     verbose output of processing parameters
c
c     ntap  - C*120    input file name
c     nsamp - I*4      number of samples in trace
c     nsi   - I*4      sample interval in ms
c     ntrc  - I*4      traces per record
c     nrec  - I*4      number of records per line
c     iform - I*4      format of data
c     s     - I*4      starting time (ms)
c     e     - I*4      ending time (ms)
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     rs    - I*4      starting record index
c     re    - I*4      ending record index
c     otap  - C*120    output file name
c     ntrco - I*4      traces per record for output
c     nreco - I*4      number of records per line for output
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec,rs,re,s,e
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
c            write(LERR,10) ' input data set name =  ', ntap
            write(LERR,10) ntap
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) ' Input values from command line:'
            write(LERR,*) ' starting time         : ',s, '(ms)'
            write(LERR,*) ' ending time           : ',e, '(ms)'
            write(LERR,*) ' starting trace index  :',ns
            write(LERR,*) ' ending trace index    :',ne
            write(LERR,*) ' starting record index :',rs
            write(LERR,*) ' ending record index   :',re
c            write(LERR,20) ' output data set name=  ', otap
            write(LERR,20) otap
            write(LERR,*) ' traces per record     = ', ntrco
            write(LERR,*) ' records per line      = ', nreco
            write(LERR,*)' '
            write(LERR,*)' '
10          format(' input data set name   =  ',a120)
20          format(' output data set name  =  ',a120)
      return
      end
