C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c      program module PSVSPEC: velocity analysis for P-S converted wave
c                              ( as sis files )
c
c**********************************************************************c
c  Yaohui Zhang   July, 1995
c
c  This program is still under testing and modification. It will be placed
c  on phase 1 only
c
c**********************************************************************c
c
c      The main program reads P-wave velocity picks (Disco HANDVEL,
c      flat velocity data file, XSD velocity pick file) to a big one
c      dimension array with an integer array as pointer pointing to the
c      starting position of each velocity pick group. VSII is called to
c      determine the record index for space interpolation. After the
c      depth and space interpolations of the velocity in each gather are
c      done,TPSVEL is called to perform non-hyperbolic trajectory scan
c      search for optimum Vs/Vp ratio as a function of two-way zero-offset
c      time (one way for P-wave, one way for S-wave) via a coherency measure
c      in a CSP or CCP gather of traces.
c
c**********************************************************************c

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

      INTEGER * 2 ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD ), LUIN, NBYTES, OBYTES
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM, LBYTES
      INTEGER     ISTOP, ISTART, NPT
      REAL        START,STOP
      REAL        TRI ( SZSMPM )
      CHARACTER   NAME*7, ntap*120, otap*120, vpikf*120, velpikf*120
#include <f77/pid.h>
      logical     verbos, nowt
      logical     abslut
      logical     query, heap, ibad
      integer     argis
c     real        traces (SZSMPM,SZSPRD)
      real        traces, vels
      pointer     (wkaddr, traces(1))
      pointer     (wkvels, vels(1))
      real        tmul, dmul
      real        dis( SZLNHD ), weight( SZLNHD )
      real        tp(SZSMPM),vp(SZSMPM)
      real        vvs(SZSMPM),tts(SZSMPM),tte(SZSMPM),vve(SZSMPM)
      real        vvp1(SZSMPM),vvp2(SZSMPM)
      real        ttp(SZSMPM),vvp(SZSMPM)

      real        vello( SZLNHD )
      real        velhi( SZLNHD )
      integer     np,indv(9999),nt(9999),indptr(9999),vflag
      integer     is(9999),ie(9999),isp(9999),inters(9999),intere(9999)

      integer     nvsvp
      integer     ns,ne
      real        vsvp0,vsvp1
      integer     igt

c     EQUIVALENCE ( ITR(129), TRI (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME /'PSVSPEC'/, NBYTES / 0 /, LBYTES / 0 /
c______________________________________________________________________
c     calculate trace header locations.
c______________________________________________________________________
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

C*********************************************************************C
c  get online help if necessary
C*********************************************************************C
      query = ( argis('-?').gt.0 .OR.
     1          argis('-h').gt.0 .OR.
     2          argis('-H').gt.0 .OR.
     3          argis( '-help' ) .gt. 0 .OR.
     4          argis( '-HELP' ) .gt. 0 )
      if ( query ) then
           call help ()
           stop
      endif

C*********************************************************************C
c  open printout file
C*********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,vpikf,vflag,start,stop,dmul,tmul,igt,
     &       ns,ne,irs,ire,nvsvp,vsvp0,vsvp1,abslut,verbos,nowt)
c        write(*,*) 'Vpikf=',vpikf, ' vflag=',vflag
         if (vpikf(1:1) .ne. ' ') then
            open(11,file=vpikf,iostat=ierr)

            if (ierr .ne. 0) then
               write(LERR,*)'Could not open velpik file ',vpikf
               write(LERR,*)'Check existence'
               vpikf = ' '
            endif
         endif

c
c  Read in P-wave velocity  picks
c
c        vflag=1
c        lenvp= lenth(vpikf)
c        velpikf = vpikf(1:lenvp)//'\0'
c        call get_pick_flag(velpikf,vflag)
        call get_pick_flag(vpikf,vflag)
        if(vflag .gt. 5) then
             write(*,*) 'vflag=',vflag
             write(*,*) 'Unknown Velocity pick file format'
             write(*,*) 'The program reads the following format:'
             write(*,*) 'XSD-like pick file, Disoc HANDVEL,'
             write(*,*) 'flat file, TDFN card images, and ProMax.'
             write(*,*) 'Check the velocity pick file:',velpikf
             write(*,*) 'and try again'
             write(*,*) 'STOP 1'
             stop 1
        endif
c        call read_vel_picks(velpikf,np,indv,vflag,tp,vp,nt,indptr)
        call read_vel_picks(vpikf,np,indv,vflag,tp,vp,nt,indptr)
c        kkk=0
c        do ijk=1,np
c           write(25,*) '    ',ijk,nt(ijk)
c           do kji = 1,nt(ijk)
c              kkk=kkk+1
c              write(25,*) kkk,tp(kkk),vp(kkk),indptr(ijk)+1,indv(ijk)
c           enddo
c        enddo
c
c       Now the time index and velocity picks are stored in
c       two big array, tp and vp, respectively. np is the 
c       total number of record with velocity picks. nt is the
c       a one fimension integer array storing the number of picks
c       in each record. indv is a one dimension array to store
c       the record number where the velocity was picked. iv is
c       one dimension integer array as the pointers to the beginning
c       of the each velocity pick. flag is the a integer to indecate
c       the velocity pick format, 0 = disco HANDVEL format, 1 = flat
c       file, 2 = XSD pick segment. "read_vel_picks" is a C program.
c       The program can be easily modified to read any new velocity
c       format.
c       The velocity picks is a SPARC matrix and is read into a one
c       dimension array.
c  index          tp      vp         nt         iv                indv
c    1            t11     v11      nt(1)=k     iv(1)=1            indv(1)=rec1
c    2            t12     v12          
c    3            t13     v13
c     ...
c    k            t1k     v1k
c    k+1          t21     v21      nt(2)=j     iv(2)=k+1          indv(2)=rec2
c    k+2          t22     v22     
c    k+3          t23     v23
c     ...
c    k+j          t2k     v2j
c     ...
c     ...
c    k+j+...+1    tN1     vN1      nt(N)=M     iv(N)=k+j+...+1   indv(N)=recN
c    k+2+...+2    tN2     vN2  
c    k+3+...+3    tN3     vN3
c     ...
c    k+j+...+N    tNk     vNM
c
c
c       check velocity and data index 
c       the velocity picks must be ascent order
c
       call chkascent(indv,np,ibad)
       if(ibad) then
           write(*,*) 'BAD record index detected'
           write(*,*) 'The record number in velocity picks'
           write(*,*) 'are not in ascent order'
           stop 1
       endif
c
c      Velocity space interpolation pre check
c
c      Single velocity
c
       isingle=0
       if(np .eq. 1) then
              write(*,*) 'Single velocity is used'
c          do ii=irs,ire
c              isp(ii)=0
c              inters(ii)=1
c              intere(ii)=1
c              is(i)=1
c              ie(i)=1
c          enddo
       isingle=1
       else
c
c      vsii check the velocity index and prepare the
c      space interpolation table according the starting and
c      ending record index of the input data.
c
c      rs,re: start and end record of the input data (input)
c      indv : 1D array to store velocity record index (input)
c      np : Number of velocity pick segments
c      inters,intere: Nearest tarting and ending avalaible velocity record index
c      isp  : =0, no interpolation is needed
c                 inters=intere=indv
c             =record index, interpolation is needed,
c                 isp is belonged to [inters,intere]
c
          call vsii(irs,ire,indv,np,inters,intere,isp,is,ie)
       endif
c
c      

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
       call getln ( luin, ntap, 'r', 0 )
       call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE  ( LUIN, itr, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'PSVSPEC: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt ( ITR , LBYTES, name, 7, LERR         )

c-----------------------------------------
c  save key header values
#include <f77/saveh.h>

         write(LERR,*)' '
         write(LERR,*)' Values read from input data set lineheader'
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform

C**********************************************************************C
C     CHECK DEFAULT VALUES AND SET PARAMETERS
C**********************************************************************C
      if(START.le.0.0)START = 0.0
      ttmax = (NSAMP-1)*NSI
      if(STOP.le.0.0 .or. STOP.ge. ttmax)STOP=ttmax
      if (nsi .le. 32) then
          dt = float(nsi)/1000.
      else
          dt = float(nsi)/1000000.
      endif
      si = tmul * float(nsi)
      dt = dt * tmul
      ISTART =   INT   ( START / si ) + 1
      ISTOP  =   INT   ( STOP  / si ) + 1
        IF ( ISTART . LT. 1     .OR. ISTART.GT. NSAMP ) THEN
           ISTART = 1
        ENDIF
        IF ( ISTOP . LE. ISTART .OR. ISTOP .GT. NSAMP ) THEN
           ISTOP  = NSAMP
        ENDIF
      NPT    =       ISTOP - ISTART + 1
      if(ire.lt.1.or.ire.lt.irs.or.ire.gt.nrec)ire = nrec
      nrecc = ire - irs + 1
      if(ns.le.0 )ns = 1
      if(ne.le.0 .or. ne.gt.ntrc)ne=ntrc

      igt0 = 2 * igt + 1
      call vfill (1.0, weight, 1, igt0)
      if (igt0 .gt. 1 .AND. .not.nowt) then
         igt2 = igt / 2 
         do  i = 1, igt2
             ang = 3.14159265 * float(i-1)/float(igt2)
             weight (i) = .5 * (1. - cos ( ang ) )
             weight (igt0-i+1) = weight (i)
         enddo
      endif

C**********************************************************************C
c     if ( verbos ) then
         write(LERR,*)' '
         write(LERR,*)' Values read from file command line'
         write(LERR,*)' Start time in ms (default = 0 ms)    =  ',START
         write(LERR,*)' Stop time in ms (default= full trace) =  ',STOP
         write(LERR,*)' Start time in samples                =  ',ISTART
         write(LERR,*)' Stop time in samples                  =  ',ISTOP
         write(LERR,*)' Number of velocity inputs             =  ',nvsvp
         write(LERR,*)' Minimum velocity ratio for plots      =  ',vsvp0
         write(LERR,*)' Maximum velocity ratio for plots      =  ',vsvp1
         write(LERR,*)' Time gate integer                     =  ',igt
         write(LERR,*)' Turn off cosine weighting?            =  ',nowt
         write(LERR,*)' Distance multiplied by a factor       =  ',dmul
         write(LERR,*)' Time multiplied by a factor           =  ',tmul
         write(LERR,*)' First record to process               =  ',irs
         write(LERR,*)' Last record to process                =  ',ire
         write(LERR,*)' Starting trace number                 =  ',ns
         write(LERR,*)' Ending   trace number                 =  ',ne
         write(LERR,*)' Using non hyperbolic velocity analysis'
         write(LERR,*)' '
         write(LERR,*)' Weight applied to time gate:'
         write(LERR,*)(weight(ii),ii=1,igt0)
         write(LERR,*)' '
c     end if
C**********************************************************************C


c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

      items = ntrc * (nsamp)
      itemv = nvsvp * (nsamp)
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.
      call galloc (wkvels, itemv*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemv*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemv*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c
c  adjust line header, historical l.h., & output header

       dg = (vsvp1 - vsvp0)/float(nvsvp-1)

       call savew( itr, 'MnLnIn',  0   , LINHED)
       call savew( itr, 'ILClIn',  vsvp0, LINHED)
       call savew( itr, 'CLClIn',  dg, LINHED)

       call savew( itr, 'NumTrc', nvsvp , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)
       call savew( itr, 'NumSmp', istop, LINHED)
       obytes = SZTRHD + SZSMPD * istop
       call savhlh ( itr, lbytes, lbyout )
        call wrtape(luout, itr, lbyout )

c
c---------------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)

C**********************************************************************C
C
C      READ TRACES, COMPUTE SPECTRA, WRITE RESULTS
C
C**********************************************************************C
        ist=0
        ddt=dt*1000
        ntrec=ire-irs+1
        DO 5001 JJ = irs, ire

c-----------------------------------------------
c  skip to start trace of current record
            call trcskp(jj,1,ns-1,luin,ntrc,itr)

c               write(*,*) 'nsjj=nt(1):',nt(1)
         IF(isingle .ne. 1) go to 8192
c               write(*,*) 'nsjj=nt(1):',nt(1)
               call mvdat(vp(1),nt(1),vvs)
               call mvdat(tp(1),nt(1),tts)
               nsjj=nt(1)
c               write(*,*) 'nsjj=nt(1):',nsjj
               call vinterp(tts,vvs,nsamp,ddt,nsjj,ttp,vvp,jj)
              do kkkk=1,nsamp
                 write(23,*) kkkk,vvp(kkkk)
              enddo
         go to 8193
8192     continue
c
c P-wave Velocity space time and space interpolations
c
         if(isp(jj) .eq. 0) then
c
c     No space interpolation is needed for the current trace
c
             call mvdat(vp(1+indptr(is(jj))),nt(is(jj)),vvs)
             call mvdat(tp(1+indptr(is(jj))),nt(is(jj)),tts)
             nsjj=nt(is(jj))
             call vinterp(tts,vvs,nsamp,ddt,nsjj,ttp,vvp,jj)
         else
c
c     Space interpolcation is needed. trace(jj) is obtained from
c     trace[inters(jj)] and trace[inters(jj)] by linear interpolation
c
             call mvdat(vp(1+indptr(is(jj))),nt(is(jj)),vvs)
             call mvdat(tp(1+indptr(is(jj))),nt(is(jj)),tts)
             call mvdat(vp(1+indptr(ie(jj))),nt(ie(jj)),vve)
             call mvdat(tp(1+indptr(ie(jj))),nt(ie(jj)),tte)
             nsjj=nt(is(jj))
             nejj=nt(ie(jj))
             call vinterp(tts,vvs,nsamp,ddt,nsjj,ttp,vvp1,jj)
             call vinterp(tte,vve,nsamp,ddt,nejj,ttp,vvp2,jj)
             xs=inters(jj)
             xe=intere(jj)
             x=isp(jj)
             call linterp(nsamp,xs,vvp1,xe,vvp2,x,vvp)
         endif
8193     continue
c
c      Now, vvp is ready to be used by the routine "tpsvel" for Vs/Vp
c      ratio scan. Nonhyperbolic aprroach.
c
c      create P-wave velocity tape after space interpolation
c
c       write(22,*) '"rec#',jj
c        do 123 ijk=1,nsamp
c           write(22,321) ttp(ijk), vvp(ijk)
c123     continue
c321     format(2x,f12.4,2x,f16.2)
c        write(22,*)
c        write(22,*)
c
           ist=ist+1
           k=0

c----------------------------
c  read selected data
           DO 5002 KK = ns, ne

                 NBYTES = 0
                 CALL RTAPE  ( LUIN, ITR, NBYTES )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 999
                 endif
                 call vmov (lhed(ITHWP1),1,tri,1,nsamp)
                 call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic , TRACEHEADER)

                 IF (istatic .ne. 30000) THEN
                     call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           irec , TRACEHEADER)
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idis , TRACEHEADER)
                     call saver2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                           idi  , TRACEHEADER)
                     k=k+1
                     dis(k) = iabs( idis ) * dmul
                     istrc  = (k-1) * nsamp
                     do 5004 LL= 1, nsamp
                           traces(istrc + LL) = tri(LL)
 5004                continue
                 ENDIF

 5002      CONTINUE

c----------------------------------
c  do spectra
      call tpsvel(traces,vels,lhed,tri,dt,nvsvp,k,dis,thresh,
     1          vsvp0,vsvp1,luout,obytes,irec,vvp,ttp,np,
     2          ntap,jj,ns,ne,nsi,nsamp,istart,istop,weight,
     3          start,stop,igt,abslut,irs,ire,ist,idi,
     4          ifmt_TrcNum,l_TrcNum,ln_TrcNum,vello,velhi,
     5          ifmt_RecNum,l_RecNum,ln_RecNum,
     6          ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     7          ifmt_DphInd,l_DphInd,ln_DphInd,
     8          ifmt_StaCor,l_StaCor,ln_StaCor)

      jleft=ntrec-(JJ-irs+1)
      pcd=(1.0-1.0*jleft/ntrec)*100.0
c      write(LER,4999)'Completed Record ',JJ, ',',pcd,'% '
      write(LER,4999)JJ,pcd
4999  format(2x,'Completed Record ',i4,' , ',f6.2,'% has been done')
 5001 CONTINUE

  999 continue
      call lbclos( luin)
      call lbclos(luout)
c
      call exit(0)
      end
C**********************************************************************C

C**********************************************************************C
      subroutine tpsvel(traces,vels,lhed,tri,dt,nvsvp,k,dis,thresh,
     1                vsvp0,vsvp1,luout,obytes,irec,vp,tp,np,
     2                ntap,nrec,ktrc1,ktrc2,nsi,nsamp,istart,istop,
     3                wt,start,stop,igt,abslut,irs,ire,ist,idi,
     4                ifmt_TrcNum,l_TrcNum,ln_TrcNum,vello,velhi,
     5                ifmt_RecNum,l_RecNum,ln_RecNum,
     6                ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     7                ifmt_DphInd,l_DphInd,ln_DphInd,
     8                ifmt_StaCor,l_StaCor,ln_StaCor)
C**********************************************************************C
c      SUBROUTINE ARGUMENTS
c
c      traces    R*4      Two dimensional array of spectra of trace
c                         traces(LL,LR) for trace LR and time LL
c      obytes    I*4      output number of bytes
c      itr       I*2      output data vector equivalenced to...
c...   tri       R*4      ...output real data vector
c      luout     I*4      output data unit number
c      istart    I*4      start time in samples
c      start     R*4      start time in ms
c      istop     I*4      stop time in samples
c      stop      R*4      stop time in ms
c      dt        R*4      Sample interval in MILLISECONDS
c      nvsvp     I*4      Number of velocity inputs
c      k         I*4      Number of traces
c      dis       R*4      Array of source-receiver distances
c      vsvp0     R*4      Minimum velocity  (ft/sec)for plot
c      vsvp1     R*4      Maximum velocity  (ft/sec)for plot
c      ntap      C*120    File name
c      nrec      I*4      Record number
c      ktrc1     I*4      Starting trace number
c      ktrc2     I*4      Ending trace number
c      nsi       I*4      Sample interval in MILLISECONDS
c      NSAMP     I*4      Number of samples in original time series
c      IGT       I*4      integer for time gate centered at zero-offset time
c                         semblance varies between 0 and 1
c      abslut    L        contour absolute semblance rather than relative
c      vp        R*4      P-wave velocity function
c      tp        R*4      time function for P-wave velocity
C**********************************************************************C
c

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      real*4    traces(nsamp,k), vels(nsamp,nvsvp),tri(nsamp)
      real*4    vp(1),tp(1),vtps(SZSMPM)
      integer   lhed(*)
      integer*4 IGT,nvsvp,IO
      real*4    dis(k), wt(k)
      real*4    cnnum,cnden,xtrc,amp
      real*4    vel, vello(nsamp), velhi(nsamp)
      real*4    snum(SZSMPM),sden(SZSMPM)
      real*4    cn(SZSMPM)
      logical   abslut

      xtrc=k
      dt1 = dt
C**********************************************************************C
c     perform scan of non-hyperbolic trajectories to determine the Vs/Vp
C**********************************************************************C
      recmax = 0.0

         gbeg = vsvp0
         gend = vsvp1
         dg   = (vsvp1-vsvp0)/(nvsvp-1)

      if (nrec .eq. irs) then
c         write(LERR,1153)'Velocity ratio increment = ',dg
c         write(LER ,1153)'Velocity ratio ncrement = ',dg
         write(LERR,1153) dg
         write(LER ,1153) dg
      endif
1153     format(2x,'Velocity ratio increment = ',f10.5)
C**********************************************************************C
c       for each velocity ratio
C**********************************************************************C
      DO 100 IR = 1,nvsvp
            do 45 LL=1,ISTOP
               cn(LL) = 0.
   45       continue

         g=gbeg+(ir-1)*dg

            DO 51 LL=ISTART,ISTOP
              snum(LL) = 0.
51            sden(LL) = 0.
c
c   converting V(tp,vp) to V(tps,vp)
c
c*************************************
c         call tp2tps(tp,tps,g,np)
c          do 47 l=1,nsamp
c              vtps(l)=vp(l)
c         write(*,*) tp(l),tps(l),vtps(l)
c47    continue
         ddt=dt*1000
         call tp2tps1(vp,g,0.0,ddt,nsamp,vtps)
c*************************************
C**********************************************************************C
c         write(21,*) '"x-offset'
      DO 102 LR = 1,k
c
c     get offset
c
         x = dis(lr)
         
C**********************************************************************C
      DO 102 LL = ISTART,ISTOP

         IF (g .ge. gbeg .AND. g .le. gend) THEN
c
c     get conversion distance
c
         tpss=(ll-1)*dt1
         z=g*tpss*vtps(ll)/(1.0+g)
         call getxp(x,z,g,xp)
c
c
c            1                      1
c     tps = --- SQRT[xp**2+z**2] + ---- SQRT[(x-xp)**2+z**2]
c           Vp                     GVp
c
c                xp**2    z**2             (x-xp)**2    z**2
c   dt1*N = SQRT[----- + -----] + --- SQRT[--------- + -----]
c                Vp**2   Vp**2     G        Vp**2      Vp**2
c
c
c The amount of P-S NMO in terms of samples is given by
c
c
c                xp**2         z**2        1        (x-xp)**2        z**2
c   N = SQRT[----------- + -----------] + --- SQRT[----------- + -----------]
c            (dt1*Vp)**2   (dt1*Vp)**2     G       (dt1*Vp)**2   (dt1*Vp)**2
c
c
c
c     z**2       G*(LL-1)*dt1*vp/(1+G)        G*(LL-1)
c  ---------- = (---------------------)**2 = (--------)**2
c  (dt1*Vp)**2         dt1*Vp                  1+G
c
c
c
c
         rxp= (xp/(vtps(ll)*dt1))**2
         rxs= ((dis(lr)-xp)/(vtps(ll)*dt1))**2
c
c
c
            ttp=sqrt((g*(LL-1)/(1.0+g))**2+ rxp)+1.0
            tts=sqrt((g*(LL-1)/(1.0+g))**2+ rxs)/g
            tt = ttp+tts

c         write(21,22) x,tpss,z,xp,rxp,rxs,ttp,tts
c22       format(1x,f8.1,1x,f8.3,2x,f8.3,2x,f8.2,1x,f8.2,1x,f8.2,1x,
c     1          2(f8.2,1x))
            it = tt
c           dx = tt -it
            if(it.lt.1)then
                  amp = 0.0
            elseif(it.ge.nsamp)then
                  amp = 0.0
            else
c                 xx1 = traces(it,LR)
c                 xx2 = traces(it+1,LR)
c                 amp = rinter(xx1,xx2,dx)
                  amp = traces(it,LR)
            endif
                        snum(LL)=snum(LL) + amp
                        sden(LL)=sden(LL) + amp*amp
          ELSE
            snum(LL) = 0.
          ENDIF

102   CONTINUE
C**********************************************************************C
c      square numerator term
C**********************************************************************C
            DO 103 LL=ISTART,ISTOP
               snum(LL)=snum(LL)**2
103         continue
C**********************************************************************C
c      decide for a time gate
C**********************************************************************C
      IGTP= ISTART + IGT
      IGTM= ISTOP  - IGT
      IO= IGTM - IGTP + 1
C**********************************************************************C
c      begin to compute semblance for a given velocity
C**********************************************************************C
      DO 200 LL=IGTP,IGTM
            cnnum = 0.
            cnden = 0.
C**********************************************************************C
            IGL = LL-IGT
            if (IGL.le.0) IGL = 1
            IGH = LL+IGT
            if (IGH.gt.ISTOP) IGH = ISTOP
C**********************************************************************C
            ig = 0
            DO 305 I=IGL,IGH
              ig = ig + 1
              wti = wt (ig)
              cnnum = cnnum + snum(I) * wti
              cnden = cnden + sden(I)
305         continue
C**********************************************************************C
c
c   put correlation z-values into big matrix
            if(cnden.ne.0.0)cn(LL)=307.*cnnum/(xtrc*cnden)
C**********************************************************************C
200       continue
C**********************************************************************C
c
c   if absolute is true do not normalize correlation in time
      call vclr ( tri,1,istop )
      if(.not.abslut) then
            fmax=0.
            do 210 LL=ISTART,ISTOP
                 if(cn(LL) .ge. fmax) then 
                     fmax = cn(LL)
                     llmax = LL
                 endif
210         continue
         if(fmax .ne. 0.) then
            do 220 LL=ISTART,ISTOP
               sem = cn(LL)/fmax
               if (sem .lt. thresh) sem = 0.0
               tri(LL) = sem
220         continue
         endif
      else
            do 230 LL=ISTART,ISTOP
               sem = cn(LL)
               if (sem .lt. thresh) sem = 0.0
               tri(LL) = sem
230         continue
      endif
C**********************************************************************C
          call vmov (tri, 1, vels(1,IR), 1, nsamp)
100       continue
C**********************************************************************C
      do  1000  J = 1, nvsvp
          call vmov (vels(1,J), 1, tri, 1, nsamp)
          vel= gbeg+(J-1)*dg
          ivel = vel*1000
          call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec , TRACEHEADER)
          call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                 J   , TRACEHEADER)
          call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                ivel , TRACEHEADER)
          call savew2(lhed,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                idi  , TRACEHEADER)
          call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                 0   , TRACEHEADER)
          call vmov  (tri, 1, lhed(ITHWP1), 1, nsamp)
          call wrtape(luout, lhed, obytes)
1000  continue
c
      return
      end
C**********************************************************************C
C**********************************************************************C
      function rinter(y1,y2,dx)
C**********************************************************************C
c      interpolate between y1 and y2 for 0 < dx < 1
C**********************************************************************C
      rinter = (1.0 - dx)*y1 + dx*y2
      return
      end

c-----------------------------------------
c  online help section
c-----------------------------------------
       subroutine  help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)' '
      write(LER,*)
     :'PSVSPEC construct Vs/Vp ratio spectrum for P-S converted'
      write(LER,*)
     :'wave data. Users provide P-S converted wave data and the'
      write(LER,*)
     :'corresponding P-wave velocity picks.'
      write(LER,*)' '
      write(LER,*)
     :'Execute program by typing psvspec and the following arguments'
      write(LER,*)
     :' -N[ntap]    (default stdin)     : Input data file name'
      write(LER,*)
     :' -O[otap]    (default stdout)    : Output data file'
      write(LER,*)
     :' -Vpik[vpik]   (default ignore)  : P-wave velocity pick file'
c      write(LER,*)
c     :' -vflag[vflag] (default=2)       : Velocity pick file format'
c      write(LER,*)
c     1'             = 0: disco HANDVEL'
c      write(LER,*)
c     2'             = 1: flat file'
c      write(LER,*)
c     3'             = 2: XSD pick file'
c      write(LER,*)
c     4'             = 3: CVD or XVOS pick file'
c      write(LER,*)
c     4'             = 4: TDFN format'
      write(LER,*)
     :' -tmin[start] (deflt=0)          : start time of spectra (ms)'
      write(LER,*)
     :' -tmax[stop] (deflt = full trace):stop time of spectra (ms)'
      write(LER,*)
     :' -rs[irs],     (default=1)  : beginning record number'
      write(LER,*)
     :' -re[ire],   (default=last) : ending record number'
      write(LER,*)
     :' -ns[ns],      (default=1)  : starting trace number'
      write(LER,*)
     :' -ne[ne]     (default=last) : ending trace number'
      write(LER,*) ' '
      write(LER,*)
     :' -nvsvp[nvsvp] (default=101): number of velocity ratios'
      write(LER,*)
     :' -igt[igt]    (default=8)   : samples in time gate(= 2*igt*dt)'
      write(LER,*)
     :' -dmul[dmul]    (default=1) : distance multiplier'
      write(LER,*)
     :' -tmul[tmul]   (default=1)  : sampling interval multiplier'
      write(LER,*)
     :' -vsvp0[vsvp0]  (deflt=0.3) : Minimum Vs/Vp ratio for plot'
      write(LER,*)
     :' -vsvp1[vsvp1]  (deflt=0.8) : Maximum Vs/Vp ratio for plot'
      write(LER,*)
     :' -thld[thresh]  (deflt=0.0) : zero semblances < this value'
      write(LER,*) ' '
      write(LER,*)
     :'USAGE: psvspec -N[ntap] -re[re] -rs[rs] -ns[ns] -ne[ne]'
      write(LER,*)
     :'       -vsvp0[vsvp0] -vsvp1[vsvp1] -nvsvp[nvsvp] -Vpik[vpik]'
      write(LER,*)
     :'       -tmin[start] -tmax[stop] -igt[igt]'
         write(LER,*) ' '
         write(LER,*)
     1 ' Contact: Yaohui Zhang/Ext3901, E&PTG'
         write(LER,*)
     1 '          Email: yzhang@amoco.com'
         write(LER,*)
     :'***************************************************************'

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c   start   - R      start time of analysis
c    stop   - R      stop time
c    dmul   - R      distance multiplier
c    tmul   - R      sample interval multiplier
c    nvsvp   - I      number velocities
c    vmin   - R      min velocity
c    vmax   - R      max velocity
c    abslut - L      use absolute semblance
c    verbos - L      verbose output or not
c-----
       subroutine cmdln (ntap,otap,vpikf,vfm,start,stop,dmul,tmul,
     1    igt,ns,ne,irs,ire,nvsvp,vsvp0,vsvp1,abslut,verbos,nowt)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
       character  ntap*(*), otap*(*), vpikf*(*)
       integer    ns,ne,irs,ire,nvsvp,igt,start,stop,vfm
       real       dmul,tmul,vsvp0,vsvp1
       logical    abslut, verbos,nowt

         call argstr('-N', ntap, ' ', ' ' )
         call argstr('-O', otap, ' ', ' ' )
         call argstr('-Vpik', vpikf, ' ', ' ' )
         call argr4 ('-tmin', START, 0., 0.)
         call argr4 ('-tmax', STOP , 0., 0.)
         call argr4('-dmul',dmul,1.0,1.0)
         call argr4('-tmul',tmul,1.0,1.0)
         call argi4('-igt',IGT,8,8)
         call argi4('-vfm', vfm ,2,2)
         call argi4 ('-rs',irs,1,1)
         call argi4 ('-re',ire,0,0)
         call argi4 ('-ns',ns,1,1)
         call argi4 ('-ne',ne,0,0)
         call argi4 ('-nvsvp',nvsvp,101,101)
         call argr4('-vsvp0',vsvp0,0.3,0.3)
         call argr4('-vsvp1',vsvp1,0.8,0.8)
         call argr4('-thld',thresh,0.0,0.0)
         nowt     = ( argis ('-W') .gt. 0 )
         return
         end

