C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c------------------------------
c  online help section
c------------------------------
      subroutine  help  
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for DMOAMP: dip moveout'
        write(LER,*)'to zero offset with true amplitude: prestack &'
        write(LER,*)'post-stack'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set               (stdin)'
        write(LER,*)'-O[otap]   -- output data set        (no pipe out)'
        write(LER,*)'-v[ntap]   -- CMP velocity tape'
        write(LER,*)'-dv[idv]   -- time decimation of velocity trc  (2)'
        write(LER,*)' '
        write(LER,*)'-st[st]    -- start time (ms) of dmo  (first samp)'
        write(LER,*)'-et[et]    -- end time (ms) of dmo     (lest samp)'
        write(LER,*)'-sp1[xs1]  -- starting shot index on line      (1)'
        write(LER,*)'-srcpt     -- use SoPtNm for source pt index, else'
        write(LER,*)'              use SrcLoc (srcpt x 10)'
        write(LER,*)'-fr[fr]    -- starting record to process   (first)'
        write(LER,*)'-lr[lr]    -- ending record to process      (last)'
        write(LER,*)'-ds[ds]    -- shot coordinate increment     (none)'
        write(LER,*)'-dm[dm]    -- midpoint coordinate increment (none)'
        write(LER,*)'-nm[nm]    -- # CDPs override     (# recs on vtap)'
        write(LER,*)'-dip[dip]  -- max dip                         (90)'
        write(LER,*)' '
        write(LER,*)'-dl1[dl1]  -- leftmost range limit   (end of sprd)'
        write(LER,*)'-dl2[dl2]  -- nearleft range limit   (near offset)'
        write(LER,*)'-dr1[dl1]  -- nearright range limit  (near offset)'
        write(LER,*)'-dr2[dl2]  -- rightmost range limit  (end of sprd)'
        write(LER,*)' '
        write(LER,*)'pre-stack:'
        write(LER,*)'-dg[dg]    -- CDP spread model: bin size (ft,m)'
        write(LER,*)'-ng[ng]    -- CDP spread model: number bins'
        write(LER,*)'-fg[fg]    -- CDP spread model: max offset (ft,m)'
        write(LER,*)'-S         -- CDP spread model: split spread'
        write(LER,*)'-R         -- restart (at shot rs trc ns)'
        write(LER,*)'-ns[ns]    -- restart trc # for shot fs        (1)'
        write(LER,*)' '
        write(LER,*)'-amp[amp]  -- amp = 0: common shot amp   (default)'
        write(LER,*)'           -- amp = 1: common offset amp'
        write(LER,*)'           -- amp = 2: Kninematic DMO amp term'
        write(LER,*)'-A         -- if present process all dips  (to 90)'
        write(LER,*)'              else, allow no aliasing'
        write(LER,*)'-GS        -- if present does not have 0-offset spr
     1  eading'
        write(LER,*)'              else, output contains 0-offset spread
     1  ing'
        write(LER,*)'              else, allow no aliasing'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   dmoamp -N[] -O[] -v[] -sp1[] -fr[] -lr[] -ds[]'
        write(LER,*)'          -dm[] -dip[] [ -dl1[] -dl2[] -dr1[]'
        write(LER,*)'           -dr2[] ] [-dg[] -ng[] -fg[] -S -R'
        write(LER,*)'           -ns[]] -dv[] [-nm[] -amp -A -GS -V'
        write(LER,*)'           -srcpt]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     irs   - I      start record
c     ire   - I      stop end record
c      ns   - I      start trace
c      ne   - I      end trace
c     dx    - R      shot spacing (input)
c    revrse - L      inverse dmo
c    verbos - L      verbose output or not
c-----
C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
c       .. readpar reads the parameter file bdmo.par,
c       .. and fills velocity map.

        subroutine cmdln  ( ntap, iss, lss, xs1, dxs, nearoff, dxg,
     ;                    otap, xmin, nx, dx, maxdip, vtap, idv,
     ;                    aliasflag, ampflag, sprdflag, source,
     ;                    verbos, ist,iend,irs,ire,ns,ne,ncdp,
     ;                    dl1, dl2, dr1, dr2, far,split,restart,pre)

#include <f77/iounit.h>
      character  ntap*(*), otap*(*), vtap*(*)
      real       dx, nearoff, xs1, dxs, dxg, xmin, maxdip
      real       dl1, dl2, dr1, dr2
      integer    argis,ist,iend,irs,ire,ns,ne, idv
      integer    aliasflag, ampflag, sprdflag, nx
      logical    verbos, alias, sprd, split, restart, pre, source

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argstr('-v',vtap,' ',' ') 
          call argi4('-dv', idv , 2 , 2 )
          call argi4('-fr', iss , 1 , 1 )
          call argi4('-lr', lss , 0 , 0 )
          call argr4('-sp1', xs1 ,-999999.0,-999999.0)
          call argr4('-ds', dxs ,0.0,0.0)
          call argr4('-fg', far ,0.0,0.0)
          call argr4('-dg', dxg ,0.0,0.0)
          call argi4('-ng', ncdp, 0 , 0 )
          call argr4('-dm',dx,0.,0.)
          call argr4('-fm',xmin,0.,0.)
          call argi4('-nm',nx,0,0)
          call argr4('-dip',maxdip, 90. ,90. )

          call argr4('-dl1',dl1, -9999999. ,-9999999. )
          call argr4('-dl2',dl2, -0000000. ,-0000000. )
          call argr4('-dr1',dr1, +0000000. ,+0000000. )
          call argr4('-dr2',dr2, +9999999. ,+9999999. )

          call argi4('-st', ist , 1 , 1 )
          call argi4('-et', iend, 0 , 0 )
          call argi4('-ns', ns  , 1 , 1 )
          ne   = 0
          irs  = 1
          ire  = 0
          source  = (argis('-srcpt') .gt. 0)
          restart = (argis('-R') .gt. 0)

          call argi4 ('-amp',ampflag, 0 ,0 )
          alias  = (argis('-A') .gt. 0)
          if (alias) then
             aliasflag = 1
          else
             aliasflag = 0
          endif
          call argi4('-A',aliasflag,0,0)
          split  = (argis('-S') .gt. 0)
          sprd   = (argis('-GS') .gt. 0)
          if (sprd) then
             sprdflag = 0
          else
             sprdflag = 1
          endif
          pre    = (argis('-P') .gt. 0)
          verbos = (argis('-V') .gt. 0)

c       if ( vtap(1:1) .eq. ' ') then
c               write(LERR,*)
c               write(LERR,*) 'PARAMETER ERROR:'
c               write(LERR,*) 'Velocity tape must be a named disk file'
c               write(LERR,*) 'using -v[] on cmd line'
c               write(LERR,*)
c               stop
c       end if
        if ( pre .and. otap(1:1) .eq. ' ') then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'For pre-stack option output data must go'
                write(LERR,*) 'to a named disk file, -O[]'
                write(LERR,*)
                stop
        end if
        if ( restart .and. .not.pre) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'Cannot restart dmo stack, only prestack'
                write(LERR,*) 'option ( -P )'
                write(LERR,*)
                stop
        end if
        if ( dxs .le. 0.0 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'dxs =', dxs
                write(LERR,*) 'dxs must be positive'
                write(LERR,*)
                stop
        end if
        if ( pre .and. far .eq. 0.0 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'far = ', far
                write(LERR,*) 'far off must be non-negative.'
                write(LERR,*)
                stop
        end if
        if ( pre .and. dxg .le. 0.0 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'CDP grp interval dxg =', dxg
                write(LERR,*) 'dxg must be positive'
                write(LERR,*)
                stop
        end if
        if ( pre .and. ncdp .eq. 0 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'ncdp = ', ncdp
                write(LERR,*) 'Must enter # traces/CDP'
                write(LERR,*)
                stop
        end if
        if ( dx .le. 0.0 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'dx =', dx
                write(LERR,*) 'dx should be positive'
                write(LERR,*)
                stop
        end if
        if ( maxdip .lt. 0.0 .or. maxdip .gt. 90.0 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'maxdip =', maxdip
                write(LERR,*) 'maxdip must be 0 to 90 degrees.'
                write(LERR,*)
                stop
        end if
        if ( aliasflag .lt. 0 .or. aliasflag .gt. 1 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'aliasflag =', aliasflag
                write(LERR,*) 'aliasflag can be 0 or 1.'
                write(LERR,*)
                stop
        end if
        if ( ampflag .lt. 0 .or. ampflag .gt. 2 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'ampflag =', ampflag
                write(LERR,*) 'ampflag can be 0, 1 or 2.'
                write(LERR,*)
                stop
        end if
        if ( sprdflag .lt. 0 .or. sprdflag .gt. 1 ) then
                write(LERR,*)
                write(LERR,*) 'PARAMETER ERROR:'
                write(LERR,*) 'sprdflag =', sprdflag
                write(LERR,*) 'sprdflag can be 0 or 1.'
                write(LERR,*)
                stop
        end if


      return
      end
