C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
************************************************************************
*
* This program belongs to the Center for Wave Phenomena
* Colorado School of Mines
*
* $Author: chris $
* $Source: /src/su/src/Subs/RCS/logdmosbs.f,v $
* $Revision: 1.3 $ ; $Date: 88/09/08 20:51:50 $
*
************************************************************************

	subroutine logdmo(rdata,nt,dt,ny,dy,h,dmosgn,cdata,ky,w,
     1                    work,first)

************************************************************************
*
*	LSDMOSUB -- fortran subroutine for doing 'Full Log' DMO
*
*	INPUT DATA/PARAMETERS -- rdata(nt,ny),nt,dt,ny,dy,h,dmosgn
*
*	INPUT EMPTY ARRAYS FOR MEMORY ALLOCATION 
*			      -- cdata(nt,ny),ky(ny),w(ny)
*
*	OUTPUT DMO'D DATA     -- rdata(nt,ny)	
*			         .. still needs inverse log stretch ..
*
*	SUMMARY -- carry out preliminary fft's, initialize freq and
*		   wavenumber vectors, make DMO phase operator,
*		   mult data by operator for all freqs and wavenumbers, 
*		   then do inverse ffts.
*
*   Technical Reference: Liner, C. L., 1988, Colo. School of Mines,
*			 Center for Wave Phenomena, Res. Report cwp-073
*		      &	 Bale and Jakubowicz, 1987, SEG Expanded Abstr.,
*			 New Orleans Meeting, p.714 
*
*
*   Definition of Variables - Complex
*
*	CDATA(,) =  complex data
*	CI	 =  sqrt(-1)
*	CZERO	 =  cmplx(0,0) 
*	PHASE(,) =  phase function of complex operator
*	OPER(,)  =  DMO operator in (freq,wavenumber) space
*     WRKAREA(,) =  ***** NOT USED ******* 
*
*   Definition of Variables - Real
*
*	AMP	=   amplitude of DMO operator 
*	ARG	=   argument for the phase log function
*	BETA	=   ys / h
*      RDATA(,)	=   real common offset input data
*	DKY	=   wavenumber increment
*	DMOSGN	=   flag for forward or inverse dmo
*		    +1 = DMO .... -1 = inv.DMO
*	DT	=   time sample rate of data 
*	DW	=   frequency increment
*	DY	=   trace spacing (midpoint increment) 
*	H	=   half of source-receiver offset 
*	H2	=   h*h
*	KY()	=   wavenumber array
*	KY2	=   ky()*ky()
*	ONE	=   1.0
*	PI	=   pi 
*	TWO	=   2.0
*	W()	=   frequency array
*	W2	=   w()*w()
*	WOKY	=   w()/ky()
*	YS	=   y stationary point (from stationary phase)
*	ZERO	=   0.0
*
*   Definition of Variables - Integer 
*
*	DMOSGN	=   +1 for DMO; -1 for inverse DMO
*	IKY	=   wavenumber counter
*	IW	=   frequency counter
*	IY	=   trace counter
*	NT	=   time samples on input data
*	NTNYQ	=   nyquist freq index
*	NY	=   traces on input data
*	NYNYQ	=   nyquist wavenumber index
*
************************************************************************
cimplicit undefined (a-z)
	integer dmosgn,	iky,	iw,	iy,
     :		nt,	ntnyq,	ny,	nynyq
	real 	    	arg,	beta,	dk,	dt,	dw,	dy,
     : 		h,	h2,	             	ky(ny),	ky2,
     :		one,	pi,	rdata(nt,ny),
     :		two,	w(nt),	woky,	w2,	ys,	zero
	complex ci,	cdata(nt,ny),	czero,	phase,	oper
        complex work(nt)
        logical first
	parameter(pi=3.14159265)

        if (h .eq. 0.0) return

c	.. set constants
	zero = 0.0
	one = 1.0
	two = 2.0
	czero = cmplx(zero,zero)
	ci = cmplx(zero,one)

c	.. calculate some constants
        fnt = nt
        fny = ny
	ntnyq = nt/2 + 1
	nynyq = ny/2 + 1
        nt12  = ntnyq
        nx12  = nynyq
        rntny = 1./float(nt*ny)
	h2 = h*h
 
c  	.. FT (t,x) --> (w,k)

         do  1  j = 1, ny
            do  2  i = 1, nt

                cdata(i,j) = cmplx( rdata(i,j), 0.0 )

2           continue
1       continue

c       call cfft2d ( cdata, nt, ny, 1)


c        do  2  i = 1, nt12
c
c               call rfftsc (cdata(i,1), ny, 3, 1)
c
c2       continue

        call ft2d(nt,ny,cdata,1.,-1.,sqrt(1./fnt),sqrt(1./fny),work)
        do  10  j = 1, ny
 
                call cvsmul (cdata(1,j), 2, rntny, cdata(1,j), 2, nt)
 
10      continue

c-------------------------------------
c 	.. Initialize ky vector
c
c					.. Positive wavenumbers
      IF (first) THEN

	dk= ( two*pi ) / ( float(ny)*dy )
      	do 11 iky = 1, nynyq
         	ky(iky) = ( iky - one )*dk
 11   	continue
c					.. Negative wavenumbers
      	do 12 iky = nynyq + 1, ny
       	  	ky(iky) = ( iky - one - ny )*dk
 12   	continue
 
c 	.. Initialize w vector
c
c					.. Positive frequencies
	dw = ( two*pi ) / ( float(nt)*dt )
      	do 13 iw = 1, ntnyq
         	w(iw) = ( iw - one )*dw
 13   	continue
c					.. Negative frequencies
      	do 14 iw = ntnyq + 1, nt
         	w(iw) = ( iw - one - nt )*dw
 14   	continue

      ENDIF
c-------------------------------------
 
c	.. MAIN LOOPS ..
 
c	.. loop over wavenumbers
      	do 111 iky = 1, ny
	        ky2 = ky(iky)*ky(iky)
 
c		.. loop over frequencies
      		do 113 iw = 1, nt
                	w2 = w(iw)*w(iw)
 
c                    .. calc asymptotic DMO operator using ys.
c                    .. special cases for h=0, k=0, and w=0
                     if ( h.eq.zero.or.ky(iky).eq.zero ) then
                         oper = cmplx(one,zero)
                     else
                         if ( w(iw).eq.zero ) then
                             oper = czero
                         else

c                        .. calc stationary y-value, ys.
                         woky = w(iw) / ky(iky)
                         ys = .5*woky*( sqrt(one+4.0*h2*ky2/w2) - one )
                         beta = ys/h
                         amp = one / sqrt( one + beta*beta )
                         arg = one - ys*ys/h2
                         if ( dmosgn.eq.-1 ) amp = one / amp

c                        .. avoid neg log argument
                         if ( arg.gt.zero ) then
                            phase = -ci*(.5*w(iw)*log( arg )+ky(iky)*ys)
                            phase = phase*dmosgn
                            oper  = amp*cexp(phase)
                         else
                            oper = czero
                         endif
                       endif
                     endif

 
c  			.. mult. (w,k)-data by DMO operator
			cdata(iw,iky) = cdata(iw,iky)*oper
 113		continue
 111	continue
 
c  	.. FT (w,k) --> (t,x)

c        do  4  i = 1, nt12
c
c               call rfftsc (cdata(i,1), ny, -3, 0)
c
c4       continue
c        do  3  j = 1, ny12
c
c               call rfftsc (cdata(1,j), nt, -3, 0)
c
c3       continue

c       call cfft2d ( cdata, nt, ny, -1)

        call ft2d(nt,ny,cdata,-1.,1.,sqrt(1./fnt),sqrt(1./fny),work)

         do  3  j = 1, ny
            do  4  i = 1, nt

                rdata(i,j) = real( cdata(i,j) )

4           continue
3       continue

	return
	end
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
