C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER   -                                             *
C      HELP              -                                             *
C      OPENPR            -                                             *
C      GCMDLN            -                                             *
C      GETLN             -                                             *
C      GALLOC            -                                             *
C      VERBAL            -                                             *
C      SRTIDX            -                                             *
C      AMNEB             -                                             *
C      WEIGHT  REAL      -                                             *
C      NBRHD   INTEGER*2 -                                             *
C      AVERGE            -                                             *
C      INTRP             -                                             *
C      VMOV              -                                             *
C      VCLR              -                                             *
C      SAVEW             -                                             *
C      HLHPRT            -                                             *
C      WRTAPE            -                                             *
C      LBCLOS            -                                             *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MIN     GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C  FILES:                                                              *
C      LER   ( OUTPUT SEQUENTIAL ) -                                   *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C      LUIN  ( INPUT  SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 6) -                                                 *
C      75       ( 2) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:     12 DETECTED                               *
C      INTEGER*                                                        *
C      POINTER (PGRID, GRID(1))                                        *
C      POINTER (PGRID2, GRID2(1))                                      *
C      POINTER (PGRIDT, GRIDT(1))                                      *
C      POINTER (PWEIGHT, WEIGHT(1))                                    *
C      POINTER (PZ, Z(1))                                              *
C      POINTER (PX, X(1))                                              *
C      POINTER (PY, Y(1))                                              *
C      POINTER (PKX, KX(1))                                            *
C      POINTER (PKY, KY(1))                                            *
C      POINTER (PNBRHD, NBRHD(1))                                      *
C      statement out of order :            GRID(INDEX)=DEL             *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c aint - February 13, 1995
c This modification allows several new diagnostic modes including the
c ability to plot the pick number, pick location, and inline or crossline
Cnumber.
c Gary Murphy                     Version 1.1             March 15, 1995
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/localsize.h>
c-----
 
      parameter (NYMAX=4000)
      integer     luin , luout
      character*1 blank(80)
 
c------
c  dynamic memory allocation for big arrays, eg whole records
      real x, y, weight, grid, grid2, gridt
      integer*2 z, kx, ky, nbrhd
      pointer (pgrid, grid(1))
      pointer (pgrid2, grid2(1))
      pointer (pgridt, gridt(1))
      pointer (pweight, weight(1))
      pointer (pz, z(1))
      pointer (px, x(1))
      pointer (py, y(1))
      pointer (pkx, kx(1))
      pointer (pky, ky(1))
      pointer (pnbrhd, nbrhd(1))
 
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   inpick * 100, otap * 100, name*4, version*4
      logical     verbos, hlp, query, cnvxhl, hgridt
      logical     hgrid, hgrid2, hweight, hz, hx, hy, hkx, hky, hnbrhd
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      INTEGER IHEAD(SZLNHD)
      INTEGER*2 IRX(LNTRHD)
      REAL RXX(NYMAX+ITRWRD),DATA(NYMAX)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
      DATA BLANK/80*' '/
 
      data name/'AINT'/, version /' 1.1'/
      RDIST(XX,YY)=1./SQRT(XX*XX+YY*YY)
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
      if ( hlp ) then
           call help()
           stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/mbsopen.h>
 
      call gcmdln(inpick,otap,verbos,
     1            dy,dx,ny,nx,ili1,idi1,cnvxhl,del,lidi)
 
c     get logical output for tape
c-----
      call getln(luout, otap, 'w', 1)
 
      if (ny .gt. NYMAX) then
         write (lerr, *) ' error - number of li(s) exceeds ', NYMAX
         stop
      endif
      minli=ili1
      maxli=ny+ili1-1
      mindi=idi1
      maxdi=nx+idi1-1
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings inpick & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if inpick & otap are blank strings, i.e. inpick = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c-----
c  compute size of input buffer
      if(inpick.eq.' ')then
         write(LERR,*)' must specify li, di, z file.'
         stop
      endif
      luin=19
      open(unit=luin,file=inpick,status='unknown',iostat=ierr)
      if(ierr.ne.0)then
         write(LERR,*)' end of file or error opening ', inpick
         stop
      endif
      itot=0
      icount=0
      zmin=50000.
      zmax=-50000.
      minix=99999
      miniy=99999
      maxix=-99999
      maxiy=-99999
  100 continue
         itot=itot+1
         read(luin,*,end=110,err=100)iy,ix,iz
         if(ix.lt.minix)minix=ix
         if(ix.gt.maxix)maxix=ix
         if(iy.lt.miniy)miniy=iy
         if(iy.gt.maxiy)maxiy=iy
         if(minli.le.iy.and.iy.le.maxli.and.
     1      mindi.le.ix.and.ix.le.maxdi)then
            icount=icount+1
            if(iz.lt.zmin)zmin=iz
            if(iz.gt.zmax)zmax=iz
         endif
         goto 100
  110 continue
      rewind(luin)
      if(nx.eq.0)then
         minli=miniy
         mindi=minix
         maxli=maxiy
         maxdi=maxix
         nx=maxdi-mindi+1
         ny=maxli-minli+1
         icount=itot
      endif
      if(verbos)then
         write(LERR,*) ' total lines read ', itot
         write(LERR,*) ' total coordinates read ', icount
         write (lerr, *) ' minimum li = ', minli
         write (lerr, *) ' minimum di = ', mindi
         write (lerr, *) ' maximum li = ', maxli
         write (lerr, *) ' maximum di = ', maxdi
      endif
 
c---------------------------------------------------
c  malloc only space we're going to use
      hgrid = .true.
      hgrid2 = .true.
      hgridt = .true.
      hweight = .true.
      hz = .true.
      hx = .true.
      hy = .true.
      hkx = .true.
      hky = .true.
      hnbrhd = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      lgrid = nx*ny  * WORDSIZ
      lgrid2 = nx*ny  * WORDSIZ
      lgridt = nx*ny  * WORDSIZ
      lweight = icount  * WORDSIZ
      lz = icount  * HFWDSIZ
      lx = icount  * WORDSIZ
      ly = icount  * WORDSIZ
      lkx = icount  * HFWDSIZ
      lky = icount  * HFWDSIZ
      lnbrhd = icount * HFWDSIZ
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (pgrid, lgrid, egrid, agrid)
      call galloc (pgrid2, lgrid2, egrid2, agrid2)
      call galloc (pgridt, lgridt, egridt, agridt)
      call galloc (pweight, lweight, eweight, aweight)
      call galloc (pz, lz, ez, az)
      call galloc (px, lx, ex, ax)
      call galloc (py, ly, ey, ay)
      call galloc (pkx, lkx, ekx, akx)
      call galloc (pky, lky, eky, aky)
      call galloc (pnbrhd, lnbrhd, enbrhd, anbrhd)
 
      if (egrid .ne. 0.) hgrid = .false.
      if (egrid2.ne. 0.) hgrid2 = .false.
      if (egridt.ne. 0.) hgridt = .false.
      if (eweight .ne. 0.) hweight = .false.
      if (ez .ne. 0.) hz = .false.
      if (ex .ne. 0.) hx = .false.
      if (ey .ne. 0.) hy = .false.
      if (ekx .ne. 0.) hkx = .false.
      if (eky .ne. 0.) hky = .false.
      if (enbrhd .ne. 0.) hnbrhd = .false.
 
      if (.not. hgrid .or. .not. hweight .or. .not. hz .or.
     1    .not. hx  .or. .not. hy  .or. .not. hkx .or. .not. hgridt
     1    .or. .not. hky .or. .not. hnbrhd .or. .not. hgrid2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) lgrid,'  bytes'
         write(LERR,*) lgrid2,'  bytes'
         write(LERR,*) lgridt,'  bytes'
         write(LERR,*) lweight,'  bytes'
         write(LERR,*) lz,'  bytes'
         write(LERR,*) lx,'  bytes'
         write(LERR,*) ly,'  bytes'
         write(LERR,*) lkx,'  bytes'
         write(LERR,*) lky,'  bytes'
         write(LERR,*) lnbrhd,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) lgrid,'  bytes'
         write(LERR,*) lgrid2,'  bytes'
         write(LERR,*) lgridt,'  bytes'
         write(LERR,*) lweight,'  bytes'
         write(LERR,*) lz,'  bytes'
         write(LERR,*) lx,'  bytes'
         write(LERR,*) ly,'  bytes'
         write(LERR,*) lkx,'  bytes'
         write(LERR,*) lky,'  bytes'
         write(LERR,*) lnbrhd,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
           call verbal(inpick,otap,ns,ne,irs,ire,verbos,
     1                 dy,dx,ny,nx,ili1,idi1,cnvxhl,del,lidi)
      end if
 
      write(LERR,*) ' number of lis is ', ny
      write(LERR,*) ' number of dis is ', nx
 
      do ili=1,ny
         do idi=1,nx
            index=((idi-1)*ny) + ili
            grid(index)=del
         enddo
      enddo
      i=0
      j=0
      ixold=mindi-1
      iyold=minli-1
      iline=0
  200 continue
         read(luin,*,end=210,err=200)iy,ix,iz
         i=i+1
         if(minli.le.iy.and.iy.le.maxli.and.
     1      mindi.le.ix.and.ix.le.maxdi)then
            j=j+1
            ix=ix-idi1+1
            iy=iy-ili1+1
            index=((ix-1)*ny) + iy
            if(lidi.eq.5)then
               grid(index)=i
            else if(lidi.eq.6)then
               if(((iy-iyold).ne.0).and.((ix-ixold).ne.0))then
                  iline=iline+1
               endif
               grid(index)=iline
            else if(lidi.eq.7)then
               grid(index)=-del
            else
               grid(index)=iz
            endif
            ixold=ix
            iyold=iy
            x(j)=(ix*dx)-(dx*.5)
            y(j)=(iy*dy)-(dy*.5)
            z(j)=iz
         endif
         goto 200
  210 continue
 
C
C-----------------------------------------------------------------------
C
C     SORT THE X-COORDINATE & Y-COORDINATE INDEXES FOR THE
C     NEIGHBORHOOD ROUTINE
C
C-----------------------------------------------------------------------
C
c lidi = 0 for amomap
c      = 1 for average of li di linear interpolation
c      = 2 for di constant interpolation (interpolate lis)
c      = 3 for li constant interpolation (interpolate dis)
c      = 4 no interpolation (show pick clouds)
c      = 5 pick number
c      = 6 line number (inline+, xline-)
c      = 7 location of picks only (=-del)
      if(lidi.eq.0)then
         CALL SRTIDX(X, KX, ICOUNT)
         CALL SRTIDX(Y, KY, ICOUNT)
 
 
C
C-----------------------------------------------------------------------
C
C     FIND THE NEIGHBORHOOD OF POINTS
C
C-----------------------------------------------------------------------
C
         tol=.5*min(dx,dy)
         eps=tol*.01
         do ili=1,ny
            knt=icount
            do idi=1,nx
               index=((idi-1)*ny) + ili
               XTBC              = (DX * IDI) - (DX *.5) - eps
               YTBC              = (DY * ILI) - (DY *.5) - eps
               NTP               = 0
               nfound=0
               CALL AMNEB(X     , Y     , NTP   , XTBC  , YTBC  ,
     *              NBRHD , WEIGHT, NFOUND, KX    , KY    ,
     *              knt, TOL   )
               sum=weight(1)
               knt=0
               WEIGHT(1)=WEIGHT(1)*
     *               RDIST(XTBC-X(NBRHD(1)),YTBC-Y(NBRHD(1)))
               DO I=2,NFOUND
                  sum=weight(i)+sum
                  WEIGHT(I)=WEIGHT(I)*
     *               RDIST(XTBC-X(NBRHD(I)),YTBC-Y(NBRHD(I)))
               enddo
C
C-----------------------------------------------------------------------
C
C     COMPUTE THE WEIGHTED AVERAGE FROM THE NEIGHBORS & WEIGHTS
C     FOUND BY SUBROUTINE "AMNEB" & PLACE IN TRACE HEADER AND
C     CONTOURING BUFFER
C
C-----------------------------------------------------------------------
C
               CALL AVERGE(z, icount, nfound, nbrhd, weight, intz, zint)
               if(cnvxhl)then
                  if(sum.ge.6.28)then
                     GRID(INDEX) = zint
                  else
                     grid(index) = del
                  endif
               else
                     GRID(INDEX) = zint
               endif
 
C
            enddo
         enddo
      else if ((1.le.lidi).and.(lidi.le.3)) then
 
         do idi=1,nx
            ifirst=ny+1
            ilast=1
            do ili=1,ny
               index=((idi-1)*ny) + ili
               index2=((ili-1)*nx) + idi
               if(grid(index).ne.del)then
                  ilast=ili
                  if(ili.lt.ifirst)ifirst=ili
               endif
               grid2(index2)=grid(index)
            enddo
            if(cnvxhl)then
               n=ilast-ifirst+1
            else
               ifirst=1
               n=ny
            endif
            index=((idi-1)*ny) + 1
            if(ifirst.le.ny)
     *        call intrp(grid(index+ifirst-1), n, del, ierror)
         enddo
 
         do idi=1,nx
            do ili=1,ny
               index=((idi-1)*ny) + ili
               indext=((ili-1)*nx) + idi
               gridt(indext)=grid(index)
            enddo
         enddo
 
         do ili=1,ny
            ifirst=nx+1
            ilast=1
            do idi=1,nx
               indext=((ili-1)*nx) + idi
               if(gridt(indext).ne.del)then
                  ilast=idi
                  if(idi.lt.ifirst)ifirst=idi
               endif
            enddo
            if(cnvxhl)then
               n=ilast-ifirst+1
            else
               ifirst=1
               n=nx
            endif
            indext=((ili-1)*nx) + 1
            if(ifirst.le.nx)
     *        call intrp(gridt(indext+ifirst-1), n, del, ierror)
         enddo
 
         do idi=1,nx
            do ili=1,ny
               index=((idi-1)*ny) + ili
               indext=((ili-1)*nx) + idi
               grid(index)=gridt(indext)
            enddo
         enddo
 
         do ili=1,ny
            ifirst=nx+1
            ilast=1
            do idi=1,nx
               index2=((ili-1)*nx) + idi
               if(grid2(index2).ne.del)then
                  ilast=idi
                  if(idi.lt.ifirst)ifirst=idi
               endif
            enddo
            if(cnvxhl)then
               n=ilast-ifirst+1
            else
               ifirst=1
               n=nx
            endif
            index2=((ili-1)*nx) + 1
            if(ifirst.le.nx)
     *        call intrp(grid2(index2+ifirst-1), n, del, ierror)
         enddo
 
         do ili=1,ny
            do idi=1,nx
               index2=((ili-1)*nx) + idi
               indext=((idi-1)*ny) + ili
               gridt(indext)=grid2(index2)
            enddo
         enddo
 
         do idi=1,nx
            ifirst=ny+1
            ilast=1
            do ili=1,ny
               indext=((idi-1)*ny) + ili
               if(gridt(indext).ne.del)then
                  ilast=ili
                  if(ili.lt.ifirst)ifirst=ili
               endif
            enddo
            if(cnvxhl)then
               n=ilast-ifirst+1
            else
               ifirst=1
               n=ny
            endif
            indext=((idi-1)*ny) + 1
            if(ifirst.le.ny)
     *        call intrp(gridt(indext+ifirst-1), n, del, ierror)
         enddo
 
         do ili=1,ny
            do idi=1,nx
               index2=((ili-1)*nx) + idi
               indext=((idi-1)*ny) + ili
               grid2(index2)=gridt(indext)
            enddo
         enddo
 
         do ili=1,ny
            do idi=1,nx
               index=((idi-1)*ny) + ili
               index2=((ili-1)*nx) + idi
               if (lidi.eq.1) then
                  if(grid(index).ne.del)then
                     if(grid2(index2).eq.del)then
                        grid2(index2)=grid(index)
                     else
                        grid2(index2)=.5*(grid2(index2)+grid(index))
                     endif
                  endif
               else if (lidi.eq.2) then
                  grid2(index2)=grid(index)
               endif
            enddo
         enddo
 
         do ili=1,ny
            do idi=1,nx
               index=((idi-1)*ny) + ili
               index2=((ili-1)*nx) + idi
               grid(index)=grid2(index2)
            enddo
         enddo
 
      endif
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     BUILD AND WRITE A LINE HEADER
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL VMOV(BLANK,1,IHEAD,1,10)
      CALL VCLR(IHEAD(11),1,1490)
      CALL VMOV(BLANK,1,IHEAD(18),1,2)
      CALL VMOV(BLANK,1,IHEAD(21),1,2)
      isi=dy
      CALL SAVEW(IHEAD, 'NumTrc', nx, LINHED)
      CALL SAVEW(IHEAD, 'NumRec', 1, LINHED)
      CALL SAVEW(IHEAD, 'SmpInt', isi, LINHED)
      CALL SAVEW(IHEAD, 'NumSmp', ny, LINHED)
      CALL SAVEW(IHEAD, 'Format', 3, LINHED)
      IDX = DX*1000.
      Idzdt = DY*1000.
      CALL SAVEW(IHEAD, 'Dx1000', IDX, LINHED)
      CALL SAVEW(IHEAD, 'Dz1000', Idzdt, LINHED)
      IHEAD(324) = 2*SZSMPD
      JEOF = 324*SZSMPD
      LEN=4
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LERR)
      CALL WRTAPE(LUOUT,IHEAD,JEOF)
      IF(JEOF.EQ.0)THEN
         WRITE(LERR,*)' ERROR WRITING LINEHEADER'
         STOP  75
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  WRITE THE MATRIX IN SIS TAPE FORM
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      call vclr(irx,1,itrwrd)
      jbytes=(ny*SZSMPD)+SZTRHD
      do idi=1,nx
         index=((idi-1)*ny) + 1
         call vmov(grid(index),1,data,1,ny)
         irx(106)=1
         irx(107)=idi
         jbytes=(ny*SZSMPD)+SZTRHD
         call wrtape(luout,rxx,jbytes)
         if(jbytes.eq.0)then
            write(lprt,*)' error writing trace ', ili
            stop 75
         endif
      enddo
 
 
  999 continue
 
c-----
c     close data files
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      close ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of aint, processed',itot,' record(s)',
     :               ' with ',icount, ' coordinates'
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HELP                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      HELP                                                            *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      print *,' aint linearly grids gocad surfaces'
      print *,' '
      print *,' -P1[inpick] input file'
      print *,' -O[ota]  output file'
      print *,' -dy[dy]     bin spacing in y '
      print *,' -dx[dx]     bin spacing in x '
      print *,' -ny[ny]     number of line indices'
      print *,' -nx[nx]     number of depth indices'
      print *,' -ili[ili1]  starting li bias '
      print *,' -idi[idi1]  starting di bias '
      print *,' -X          Interpolate only in convex hull '
      print *,' -D[del]   delimiter for outside convex hull '
      print *,' [-lidi]     flag for linear interpolation '
      print *,' [-V]        verbose flag '
      print *,' '
      print *,'usage'
      print *,' '
      print *,'aint -P1[inpick] -O[otap] -dy[dy] -dx[dx]'
      print *,'     -ny[ny] -nx[nx] -ili[ili1] -idi[idi1]'
      print *,'     -D[del] [-lidi]'
      print *,'     [-V]'
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GCMDLN                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GCMDLN  (INPICK,OTAP,VERBOS,DY,DX,NY,NX,ILI1,IDI1,CNVXHL,DEL,   *
C               LIDI)                                                  *
C  ARGUMENTS:                                                          *
C      INPICK  CHAR*(*)  ??IOU* -                                      *
C      OTAP    CHAR*(*)  ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C      DY      REAL      ??IOU* -                                      *
C      DX      REAL      ??IOU* -                                      *
C      NY      INTEGER   ??IOU* -                                      *
C      NX      INTEGER   ??IOU* -                                      *
C      ILI1    INTEGER   ??IOU* -                                      *
C      IDI1    INTEGER   ??IOU* -                                      *
C      CNVXHL  LOGICAL   ??IOU* -                                      *
C      DEL     REAL      ??IOU* -                                      *
C      LIDI    INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR          -                                               *
C      ARGR4           -                                               *
C      ARGI4           -                                               *
C      ARGIS   INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
 
      subroutine gcmdln(inpick,otap,verbos,
     1            dy,dx,ny,nx,ili1,idi1,cnvxhl,del,lidi)
 
 
 
c-----
c     verbose output of processing parameters
c
c     character*100 inpick   - input file
c     character*100 otap   - output file
c     logical       verbos - verbose flag
c     real          dy     - bin spacing in y
c     real          dx     - bin spacing in x
c     integer       ny     - number of line indices
c     integer       nx     - number of depth indices
c     integer       ili1   - starting li bias
c     integer       idi1   - starting di bias
c     logical       cnvxhl - interpolate only within convex hull
c     real          del    - dilimter value for beyond convex hull
c     integer       lidi   - flag for linear interpolation
c-----
#include <f77/iounit.h>
 
      character*(*) inpick
      character*(*) otap
      logical       verbos
      real          dy
      real          dx
      integer       ny
      integer       nx
      integer       ili1
      integer       idi1
      logical       cnvxhl
      real          del
      integer       lidi
      integer       argis
 
c-------
c     import values from the command line using keys, e.g. -P1
c     to which are immediately attached the users values.
 
c     For example program aint might be invoked in the following way:
 
c     aint  -P1inpick -Ootap
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into aint and associated with the variable
c     "inpick"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
      call argstr( '-P1', inpick, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argr4 ( '-dy', dy, 1., 1. )
      call argr4 ( '-dx', dx, 1., 1. )
      call argi4 ( '-ny', ny ,   0  ,  0    )
      call argi4 ( '-nx', nx ,   0  ,  0    )
      call argi4 ( '-ili', ili1 ,   1  ,  1    )
      call argi4 ( '-idi', idi1 ,   1  ,  1    )
      cnvxhl =   (argis('-X') .gt. 0)
      call argr4 ( '-D', del ,   99999.  ,  99999.    )
      call argi4 ( '-lidi', lidi ,   0  ,  0    )
      verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VERBAL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      VERBAL  (INPICK,OTAP,NS,NE,IRS,IRE,VERBOS,DY,DX,NY,NX,ILI1,     *
C               IDI1,CNVXHL,DEL,LIDI)                                  *
C  ARGUMENTS:                                                          *
C      INPICK  CHAR*(*)  ??IOU* -                                      *
C      OTAP    CHAR*(*)  ??IOU* -                                      *
C      NS      INTEGER   ??IOU* -                                      *
C      NE      INTEGER   ??IOU* -                                      *
C      IRS     INTEGER   ??IOU* -                                      *
C      IRE     INTEGER   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C      DY      REAL      ??IOU* -                                      *
C      DX      REAL      ??IOU* -                                      *
C      NY      INTEGER   ??IOU* -                                      *
C      NX      INTEGER   ??IOU* -                                      *
C      ILI1    INTEGER   ??IOU* -                                      *
C      IDI1    INTEGER   ??IOU* -                                      *
C      CNVXHL  LOGICAL   ??IOU* -                                      *
C      DEL     REAL      ??IOU* -                                      *
C      LIDI    INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
 
      subroutine verbal(inpick,otap,ns,ne,irs,ire,verbos,
     1            dy,dx,ny,nx,ili1,idi1,cnvxhl,del,lidi)
 
 
c-----
c     verbose output of processing parameters
c
c     character*100 inpick   - input file
c     character*100 otap   - output file
c     logical       verbos - verbose flag
c     real          dy     - bin spacing in y
c     real          dx     - bin spacing in x
c     integer       ny     - number of line indices
c     integer       nx     - number of depth indices
c     integer       ili1   - starting li bias
c     integer       idi1   - starting di bias
c-----
#include <f77/iounit.h>
 
      character*(*) inpick
      character*(*) otap
      logical       verbos
      real          dy
      real          dx
      integer       ny
      integer       nx
      integer       ili1
      integer       idi1
      logical       cnvxhl
      real          del
      integer       lidi
 
      write(lerr,*)' input file                 ', inpick
      write(lerr,*)' output file                ', otap
      write(lerr,*)' verbose flag               ', verbos
      write(lerr,*)' bin spacing in x           ', dx
      write(lerr,*)' bin spacing in y           ', dy
      write(lerr,*)' number of line indices     ', ny
      write(lerr,*)' number of depth indices    ', nx
      write(lerr,*)' starting li bias           ', ili1
      write(lerr,*)' starting di bias           ', idi1
      write(lerr,*)' interpolate in convex hull ', cnvxhl
      write(lerr,*)' del value                  ', del
      write(lerr,*)' linear interpolation       ', lidi
 
      return
      end
