C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       AMNEB                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      AMNEB  (X,Y,NTP,XC,YC,JD,TT,NID,KX,KY,MP,TOL)                   *
C  ARGUMENTS:                                                          *
C      X       REAL       ??IOU*  (2) -                                *
C      Y       REAL       ??IOU*  (2) -                                *
C      NTP     INTEGER    ??IOU*      -                                *
C      XC      REAL       ??IOU*      -                                *
C      YC      REAL       ??IOU*      -                                *
C      JD      INTEGER*2  ??IOU*  (2) -                                *
C      TT      REAL       ??IOU*  (2) -                                *
C      NID     INTEGER    ??IOU*      -                                *
C      KX      INTEGER*2  ??IOU*  (2) -                                *
C      KY      INTEGER*2  ??IOU*  (2) -                                *
C      MP      INTEGER    ??IOU*      -                                *
C      TOL     REAL       ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/14  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      SBOS -                                                          *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      SIGN    GENERIC -                                               *
C      ATAN2   GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C SUBROUTINE ID. AMNEB                                                  00139300
C FUNCTION. GIVEN A POINT (XC,YC) NEIGHBORING POINTS ARE FOUND FROM THE 00139400
C   X,Y ARRAYS.                                                         00139500
C AUTHOR. ELDON POWERS                                                  00139600
C DATE WRITTEN. 72-7-1  REVISED. 74-9-7 ENP                             00139700
C                                                                       00139800
C MODIFICATION CROSS REFERENCE:                                         00139900
C 7/01/82  SANDY COWAN - INCREASE FAULT TRACE LIMIT FROM 100 TO 500     00140000
C                        AND FAULT TRACE POINT LIMIT FROM 300 TO 1500   00140100
C                                                                       00140200
C DETAILED DESCRIPTION.                                                 00140300
C   PARAMETER LIST:                                                     00140400
C     X,Y=ARRAYS OF BASIC DATA LOCATIONS                                00140500
C     NTP=THE SUBSCRIPT LOCATION OF XC,YC IF IT IS A POINT IN THE LIST  00140600
C     XC,YC IS THE LOCATION WHERE A NEIGHBORHOOD MUST BE FOUND.         00140700
C     JD IS AN ARRAY OF POINTERS RETURNED POINTING TO X,Y POINTS        00140800
C       REPRESENTING THE NEIGHBORHOOD FOUND.                            00140900
C     TT IS ONE TO ONE WITH JD REPRESENTING THE WEIGHT OF EACH NEIGHBOR.00141000
C     NID=THE NUMBER OF NEIGHBORS FOUND.                                00141100
C     KX IS A SORTED (X ORDER) LIST OF POINTERS TO X,Y.                 00141200
C     KY IS A SORTED (Y ORDER) LIST OF POINTERS TO X,Y.                 00141300
C     MP>0 IS THE NUMBER OF KX AND KY POINTERS.  MP MUST BE A VARIABLE, 00141400
C       I.E. IT MUST NOT BE A LITERAL.  MP=0 MAY BE USED UPON SUBSEQUENT00141500
C       CALLS TO AMNEB (TO SAVE SEARCH TIME WHEN THE XC,YC IS CLOSE TO  00141600
C       THE XC,YC OF THE MOST RECENT CALL).                             00141700
C     TOL=THE TOLERANCE PERMITTED BETWEEN XC,YC AND X,Y LOCATIONS.      00141800
C SUBROUTINES CALLED. SBOS                                              00141900
      SUBROUTINE AMNEB (X,Y,NTP,XC,YC,JD,TT,NID,KX,KY,MP,TOL)           00142000
      INTEGER*2 JD(2),KX(2),KY(2),ID(2000)                              00142100
C                                                                       00142200
      DIMENSION X(2),Y(2),TT(2),ISW(5),MNS(4)                           00142300
      DIMENSION XT(2000),YT(2000),ARG(2000),ZB(4),HXT(5),ZN(4)          00142400
C                                                                       00142500
      DATA ZB/0.,2.,4.,6./ ,ZN/1.,3.,5.,7./                             00142600
      DATA HXT/0.,.0001,0.,-.0001,0./                                   00142700
      IF(MP)901,601,602                                                 00142800
  901 NP=-MP                                                            00142900
      GO TO 801                                                         00143000
  601 NP=NPS                                                            00143100
      ISV=ISVS                                                          00143200
      JSV=JSVS                                                          00143300
      GO TO 801                                                         00143400
  602 NP=MP                                                             00143500
      NPS=MP                                                            00143600
  801 CALL SBOS(KX,XC,NP,X,MP,ISV)                                      00143700
      CALL SBOS(KY,YC,NP,Y,MP,JSV)                                      00143800
      IF(MP)8001,8002,8003                                              00143900
 8003 MP=0                                                              00144000
 8002 ISVS=ISV                                                          00144100
      JSVS=JSV                                                          00144200
C INITIALIZE                                                            00144300
 8001 DO 42 I=1,4                                                       00144400
   42 ISW(I)=1                                                          00144500
      ISW(5)=-1                                                         00144600
      JDC=JSV                                                           00144700
      INC=ISV+1                                                         00144800
      IDC=ISV                                                           00144900
      JNC=JSV+1                                                         00145000
      L=1                                                               00145100
C SEARCH IN ZONE 1 FOR 1 POINT                                          00145200
   10 IF(INC-NP)1,1,2                                                   00145300
    1 K=KX(INC)                                                         00145400
      DX=X(K)-XC                                                        00145500
      DY=Y(K)-YC                                                        00145600
      INC=INC+1                                                         00145700
      IF(ABS(DY)-DX)833,4,10                                            00145800
    4 IF(DX)7,7,833                                                     00145900
  833 DYDX=DY/DX                                                        00146000
      GO TO 3                                                           00146100
    7 IF(NTP-K)9,10,9                                                   00146200
    9 NID=1                                                             00146300
      JD(1)=K                                                           00146400
      TT(1)=3.141592                                                    00146500
      GO TO 999                                                         00146600
C SEARCH IN ZONE 2 FOR 1 POINT                                          00146700
   11 IF(JNC-NP)12,12,2                                                 00146800
   12 K=KY(JNC)                                                         00146900
      DX=X(K)-XC                                                        00147000
      DY=Y(K)-YC                                                        00147100
      JNC=JNC+1                                                         00147200
      IF(ABS(DX)-DY)733,11,11                                           00147300
  733 DYDX=-DX/DY                                                       00147400
      GO TO 3                                                           00147500
C SEARCH IN ZONE 3 FOR 1 POINT                                          00147600
   21 IF(IDC)2,2,22                                                     00147700
   22 K=KX(IDC)                                                         00147800
      DX=X(K)-XC                                                        00147900
      DY=Y(K)-YC                                                        00148000
      IDC=IDC-1                                                         00148100
      IF(ABS(DY)+DX)833,24,21                                           00148200
   24 IF(DX)833,27,27                                                   00148300
   27 IF(NTP-K)9,21,9                                                   00148400
C SEARCH IN ZONE 4 FOR 1 POINT                                          00148500
   31 IF(JDC)2,2,32                                                     00148600
   32 K=KY(JDC)                                                         00148700
      DX=X(K)-XC                                                        00148800
      DY=Y(K)-YC                                                        00148900
      JDC=JDC-1                                                         00149000
      IF(ABS(DX)+DY)733,31,31                                           00149100
    3 D2=DX**2+DY**2                                                    00149200
      IF(D2-TOL)9,9,9254                                                00149300
 9254 XT(L)=DX/D2                                                       00149400
      YT(L)=DY/D2                                                       00149500
      ID(L)=K                                                           00149600
      GO TO 911                                                         00149700
    2 XT(L)=HXT(L+1)                                                    00149800
      YT(L)=HXT(L)                                                      00149900
      ID(L)=-L                                                          00150000
      DYDX=0.                                                           00150100
      ISW(L)=0                                                          00150200
  911 ARG(L)=ZN(L)+DYDX                                                 00150300
      MNS(L)=SIGN(1.,DYDX)                                              00150400
      JD(L)=L                                                           00150500
      L=L+1                                                             00150600
      GO TO (10,11,21,31,931),L                                         00150700
C CHECK FOR REDUCTION OF 4 STARTING POINTS                              00150800
  931 NID=0                                                             00150900
      DO 412 I=1,4                                                      00151000
        J=I+1                                                           00151100
        IF(J-4)9133,9133,8134                                           00151200
 8134   J=1                                                             00151300
 9133   K=I-1                                                           00151400
        IF(K)7132,7132,7133                                             00151500
 7132   K=4                                                             00151600
 7133   CP=(XT(I)-XT(K))*(YT(J)-YT(K))-(YT(I)-YT(K))*(XT(J)-XT(K))      00151700
        IF(CP)412,412,418                                               00151800
  418   NID=NID+1                                                       00151900
        JD(NID)=I                                                       00152000
  412 CONTINUE                                                          00152100
      LID=4                                                             00152200
      IGO=0                                                             00152300
C BEGIN LARGE LOOP THAT WORKS IN ONE ZONE AT A TIME                     00152400
C LOOP GOES TO STATEMENT 157                                            00152500
 4514 IGO=IGO+1                                                         00152600
C CALCULATE BOUNDS                                                      00152700
      IF(ISW(IGO))6000,4514,7084                                        00152800
 7084 LSV=1                                                             00152900
 7984 I=NID+IGO-4                                                       00153000
      CALL SBOS(JD,ZB(IGO),NID,ARG,0,I)                                 00153100
      IF(I)7002,7002,7001                                               00153200
 7002 I=NID                                                             00153300
 7001 JBOUN=0                                                           00153400
      XYB=0.                                                            00153500
      IJ=0                                                              00153600
 4158 J=I+1                                                             00153700
      IF(J-NID)3160,3160,3157                                           00153800
 3157 J=1                                                               00153900
 3160 IDM=JD(I)                                                         00154000
      IDI=ID(IDM)                                                       00154100
      IDN=JD(J)                                                         00154200
      IDJ=ID(IDN)                                                       00154300
      IF(IDI)7051,7051,7045                                             00154400
 7051 BOUND=ARG(IDN)                                                    00154500
      JBOUN=1                                                           00154600
      GO TO 7255                                                        00154700
 7045 IF(IDJ)7251,7251,7046                                             00154800
 7251 IF(JBOUN)7252,7252,7253                                           00154900
 7253 XYB=1000.                                                         00155000
      JBOUN=0                                                           00155100
      GO TO 4513                                                        00155200
 7252 JBOUN=-1                                                          00155300
      BOUND=ARG(IDM)                                                    00155400
      GO TO 4513                                                        00155500
 7046 IF(I-IJ)9010,9012,9010                                            00155600
 9010 IJ=J                                                              00155700
      XD1=X(IDI)-XC                                                     00155800
      YD1=Y(IDI)-YC                                                     00155900
      DS1=XD1**2+YD1**2                                                 00156000
      GO TO 7048                                                        00156100
 9012 XD1=XD2                                                           00156200
      YD1=YD2                                                           00156300
      DS1=DS2                                                           00156400
 7048 IJ=J                                                              00156500
      XD2=X(IDJ)-XC                                                     00156600
      YD2=Y(IDJ)-YC                                                     00156700
      DS2=XD2*XD2+YD2*YD2                                               00156800
      XYD=XD1*YD2-XD2*YD1                                               00156900
      IF(ABS(XYD).GT..000000001)GO TO 6528                              00157000
      XYB=1000.                                                         00157100
      GO TO 7259                                                        00157200
 6528 XYD=1./(XYD+XYD)                                                  00157300
      XX=(YD2*DS1-YD1*DS2)*XYD                                          00157400
      YY=(XD1*DS2-XD2*DS1)*XYD                                          00157500
      TEMP=SQRT(XX*XX+YY*YY)                                            00157600
      GO TO (7901,7902,7903,7904),IGO                                   00157700
 7901 DST=XX+TEMP                                                       00157800
      GO TO 7905                                                        00157900
 7902 DST=YY+TEMP                                                       00158000
      GO TO 7905                                                        00158100
 7903 DST=-XX+TEMP                                                      00158200
      GO TO 7905                                                        00158300
 7904 DST=-YY+TEMP                                                      00158400
 7905 IF(XYB-DST)7049,7259,7259                                         00158500
 7049 XYB=DST                                                           00158600
 7259 IF(ARG(IDN)-ZB(IGO)-2.)7260,4513,4513                             00158700
 7260 IF(ARG(IDN)-ZB(IGO))4513,7255,7255                                00158800
 7255 I=J                                                               00158900
      GO TO 4158                                                        00159000
 4513 GO TO (4113,4213,4313,4413),IGO                                   00159100
 4113 IF(INC-NP)4112,4112,4514                                          00159200
 4112 K=KX(INC)                                                         00159300
      DX=X(K)-XC                                                        00159400
      DY=Y(K)-YC                                                        00159500
      INC=INC+1                                                         00159600
      IF(ABS(DY)-DX)4115,4115,4113                                      00159700
 4115 ARX=1.+DY/DX                                                      00159800
      IF(DX-XYB)4510,4510,4117                                          00159900
 4213 IF(JNC-NP)4212,4212,4514                                          00160000
 4212 K=KY(JNC)                                                         00160100
      DY=Y(K)-YC                                                        00160200
      DX=X(K)-XC                                                        00160300
      JNC=JNC+1                                                         00160400
      IF(ABS(DX)-DY)4215,4213,4213                                      00160500
 4215 ARX=3.-DX/DY                                                      00160600
      IF(DY-XYB)4510,4510,4117                                          00160700
 4313 IF(IDC)4514,4514,4312                                             00160800
 4312 K=KX(IDC)                                                         00160900
      DX=X(K)-XC                                                        00161000
      DY=Y(K)-YC                                                        00161100
      IDC=IDC-1                                                         00161200
      IF(ABS(DY)+DX)4315,4315,4313                                      00161300
 4315 ARX=5.+DY/DX                                                      00161400
      IF(-DX-XYB)4510,4510,4117                                         00161500
 4413 IF(JDC)6000,6000,4412                                             00161600
 4412 K=KY(JDC)                                                         00161700
      DY=Y(K)-YC                                                        00161800
      DX=X(K)-XC                                                        00161900
      JDC=JDC-1                                                         00162000
      IF(ABS(DX)+DY)4415,4413,4413                                      00162100
 4415 ARX=7.-DX/DY                                                      00162200
      IF(-DY-XYB)4510,4510,4117                                         00162300
 4117 IF(JBOUN)4119,4514,4120                                           00162400
 4119 IF(ARX-BOUND)4513,4513,4510                                       00162500
 4120 IF(ARX-BOUND)4510,4513,4513                                       00162600
 4510 DD=DX*DX+DY*DY                                                    00162700
      XTR=DX/DD                                                         00162800
      YTR=DY/DD                                                         00162900
      CALL SBOS(JD,ARX,NID,ARG,LSV,JSAVE)                               00163000
      I=JSAVE                                                           00163100
      LSV=0                                                             00163200
      IF(I)657,657,1657                                                 00163300
  657 J=1                                                               00163400
      I=NID                                                             00163500
      GO TO 457                                                         00163600
 1657 II=JD(I)                                                          00163700
      IF(ARX-ARG(II))2657,157,2657                                      00163800
 2657 J=I+1                                                             00163900
      IF(J-NID)457,457,3657                                             00164000
 3657 J=1                                                               00164100
  457 M=JD(I)                                                           00164200
      N=JD(J)                                                           00164300
      CP=(XTR-XT(M))*(YT(N)-YT(M))-(YTR-YT(M))*(XT(N)-XT(M))            00164400
      IF(CP)157,157,62                                                  00164500
C POINT IS TO BE INCLUDED                                               00164600
C WORK BACKWARDS                                                        00164700
   62 ISAVE=I                                                           00164800
  662 J=I                                                               00164900
      I=I-1                                                             00165000
      IF(I)862,862,762                                                  00165100
  862 I=NID                                                             00165200
  762 M=JD(I)                                                           00165300
      N=JD(J)                                                           00165400
      CP=(XTR-XT(M))*(YT(N)-YT(M))-(YTR-YT(M))*(XT(N)-XT(M))            00165500
      IF(CP)64,64,662                                                   00165600
   64 MB=J                                                              00165700
C WORK FORWARD                                                          00165800
      J=ISAVE+1                                                         00165900
      IF(J-NID)72,72,564                                                00166000
  564 J=1                                                               00166100
   72 I=J                                                               00166200
      J=J+1                                                             00166300
      IF(J-NID)69,69,569                                                00166400
  569 J=1                                                               00166500
   69 M=JD(I)                                                           00166600
      N=JD(J)                                                           00166700
      CP=(XTR-XT(M))*(YT(N)-YT(M))-(YTR-YT(M))*(XT(N)-XT(M))            00166800
      IF(CP)572,572,72                                                  00166900
  572 MF=I                                                              00167000
C ADD POINT                                                             00167100
      IF(MF-MB-1)672,777,888                                            00167200
  777 L=NID                                                             00167300
 2778 JD(L+1)=JD(L)                                                     00167400
      IF(L-MF)778,1778,778                                              00167500
  778 L=L-1                                                             00167600
      GO TO 2778                                                        00167700
 1778 NID=NID+1                                                         00167800
      LID=LID+1                                                         00167900
      XT(LID)=XTR                                                       00168000
      YT(LID)=YTR                                                       00168100
      ID(LID)=K                                                         00168200
      ARG(LID)=ARX                                                      00168300
      JD(MF)=LID                                                        00168400
      GO TO 57                                                          00168500
  888 MB=MB+1                                                           00168600
  898 M=JD(MB)                                                          00168700
      XT(M)=XTR                                                         00168800
      YT(M)=YTR                                                         00168900
      ID(M)=K                                                           00169000
      ARG(M)=ARX                                                        00169100
      IF(MF-MB-1)57,57,74                                               00169200
   74 MB=MB+1                                                           00169300
  874 JD(MB)=JD(MF)                                                     00169400
      MF=MF+1                                                           00169500
      IF(MF-NID)74,74,75                                                00169600
   75 NID=MB                                                            00169700
      GO TO 57                                                          00169800
  672 IMF=JD(MF)                                                        00169900
      IF(ARX-ARG(IMF))76,76,77                                          00170000
   76 IF(MF-1)78,78,79                                                  00170100
   78 NID=MB                                                            00170200
      GO TO 777                                                         00170300
   79 NID=MB                                                            00170400
      MB=1                                                              00170500
      GO TO 898                                                         00170600
   77 MB=MB+1                                                           00170700
      LID=LID+1                                                         00170800
      XT(LID)=XTR                                                       00170900
      YT(LID)=YTR                                                       00171000
      ID(LID)=K                                                         00171100
      ARG(LID)=ARX                                                      00171200
      JD(MB)=LID                                                        00171300
      NID=MB                                                            00171400
      IF(MF-1)57,57,974                                                 00171500
  974 MB=1                                                              00171600
      GO TO 874                                                         00171700
   57 IF(MNS(IGO))6250,157,6252                                         00171800
 6250 IF(ARX-ZN(IGO))157,157,6254                                       00171900
 6252 IF(ARX-ZN(IGO))6254,157,157                                       00172000
 6254 MNS(IGO)=0                                                        00172100
      GO TO 7984                                                        00172200
  157 GO TO (4113,4213,4313,4413),IGO                                   00172300
 6000 JD(NID+1)=JD(1)                                                   00172400
      KID=JD(NID)                                                       00172500
      MID=JD(1)                                                         00172600
      DX2=XT(KID)-XT(MID)                                               00172700
      DY2=YT(KID)-YT(MID)                                               00172800
      J=0                                                               00172900
      DO 6100 M=1,NID                                                   00173000
        DX1=DX2                                                         00173100
        DY1=DY2                                                         00173200
        I=JD(M)                                                         00173300
        IP=JD(M+1)                                                      00173400
        DX2=XT(I)-XT(IP)                                                00173500
        DY2=YT(I)-YT(IP)                                                00173600
        IF(ID(I))6100,6100,6037                                         00173700
 6037   RNUM=DX1*DY2-DX2*DY1                                            00173800
        DENOM=DX1*DX2+DY1*DY2                                           00173900
        THETA=ATAN2(RNUM,DENOM)                                         00174000
        IF(ABS(THETA)-1.E-3)6100,6100,6070                              00174100
 6070   J=J+1                                                           00174200
        TT(J)=THETA                                                     00174300
        JD(J)=ID(I)                                                     00174400
 6100 CONTINUE                                                          00174500
      NID=J                                                             00174600
  999 RETURN                                                            00174700
      END                                                               00174800
