C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ANGS                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:       TO PRODUCE ANGLE SORTED SECTIONS PLOTS               *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/04/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/14  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C      ARGI4           -                                               *
C      OPENPR - OPEN PRINTOUT                                          *
C      GAMOCO - PRINT TORCH & OVAL                                     *
C      ICOPEN  INTEGER -                                               *
C      LBOPEN - TAPEIO OPEN TAPE                                       *
C      SISLGB          -                                               *
C      RTAPE4 - READ TRACE, RETURN NO. BYTES IN CRAY & IEEE FORMAT     *
C      SAVER           -                                               *
C      LBCLOS - TAPEIO CLOSE TAPE                                      *
C      HLHPRT - UPDATE AND PRINT LINE HEADER                           *
C      SAVEW           -                                               *
C      WRTAPE - WRITE A TRACE                                          *
C      RTAPE  - READ A TRACE                                           *
C      SEEKT  - POSITION TAPE FOR NEXT READ                            *
C      VCLR   - MOVE A STRING of zeroes                                *
C      VMOV   - MOVE A CHARACTER STRING                                *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IABS    INTEGER -                                               *
C  FILES:                                                              *
C      LCRD  ( INPUT  SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C      LTRM  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 2) -                                                 *
C      200      ( 1) -                                                 *
C      50       ( 1) -                                                 *
C      100      ( 3) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  SIS TYPE 3 INPUT IS READ AND TRACES ARE EITHER*
C       - SKIPPED OR SUMMED AND WRITTEN TO OUTPUT TAPE IN SORTED ORDER *
C       -               --RECORDS & TRACES BECOME TRACES & RECORDS     *
C       - PURPOSE:TO PRODUCE ANGLE SORTED SECTIONS                     *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/06/15  *
C            -  INPUT CANNOT BE A PIPE - OUTPUT CAN BE A PIPE          *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/06/30  *
C            -  USE FUNCTION COPEN RATHER THAN COMMAND LINE ARGUMENTS  *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/07/06  *
C               - USE THE PID FOR PRINTOUT RATHER THAN A NAMED FILE    *
C               - AND EITHER OPEN A CARD FILE OR NOT                   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/09/29  *
C               - ALLOW COMMAND LINE ARGUMENTS OR CRD FILE USED IN A   *
C               - BATCH STREAM (COPEN) BUT NO ANGS.CRD WILL BE OPENED  *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/12/10  *
C               - ADDED PRINTOUT COLLATION AND ACCOUNTING ROUTINES     *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/01/28  *
C               - ADD GAMOCO AND CONVERSION ON FLY TAPEIO              *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/02/12  *
C               - ADD FIXED FORMATS, MAKE COPEN AN INTEGER             *
C               - MAKE DEFAULTS EQUAL NINC=1; NSUM=0                   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/03/15  *
C               - NINC DEFAULT MUST BE 0, IF SUMMING                   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/04/07  *
C               - MAKE W/NEW LIBRARIES, CALL ICOPEN, CHECK ON OPEN OF  *
C               - CARD FILES, CALL HLHPRT                              *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/04/07  *
C               - add call to sislgbuf to lessen i/o costs             *
C               - can't find zero & mov, so change to call move        *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/07/31  *
C               - Moving system maintenance to the 1                 * *
C               - Added saver, savew, changed MOVE to VCLR, VMOV       *
C               - Bytes taken care of here by calling rtape4           *
C  REVISED BY:  MARY ANN THORNTON  v:2.1      REVISION DATE: 92/03/01  *
C               - Remove calling save routines inside trace loops      *
C               - Remove wordsize references to run on 32Bit machine   *
C               - Call openpr with full program name for OS 6.1        *
C  REVISED BY:  MARY ANN THORNTON  v:2.2      REVISION DATE: 92/06/24  *
C               - Correct the trace header record and trace numbers.   *
C  REVISED BY:  MARY ANN THORNTON  v:2.3      REVISION DATE: 93/04/04  *
C               - Add SZLNHD for line header length and add HP lu (ler)*
C  REVISED BY:  MARY ANN THORNTON  v:3.0      REVISION DATE: 93/06/07  *
C               - Add code for auditing purposes                       *
C               - Allow program to run when -I and -N are both missing *
C               - in that case trace skipping of 1 (ninc=1) will be don*
C  REVISED BY:  MARY ANN THORNTON  v:3.1      REVISION DATE: 93/09/20  *
C               - add newest auditing                                  *
C  REVISED BY:  MARY ANN THORNTON  v:3.2      REVISION DATE: 93/10/08  *
C               - make for gp15 and remove auditing                    *
C***********************************************************************
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/14 ==================   *
C      ICOPEN  INTEGER -                                               *
C      25   ( INPUT  SEQUENTIAL ) -                                    *
C      26   ( OUTPUT SEQUENTIAL ) -                                    *
C      27   ( OUTPUT SEQUENTIAL ) -                                    *
C      =BLANK=  ( 4) -                                                 *
C      = 200 =  ( 1) - ERROR OPENING PRINTOUT                          *
C      = 100 =  ( 4) - TAPEIO ERROR                                    *
C      =  50 =  ( 1) - INPUT CANNOT BE A PIPE                          *
C      =  75 =  ( 1) - ERROR IN PARAMETER INPUT                        *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
 
      PARAMETER (MXSAM=6000,LHEAD=SZLNHD)
      PARAMETER (LCRD = 25, LPRT = 26, LLIST = 27)
C
      DIMENSION IHEAD(LHEAD)
      DIMENSION RXX(MXSAM+ITRWRD),DATA(MXSAM),A(MXSAM)
C
      INTEGER*2 IRX(LNTRHD)
      INTEGER OFFSET, ARGIS
      LOGICAL ERROR,HELP,VERBOS
C
      CHARACTER*1 CARD(80),PARR(66)
      CHARACTER*4 VERSION
      CHARACTER*4 NAME,PPNAME
      CHARACTER*128 NTAP,OTAP
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
      EQUIVALENCE (CARD(1),NAME)
      DATA VERSION/'3.1 '/
      DATA PPNAME/'ANGS'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ','A','N','G','L','E',' ','S','O','R','T','E','D',' ','S',
     3'E','C','T','I','O','N','S',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
      LTRM = LER
      ERROR = .FALSE.
      VERBOS= .FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS FOR ANGLE SECTION SORT'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'INPUT'
         WRITE(LTRM,*)'-N[ntap]  .. INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap]  .. OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-I[inc]   .. TRACE SKIPPING INCREMENT'
         WRITE(LTRM,*)'-T[tsum]  .. NO. TRACES TO SUM'
         WRITE(LTRM,*)'-V        .. VERBOSE PRINTOUT'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'   angs -N[] -O[] -I[] -T[] -V'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGI4 ('-I',NINC,0,999)
      CALL ARGI4 ('-T',NSUM,0,999)
      VERBOS =   (ARGIS( '-V' ).GT.0)
CC
C     OPEN PRINTOUT
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      IF(NINC.GE.999 .AND. NSUM.GE.999)THEN
         N = ICOPEN('-angs.crd',LCRD)
      ENDIF
      IF(N.NE.0)THEN
    4    CONTINUE
         READ(LCRD,5)CARD
         IF(NAME.NE.'ANGS')GO TO 4
         READ(LCRD,600)NINC,NSUM
  600    FORMAT(I10,I5)
      ENDIF
      IF(NINC.GE.999) NINC = 0
      IF(NSUM.GE.999) NSUM = 0
      IF(NSUM.EQ.0 .AND. NINC.EQ.0)THEN
         ninc = 1
         WRITE(LPRT,*)' NO PARAMETERS WERE ENTERED - ',
     &    ' TRACE SKIPPING OF 1 WILL BE USED '
      ENDIF
      WRITE(LPRT,44)NINC,NSUM
   44 FORMAT(' TRACE INCREMENT IS ',I5,'; TRACES TO SUM IS ',I5)
C
      IF(NTAP.NE.' ')THEN
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
         WRITE(LPRT,*)'  INPUT CANNOT BE A PIPE'
         STOP 50
      ENDIF
      IF(OTAP.NE.' ')THEN
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
         LUOUT = 1
      ENDIF
      IF(LUIN.LT.0 .OR. LUOUT.LT.0)THEN
         WRITE(LPRT,*)' UNABLE TO OPEN I/O FILES'
         STOP 100
      ENDIF
c     set large buffer off to save i/o costs
      call sislgbuf (luin, 'off' )
C     RTAPE4 RETURNS NO. OF BYTES IN CRAY FORMAT WORDS IN JCOF
C     RTAPE4 RETURNS NO. OF BYTES IN IEEE FORMAT WORDS IN JEOF
      JEOF = 0
      CALL RTAPE4(LUIN,IHEAD,JCOF,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      LBYTES4 = JEOF + 4
      call saver(IHEAD, 'NumTrc', ltr, LINHED)
      call saver(IHEAD, 'NumRec', nrec, LINHED)
      call saver(IHEAD, 'NumSmp', ksamp, LINHED)
      call saver(IHEAD, 'SmpInt', isi, LINHED)
    5 FORMAT(80A1)
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' MAXIMUM NO. SAMPLES ALLOWED = ',MXSAM
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
      ENDIF
C
      IF(NSUM.GT.0 .AND. NINC.GT.0)THEN
         WRITE(LPRT,*)' YOU ASKED FOR BOTH SUMMING AND SKIPPING'
         WRITE(LPRT,*)' SKIPPING WILL BE DONE--SUMMING WILL NOT'
         NSUM = 0
      ENDIF
      IF(NSUM.GT.0)THEN
         LL = LTR/NSUM
         LEFT = LTR-(LL*NSUM)
      ELSE
         LTEM = LTR + NINC - 1
         LL   = LTEM/NINC
         LEFT = IABS((LL*NINC)-LTEM)
      ENDIF
      LEN=4
      CALL HLHPRT(IHEAD,JCOF,PPNAME,LEN,LPRT)
      call savew(IHEAD, 'NumTrc', NREC, LINHED)
      call savew(IHEAD, 'NumRec', LL, LINHED)
      CALL WRTAPE(LUOUT,IHEAD,JCOF)
 
        WRITE(LPRT,10)
   10    FORMAT (///,56X,'PROGRAM PARAMETERS')
        WRITE(LPRT,20)NINC,NSUM,NREC,LL
   20    FORMAT(/,
     *  34X,'TRACE SORTING INCREMENT                ', 10X,'=', I10,  /,
     *  34X,'NO. OF INPUT TRACES TO SUM             ', 10X,'=', I10,  /,
     *  34X,'NO. OF OUTPUT TRACES                   ', 10X,'=', I10,  /,
     *  34X,'NO. OF OUTPUT RECORDS                  ', 10X,'=', I10)
        WRITE(LPRT,30)LEFT
   30    FORMAT(
     *  34X,'TRACES TO SKIP AT END OF EACH RECORD   ', 10X,'=', I10)
C
C   GET NUMBER OF BYTES FOR EACH TRACE
        CALL RTAPE(LUIN,RXX,NBYTES)
        NBYTES4 = NBYTES + 4
        NBYTES4 = 4 + 256 + KSAMP*4
C
C     READ INPUT TAPE AND SUM AND WRITE TO DIRECT ACCESS DEVICE
C
      IF(NSUM.LE.0)GO TO 300
      KNTW = 0
      DO 200 ML = 1,LL
         IF(VERBOS)WRITE(LPRT,*) '  PROCESSING OUTPUT RECORD ',ML
         DO 150 MR = 1,NREC
C           PUT THE POINTER JUST BEFORE NEXT READ
            OFFSET = LBYTES4 + ( (ML-1)*NSUM + (MR-1)*LTR )*NBYTES4
            CALL SEEKT(LUIN,OFFSET)
            CALL VCLR(A,1,MXSAM)
            DO 100 N=1,NSUM
               JEOF=0
               CALL RTAPE(LUIN,RXX,JEOF)
               IF(JEOF.EQ.0)GO TO 1500
               DO 50 K=1,KSAMP
                  A(K)=A(K)+DATA(K)
   50          CONTINUE
  100       CONTINUE
            CALL VMOV(A,1,DATA,1,KSAMP)
            irx(106) = ml
            irx(107) = mr
            CALL WRTAPE(LUOUT,RXX,JEOF)
            KNTW = KNTW + 1
  150    CONTINUE
  200 CONTINUE
       WRITE(LPRT,*)KNTW,' TOTAL TRACES WRITTEN'
      GO TO 500
C
C     READ INPUT TAPE AND SKIP AND WRITE TO DIRECT ACCESS DEVICE
C
  300 CONTINUE
      KNTW = 0
      DO 475 ML = 1,LL
         IF (VERBOS)WRITE(LPRT,*) '  PROCESSING OUTPUT RECORD ',ML
         DO 400 MR = 1,NREC
C           PUT THE POINTER JUST BEFORE NEXT READ
            OFFSET = LBYTES4 + ( (ML-1)*NINC + (MR-1)*LTR )*NBYTES4
            CALL SEEKT(LUIN,OFFSET)
            JEOF=0
            CALL RTAPE(LUIN,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            irx(106) = ml
            irx(107) = mr
            CALL WRTAPE(LUOUT,RXX,JEOF)
            KNTW = KNTW + 1
  400    CONTINUE
  475 CONTINUE
  500 CONTINUE
      WRITE(LPRT,*)KNTW,' TOTAL TRACES WRITTEN'
      WRITE(LPRT,*) ' JOB COMPLETE'
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 100
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)
 1510 FORMAT(2X,'ERROR READING TRACE FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 100
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         NORMAL END OF JOB HERE                       C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
