 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GRIDIN                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GRIDINIT  (Z,T,R)                                               *
C  ARGUMENTS:                                                          *
C      Z       REAL  ??IOU* -                                          *
C      T       REAL  ??IOU* -                                          *
C      R       REAL  ??IOU* -                                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
c  revision history                 gary murphy         revision 2.2   *
c  commented out section of code that was unreachable because of goto  *
c  in rreindex subroutine                                              *
C  REVISED:  D.W. Nelson                             15 Dec 92
C            Changed BIGNUM for 9E99 to 9E37 for 32-bit machines
C***********************************************************************
      SUBROUTINE GRIDINIT(Z,T,R)
      REAL Z,T,R
 
 
#include "apkr.h"
      DZ = Z
      DT = T
      DR = R
      DZ2 = DZ*DZ
      DT2 = DT*DT
      DR2 = DR*DR
      DZINV = 1./DZ
      DTINV = 1./DT
      DRINV = 1./DR
 
      DSTDGLZT = SQRT(DT2+DZ2)
      SINDGLZT = DT/DSTDGLZT
      COSDGLZT = DZ/DSTDGLZT
 
      DSTDGLRT = SQRT(DR2+DT2)
      SINDGLRT = DT/DSTDGLRT
      COSDGLRT = DR/DSTDGLRT
 
#ifdef CRAYSYSTEM
      BIGNUM = 9E99
#else
      BIGNUM = 9E37
#endif
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VGUIDE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      VGUIDE  REAL  (VEL,TIME,NVEL,VINC,NZ,ISI)                       *
C  ARGUMENTS:                                                          *
C      VEL     REAL     ??IOU*  (NVEL) -                               *
C      TIME    REAL     ??IOU*  (NVEL) -                               *
C      NVEL    INTEGER  ??IOU*         -                               *
C      VINC    REAL     ??IOU*         -                               *
C      NZ      INTEGER  ??IOU*         -                               *
C      ISI     INTEGER  ??IOU*         -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MIN     GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      GUIDE   NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/07/31 ==================   *
C      VGUIDE  (VEL,TIME,NVEL,VINC,NZ,ISI)                             *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE VGUIDE(VEL,TIME,NVEL,VINC,NZ,ISI)
      INTEGER NVEL,NZ,ISI
      REAL VEL(NVEL),TIME(NVEL),VINC
 
#include "apkr.h"
#include "dpzt.h"
      print*,"VGUIDE"
 
      NGUIDE = NVEL
 
      DO 100 IZ=1, NZ+1
         IGUIDE(IZ) = 1
100   CONTINUE
 
       IZ=1
      DO 200 I=1, NGUIDE
          K=TIME(I)/ISI
          ITMAX = MIN(K,NZ+1)
          DO 210 IZ=IZ,ITMAX
                  IGUIDE(IZ) = I
210       CONTINUE
200   CONTINUE
 
      DTGUIDE(1)=0
      DO 300 I=2,NVEL
        write(IPRT,*)'dtguide i=',i,'time(i)=',time(i),' ',time(i-1)
          DTGUIDE(I)=(VEL(I)-VEL(I-1))*ISI/(VINC*(TIME(I)-TIME(I-1)))
300   CONTINUE
 
      DO 400 I=1,NGUIDE
          DTG=DTGUIDE(I)
          DGLZTA(I) = SQRT((DT-DTG)*(DT-DTG) + DZ2)
          DGLZTB(I) = SQRT(DTG*DTG + DZ2)
          DGLZTC(I) = SQRT((DT+DTG)*(DT+DTG) + DZ2)
 
          SINZTA(I) = (DT-DTG)/DGLZTA(I)
          SINZTB(I) = -DTG/DGLZTB(I)
          SINZTC(I) = -(DT+DTG)/DGLZTC(I)
 
          COSZTA(I) = DZ/DGLZTA(I)
          COSZTB(I) = DZ/DGLZTB(I)
          COSZTC(I) = DZ/DGLZTC(I)
400   CONTINUE
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PRTGUI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PRTGUIDE  ()                                                    *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      GUIDE   NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE PRTGUIDE()
 
 
 
#include "apkr.h"
#include "dpzt.h"
 
      DO 100 I=1,NGUIDE
          WRITE(IPRT,*) "  INDX   DTGUIDE     DGLA     SINA     COSA"
          WRITE(IPRT,78)I,DTGUIDE(I),
     &                  DGLZTA(I),SINZTA(I),COSZTA(I)
78        FORMAT(2X,I5,1X,10(1X,F8.4))
          WRITE(IPRT,*) "                     DGLB     SINB     COSB"
          WRITE(IPRT,79)DGLZTB(I),SINZTB(I),COSZTB(I)
79        FORMAT(17X,10(1X,F8.4))
          WRITE(IPRT,*) "                     DGLC     SINC     COSC"
          WRITE(IPRT,79)DGLZTC(I),SINZTC(I),COSZTC(I)
      WRITE(IPRT,*)' '
100   CONTINUE
      RETURN
      END
 
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PRTGRI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PRTGRID  ()                                                     *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE PRTGRID()
 
#include "apkr.h"
 
 
      WRITE(IPRT,*)'GRID PARAMETERS:'
      WRITE(IPRT,77)DZ,DZ2,DZINV
77    FORMAT(3X,'DZ = ',F12.7,'   DZ2 = ',F20.7,'   DZINV = ',F12.7)
      WRITE(IPRT,78)DT,DT2,DTINV
78    FORMAT(3X,'DT = ',F12.7,'   DT2 = ',F20.7,'   DTINV = ',F12.7)
      WRITE(IPRT,79)DR,DR2,DRINV
79    FORMAT(3X,'DR = ',F12.7,'   DR2 = ',F20.7,'   DRINV = ',F12.7)
 
      WRITE(IPRT,*)'   DSTDGLZT = ',DSTDGLZT
      WRITE(IPRT,*)'   SINDGLZT = ', SINDGLZT
      WRITE(IPRT,*)'   COSDGLZT = ',COSDGLZT
      WRITE(IPRT,*)'   DSTDGLRT = ',DSTDGLRT
      WRITE(IPRT,*)'   SINDGLRT = ',SINDGLRT
      WRITE(IPRT,*)'   COSDGLRT = ',COSDGLRT
      WRITE(IPRT,*)'   BIGNUM   = ',BIGNUM
      WRITE(IPRT,*)' '
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       COH2ER                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      COH2ERR  (A,NZ,NT,NR,FUDGE1,FUDGE2,PEAKPWR,AMAX)                *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NZ+1)*(NT+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      FUDGE1  REAL     ??IOU*                     -                   *
C      FUDGE2  REAL     ??IOU*                     -                   *
C      PEAKPW  REAL     ??IOU*                     -                   *
C      AMAX    REAL     ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
 
      SUBROUTINE COH2ERR(A,NZ,NT,NR,FUDGE1,FUDGE2,PEAKPWR,AMAX)
      REAL A((NZ+1)*(NT+1)*NR)
      REAL FUDGE1,FUDGE2,PEAKPWR
      INTEGER NZ,NT,NR
 
      REAL SUM,MAXIMUM,MINIMUM,AVG,CUTOFF,AA,AVGINV
      REAL AVGINVP
      INTEGER IA,N
 
#include "apkr.h"
 
      MINIMUM = BIGNUM
 
      MAXIMUM = 0
      AVG=1
      N=0
      SUM = 0
 
C     +-----------------------------------------------------------------------+
C     |  Determine the global minimum and maximum                             |
C     +-----------------------------------------------------------------------+
      DO 100 IR=1,NR
	  DO 200 IT=1,NT
	      DO 300 IZ=1,NZ
                  IA = (IR-1)*IRECSZ + (IT-1)*ITRSZ+IZ
		  AA = A(IA)
                  IF(AA.LT.0)A(IA)=0
                  IF(AA.GE.0)THEN
                      N = N + 1
      		      SUM = SUM + AA
		      IF (AA.GT.MAXIMUM) MAXIMUM=AA
          	      IF (AA.LT.MINIMUM) MINIMUM=AA
                  ENDIF
300	      CONTINUE
200	  CONTINUE
100   CONTINUE
 
      IF(N.NE.0)AVG = SUM/N
      IF(N.EQ.0)WRITE(IPRT,*)'** ERROR in COH2ERR- N=0'
      IF(AVG.EQ.0)THEN
      WRITE(IPRT,*)
     &"** WARNING IN SUBROUTINE COH2ERR, AVG=0 , RESET TO 1."
          AVGINV=1.
      ELSE
          AVGINV = 1./AVG
      ENDIF
         AVGINVP = AVGINV**PEAKPWR
      AMAX=MAXIMUM
 
      IF (FUDGE1.GE.0) THEN
	  CUTOFF = AVG*(1.-FUDGE1) + MAXIMUM*FUDGE1
      ELSE
	  CUTOFF = AVG*(1.+FUDGE1) + MINIMUM*(-FUDGE1)
      ENDIF
 
      SCALAR = (FUDGE2+(CUTOFF**PEAKPWR)*AVGINVP)
 
 
C     +-----------------------------------------------------------------------+
C     |  Invert coherencies
C     +-----------------------------------------------------------------------+
      DO 110 IR=1,NR
	  DO 210 IT=1,NT
	      DO 310 IZ=1,NZ
		  IA = (IR-1)*IRECSZ + (IT-1)*ITRSZ+IZ
		  AA = A(IA)
		  IF (AA.GE.0) THEN
		      IF (AA.LE.CUTOFF) AA=CUTOFF
		      A(IA) = SCALAR/(FUDGE2+(AA**PEAKPWR)*AVGINVP)
		  ENDIF
310	      CONTINUE
210	  CONTINUE
110   CONTINUE
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       TSCALE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      TSCALEE  (E,NZ,NT,NR,EMAX)                                      *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      EMAX    REAL     ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE TSCALEE(E,NZ,NT,NR,EMAX)
      INTEGER NZ,NT,NR
      REAL E((NT+1)*(NZ+1)*NR)
      REAL EMAX
 
      REAL SUM,AVG
      INTEGER IR,IZ,IT,IE,N
      REAL RECSUM,MINIMUM,MAXIMUM,NEWMIN,RECSHIFT,MAXSHIFT
      INTEGER RECN
      REAL RECAVG(4096),RECMIN(4096),RECMAX(4096)
 
#include "apkr.h"
 
      print*,"TSCALEE"
      NEWMIN = .0001
      MINIMUM = BIGNUM
      MAXIMUM = 0
      SUM = 0
      N = 0
      IMAX = IRECSZ*NR
 
      DO 100 IR=1,NR
          RECSUM = 0
          RECN = 0
          RECMIN(IR) = BIGNUM
          RECMAX(IR) = 0
          DO 200 IT = 1,NT
              DO 300 IZ=1,NZ
              IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
              IF (E(IE).LT.BIGNUM.AND.E(IE).GT.0) THEN
                  RECSUM = RECSUM + E(IE)
                  RECN = RECN + 1
                  IF(E(IE).LT.RECMIN(IR)) RECMIN(IR)=E(IE)
                  IF(E(IE).GT.RECMAX(IR)) RECMAX(IR)=E(IE)
              ENDIF
300           CONTINUE
200       CONTINUE
 
          SUM = SUM + RECSUM
          N = N + RECN
          IF(RECN.EQ.0)RECN=1
          IF(RECSUM.EQ.0)RECSUM=1
          RECAVG(IR) = RECSUM/RECN
          IF(RECMIN(IR).LT.MINIMUM)MINIMUM=RECMIN(IR)
          IF(RECMAX(IR).GT.MAXIMUM)MAXIMUM=RECMAX(IR)
          IF(VERBOS)THEN
              WRITE(IPRT,*)'REC=',IR,' MIN=',RECMIN(IR),
     &        ' AVG=',RECAVG(IR),' MAX=',RECMAX(IR)
          ENDIF
 
100   CONTINUE
 
      IF(N.NE.0)AVG = SUM/N
 
 
      MAXSHIFT = BIGNUM
      DO 105 IR = 1,NR
C          print*,"RECMIN(IR)=",RECMIN(IR)
C          print*,"RECAVG(IR)=",RECAVG(IR)
          TEMP = RECMIN(IR) - RECAVG(IR)
          IF(TEMP.LT.MAXSHIFT)MAXSHIFT= TEMP
105   CONTINUE
 
      NEWMIN = (AVG-MINIMUM)*.0001
 
        EMAX = AVG -MAXSHIFT+ NEWMIN
 
      IF(VERBOS)THEN
          WRITE(IPRT,*)' '
          WRITE(IPRT,*)'   MINIMUM=',MINIMUM,' AVERAGE=',AVG,
     &     ' MAXIMUM=',MAXIMUM
          WRITE(IPRT,*)'   MINIMUM RESET TO ',NEWMIN
          WRITE(IPRT,*)' '
      ENDIF
 
C--------SCALING TO REMOVE DC SHIFT FROM DATA--------
      MINIMUM = BIGNUM
      MAXIMUM = 0
      SUM = 0
      N = 0
      DO 110 IR=1,NR
          RECSHIFT = -RECAVG(IR) -MAXSHIFT + NEWMIN
          RECSUM = 0
          RECN = 0
          RECMIN(IR) = BIGNUM
          RECMAX(IR) = 0
          DO 210 IT = 1,NT
              DO 310 IZ=1,NZ
              IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
              IF (E(IE).LT.BIGNUM.AND.E(IE).GT.0) THEN
                  E(IE) = E(IE) + RECSHIFT
                  RECSUM = RECSUM + E(IE)
                  RECN = RECN + 1
                  IF(E(IE).LT.RECMIN(IR)) RECMIN(IR)=E(IE)
                  IF(E(IE).GT.RECMAX(IR)) RECMAX(IR)=E(IE)
              ENDIF
310           CONTINUE
210       CONTINUE
 
          SUM = SUM + RECSUM
          N = N + RECN
          IF(RECN.EQ.0)RECN=1
          IF(RECSUM.EQ.0)RECSUM=1
          RECAVG(IR) = RECSUM/RECN
          IF(RECMIN(IR).LT.MINIMUM)MINIMUM=RECMIN(IR)
          IF(RECMAX(IR).GT.MAXIMUM)MAXIMUM=RECMAX(IR)
          IF(VERBOS)THEN
              WRITE(IPRT,*)'REC=',IR,' MIN=',RECMIN(IR),
     &    ' AVG=',RECAVG(IR),' MAX=',RECMAX(IR)
          ENDIF
 
110   CONTINUE
 
 
      EMAX = MAXIMUM
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SCALE2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SCALE2  (E,NZ,NT,NR,EAVG)                                       *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      EAVG    REAL     ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE SCALE2(E,NZ,NT,NR,EAVG)
      INTEGER NZ,NT,NR
      REAL E((NT+1)*(NZ+1)*NR)
      REAL EAVG
 
      REAL ZSUM,ZMIN,ZMAX,GLOBMIN,GLOBMAX,GLOBSUM,AVG,GLOBAVG
      INTEGER NSUM,NGLOB,IT,IZ,IR
 
#include "apkr.h"
 
      GLOBMIN = BIGNUM
      GLOBMAX = 0
      GLOBSUM = 0
      NGLOB=0
      SMALLNUM = 1E-10
      DO 100 IZ = 1,NZ
         ZMIN = BIGNUM
         ZMAX = 1
         NSUM = 0
         ZSUM = 0
         DO 200 IR=1,NR
             DO 300 IT = 1,NT
                 IE = (IR-1)*IRECSZ+(IT-1)*ITRSZ+IZ
                 IF(E(IE).LT.BIGNUM.AND.E(IE).GT.0)THEN
                     ZSUM = ZSUM + E(IE)
                     NSUM = NSUM + 1
                     IF(E(IE).LT.ZMIN)  ZMIN=E(IE)
                     IF(E(IE).GT.ZMAX)  ZMAX=E(IE)
                 ENDIF
300          CONTINUE
200      CONTINUE
 
         IF(NSUM.NE.0)AVG=ZSUM/NSUM
         IF(VERBOS)THEN
             WRITE(IPRT,*)
     &      'IZ=',IZ,' MIN=',ZMIN,' AVG=',AVG,' ZMAX=',ZMAX
         ENDIF
 
         DO 210 IR=1,NR
             DO 310 IT = 1,NT
                 IE = (IR-1)*IRECSZ+(IT-1)*ITRSZ+IZ
                 IF(E(IE).LT.BIGNUM.AND.E(IE).GT.0)THEN
                     E(IE) = E(IE)-ZMIN +SMALLNUM
                 ENDIF
310          CONTINUE
210       CONTINUE
 
          NGLOB = NGLOB + NSUM
          GLOBSUM = GLOBSUM + ZSUM
          IF(ZMIN.LT.GLOBMIN) GLOBMIN = ZMIN
          IF(ZMAX.GT.GLOBMAX) GLOBMAX = ZMAX
          EAVG = EAVG + ZSUM -ZMIN + SMALLNUM
100   CONTINUE
 
      IF(NGLOB.NE.0) GLOBAVG=GLOBSUM/NGLOB
      IF(NGLOB.NE.0) EAVG = EAVG/NGLOB
      IF(VERBOS) THEN
           WRITE(IPRT,*)'GLOBAL MIN=',GLOBMIN,' GLOBAL AVERAGE=',
     &  GLOBAVG,' GLOBAL MAX=',GLOBMAX
           WRITE(IPRT,*)'NEW GLOBAL AVERAGE=',EAVG
      ENDIF
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ERRMIX                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ERRMIX  (E,A,NZ,NT,NR,AMULT,ESHIFT)                             *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      AMULT   REAL     ??IOU*                     -                   *
C      ESHIFT  REAL     ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE ERRMIX(E,A,NZ,NT,NR,AMULT,ESHIFT)
      INTEGER NZ,NT,NR
      REAL E((NT+1)*(NZ+1)*NR)
      REAL A((NT+1)*(NZ+1)*NR)
      REAL AMULT,ESHIFT
 
      REAL ESUM,EAVG,ASUM,AAVG
      REAL EMULT
      INTEGER NSUME,NSUMA,IT,IZ,IR
 
#include "apkr.h"
 
      IF(AMULT.GT.1.)AMULT = 1.
      IF(AMULT.LT.0)AMULT = 0.
      EMULT = 1.-AMULT
 
      ESUM = 0
      NSUME = 0
      ASUM = 0
      NSUMA = 0
      DO 100 IR = 1,NR
         DO 200 IT=1,NT
             DO 300 IZ = 1,NZ
                 IE = (IR-1)*IRECSZ+(IT-1)*ITRSZ+IZ
                 IF(E(IE).LT.BIGNUM.AND.E(IE).GT.0)THEN
                     ESUM = ESUM + E(IE)
                     NSUME = NSUME + 1
                 ENDIF
                 IF(A(IE).LT.BIGNUM.AND.A(IE).GT.0)THEN
                     ASUM = ASUM + A(IE)
                     NSUMA = NSUMA + 1
                 ENDIF
300          CONTINUE
200      CONTINUE
100   CONTINUE
 
         IF(NSUME.NE.0) EAVG=ESUM/NSUME
         IF(NSUMA.NE.0) AAVG=ASUM/NSUMA
 
 
      DO 110 IR = 1,NR
         DO 210 IT=1,NT
             DO 310 IZ = 1,NZ
                 IE = (IR-1)*IRECSZ+(IT-1)*ITRSZ+IZ
                 IF(E(IE).LT.BIGNUM.AND.E(IE).GT.0)THEN
                     E(IE) = EMULT*(E(IE)/EAVG + ESHIFT) +
     &               AMULT*A(IE)/AAVG
                 ENDIF
310          CONTINUE
210      CONTINUE
110   CONTINUE
 
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       MINPAT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      MINPATH  (E,NZ,NT,NR,PATH)                                      *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NZ+1)*(NT+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      PATH    REAL     ??IOU*  ((NZ+1)*NR)        -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE MINPATH(E,NZ,NT,NR,PATH)
      INTEGER NZ,NT,NR
      REAL E((NZ+1)*(NT+1)*NR)
      REAL PATH((NZ+1)*NR)
 
      INTEGER IZ,IT,IR,IP,IE
      REAL MINIMUM
 
#include "apkr.h"
 
      DO 100 IR=1,NR
          write(*,*)'minpath record',ir
	  DO 200 IZ=1,NZ+1
	      IP = (IR-1)*ITRSZ+IZ
	      MINIMUM = BIGNUM
	      DO 300 IT=1,NT+1
		  IE = (IR-1)*IRECSZ +(IT-1)*ITRSZ+IZ
		  IF (E(IE).LT.MINIMUM) THEN
		      MINIMUM = E(IE)
		      PATH(IP) = IT
		  ENDIF
300	      CONTINUE
200	  CONTINUE
100   CONTINUE
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CNTRLP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CNTRLPT  (E,NZ,NT,NR,IZCTL,ITCTL,IRCTL)                         *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NZ+1)*(NT+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      IZCTL   INTEGER  ??IOU*                     -                   *
C      ITCTL   INTEGER  ??IOU*                     -                   *
C      IRCTL   INTEGER  ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE CNTRLPT(E,NZ,NT,NR,IZCTL,ITCTL,IRCTL)
      INTEGER NZ,NT,NR
      REAL E((NZ+1)*(NT+1)*NR)
      INTEGER IZCTL,ITCTL,IRCTL
 
      INTEGER IZ,IT,IR
 
#include "apkr.h"
 
      IR = IRCTL
      IZ = IZCTL
      IT = ITCTL
 
      IE = IR*IRECSZ + (IT-1)*ITRSZ + IZ
      IF(E(IE-1).LT.0) RETURN
      IF(E(IE+1).LT.0) RETURN
 
      DO 100 IT=1,NT+1
 
          IE = IR*IRECSZ + (IT-1)*ITRSZ + IZ
          IF(E(IE).GT.0) E(IE) = -E(IE)
100   CONTINUE
 
      IT = ITCTL
      IE = IR*IRECSZ + (IT-1)*ITRSZ + IZ
      IF(E(IE).LT.0) E(IE)=-E(IE)
      IF(E(IE).EQ.0) E(IE)=.001
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       TREIND                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      TREINDEX  (E,NZ,NT,NR,IFLAG)                                    *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NZ+2)*(NT+2)*(NR+1))                 *
C      NZ      INTEGER  ??IOU*                                         *
C      NT      INTEGER  ??IOU*                                         *
C      NR      INTEGER  ??IOU*                                         *
C      IFLAG   INTEGER  ??IOU*                                         *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/07/31 ==================   *
C      E       REAL     ??IOU*  ((NZ+1)*(NT+1)*(NR+1))                 *
C  =============================== DATE: 91/12/17 ==================   *
C      TREINDEX  (E,NZ,NT,NR)                                          *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C TREINDEX - Trace oriented reindexing of error surface
C After applying the dynamic programming algorithm to an error
C surface composed of cells, the minimum total error values are
C defined at the corners of the cells (or at the grid nodes).
C This subroutine calculates the values in the cells by interpolating
C values from the nodes.
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE TREINDEX(E,NZ,NT,NR,IFLAG)
      INTEGER NZ,NT,NR,IFLAG
      REAL E((NZ+2)*(NT+2)*(NR+1))
 
#include "apkr.h"
 
      INTEGER IZ,IT,IR,IE,IE1
 
      print*,"TREINDEX"
C     -------interpolate T index-----------------------
      DO 100 IR=1,NR
          DO 200 IT = 1,NT
              DO 300 IZ=1,NZ+1
                  IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
                  IE1 = (IR-1)*IRECSZ + (IT)*ITRSZ + IZ
                   E(IE) = E(IE) + E(IE1)
300           CONTINUE
200       CONTINUE
100   CONTINUE
 
 
C     ---------interpolate Z index----------------------
      IF(IFLAG.NE.1)THEN
      print*,"TREINDEX-interpolate z index"
      DO 110 IR=1,NR
          DO 210 IT = 1,NT
              DO 310 IZ=1,NZ
                  IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
                  IE1 = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ+1
                  IF(E(IE).LT.BIGNUM.AND.E(IE1).LT.BIGNUM.
     &               AND.E(IE).GT.0.AND.E(IE1).GT.0) THEN
                      E(IE) = E(IE) + E(IE1)
                  ELSE IF(E(IE).LT.BIGNUM) THEN
                      E(IE) = 2*E(IE)
                  ELSE IF(E(IE1).LT.BIGNUM.AND.E(IE1).GT.0) THEN
                      E(IE) = 2*E(IE1)
                  ELSE
                      E(IE) = 2*E(IE)
                  ENDIF
310           CONTINUE
210       CONTINUE
110   CONTINUE
      ENDIF
 
      IF(IFLAG.EQ.1)THEN
        DO 115 IR=1,NR
          DO 215 IT=1,NT
            DO 315 IZ=1,NZ
               IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
               E(IE) = E(IE+1)
315         CONTINUE
215       CONTINUE
115     CONTINUE
      ENDIF
 
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RREIND                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RREINDEX  (E,NZ,NT,NR)                                          *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NZ+2)*(NT+2)*(NR+1))                 *
C      NZ      INTEGER  ??IOU*                                         *
C      NT      INTEGER  ??IOU*                                         *
C      NR      INTEGER  ??IOU*                                         *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/07/31 ==================   *
C      E       REAL     ??IOU*  ((NZ+1)*(NT+1)*(NR+1))                 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
 
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RREIND                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RREINDEX  (E,NZ,NT,NR)                                          *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NZ+2)*(NT+2)*(NR+1))                 *
C      NZ      INTEGER  ??IOU*                                         *
C      NT      INTEGER  ??IOU*                                         *
C      NR      INTEGER  ??IOU*                                         *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 91/07/31 ==================   *
C      E       REAL     ??IOU*  ((NZ+1)*(NT+1)*(NR+1))                 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C RREINDEX - Record oriented reindexing of error surface
C After applying the dynamic programming algorithm to an error
C surface composed of cells, the minimum total error values are
C defined at the corners of the cells (or at the grid nodes).
C This subroutine calculates the values in the cells by interpolating
C values from the nodes.
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE RREINDEX(E,NZ,NT,NR)
      INTEGER NZ,NT,NR
      REAL E((NZ+2)*(NT+2)*(NR+1))
 
      INTEGER IZ,IT,IR,IE
 
#include "apkr.h"
       print*,"RREINDEX"
 
C     -------interpolate traces-------------------------
      DO 100 IR=1,NR+1
          DO 200 IT = 1,NT
              DO 300 IZ=1,NZ
                  IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
                  IE1 = (IR-1)*IRECSZ + IT*ITRSZ + IZ
                  E(IE) = E(IE) + E(IE1)
300           CONTINUE
200       CONTINUE
100   CONTINUE
 
cgem      GOTO 999
C     -------interpolate records-----------------------
cgem      DO 110 IR=1,NR
cgem          DO 210 IT = 1,NT
cgem              DO 310 IZ=1,NZ
cgem                  IE = (IR-1)*IRECSZ + (IT-1)*ITRSZ + IZ
cgem                  IE1 = IR*IRECSZ + (IT-1)*ITRSZ + IZ
cgem                  IF(E(IE).LT.BIGNUM.AND.E(IE1).LT.BIGNUM) THEN
cgem                      E(IE) = E(IE) + E(IE1)
cgem                  ELSE IF(E(IE).LT.BIGNUM) THEN
cgem                      E(IE) = 2*E(IE)
cgem                  ELSE IF(E(IE1).LT.BIGNUM) THEN
cgem                      E(IE) = 2*E(IE1)
cgem                  ELSE
cgem                      E(IE) = 2*E(IE)
cgem                  ENDIF
cgem                  E(IE) = E(IE)/2.
cgem310           CONTINUE
cgem210       CONTINUE
cgem110   CONTINUE
 
cgem999   CONTINUE
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ERRMUL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ERRMULT  (E,A,NZ,NT,NR,AMULT,ESHIFT)                            *
C  ARGUMENTS:                                                          *
C      E       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      A       REAL     ??IOU*  ((NT+1)*(NZ+1)*NR) -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      AMULT   REAL     ??IOU*                     -                   *
C      ESHIFT  REAL     ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/07/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE ERRMULT(E,A,NZ,NT,NR,AMULT,ESHIFT)
      INTEGER NZ,NT,NR
      REAL E((NT+1)*(NZ+1)*NR)
      REAL A((NT+1)*(NZ+1)*NR)
      REAL AMULT,ESHIFT
 
      INTEGER IT,IZ,IR
 
#include "apkr.h"
 
 
      DO 110 IR = 1,NR
         DO 210 IT=1,NT
             DO 310 IZ = 1,NZ
                 IE = (IR-1)*IRECSZ+(IT-1)*ITRSZ+IZ
                 IF(E(IE).LT.BIGNUM.AND.E(IE).GT.0)THEN
                     E(IE) = E(IE)*A(IE)
                 ENDIF
310          CONTINUE
210      CONTINUE
110   CONTINUE
 
 
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ERRNOR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ERRNORM  (A,NR,NT,NZ)                                           *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  ((NZ+1)*(NT+1)*NR) -                   *
C      NR      INTEGER  ??IOU*                     -                   *
C      NT      INTEGER  ??IOU*                     -                   *
C      NZ      INTEGER  ??IOU*                     -                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 91/08/12  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 91/12/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:                                                             *
C      GRID    NUMERIC    ??IOU* -                                     *
C      IO      NUMERIC    ??IOU* -                                     *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C ERRNORM - Normaliztion of error surface amplitude to the interval [0,1]
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      SUBROUTINE ERRNORM(A,NR,NT,NZ)
      REAL A((NZ+1)*(NT+1)*NR)
      INTEGER NZ,NT,NR
 
      REAL MAXIMUM,SCALE,SMALLNUM
      INTEGER IA
 
#include "apkr.h"
 
      MAXIMUM = 0
      SMALLNUM = 1E-10
 
 
C     +----------------------------------------------------------+
C     | Determine the global maximum amplitude                   |
C     +----------------------------------------------------------+
      DO 300 IR=1,NR
         DO 200  IT=1,NT
            DO 100 IZ=1,NZ
               IA = (IR-1)*IRECSZ + (IT-1)*ITRSZ+IZ
               IF(A(IA).GT.MAXIMUM)MAXIMUM=A(IA)
100         CONTINUE
200      CONTINUE
300   CONTINUE
 
 
C     +----------------------------------------------------------+
C     | Scale amplitudes to interval (0,1]                       |
C     +----------------------------------------------------------+
      SCALE = 1./MAXIMUM
      DO 600 IR=1,NR
         DO 500 IT=1,NT
            DO 400 IZ=1,NZ
               IA = (IR-1)*IRECSZ + (IT-1)*ITRSZ+IZ
               A(IA)=SCALE*A(IA)
               IF(A(IA).LT.SMALLNUM)A(IA)=SMALLNUM
400         CONTINUE
500      CONTINUE
600   CONTINUE
 
      RETURN
      END
 
 
 
