C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       TRBOXC                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      TRBOXCAR  (AAVG,NR,NZ,NSMOOTH)                                  *
C***********************************************************************
      SUBROUTINE TRBOXCAR(AAVG,NR,NZ,NSMOOTH)
      REAL AAVG(NR*(NZ+1))
      INTEGER NR,NZ,NSMOOTH
 
      REAL ANEW(4096)
      INTEGER IA,IZ,IR
 
#include "apkr.h"
 
      NS = NSMOOTH/2
 
      DO 100 IZ = 1,NZ
          SUM = 0
          NSUM = 0
          IEND = NS
          IF(NR.LT.NS)  IEND = NR
 
C         +----------------------------------+
C         | determine filter for first trace |
C         +----------------------------------+
          DO 200 IR = 1,IEND
              IA = (IR-1)*ITRSZ + IZ
              SUM = SUM + AAVG(IA)
              NSUM = NSUM + 1
200       CONTINUE
 
          DO 300 IR = 1,NR
C             +--------------------------+
C             | add leading point to sum |
C             +--------------------------+
              IF(IR+NS.LE.NR)THEN
                  IAFOR = (IR + NS -1)*ITRSZ +IZ
                  IEND = IR + NS
                  NSUM = NSUM + 1
                  SUM = SUM + AAVG(IAFOR)
              ENDIF
C             +--------------------------------+
C             | remove trailing point from sum |
C             +--------------------------------+
              IF(IR-NS.GT.1)THEN
                  IABACK = (IR -NS - 2)*ITRSZ + IZ
                  IBEG = IR-NS
                  NSUM = NSUM -1
                  SUM = SUM - AAVG(IABACK)
              ENDIF
              IF(NSUM.NE.0)ANEW(IR)=SUM/NSUM
300       CONTINUE
 
          DO 400 IR = 1,NR
              IA = (IR-1)*ITRSZ + IZ
              AAVG(IA)=ANEW(IR)
400       CONTINUE
 
100   CONTINUE
 
 
      RETURN
      END
