C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  find weights of 4 corner points that apply to some point inside a
c  rectangle.  Use distance from the point of interest to each corner.

      subroutine WghtDist (xin,yin,dx,dy,wght1,wght2,wght3,wght4)

      real xin,yin,dx,dy,wght1,wght2,wght3,wght4
      real c1x,c1y,c2x,c2y,c3x,c3y,c4x,c4y
      real dist1, dist2,dist3,dist4,distsum

c
c
c     c3--------------c4
c      |              |
c      |              |
c      |         *    | <-- yin
c      |              |
c     c1--------------c2
c                |
c               xin
c
      c1x = dx* int(xin/dx)
      c1y = dy* int(yin/dy)
      dist1 = sqrt( (xin-c1x)**2 + (yin-c1y)**2 )

      c2x = c1x + dx
      c2y = c1y
      dist2 = sqrt( (xin-c2x)**2 + (yin-c2y)**2 )

      c3x = c1x
      c3y = c1y + dy
      dist3 = sqrt( (xin-c3x)**2 + (yin-c3y)**2 )

      c4x = c2x
      c4y = c3y
      dist4 = sqrt( (xin-c4x)**2 + (yin-c4y)**2 )

      distsum = 1./dist1 + 1./dist2 + 1./dist3 + 1./dist4

      wght1 = 1./dist1/distsum
      wght2 = 1./dist2/distsum
      wght3 = 1./dist3/distsum
      wght4 = 1./dist4/distsum

      return
      end
