C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c     at3d_lite : at3d made easy. Extracts arbitrary traverses from
c                 3-D post stack volumes. Corner vertices are picked
c                 in xsd on a horizontal slice that xsd extracted from
c                 the volume.
c                  
c                 Unlike the original AT3D, at3d_lite does not allow'
c                 the sophisticated use of x,y pairs to describe'
c                 survey corners and traverse vertices. Nor does it' 
c                 explicitely use LI,DI ranges and increments.  All'
c                 vertex control and relational survey information'
c                 are retrieved from the xsd pick file.'
c                  
c     Program Changes:
c
c      - original written: October/95
c      - modified from original : July/96,  MJO
c
c     Program Description:
c
c      - This routine extracts, from a post-stack 3d volume of seismic
c        data, an artificial 2D traverse [fence diagram-like].  Input
c        to the routine includes a USP format seismic volume and vertex
c        control in an XSD pickfile.  Output is a USP format seismic
c        stack data of nrec records of 1 trace each.
c
c Maintenance Notes: [OBrien]
c
c     This version should not need transformed and untransformed
c     vectors and arrays but speed of conversion made it easier
c     to leave them in for the first cut. In each case, all
c     transformed arrays should be equal to their untransformed 
c     counterparts. In this code, an input record has a constant
c     y coordinate, each trace increments by dx.
c
c Maintenance Notes: [Garossino]
c
c The Vetex control is contained in the following arrays:
c
c     Vertex_XY[] --> the (x,y) coordinates of the dataset
c     LI_DI[]     --> the nearest (li,di) coordinates corresponding
c                     to the above (x,y)
c     Vertex_XY_Transformed --> the (x,y) coordinates of the
c                               transformed rectangle
c
c
c Once the above are defined [from a pickfile] output cdp locations can
c be derived.  CDP data is stored in the following arrays:
c
c     CDP_XY[]    --> (x,y) coordinates of output cdp locations
c                     in input dataset coordinates
c     CDP_LIDI[]  --> (li,di) coordinates of output cdp locations
c                     in input dataset coordinates
c     CDP_XY_Transformed[]  --> (x,y) cdp locations in coords
c                               of transformed rectangle
c     CDP_LIDI_XY_Transformed[] --> (x,y) of (li,di) location in
c                                   coords of transformed rectangle
c
c
c Now go through the cdp locations one at a time, find the 4 nearest
c neighbor traces to a given location and sum then using a normalized
c weighting based on offset from cdp location.  This logic uses
c the following arrays:
c
c     LI_Neighbors[]  --> sequential record of neighbor traces 
c     DI_Neighbors[]  --> sequential trace of neighbor traces
c     LIDI_Neighbors_X[] --> x coord [transformed rectangle] 
c     LIDI_Neighbors_Y[] --> y coord [transformed rectangle] 
c     CDPBCX[] --> bin center X coord in dataset coord
c     CDPBCY[] --> bin center Y coord in dataset coord
c     CDPBCX_Transformed[] --> bin center X coord in transformed
c                              rectangle coord
c     CDPBCY_Transformed[] --> bin center Y coord in transformed
c                              rectangle coord
c     Weight[] --> weight to apply to neighbor traces
c                  prior to summation
c

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c dimension standard usp variables

      integer iform, nsamp, nrec, nreco, nsi, ntrc, ntrco
      integer luin, luout, argis, obytes, lbytes, lbyout
      integer itr(SZLNHD)

      real tri(SZLNHD)

      character ntap*255, otap*255, name*12
      character wght*6

      logical verbos

c program dependant variables

      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer ifmt_DphInd, l_DphInd, ln_DphInd, DphInd
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, CDPBCX(4)
      integer ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, CDPBCY(4)

      integer LI_DI(2,SZLNHD)
      integer CDP_LIDI(2,SZLNHD)
      integer LI_Neighbors(4), DI_Neighbors(4)
      integer lu_ptap
      integer NumVertices, CDP_counter

      integer XSD_NumSegs, XSD_PicksPerSeg(SZLNHD), XSD_SegNum
      integer XSD_SegColor, XSD_nsamp, XSD_ntrc, XSD_nrec
      integer tr_index, WalkOffDataCount

      real ilts, xlts, dx, dy
      real Vertex_XY(2,SZLNHD)
      real Vertex_XY_Transformed(2,SZLNHD)
      real LI_DI_XY(2,SZLNHD)
      real LI_DI_XY_Transformed(2,SZLNHD)
      real CDP_XY(2,SZLNHD)
      real CDP_XY_Transformed(2,SZLNHD)
      real CDP_LIDI_XY(2,SZLNHD)
      real CDP_LIDI_XY_Transformed(2,SZLNHD)
      real LIDI_Neighbors_X(4), LIDI_Neighbors_Y(4)
      real XSD_SmpUnits, XSD_SmpOffset, XSD_TrcUnits, XSD_TrcOffset
      real XSD_Record(SZLNHD), XSD_Trace(SZLNHD), XSD_Sample(SZLNHD)
      real CdpInt, CDP_X, CDP_Y
      real Neighbors(SZLNHD,4)
      real CDPBCX_Transformed(4), CDPBCY_Transformed(4)  
      real Weight(4)

      character  ptap*255, Xsd_SegName*20

c initialize variables

      data name/'AT3D_LITE'/
      data ntrco/1/
      data nreco/0/
      data RecNum/1/
      data WalkOffDataCount/0/

C get help if necessary

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c initialize variables

      do i = 1, 4
         CDPBCX(i) = 0
         CDPBCY(i) = 0
         LI_Neighbors(i) = 0
         DI_Neighbors(i) = 0
         LIDI_Neighbors_X(i) = 0.
         LIDI_Neighbors_Y(i) = 0.
         CDPBCX_Transformed(i) = 0.
         CDPBCY_Transformed(i) = 0.
         Weight(i) = 0.
         call vclr ( Neighbors(1,i), 1, SZLNHD )
      enddo

      do i = 1, SZLNHD
         LI_DI(1,i) = 0
         LI_DI(2,i) = 0
         CDP_LIDI(1,i) = 0         
         CDP_LIDI(2,i) = 0
         XSD_PicksPerSeg(i) = 0
         Vertex_XY(1,i) = 0.
         Vertex_XY(2,i) = 0.
         Vertex_XY_Transformed(1,i) = 0.
         Vertex_XY_Transformed(2,i) = 0.
         LI_DI_XY(1,i) = 0.
         LI_DI_XY(2,i) = 0.
         LI_DI_XY_Transformed(1,i) = 0.
         LI_DI_XY_Transformed(2,i) = 0.
         CDP_XY(1,i) = 0.
         CDP_XY(2,i) = 0.
         CDP_XY_Transformed(1,i) = 0.
         CDP_XY_Transformed(2,i) = 0.
         CDP_LIDI_XY(1,i) = 0.
         CDP_LIDI_XY(2,i) = 0.
         CDP_LIDI_XY_Transformed(1,i) = 0.
         CDP_LIDI_XY_Transformed(2,i) = 0.
      enddo

C open printout file

#include <f77/open.h>

C read command line parameters

      call cmdln( ntap, otap, ptap, ilts, xlts, CdpInt, verbos,
     :            wght )

      dx = ilts
      dy = xlts

c open input and output files

      call getln ( luin , ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )
 
c  read input line header 

      call rtape ( luin, itr, lbytes )
      if ( lbytes .eq. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' no header read from unit ',luin
         write(LERR,*)' FATAL'
         write(LER,*)' '
         write(LER,*)' AT3D_LITE: no header read from unit ',luin
         write(LER,*)' FATAL'
         stop
      endif

c save global data parameters

      call saver (itr, 'NumSmp', nsamp, LINHED)
      call saver (itr, 'SmpInt', nsi  , LINHED)
      call saver (itr, 'NumTrc', ntrc , LINHED)
      call saver (itr, 'NumRec', nrec , LINHED)
      call saver (itr, 'Format', iform, LINHED)

c set up pointers to trace header entries required by this routine

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

c update the historical line header

      call savhlh (itr, lbytes, lbyout)

c set output bytes/trace size
 
      obytes = nsamp * SZSMPD + SZTRHD

c get traverse control points and be sure both (x,y) and (li,di) arrays
c are complete. Start by openning the pick file.

      call alloclun(lu_ptap)
      length = lenth(ptap)
      open ( lu_ptap, file = ptap(1:length), status = 'old', 
     :       err = 991 )

c initialize XSD variables based on pick file attached.

      call XSDInit_lite(lu_ptap,
     :     XSD_SmpUnits, XSD_TrcUnits, XSD_RecUnits,
     :     XSD_SmpOffset, XSD_TrcOffset, XSD_RecOffset,
     :     XSD_nsamp, XSD_ntrc, XSD_nrec, XSD_NumSegs, XSD_PicksPerSeg) 

c read in the pick file data.  This logic assumes only one segment
c per pickfile. If more than one traverse is required then user must
c create a separate pickfile for each traverse.

      call XsdReadPicks(lu_ptap, XSD_Record, XSD_Trace, XSD_Sample, 
     :     XSD_PicksPerSeg(1), SZLNHD, XSD_SegNum, XSD_SegName, 
     :     XSD_SegColor)
         
      NumVertices = XSD_PicksPerSeg(1)

c calculate LI_DI[], Vertex_XY[] and Vertex_XY_Transformed[] for input
c traverse vertices         

      do i = 1, NumVertices

c This logic converts the XSD_Record[] and XSD_Tracee[] numbers to
c sequential record and trace for use when recovering trace data.
c LI_DI(1,*) holds the index of the 'y' coordinate.  (x,y) --> (di,li)
c LI_DI(2,*) holds the index of the 'x' coordinate.

         LI_DI(1,i) = nint((XSD_Record(i)-XSD_RecOffset)/XSD_RecUnits)
         LI_DI(2,i) = nint((XSD_Trace(i) -XSD_TrcOffset)/XSD_TrcUnits)

         Vertex_XY_Transformed(1,i) = float(LI_DI(2,i) - 1) * dx
         Vertex_XY_Transformed(2,i) = float(LI_DI(1,i) - 1) * dy

         Vertex_XY(1,i) = Vertex_XY_Transformed(1,i)
         Vertex_XY(2,i) = Vertex_XY_Transformed(2,i)

      enddo
 

c Generate CDP (x,y) data in Transformed space

      done = 0
      CDP_X = 0.
      CDP_Y = 0.
      CDP_counter = 0


      call cdpXY_lite ( Vertex_XY_Transformed, NumVertices, CdpInt, 
     :     CDP_XY_Transformed, nreco, SZLNHD)

      if ( nreco .gt. SZLNHD ) then
         write(LERR,*)' '
         write(LERR,*)'You have asked to generate ',nreco
         write(LERR,*)'CDP traces.  This is more than this '
         write(LERR,*)'routine can handle.  Contact Garossino '
         write(LERR,*)'and ask him to put dynamic memory allocation '
         write(LERR,*)'into this routine or do your traverse in '
         write(LERR,*)'more segments '
         write(LER,*)' '
         write(LER,*)'AT3D_LITE:'
         write(LER,*)'      You have asked to generate ',nreco
         write(LER,*)'      CDP traces.  This is more than this '
         write(LER,*)'      routine can handle.  Contact Garossino '
         write(LER,*)'      and ask him to put dynamic memory '
         write(LER,*)'      allocation  into this routine or do your'
         write(LER,*)'       traverse in more segments '
         write(LER,*)'FATAL '
         goto 999
      endif

c echo all input parameters 

      call verbal (ntap, otap, ptap, dx, dy, CdpInt, 
     :     NumVertices, Vertex_XY, Vertex_XY_Transformed, 
     :     nsamp, ntrc, nrec, iform, nsi, nreco, XSD_Record, XSD_Trace, 
     :     XSD_Sample, verbos)

c echo CDP coordinate information to printout file

      if ( verbos ) write (LERR, 100)
 100  FORMAT('   CDP         X           Y       X_Transformed   Y_Trans
     :formed   line index   depth index',/, 
     *     '  -----   ------------ ----------  -------------   ---------
     :----   ----------   -----------', /)

      DO i = 1, nreco
            
c compute (x,y) co-ords of the cdps

         CDP_XY(1,i) = CDP_XY_Transformed(1,i)
         CDP_XY(2,i) = CDP_XY_Transformed(2,i)

c compute [li,di] locations for cdps: remember, (x,y) --> (di,li)

         CDP_LIDI(2,i) = int(CDP_XY(1,i)/dx) + 1
         CDP_LIDI(1,i) = int(CDP_XY(2,i)/dy) + 1

         CDP_LIDI_XY_Transformed(1,i) = (CDP_LIDI(1,i) - 1) * dy
         CDP_LIDI_XY_Transformed(2,i) = (CDP_LIDI(2,i) - 1) * dx

         if ( verbos ) write(LERR,101) i, CDP_XY(1,i), CDP_XY(2,i), 
     :        CDP_XY_Transformed(1,i), CDP_XY_Transformed(2,i), 
     :        CDP_LIDI(1,i), CDP_LIDI(2,i) 
 101     format( I5, 2X, 2f11.1, 1x, f11.1, 7x, f11.1, i12,1x, I12  )

      ENDDO

c build output lineheader

      call savew ( itr, 'NumRec', nreco, LINEHEADER )
      call savew ( itr, 'NumTrc', 1, LINEHEADER )

c output lineheader

      call wrtape ( luout, itr, lbyout )

c Processing Traverse - one trace at a time

      write(LER,*) ' AT3D_LITE is extracting ',nreco,' traces ',
     :             ' from ',NumVertices-1,' linear segments.'
      
      DO JJ = 1, nreco

c assign four neighbor traces to the desired output cdp location

         LI_Neighbors(1) = CDP_LIDI(1,JJ)
         LI_Neighbors(2) = CDP_LIDI(1,JJ)
         LI_Neighbors(3) = CDP_LIDI(1,JJ) + 1
         LI_Neighbors(4) = CDP_LIDI(1,JJ) + 1

         DI_Neighbors(1) = CDP_LIDI(2,JJ)
         DI_Neighbors(2) = CDP_LIDI(2,JJ) + 1
         DI_Neighbors(3) = CDP_LIDI(2,JJ)
         DI_Neighbors(4) = CDP_LIDI(2,JJ) + 1

         LIDI_Neighbors_X(1) = CDP_LIDI_XY_Transformed(2,JJ)
         LIDI_Neighbors_X(2) = CDP_LIDI_XY_Transformed(2,JJ)
         LIDI_Neighbors_X(3) = CDP_LIDI_XY_Transformed(2,JJ) + dx
         LIDI_Neighbors_X(4) = CDP_LIDI_XY_Transformed(2,JJ) + dx

         LIDI_Neighbors_Y(1) = CDP_LIDI_XY_Transformed(1,JJ)
         LIDI_Neighbors_Y(2) = CDP_LIDI_XY_Transformed(1,JJ) + dy
         LIDI_Neighbors_Y(3) = CDP_LIDI_XY_Transformed(1,JJ)
         LIDI_Neighbors_Y(4) = CDP_LIDI_XY_Transformed(1,JJ) + dy
         
c retrieve 4 neighbor traces

         do KK = 1, 4

c at this point the LI,DI information in these arrays corresponds to
c sequential record, sequential trace. LI's increase across records
c DI's increase across traces.

            if ( LI_Neighbors(KK) .gt. nrec .or. 
     :           DI_Neighbors(KK) .gt. ntrc .or.
     :           LI_Neighbors(KK) .lt. 1 .or. 
     :           DI_Neighbors(KK) .lt. 1 )then
               write(LERR,*)' '
               write(LERR,*)'A neighbor trace has been requested from '
               write(LERR,*)'outside the area of your data.  Either'
               write(LERR,*)'move your traverse vertices away from the'
               write(LERR,*)'edges or supply more data in the stack'
               write(LERR,*)'This happened at output trace ',JJ
               write(LERR,*)'requested Record = ', LI_Neighbors(KK)
               write(LERR,*)'requested Trace  = ', DI_Neighbors(KK)
               if (LI_Neighbors(KK) .gt. nrec ) LI_Neighbors(KK) = nrec
               if (DI_Neighbors(KK) .gt. ntrc ) DI_Neighbors(KK) = ntrc
               if (LI_Neighbors(KK) .lt. 1 ) LI_Neighbors(KK) = 1
               if (DI_Neighbors(KK) .lt. 1 ) DI_Neighbors(KK) = 1
               write(LERR,*)'LI used = ', LI_Neighbors(KK)
               write(LERR,*)'DI used = ', DI_Neighbors(KK)
               write(LERR,*)' WARNING'

               WalkOffDataCount = WalkOffDataCount + 1
               if ( WalkOffDataCount .gt. 16 ) then
                  write(LERR,*)' '
                  write(LERR,*)'  your traverse has requested so '
                  write(LERR,*)'  many traces from outside your '
                  write(LERR,*)'  volume that I think something'
                  write(LERR,*)'  must be wrong with your XSD'
                  write(LERR,*)'  pick file.  Did you make picks on'
                  write(LERR,*)'  a horizontal slice from the input'
                  write(LERR,*)'  volume?  Was XSD used to extract'
                  write(LERR,*)'  the slice?'
                  write(LERR,*)' FATAL'
                  write(LER,*)' '
                  write(LER,*)'AT3D_LITE: '
                  write(LER,*)'     your traverse has requested so '
                  write(LER,*)'     many traces from outside your '
                  write(LER,*)'     volume that I think something'
                  write(LER,*)'     must be wrong with your XSD'
                  write(LER,*)'     pick file.  Did you make picks on'
                  write(LER,*)'     a horizontal slice from the input'
                  write(LER,*)'     volume?  Was XSD used to extract'
                  write(LER,*)'     the slice?'
                  write(LER,*)' FATAL'
                  goto 999
               endif

            endif
            
            tr_index = (LI_Neighbors(KK)-1) * ntrc + (DI_Neighbors(KK))
            call sisseek (luin, tr_index)
            lbytes = 0
            call rtape (luin, itr, lbytes )
            if ( lbytes .eq. 0 ) then
                  write(LERR,*)'Premature EOF on input:'
                  write(LERR,*)'Trying to read sequential record ',  
     :                 LI_Neighbors(KK)
                  write(LERR,*)'               sequential trace ',  
     :                 DI_Neighbors(KK)
                  go to 999
            endif

            call vmov ( itr(ITHWP1), 1, Neighbors(1,KK), 1, nsamp )

         enddo

            
c calculate weighting for trace stacking relative to offset from current
c output (x,y) location.

         call CalcWeights ( CDP_XY_Transformed(1,JJ), 
     :        CDP_XY_Transformed(2,JJ), 
     :        LIDI_Neighbors_X, 
     :        LIDI_Neighbors_Y,
     :        dx, dy, Weight, wght) 

c weight traces
            
         do KK = 1, 4
            do i = 1, nsamp
               Neighbors(i,KK) = Neighbors(i,KK) * Weight(KK)
            enddo
         enddo


c form output trace

         call vmov ( Neighbors(1,1), 1, tri, 1, nsamp ) 
         do KK = 2, 4 
            call vadd ( tri, 1, Neighbors(1,KK), 1, tri, 1, nsamp ) 
         enddo         
         call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )


c update the trace header entries for this cdp output

         call savew2 ( itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, 
     :        nint(CDP_XY(1,JJ)), TRACEHEADER )
         call savew2 ( itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, 
     :        nint(CDP_XY(2,JJ)), TRACEHEADER )
         LinInd = nint((CDP_LIDI(2,JJ) -1) * dy)
         call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd, 
     :        LinInd, TRACEHEADER )
         DphInd = nint((CDP_LIDI(1,JJ) -1) * dx)
         call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd, 
     :        DphInd, TRACEHEADER )
         call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :        JJ, TRACEHEADER )
         call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :        JJ, TRACEHEADER )
         call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :        0, TRACEHEADER )


c  write out the interpolated trace

         call wrtape ( luout, itr, obytes )

      ENDDO

      write(LER,*)'AT3D_LITE: Normal Termination'
      write(LERR,*) 'Normal Termination'
      call lbclos (luin)
      call lbclos (luout)
      close(lu_ptap)
      stop

 991  continue

      write(LERR,*)' '
      write(LERR,*)' unable to open input pickfile ',ptap(1:length)
      write(LERR,*)' check existance/permissions and try again'
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' AT3D_LITE: unable to open input pickfile ',
     :     ptap(1:length)
      write(LER,*)'       check existance/permissions and try again'
      write(LER,*)' FATAL'
      goto 999

 999  continue
      
      call lbclos (luin)
      call lbclos (luout)
      close(lu_ptap)
      write(LERR,*)' Abnormal Termination'
      write(LER,*)' AT3D_LITE: Abnormal Termination'

      stop
      END

