C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C     REVISION 12-1-89

C     PROGRAM XBORN2D
C
C     V(Z) ACOUSTIC CDP KIRCHHOFF DEPTH MIGRATION,
C     USING VELOCITY VUP(Z); BASED ON PROGRAM SHOTMIG2.
C     MODIFICATION:  IMAGE GREATER THAN VERTICAL DIPS ONLY.
C     IMAGING PRINCIPLE:  AN EVENT AT TIME T ON THE INPUT TIME
C     SECTION IS MAPPED ONTO ALL POINTS OF THE OUTPUT DEPTH SECTION
C     FOR WHICH THE TOTAL TWO-WAY TRAVELTIME IS T.
C     ONE TRAVELTIME CURVE IS COMPUTED FOR EACH DEPTH ZETA, NAMELY
C     TRAVELTIMES FROM (0,0) TO ZETA USING THE VELOCITY OF THE
C     UPGOING WAVE FIELD.  THE TRAVELTIMES ARE COMPUTED
C     ALONG RAYPATHS REFRACTING THROUGH THE DEPTH-DEPENDENT MEDIUM.
C     RAYPATHS FROM A PARTICULAR SOURCE/GROUP LOCATION ARE HORIZONTAL
C     TRANSLATES OF THE COMPUTED RAYPATHS, AND SO TRAVELTIME CURVES
C     ASSOCIATED WITH A PARTICULAR UPPER-SURFACE LOCATION ARE TRIVIAL
C     TO COMPUTE.
C

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

      PARAMETER (NXI0 =   4000)
      PARAMETER (NZETA0 = 4000)
      PARAMETER (NRAY10 =  721)

c     PARAMETER (ZMAX = 35000.)
c     PARAMETER (NRAY = NZETA0+20, NRAY1 = NRAY+1)
c     PARAMETER (DIPFIL = 1.)
c     PARAMETER (DIPMAX = 169.)
c     PARAMETER (DETA = 0.)
c     PARAMETER (F1 = 2.,F2 =  4.,F3 = 20.,F4 = 28.)
c     PARAMETER (FMIN =  .5*(F1+F2),FMAX = .5*(F3+F4))
c     PARAMETER (ISIS = 1)
c     PARAMETER (SCALEZ =  0.)
c     PARAMETER (SCALET =  0.)


      integer   itr(SZLNHD)
      integer   obytes
      integer	argis
      INTEGER   IHEADR
      pointer   (wkhdr, IHEADR(1))
      complex   UC(SZLNHD)
      real      taper (SZSMPM)
      DIMENSION UDATA(SZLNHD)

c-------------
c static memory
c     DIMENSION UR(3,NXI0,0:4100)
c     DIMENSION UR1(NXI0,0:4100),UI1(NXI0,0:4100)
c     DIMENSION UR3(NXI0,0:4100),UI3(NXI0,0:4100)
c     DIMENSION BETA(NXI0,0:NZETA0)
c-------------
c dynamic
      real      UR1, UI1
      pointer   (wkur1,    ur1(1))
      pointer   (wkui1,    ui1(1))
      pointer   (wkbeta, beta(1))
c-------------
      DIMENSION SQRF(4100)
      DIMENSION ZETT(0:NZETA0)
      DIMENSION ZETT4(0:4000)
      DIMENSION ZEQL(0:4000)
      DIMENSION TSCALE(0:4100),ZSCALE(0:NZETA0)
      DIMENSION VZUP(0:NZETA0)
      DIMENSION DPMAX(0:NZETA0)
      DIMENSION DIP(0:1000),ZDIP(0:1000)
      DIMENSION VRMS(1000),VINT(1000),TeIME(1000),DEPTH(1000)
      DIMENSION VUP(0:4000)
      DIMENSION ZUP(0:4000)
c-------------
c static memory
c     DIMENSION XP(0:NRAY1,0:NZETA0)
c     DIMENSION TAU(0:NRAY1,0:NZETA0)
c     INTEGER   JTIM(0:NXI0,0:NZETA0)
c     DIMENSION JWMIN(3,0:NZETA0)
c     DIMENSION JWMAX(3,0:NZETA0)
c     DIMENSION JPMIN(0:NZETA0),JPMAX(0:NZETA0)
c-------------
c dynamic
      real      XP, TAU
      integer   JTIM, JWMIN, JWMAX, JPMIN, JPMAX
      pointer   (wkxp,        xp(1))
      pointer   (wktau,      tau(1))
      pointer   (wkjtim,    jtim(1))
      pointer   (wkjwmin,  jwmin(1))
      pointer   (wkjwmax,  jwmax(1))
      pointer   (wkjpmin,  jpmin(1))
      pointer   (wkjpmax,  jpmax(1))
c-------------
      DIMENSION P(0:nray10)
      DIMENSION JWAVE(0:NXI0)

c------
c static memory
c     DIMENSION TAUTRN(0:nray10,0:NZETA0),XPTRN(0:nray10,0:NZETA0)
c------
c dynamic memory
      real      tautrn, xptrn
      pointer   (wktautrn, tautrn(1))
      pointer   (wkxptrn,  xptrn (1))

      DIMENSION JZMIN(0:nray10),JZMAX(0:nray10)
      DIMENSION JXMIN(0:NZETA0)
      DIMENSION JXMAX(0:NZETA0)
      DIMENSION RCRITX(0:NZETA0)
      DIMENSION RCRITY(0:NZETA0)

      DIMENSION TRIGS1(8000),TRIGS2(8000)
      DIMENSION TRIGS3(8000),TRIGS4(8000)

      real      fmin, fmax, coefs(2,32), wrk1(3), wrk2(96)
      integer   norder, initf


#include <f77/pid.h>
C
C     THE CHARACTER DECLARATIONS ARE NEEDED FOR
C     DIRECT ACCESS FILE DEFINITIONS
C
      LOGICAL heap, query, tdfn, flat

      character    ntap * 256, otap * 256, vtap * 256, name*6

      DATA         name/'GAZDAG'/
      DATA         query/.false./
      DATA         norder/2/, initf/1/

c     EQUIVALENCE (UDATA(1), ITR(129))

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number

c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>

c-----
c     get command line arguments

      call       gcmdln(ntap,otap,vtap,dxi,tdfn,flat,fmin,fmax,
     1                  zmax,nray,nray1,dipfil,dipmax,dipmin,deta,
     2                  f1,f2,f3,f4,isis,scalez,scalet,scalev,itaper)
c-----

C     OPEN DISK FOR TRACE DATA READ (14)

c-----
c     get logical unit numbers for input and output of seismic data
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

      DX  = dxi
      DY = DETA
      IF (DY .LT. .0001) DY = 100000.
      DR = AMIN1(DX,DY)

      ZDIP(0) = 0.
      DIP(0) = dipmax
      ZDIP(1) = zmax
      DIP(1) =  dipmin
C
C     READ THE DIX INTERVAL VELOCITIES

      call dix   (vtap,vrms,teime,vint,depth,vup,zup,nvelup,scalev,
     1            flat, tdfn)


      JVELUP = NVELUP



C
C     THEORETICAL MAXIMUM HORIZONTAL RAY PARAMETER WHICH AVOIDS
C     USING SPATIALLY ALIASED REFLECTION DATA.
C
      call migint (dipfil,fmin,fmax,scalez,dxi,zett,f1,f2,f3,f4,
     1             nz,nvelup,nray1,nzeta0,vup,vzup,zup,zscale,dpmax,
     2             ppmax,zmax,dip,zdip,p,np,jvelup,fmaxy)


C
C     READ TRACE DATA LINE HEADER
C
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'BORN: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

c     save certain parameters
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position

c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      Call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif



C**********************EQUALLY-SAMPLED OUTPUT
C
C     REFINE THE DEPTH GRID TO .25 TIMES THE ORIGINAL SPACING.
C     THEN CREATE AN EQUALLY-SPACED DEPTH GRID WITH SPACING
C     EQUAL TO A SUFFICIENTLY SMALL MULTIPLE OF 10 UNITS (IN DEPTH)
C     OR .008 SEC (IN TIME), SO THAT THERE WILL BE NZEQL
C     EQUALLY-SPACED POINTS PER TRACE.
C
C
C     EQUAL-DEPTH-SAMPLED OUTPUT
C
      call       grid (nz,nzeta0,nzeta,isis,fmin,fmax,lngth,lngth4,
     1                 mzeql,nzeql,zett,zett4,zeql,DZEQL)



      write(LERR,*)' '
      write(LERR,*)'*********   HEADER INFORMATION  **********'
      write(LERR,*)'# OF TRACES/RECORD  = ',ntrc
      write(LERR,*)'# OF RECORDS/JOB  = ',nrec
      write(LERR,*)'DT = ',nsi
      write(LERR,*)'DX = ',dxi
      write(LERR,*)'# OF SAMPLES/TRACE  = ',nsamp
      write(LERR,*)'******************************************'
      write(LERR,*)' '

      DT = unitsc * nsi

      call bwcoef ( fmin, fmaxy, dt, coefs, xnorm, norder, ift)

c     IF (nsamp .gt. 1000) THEN
c       write(LERR,*)'***********************'
c       write(LERR,*)'Number samples > 1000'
c       write(LERR,*)'Will use first 1000 samples of trace'
c       nsamp = 1000
c       write(LERR,*)'***********************'
c     ENDIF

      NT = nsamp

c     IF (NT*DT .GT. 8.1921) THEN
c       write(LERR,*)'***********************'
c       write(LERR,*)'STOPPING: NT*DT > 8.192'
c       write(LERR,*)'***********************'
c       STOP
c     END IF

      if (ntrc .eq. 1) then
         nxi = nrec * ntrc
      else
         nxi = ntrc
      endif

      if (isis .eq. 0) then
         NZETA = nzeql
         nsio = DZEQL
      else
         NZETA = nsamp
         nsio = DZEQL * 1000.
      endif
      NT1 = nsamp
      NTMAX = NT*nsi/2
      ntmx  = ntmax

      if (ntrc .eq. 1) then
         ntrco = ntrc * nrec
         nreco = 1
      else
         ntrco = ntrc
         nreco = nrec
      endif

      call migset (NXI,NZ,NRAY1,NT,NTMAX,LNGTH,LNGTH4,nsi,ntrco,
     1             dipmax,sinmax,ppmax,sqrf,trigs1,trigs2,trigs3,
     2             trigs4,uc,p,nsamp,scalet,
     3             tscale,df,dt,itaper,taper)


C
C     WRITE TRACE DATA LINE HEADER
C
      call savew(itr, 'NumTrc', ntrco, LINHED)
      write(LERR,*)'# OF TRACES/RECORD  = ',ntrco
      nsampo = NZEQL
      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumSmp',nsampo, LINHED)
      call savew(itr, 'SmpInt', nsio , LINHED)
      OBYTES = SZSMPD * nsampo + SZTRHD
      call savhlh(itr,lbytes,lbyout)
      CALL WRTAPE(luout,itr,lbyout)

      write(LERR,*)' '
      write(LERR,*)'*********   HEADER INFORMATION  **********'
      write(LERR,*)'**********   MIGRATED SECTION  ***********'
      write(LERR,*)'# OF TRACES/RECORD  = ',ntrco
      write(LERR,*)'# OF RECORDS/JOB  = ',nreco
      write(LERR,*)'DT = ',nsio
      write(LERR,*)'# OF SAMPLES/TRACE  = ',nsampo
      write(LERR,*)'******************************************'
      write(LERR,*)' '


      write(LERR,*)' TRAVELTIMES'

C
C     TRAVELTIMES USING VUP(Z)
C
c-------------------------------------
c  first allocate memory where needed

      heap = .true.

      itemi    = ntrco * ITRWRD * SZSMPD
      iwkjwmin = 3 * (nzeta+1) * SZSMPD
      iwkjpmin =     (nzeta+1) * SZSMPD
      call galloc (wkhdr  , itemi   , errcd, abort)
      call galloc (wkjwmin, iwkjwmin, errcd, abort)
      call galloc (wkjwmax, iwkjwmin, errcd, abort)
      call galloc (wkjpmin, iwkjpmin, errcd, abort)
      call galloc (wkjpmax, iwkjpmin, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: HEADERS'
          write(LERR,*)'Unable to allocate workspace: JWMIN'
          write(LERR,*)'Unable to allocate workspace: JWMAX'
          write(LERR,*)'Unable to allocate workspace: JPMIN'
          write(LERR,*)'Unable to allocate workspace: JPMAX'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: HEADERS',wkhdr,' byts'
          write(LERR,*)'Allocating workspace: JWMIN ',iwkjwmin,' byts'
          write(LERR,*)'Allocating workspace: JWMAX ',iwkjwmin,' byts'
          write(LERR,*)'Allocating workspace: JPMIN ',iwkjpmin,' byts'
          write(LERR,*)'Allocating workspace: JPMAX ',iwkjpmin,' byts'
      endif

      iwktautrn = (nray1+20) * (nzeta+1) * SZSMPD
      call galloc (wktautrn, iwktautrn, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: TAUTRN'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: TAUTRN ',iwktautrn,' byts'
      endif
 
      call galloc (wkxptrn, iwktautrn, errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: XPTRN'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: XPTRN ',iwktautrn,' byts'
      endif


      iwkxp = (nray1+1) * (nzeta+1) * SZSMPD
      call galloc (wkxp,  iwkxp,  errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: XP'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: XP ',iwkxp,' bytes'
      endif
      call galloc (wktau,  iwkxp,  errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: TAU'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: TAU ',iwkxp,' bytes'
      endif
      iwkjtim = (nxi+1) * (nzeta+1) * SZSMPD
      call galloc (wkjtim,  iwkjtim,  errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: JTIM'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: JTIM ',iwkjtim,' bytes'
      endif

      ibyttot =  iwkxp + iwkxp + iwkjtim

      write(LERR,*)' '
      write(LERR,*)'Current memory= ',ibyttot,'  bytes'
      write(LERR,*)' '

      CALL TTIMES
     1   (TAU,XP,NRAY1,P,VZUP,ZETT,       NZ,NZETA
     2    ,JZMIN,JZMAX,JPMIN,JPMAX,TAUTRN,XPTRN,SINMAX,NP
     3    ,JTIM  ,DPMAX,ntrco,JXMIN,JXMAX,DX,DY,DR,NTMAX,NXI
     4    ,JPCRTX,JPCRTY,RCRITX,RCRITY
     4    ,JWMIN,JWMAX,PPMAX
     5    )

c-----------------------
c free up some memory
      call gfree (wkxp)
      call gfree (wktau)
      call gfree (wktautrn)
      call gfree (wkxptrn)

      ibyttot =  ibyttot - 2*iwkxp




      write(LERR,*)' MIGRATING'

c------------------------------------
c go allocate some more memory

      nmax = max (LNGTH4, NTMAX)


      iwkur1 = (nxi+1) * (nmax+1) * SZSMPD
      call galloc (wkur1,  iwkur1,  errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: UR1'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: UR1 ',iwkur1,' bytes'
      endif
      call galloc (wkui1,  iwkur1,  errcd, abort)
      if (errcd .ne. 0.) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: UI1'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: UI1 ',iwkur1,' bytes'
      endif

      ibyttot = ibyttot + 4*iwkur1

      iwkbeta = nxi * (nz+1) * SZSMPD
      call galloc (wkbeta,  iwkbeta,  errcd, abort)
      ierr = errcd
      if (ierr .ne. 0) heap = .false.
      if (.not. heap) then
          write(LERR,*)' '
          write(LERR,*)'Unable to allocate workspace: BETA'
          write(LERR,*)iwkbeta,'  bytes'
          stop
      else
          write(LERR,*)' '
          write(LERR,*)'Allocating workspace: BETA ',iwkbeta,' bytes'
          write(LERR,*)iwkbeta,'  bytes'
      endif

      ibyttot = ibyttot + iwkur + iwkbeta


      write(LERR,*)' '
      write(LERR,*)'Current memory= ',ibyttot,'  bytes'
      write(LERR,*)' '

c-------------------------------------------------------------------------
c     do all recordS
      init = 1

      DO  5000  J = 1, nreco

          call vclr (ur1,  1, (nmax+1)*(nxi+1))
          call vclr (ui1,  1, (nmax+1)*(nxi+1))
          call vclr (beta, 1, nxi*(nz+1))

      write(LER,*)'Migrating record= ',J

      call migit  (NXI,NZ,NRAY1,NT,NT1,NTMAX,LNGTH,LNGTH4,nsio,ntrco,
     1             dipmax,sinmax,ppmax,sqrf,trigs1,trigs2,trigs3,
     2             trigs4,uc,p,wrk1,wrk2,coefs,xnorm,norder,initf,
     3             beta,nzeta,iheadr,udata,zscale,ur1,ui1,
     4             zett,jwave,jwmin,jwmax,jtim,rcritx,luin,
     5             dx,nsamp,itr,tscale, nmax,taper,J,ntmx,
     6             ITRWRD, SZSMPD)
 

      CALL SIS(UR1  ,NXI,NZ,NZETA,NZEQL,ZETT4,ZEQL,ntrco,
     1         IHEADR,luout,obytes,nmax,ntrc,ITRWRD, SZSMPD)




5000  CONTINUE
c-------------------------------------------------------------------------


C
C     CLOSE INPUT AND OUTPUT FILES
C

      CALL LBCLOS(luin )
      CALL LBCLOS(luout)


      STOP
      END
