C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine migbet (ntrc, nz, nzeta, nxi, nmax, lngth4, dx,
     1                   ur1, ui1, jtim, jwave, jwmin, jwmax,
     2                   beta, zett, rcritx, ntmax)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer    ntrc, nz, nzeta, nxi, lngth4
      integer    jwmin(3,0:nzeta), jwmax(3,0:nzeta)
      integer    jtim(0:nxi,0:nzeta), jwave(0:nxi)
      real       zett(0:nzeta), rcritx(0:nzeta)
      real       ur1(nxi,0:nmax), ui1(nxi,0:nmax)
      real       beta(nxi,0:nzeta)

c     write(LER,*)'migbet: ',ntrc,nz,nzeta,nxi,nmax,lngth4,dx,ntmax
C     INITIALIZE OUTPUT ARRAY BETA.

      DO 180 JXI = 1,ntrc
        DO 160 JZETA = 0,NZ
          BETA(JXI,JZETA) = 0.
160     CONTINUE
180   CONTINUE


C
C     CREATE MEDIUM-FREQUENCY TRACES FROM HIGH- AND LOW-FREQUENCY TRACES
C

      itmx  = -99999
      itmn  =  99999
      iofmx = -99999
      iofmn =  99999

      do  i = 0, nxi
          do  j = 0, nzeta
              itj = jtim (i,j)
              if (itj .gt. ntmax) jtim (i,j) = 0
          enddo
      enddo

C
C     MIGRATION STEP.
C     LOOP ORDER FOR CRAY 2 MIGRATION:
C     LOOP OVER DEPTHS
C       LOOP OVER OFFSETS BETWEEN INPUT TRACE AND OUTPUT TRACE
C         LOOP OVER OUTPUT LOCATIONS
C
      DO 500 JZETA = 1,NZ
        ZETA = ZETT(JZETA)
c       WRITE(LER,*)'500 JZETA,ZETA: ',JZETA,ZETA,RCRITX(JZETA)

        DO 360 JX = 0,ntrc
          JWAVE(JX) = 1
360     CONTINUE
        DO 370 JALIAS = 1,3
          DO 365 JX = JWMIN(JALIAS,JZETA),JWMAX(JALIAS,JZETA)
            JWAVE(JX) = JALIAS
365       CONTINUE
366       CONTINUE
370     CONTINUE

C
C       NEGATIVE OFFSETS
C       HALF-STRENGTH FOR LARGEST OFFSET
C
        JXOFL = -IFIX(RCRITX(JZETA)/DX)
c       WRITE(LER,*)'JZETA,JXOFL: ',JZETA,JXOFL
        JWAV = JWAVE(-JXOFL)
        ix   = -JXOFL
        JTIMM = JTIM(ix,JZETA)

        if (jtimm .gt. itmx) itmx = jtimm
        if (jtimm .lt. itmn) itmn = jtimm
C
C       LARGEST OFFSET
C
        DO 380 JXI = 1,ntrc+JXOFL
c         if ((JXI-JXOFL) .gt. iofmx) iofmx = JXI-JXOFL
c         if ((JXI-JXOFL) .lt. iofmn) iofmn = JXI-JXOFL
          if (jwav .eq. 1) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .5 * UR1 (JXI-JXOFL,JTIMM)
          elseif (jwav .eq. 2) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .25 * UR1 (JXI-JXOFL,JTIMM) +
     2                         .25 * UI1 (JXI-JXOFL,JTIMM)
          elseif (jwav .eq. 3) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .5 * UI1 (JXI-JXOFL,JTIMM)
          endif
380     CONTINUE
        DO 4001 JXOFST = JXOFL+1,-1
C
C         OTHER OFFSETS
C
          JWAV = JWAVE(-JXOFST)
C         JWAV1 = JWAVE1(-JXOFST)
          ix    = -JXOFST
          JTIMM = JTIM(ix,JZETA)

        if (jtimm .gt. itmx) itmx = jtimm
        if (jtimm .lt. itmn) itmn = jtimm

          DO 391 JXI = 1,ntrc+JXOFST
c         if ((JXI-JXOFST) .gt. iofmx) iofmx = JXI-JXOFST
c         if ((JXI-JXOFST) .lt. iofmn) iofmn = JXI-JXOFST
          if (jwav .eq. 1) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         UR1 (JXI-JXOFST,JTIMM)
          elseif (jwav .eq. 2) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .5  * UR1 (JXI-JXOFST,JTIMM) +
     2                         .5  * UI1 (JXI-JXOFST,JTIMM)
          elseif (jwav .eq. 3) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         UI1 (JXI-JXOFST,JTIMM)
          endif
391       CONTINUE
4001    CONTINUE

C
C       NONNEGATIVE OFFSETS
C       HALF-STRENGTH FOR LARGEST OFFSET
C
        JXOFR =  IFIX(RCRITX(JZETA)/DX)
c       WRITE(LER,*)'JZETA,JXOFR: ',JZETA,JXOFR
        JWAV = JWAVE( JXOFR)
        ix   = JXOFR
        JTIMM = JTIM(ix,JZETA)

        if (jtimm .gt. itmx) itmx = jtimm
        if (jtimm .lt. itmn) itmn = jtimm
C
C       LARGEST OFFSET
C
        DO 4202 JXI = 1+JXOFR,ntrc
c         if ((JXI-JXOFR) .gt. iofmx) iofmx = JXI-JXOFR
c         if ((JXI-JXOFR) .lt. iofmn) iofmn = JXI-JXOFR
          if (jwav .eq. 1) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .5 * UR1 (JXI-JXOFR,JTIMM)
          elseif (jwav .eq. 2) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .25 * UR1 (JXI-JXOFR,JTIMM) +
     2                         .25 * UI1 (JXI-JXOFR,JTIMM)
          elseif (jwav .eq. 3) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .5 * UI1 (JXI-JXOFR,JTIMM)
          endif
4202    CONTINUE

        DO 4401 JXOFST = 0,JXOFR-1
C
C         OTHER OFFSETS
C
          JWAV = JWAVE( JXOFST)
          ix    = JXOFST
          JTIMM = JTIM(ix,JZETA)

        if (jtimm .gt. itmx) itmx = jtimm
        if (jtimm .lt. itmn) itmn = jtimm

          DO 4203 JXI = 1+JXOFST,ntrc
          if (jwav .eq. 1) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         UR1 (JXI-JXOFST,JTIMM)
          elseif (jwav .eq. 2) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         .5  * UR1 (JXI-JXOFST,JTIMM) +
     2                         .5  * UI1 (JXI-JXOFST,JTIMM)
          elseif (jwav .eq. 3) then
             BETA(JXI,JZETA) = BETA(JXI,JZETA) +
     1                         UI1 (JXI-JXOFST,JTIMM)
          endif
4203      CONTINUE
4401    CONTINUE

500   CONTINUE
C
C     END LOOP OVER DEPTHS
C
      write(LERR,*)' '
      write(LERR,*)'Minimum travel time = ',itmn
      write(LERR,*)'Maximum travel time = ',itmx
      write(LERR,*)'Minimum offset= ',iofmn
      write(LERR,*)'Maximum offset= ',iofmx
      write(LERR,*)' '

      return
      end

