C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      subroutine  outmig (ntrc,nz,lngth,lngth4,nzeta,nxi,nmax,
     1                    trigs3,trigs4, zscale, uc, ur1, ui1, beta)


      integer     ntrc, nz, lngth
      complex     uc(*)
      real        trigs3(*), trigs4(*), zscale(0:nzeta)
      real        ur1(nxi,0:nmax), ui1(nxi,0:nmax)
      real        beta(nxi,0:nzeta)


C
C     INITIALIZE TRACE DATA
C
      DO 2080 JXI = 1,ntrc
        DO 2040 JZETA = 1,NZ
          istrc = (jxi-1) * ntrc
          UR1(JXI,JZETA) = BETA(JXI,JZETA)*ZSCALE(JZETA)
          UI1(JXI,JZETA) = 0.
2040    CONTINUE
        DO 2060 JZETA = NZ+1,LNGTH4
          UR1(JXI,JZETA) = 0.
          UI1(JXI,JZETA) = 0.
2060    CONTINUE

C     FFT (LENGTH = LNGTH).
C     ZERO PAD TO LNGTH4 = 4*LENGTH.
C     INVERSE FFT (LNGTH4).

        do  2061  jzeta = 1, LNGTH4

            UC(jzeta) = cmplx (UR1(JXI,JZETA),UI1(JXI,JZETA))
2061    continue
        call cfftx  (UC, 2, LNGTH, 1, 0, TRIGS3, ierr)
        call cfftss (UC, 2, LNGTH)

        do  2062   jzeta = 1, LNGTH

            UR1(JXI,JZETA) = real  (UC(jzeta))
            UI1(JXI,JZETA) = aimag (UC(jzeta))
2062    continue

2080  CONTINUE

C
C
      DO 2120 JXI = 1,ntrc
        UR1(JXI,        1) = .5*UR1(JXI,1)
        UI1(JXI,        1) = .5*UI1(JXI,1)
        UR1(JXI,LNGTH/2+1) = 0.
        UI1(JXI,LNGTH/2+1) = 0.
        DO 2100 JZ = LNGTH/2  ,LNGTH4
          UR1(JXI,JZ) = 0.
          UI1(JXI,JZ) = 0.
2100    CONTINUE

        do  2101  JZ = 1, LNGTH4

            UC(JZ) = cmplx (UR1(JXI,JZ),UI1(JXI,JZ))
2101    continue

        call cfftx  (UC, 2, LNGTH4, -1, 0, TRIGS4, ierr)

        do  2102  JZ = 1, LNGTH4

            UR1(JXI,JZ) = real  (UC(JZ))
            UI1(JXI,JZ) = aimag (UC(JZ))
2102    continue

2120  CONTINUE


      return
      end
