C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3CONT    CMMVZ3D DOWNWARD CONTINUE AND IMAGE                  *
C***********************************************************************

      subroutine c3cont( verbos, debug, nkx, akx, aky,
     &                   nzseg, izsnz, zsdz, zsslo, w, phase, work,
     &                   kxlim1, kxlim2, psi, dr, di, ierr )

      implicit none

#include <f77/iounit.h>

c symbolic constants:

      complex   ONE
      complex   ZERO
      parameter( ONE = ( 1.0, 0.0 ), ZERO = ( 0.0, 0.0 ) )

c input parameters:

      logical   verbos             ! verbose printout flag
      integer   debug              ! debug printout flag
      integer   nkx                ! number of kx's
      real      akx(nkx)           ! x wave numbers
      real      aky                ! y wave number      
      integer   nzseg              ! number of z segments
      integer   izsnz(nzseg)       ! number of z steps per z segment
      real      zsdz(nzseg)        ! delta z per z segment
      real      zsslo(nzseg)       ! slowness per z segment
      real      w                  ! omega (angular frequency)

c scratch parameters:

      complex   phase(nkx)         ! phase shift vector
      real      work(nkx)          ! scratch space

c modified parameters:

      integer   kxlim1             ! lower limit for kx index
      integer   kxlim2             ! upper limit for kx index
      complex   psi(nkx)           ! wave field
      real      dr(nkx,0:*)        ! real components of complex image
      real      di(nkx,0:*)        ! imag components of complex image

c output parameters:

      integer   ierr               ! completion code

c local variables:

      real      akysq              ! aky**2
      real      arg                ! phase shift argument
      real      dz                 ! delta z in current z segment
      real      dzsq               ! dz**2
      integer   jkx                ! kx loop index
      integer   jz1                ! beginning z index
      integer   jzseg              ! z segment loop index
      integer   nkxlim             ! number of kx's within limits
      integer   nzs                ! number of z's in current z segment
      real      slow               ! slowness in current z segment
      real      ws2ky2             ! (w*slow)**2 - aky**2
C
C-----------------------------------------------------------------------
C
      if( debug .gt. 0 ) write( LUPRT, * ) 'Entered subroutine c3cont'

      akysq  = aky * aky
      nkxlim = kxlim2 - kxlim1 + 1

      if( kxlim1 .gt. 1 ) then
         do jkx = 1, kxlim1-1
            psi(jkx) = ZERO
         enddo
      endif

      if( kxlim2 .lt. nkx ) then
         do jkx = kxlim2+1, nkx
            psi(jkx) = ZERO
         enddo
      endif

      do jkx = kxlim1, kxlim2
         dr(jkx,0) = dr(jkx,0) + real ( psi(jkx) )
         di(jkx,0) = di(jkx,0) + aimag( psi(jkx) )
      enddo

c==== loop over z segments

      jz1 = 1
      do jzseg = 1, nzseg
         nzs    = izsnz(jzseg)
         slow   = zsslo(jzseg)
         dz     = zsdz (jzseg)
         dzsq   = dz * dz
         ws2ky2 = w * w * slow * slow - akysq

         if( ws2ky2 .lt. 0.0 ) return

C$DOACROSS LOCAL(jkx)
         do jkx = kxlim1, kxlim2
            work(jkx)  = ( ws2ky2 - akx(jkx) * akx(jkx) ) * dzsq
            phase(jkx) = ZERO
         enddo

C$DOACROSS LOCAL(jkx,arg)
         do jkx = kxlim1, kxlim2
            if( work(jkx) .ge. 0.0 ) then
               arg        = sqrt( work(jkx) )
               phase(jkx) = cmplx( cos( arg ), sin( arg ) )
            endif
         enddo

         call vzdcn( ONE, phase(kxlim1), psi(kxlim1), dr(kxlim1,jz1),
     &               di(kxlim1,jz1), nkx, nkxlim, nzs )
     
         jz1 = jz1 + nzs
      enddo

      ierr = 0
      return
      end
