C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3GGRIDS   GENERATE IRREGULAR GRIDS                            *
C***********************************************************************

      subroutine c3ggrids( verbos, debug, lu_zeta, fn_zeta, zmax, fmax,
     &                     nzbar, nzseg, izsnz, zsdz, zsslo )

      implicit none

#include <f77/iounit.h>
c
c input parameters:
c
      logical   verbos          ! verbose printout flag
      integer   debug           ! debug printout flag
      integer   lu_zeta         ! logical unit of zeta file
      character fn_zeta*(*)     ! name of zeta file
      real      zmax            ! maximum depth
      real      fmax            ! maximum frequency (Hz)
      integer   nzbar           ! number of z's in irregular grid
      integer   nzseg           ! number of z segments
      integer   izsnz(nzseg)    ! number of z steps per z segment
      real      zsdz(nzseg)     ! delta z per z segment
      real      zsslo(nzseg)    ! slowness per z segment
c
c local variables:
c
      real      dt              ! delta t
      real      dz              ! delta z
      real      dzeq1           ! equal dz value
      integer   i               ! grid index
      integer   jz              ! z index within current z segment
      integer   jzseg           ! z segment index
      real      t               ! time
      real      vsr             ! vertical sample rate (smp/wave length)
      real      z               ! depth
      real      zmin            ! minimum depth
c
c  data initialization:
c
      data zmin, dzeq1, vsr / 0.0, 0.0, 4.0 /

c-----------------------------------------------------------------------

  901 format( '         xvo      dxgrid       dzeq1        fref',
     1        '         vsr'/
     2        24x, 3f12.6/
     3        '        zmin        zmax          nz'/
     4        2f12.3, i12/
     5        '       izeta zeta(izeta) time(izeta)')
  902 format( i12, 2f12.3 )

c-----------------------------------------------------------------------

      if( debug .gt. 0 ) write( LUPRT, * ) 'Entered subroutine c3ggrids'

      open( unit=lu_zeta, file=fn_zeta, status='unknown' )
      write( lu_zeta, 901 ) dzeq1, fmax, vsr, zmin, zmax, nzbar-1

      i = 0
      z = 0.0
      t = 0.0
      write( lu_zeta, 902 ) i, z, t
      do jzseg = 1, nzseg
         dz = zsdz(jzseg)
         dt = 1000.0 * dz * zsslo(jzseg)
         do jz = 1, izsnz(jzseg)
            i = i + 1
            z = z + dz
            t = t + dt
            write( lu_zeta, 902 ) i, z, t
         enddo
      enddo

      close( lu_zeta )
      return
      end
