C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DSKFT                                                *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  PERFORM RESAMPLE FROM V(X,Z) TO V(0),                     *
C          - PERFORM 2D-FFT, DISK FILTER, WEIGHT EACH RECORD,          *
C          - INVERSE 2D-FFT, RESAMPLE BACK TO V(X,Z)                   *
C          - 1024 TRACE LIMIT; 4096 SAMPLE LIMIT (SISTAPE IN AND OUT)  *
C          - ITYPE       (TYPE OF FILTER TO APPLY)                     *
C          - = 1=ZERO INNER RING           (PDSCI)                     *
C          - = 2=ZERO INNER AND OUTER RING (PDISC)                     *
C          - = 3=ZERO OUTER RING           (PDSCO)                     *
C          - INPUT IS A MIGRATED DEPTH SECTION                         *
C          - THIS IS A 3RD STEP TEST ONLY, IT READS RECORD, SHRINKS/STR*
C          - ETCHES IT TO V(0) AND THEN SHRINKS/STRETCHES IT BACK TO THE
C          - ORIGINAL SIZE - THEN APPLIES 2DFFT FORWARD AND INVERSE    *
C          - LAST STEP WILL BE TO ADD THE DISK FILTER AFTER 2DFFT FORW.*
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 88/11/02  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/02  *
C       +------------------------------------------------------+       *
C       |                 REVISION HISTORY                     |       *
C       +------------------------------------------------------+       *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/11/28  *
C            -  CHANGED TO LOOP OVER RECORDS                           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/12/12  *
C            -  CHANGED NAME FROM PDSK TO DSKFT                        *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 9l/01/28  *
C            -  CHANGED to read a velocity tape and not mxc cards      *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 9l/09/10k *
C            -  Moved code to sun for maintenance/distribution         *
C  REVISED BY:  MARY ANN THORNTON  V:2.1      REVISION DATE: 92/03/15  *
C            -  Call openpr with full program name to be compatible
C            -  with OS 6.1, Remove all word size references to run on
C            -  32 bit machine; howver, this routine needs libmbs  
C            -  routines which are not yet available on Sun
C  REVISED BY:  MARY ANN THORNTON  V:2.2      REVISION DATE: 92/04/22  *
C            -  added calls to saver in the rvtap routine, and         *
C            -  recompiled with new libmbs so will run on 32 bit machine
C  REVISED BY:  MARY ANN THORNTON  V:2.3      REVISION DATE: 93/05/18  *
C            -  Changed line header size, added logical unit for hp,   *
C            -  Allow the arguments to come in from the command line, but
C            -  leave code in place for the card reading so old job
C            -  decks will work, enhance error checking
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
      PARAMETER (MXTRA=1024, MXSAM=1024)
      PARAMETER (MXXXX=MXTRA+ITRWRD, MXTOT=MXTRA*MXSAM)
      PARAMETER (LCRD=25,LPRT=26,LLIST=27,LMXC=28)
      PARAMETER (M1=MXTRA*2, M2=MXTRA*4, M3=MXSAM*2, M7=MXTRA*7)
C
      DIMENSION IHEAD(SZLNHD),VEL(MXSAM,MXTRA)
      DIMENSION IZ(M1),ZZ(M2),TABL1(MXSAM),TABL2(M3)
      DIMENSION RXX(MXXXX),DATA(MXSAM)
      DIMENSION A(MXTOT),PARM(6),WRK(M7)
C
      INTEGER*2 IRX(LNTRHD),ITHD(LNTRHD,MXTRA)
C
      LOGICAL VERBOS
      CHARACTER*1 CARD(80),PARR(66)
      CHARACTER*4 VERSION
      CHARACTER*4 GIASC
      CHARACTER*5 NAME,PPNAME
      CHARACTER*128 NTAP,OTAP,INPUT,NVTAP
C
      EQUIVALENCE (CARD(1),NAME)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
      DATA VERSION/' 2.3'/
      DATA PPNAME/'DSKFT'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ','A','P','P','L','Y',' ','A',' ','D','I','S','K',' ',
     3'F','I','L','T','E','R',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C     (LTRM) TERMINAL = 0 EXCEPT WHEN USING PIPES; THEN TERMINAL = 2
C
      ICODE = 0
      LTRM = LER
      IERR  =  0
      CALL cmdlin(NTAP,OTAP,INPUT,NVTAP,IPIPI,IPIPO,LTRM,
     &            itype,dx,dz,f1,f2,f3,f4,VERBOS)
      IF(NVTAP .EQ. ' ')then
         write(ltrm,*) 'You must supply a velocity tape name'
         Write(ltrm,*) ' JOB TERMINATED'
         stop 50
      endif
      IF(IPIPI.EQ.0) THEN
C        LU1 IS A INPUT DATASET
         CALL LBOPEN(LU1,NTAP,'r')
      ELSE
C        WE KNOW LU1 IS A PIPE
         LU1=0
         LTRM=2
      ENDIF
      CALL LBOPEN(LU3,NVTAP, 'r')
      IF(IPIPO.EQ.0) THEN
C        LU2 IS A OUTPUT DATASET
         CALL LBOPEN(LU2,OTAP,'w')
      ELSE
C        WE KNOW LU2 IS A PIPE
         LU2=1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     ITYPE  = 1=ZERO INNER RING           (PDSCI)
C            = 2=ZERO INNER AND OUTER RING (PDISC)
C            = 3=ZERO OUTER RING           (PDSCO)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,10)NTAP,OTAP
   10 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      JERR = 0
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)' ERROR OPENING EXTERNAL CARD FILE'
            STOP 50
         ENDIF
      ELSE
         N=ICOPEN('-dskft.crd',LCRD)
C     READ CARDS
            IF(N.NE.0)THEN
   20         CONTINUE
              READ(LCRD,25,ERR=3000)CARD
   25         FORMAT(80A1)
              IF(NAME.NE.'DSKF')GO TO 20
              READ(LCRD,30)ITYPE,DX,DZ,F1,F2,F3,F4
   30         FORMAT(I10,6F10.0)
            ENDIF
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      if(f2.le.0.0 .or. f3.le.0.0 .or. f4.le.0.0)then
         write(lprt,*)' No filter points were entered'
         icode = 100
         go to 5000
      endif
      if(dz.le.0.0)then
         write(lprt,*)
     &  ' The depth sample spacing must be greater than zero'
         icode = 100
         go to 5000
      endif
      WRITE(LPRT,60)
   60 FORMAT (/////, 27X, 'PROGRAM PARAMETERS',//)
      WRITE(LPRT,65)DX,DZ,F1,F2,F3,F4
   65 FORMAT(
     *' DELTA-X                                ', 10X,'=', F10.3, //,
     *' DELTA-Z                                ', 10X,'=', F10.3, //,
     *' F1                                     ', 10X,'=', F10.3, //,
     *' F2                                     ', 10X,'=', F10.3, //,
     *' F3                                     ', 10X,'=', F10.3, //,
     *' F4                                     ', 10X,'=', F10.3)

  100 CONTINUE
      IF(ITYPE.EQ.1)WRITE(LPRT,*)'ZERO INNER RING'
      IF(ITYPE.EQ.2)WRITE(LPRT,*)'ZERO INNER AND OUTER RING'
      IF(ITYPE.EQ.3)WRITE(LPRT,*)'ZERO OUTER RING'
C
      JEOF = 0
      CALL RTAPE(LU1,IHEAD,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      CALL SAVER(IHEAD, 'NumTrc', LTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', NREC, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', KSAMP, LINHED)
      CALL SAVER(IHEAD, 'Format', IFORM, LINHED)

      IF(LTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         STOP 100
      ENDIF
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         STOP 100
      ENDIF
      IF(DX.LE.0.0)THEN
         CALL SAVER(IHEAD, 'GrpInt', GIASC, LINHED)
         READ(GIASC,23,IOSTAT=IERR)DX
   23    FORMAT(F8.0)
         IF(IERR .NE. 0) THEN
           WRITE(LPRT,*)'BAD READ ON GROUP INTERVAL FROM LINEHEADER'
           STOP 999
         ELSE
           WRITE(LPRT,*)'GROUP INTERVAL READ FROM LINEHEADER ', DX
         ENDIF
         IF(DX.LE.0.0)THEN
            WRITE(LPRT,*)'  GROUP INTERVAL IN LINE HEADER IS ZERO'
            WRITE(LPRT,*)'  YOU MUST ENTER A TRACE SPACING'
            STOP 100
         ENDIF
         WRITE(LPRT,*)'  DX TAKEN FROM HEADER (GI) = ',DX
  110    FORMAT(F8.0)
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   CALL RVTAP
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      ierr = 0
      CALL RVTAP(LPRT,LU3,DX,DZ,VEL,MXSAM,MXTRA,RXX,IRX,DATA,
     1VMIN,VMAX,IERR)
      if(ierr .ne. 0)then
         if(ierr.eq.75)stop 75
         if(ierr.eq.100)stop 100
      endif

      VREF = VMIN
      WRITE(LPRT,90)VREF,VMIN,VMAX
   90 FORMAT(
     *' REFERENCE VELOCITY                     ', 10X,'=', F10.3, //,
     *' MINIMUM VELOCITY                       ', 10X,'=', F10.3, //,
     *' MAXIMUM VELOCITY                       ', 10X,'=', F10.3,/)
      LEN=5
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LPRT)
      CALL WRTAPE(LU2,IHEAD,JEOF)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  SET UP ALL PARAMETERS NEEDED FOR THE FFT AND FILTER
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IPARM = 4
      IF(ITYPE.EQ.2)THEN
         IPARM = 6
      ENDIF
      PI     = 4.0*ATAN(1.0)
      TWOPI  = 2. * PI
      V0     = VMIN
      V02    = V0/2.
      WAVMXI = V02/F1
      WAVMNI = V02/F2
      WAVMXO = V02/F3
      WAVMNO = V02/F4
      CALL PWROF2(KSAMP,KPOW)
      KSAM2  = 2**KPOW
      Z      = FLOAT(KSAM2)*DZ
      DKZ    = TWOPI/Z
      CALL PWROF2(LTR,LPOW)
      LTR2 = 2**LPOW
      X      = FLOAT(LTR2)*DX
      DKX    = TWOPI/X
      R1     = TWOPI/WAVMXI
      R2     = TWOPI/WAVMNI
      R3     = TWOPI/WAVMXO
      R4     = TWOPI/WAVMNO
      IF(ITYPE.EQ.3)THEN
         R1  = R3
         R2  = R4
      ENDIF
      NWMIN  = 1
      NFREQ  = KSAM2/2
      PARM(1) = DKX
      PARM(2) = DKZ
      PARM(3) = R1
      PARM(4) = R2
      PARM(5) = R3
      PARM(6) = R4
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C            STRETCH/SHRINK THE DATA AND MOVE INTO ARRAY A              C
C                              ----                                     C
C                   START OF LOOP OVER RECORDS                          C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      DO 300 MR= 1,NREC
      CALL VCLR(A,1,(MXSAM*MXTRA))
      INIT = 1
      LA=1
      TABL1(1) = 0.0
      TABL2(1) = 0.0
      DO 160 K=2,KSAMP
         TABL1(K) = DZ*(K-1)
  160 CONTINUE
      DO 180 L= 1,LTR
         JEOF=0
         CALL RTAPE(LU1,RXX,JEOF)
         IF(JEOF.EQ.0)GO TO 1500
         CALL VMOV(RXX,1,ITHD(1,L),1,ITRWRD)
         CALL VMOV(DATA,1,A(LA),1,KSAMP)
         DO 170 K=2,KSAMP
            RATIO = VEL(K-1,L)/V0*DZ
            TABL2(K) = TABL2(K-1) + RATIO
  170    CONTINUE
         CALL CCUINT(TABL1,DATA,KSAMP,TABL2,A(LA),KSAMP,IZ,ZZ,INIT)
         INIT=0
         LA=LA+KSAM2
  180 CONTINUE
      IF(LTR2.LE.LTR)GO TO 190
      DO 185 L=LTR+1,LTR2
         CALL VCLR(A(LA),1,KSAM2)
         LA=LA+KSAM2
  185 CONTINUE
  190 CONTINUE
C
C     DO A 2D FFT FORWARD, A FILTER, AND A 2D FFT INVERSE
C
      CALL XDSKFT(A,PARM,NWMIN,NFREQ,KSAM2,LTR2,ITYPE,IERR,WRK)
      IF(IERR.NE.0)THEN
         WRITE(LPRT,*)' ERROR ',IERR,' RETURNED FROM FILTER ROUTINE'
         ICODE=100
         GO TO 5000
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  STRETCH/SHRINK THE DATA BACK AND WRITE THE OUTPUT TAPE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      INIT=1
      LA = 1
      DO 220 L=1,LTR
         DO 200 K=2,KSAMP
            ITAB = TABL2(K-1)/DZ + 1.0
            IF(ITAB.GT.KSAMP)ITAB=KSAMP
            RATIO = V0/VEL(ITAB,L) * DZ
            TABL2(K) = TABL2(K-1) + RATIO
  200    CONTINUE
         CALL CCUINT(TABL1,A(LA),KSAMP,TABL2,DATA,KSAMP,IZ,ZZ,INIT)
         INIT=0
         LA=LA+KSAM2
         CALL VMOV(ITHD(1,L),1,RXX,1,ITRWRD) 
         CALL SAVEW(IRX, 'RecNum', MR, TRCHED) 
         CALL SAVEW(IRX, 'TrcNum', L, TRCHED) 
         CALL WRTAPE(LU2,RXX,JEOF)
         IF(JEOF.EQ.0)GO TO 1600
  220 CONTINUE
  300 CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                     END OF LOOP OVER RECORDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      WRITE(LPRT,*) ' JOB COMPLETE '
      ICODE = 0
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LU1)
      CALL LBCLOS(LU2)
      STOP 100
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)MR,L
 1510 FORMAT(2X,'ERROR READING INPUT RECORD',I5,' TRACE',I5)
      ICODE=100
      GO TO 5000
 1600 CONTINUE
      WRITE(LPRT,1610)L
 1610 FORMAT(2X,'ERROR WRITING OUTPUT TRACE',I5)
      ICODE=100
      GO TO 5000
 3000 CONTINUE
      WRITE(LPRT,*)'  ERROR READING INPUT CARDS'
      ICODE=100
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LU1)
      CALL LBCLOS(LU2)
      IF(ICODE.EQ.50) STOP 50
      IF(ICODE.EQ.75) STOP 75
      IF(ICODE.EQ.100) STOP 100
      IF(ICODE.EQ.200) STOP 200
      STOP
      END
      SUBROUTINE cmdlin(NTAP,OTAP,INPUT,NVTAP,IPIPI,IPIPO,LTRM,
     &                  itype,dx,dz,f1,f2,f3,f4,VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,OTAP,INPUT,NVTAP
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
       WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--POWER STACK & FILTER'
       WRITE(LTRM,*)' '
       WRITE(LTRM,*)' INPUT '
       WRITE(LTRM,*)'-N[ntap] .. INPUT DATASET NAME'
       WRITE(LTRM,*)'-O[otap] .. OUTPUT DATASET NAME'
       WRITE(LTRM,*)'-VT[vtap].. VELOCITY TAPE'
CMATCC WRITE(LTRM,*)'-C[input].. External card file'
       Write(ltrm,*)'-I[type] .. Type of filter to perform'
       Write(ltrm,*)'            1=zero inner ring (low frequencies)'
       Write(ltrm,*)'            2=zero inner and outer (recommended)'
       Write(ltrm,*)'            3=zero outer ring (high frequencies)'
       Write(ltrm,*)'-DX[dx]  .. Trace spacing of input dataset'
       Write(ltrm,*)'-DZ[dz]  .. Depth spacing of input dataset'
       Write(ltrm,*)'-F1[f1]  .. 1st filter point of trapezoidal filter'
       Write(ltrm,*)'-F2[f2]  .. 2nd filter point of trapezoidal filter'
       Write(ltrm,*)'-F3[f3]  .. 3rd filter point of trapezoidal filter'
       Write(ltrm,*)'-F4[f4]  .. 4th filter point of trapezoidal filter'
       WRITE(LTRM,*)'-V        .. VERBOSE PRINTOUT'
       WRITE(LTRM,*)'USAGE:'
       WRITE(LTRM,*)'dskft -N[] -O[] -C[] -VT[] -V'
       STOP
      ENDIF
      CALL ARGSTR('-N', NTAP,' ',' ')
      CALL ARGSTR('-O', OTAP,' ',' ')
      CALL ARGSTR('-VT',NVTAP,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGI4 ('-I',itype,2,2)
      CALL ARGR4 ('-DX',dx,0.0,0.0)
      CALL ARGR4 ('-DZ',dz,0.0,0.0)
      CALL ARGR4 ('-F1',f1,0.0,0.0)
      CALL ARGR4 ('-F2',f2,0.0,0.0)
      CALL ARGR4 ('-F3',f3,0.0,0.0)
      CALL ARGR4 ('-F4',f4,0.0,0.0)
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       XDSKFT                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:       2D-FFT FORWARD, DISK FILTER, 2D-FFT INVERSE          *
C  ENTRY POINTS:                                                       *
C      XDSKFT  (A,PARM,NWMIN,NFREQ,KSAM2,LTR,ITYP,IERR,WRK)             *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (*) -  ARRAY CONTAINING INPUT & OUTPUT *
C      PARM    REAL     ??IOU*  (6) -  PARAMETERS FOR DISK FILTER      *
C      NWMIN   INTEGER  ??IOU*      -  INDEX OF 1ST ELEMENT            *
C      NFREQ   INTEGER  ??IOU*      -  NUMBER OF ELEMENTS              *
C      KSAM2   INTEGER  ??IOU*      -  TIME SAMPLES/TRACE              *
C      LTR     INTEGER  ??IOU*      -  TRACES/RECORD                   *
C      ITYP    INTEGER  ??IOU*      -  TYPE OF FILTER (SEE BELOW)      *
C      IERR    INTEGER  ??IOU*      -  ERROR FLAG                      *
C      WRK     REAL     ??IOU*  (*) -  SCRATCH VECTOR OF LENGTH        *
C                                   -  MAX( 4*KSAM2+6, 7*LTR )         *
C       +------------------------------------------------------+       *
C       ]               DEVELOPMENT INFORMATION                ]       *
C       +------------------------------------------------------+       *
C  AUTHOR:   R.D. COLEMAN                       ORIGIN DATE: 87/05/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/18  *
C       +------------------------------------------------------+       *
C       ]                 EXTERNAL ENVIRONMENT                 ]       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      XRFFT -                                                         *
C      XCFFT -                                                         *
C      FDSCI -                                                         *
C      FDISC -                                                         *
C      FDSCO -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       ]             OTHER DOCUMENTATION DETAILS              ]       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THIS ROUTINE NOW WILL DO AN INPLACE 2DFFT ON  *
C                     -  ARRAY A, THEN APPLY A DISK FILTER, THEN INVERSE
C                     -  2DFFT.                                        *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/10/01  *
C            - REMOVED THE POWER STACK AND PIE FILTER                  *
C       +------------------------------------------------------+       *
C       ]                 ANALYSIS INFORMATION                 ]       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C     ITYP   = TYPE OF FILTER TO INVOKE                                *
C              1 = ZERO INNER CIRCLE                                   *
C              2 = ZERO INNER AND OUTER                                *
C              3 = ZERO OUTER CIRCLE                                   *
C    PARM(6) = (1)   DKX                                               *
C              (2)   DKY * ASPECT RATIO                                *
C              (3)   R1 (RADIUS 1 IN KX'S                              *
C              (4)   R2 (RADIUS 2 IN KX'S                              *
C              (5)   R3 (RADIUS 3 IN KX'S                              *
C              (6)   R4 (RADIUS 4 IN KX'S                              *
C***********************************************************************
      SUBROUTINE XDSKFT(A, PARM, NWMIN, NFREQ, KSAM2, LTR,ITYP,IERR,WRK)
C
      REAL    A(*), PARM(6), WRK(*)
      INTEGER IERR, LTR, ITYP, KSAM2, NFREQ, IDIR, NWMIN
C
C-----------------------------------------------------------------------
C
      IDIR = 1
      CALL XRFFT (A, IDIR, NWMIN, NFREQ, KSAM2, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
      CALL XCFFT (A, IDIR, NFREQ, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     APPLY THE FILTER
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IF (ITYP .EQ. 1) CALL FDSCI (A, PARM       , LTR, NFREQ, IDUMMY)
      IF (ITYP .EQ. 2) CALL FDISC (A, PARM       , LTR, NFREQ, IDUMMY)
      IF (ITYP .EQ. 3) CALL FDSCO (A, PARM       , LTR, NFREQ, IDUMMY)
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     DO THE INVERSE FFT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IDIR = -1
      CALL XCFFT (A, IDIR, NFREQ, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
      CALL XRFFT (A, IDIR, NWMIN, NFREQ, KSAM2, LTR, WRK, IERR)
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     EXIT ROUTINE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
  900 CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       PWROF2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  GIVEN A NUMBER(N) THIS ROUTINE RETURNS THE BASE TWO       *
C       EXPONENT(IPWR) WHICH WILL GIVE 2**(IPWR-1).GT.N.LE.2**I   *PWR
C  ENTRY POINTS:                                                       *
C      PWROF2  (N,IPWR)                                                *
C  ARGUMENTS:                                                          *
C      N       INTEGER    I    - INPUT VALUE (INTEGER)                 *
C      IPWR    INTEGER    O    - OUTPUT VALUE RETURNED (INTEGER)       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   BRUCE CROWL                        ORIGIN DATE: 84/06/18  *
C  LANGUAGE: FORTRAN 77 - CRAY           DATE LAST COMPILED: 87/05/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 87/05/08  *
C            - CONVERTED TO CRAY FORTRAN                               *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE PWROF2 (N,IPWR)
      IPWR = 0
      IF (N.LE.0) GO TO 200
100   CONTINUE
      IF (2**IPWR.GE.N) GO TO 200
      IPWR = IPWR+1
      IF (IPWR.LT.30) GO TO 100
200   CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C***********************************************************************
C  ROUTINE:       RVTAP         
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ A VELOCITY TAPE and return a matrix of velocities
C  LANGUAGE:      FORTRAN
C  AUTHOR:        M. A. Thornton   
C  ORIGIN DATE:   91/01/24
C***********************************************************************
C  CATEGORY:      GENERAL PURPOSE
C  ENTRY TYPE:    SINGLE_ENTRY
C  PARAMETERS:
C      lprt           LOGICAL UNIT NUMBER FOR PRINT OUTPUT
C      lu3            velocity Tape logical unit
C      dxd            delta-x of the data
C      dzd            delta-z of the data
C      v              matrix of velocities
C      mxsam          max. no. samples per trace
C      mxtra          max. no. traces per record
C      rxx            TRACE 
C      irx            Trace header
C      data           the trace data without the header
C      vmin           minimum velocity on tape
C      vmax           maxmum velocity on tape
C      ierr           error flag for sucessful completion of subroutine
C  KEYWORDS:
C  LOGICAL UNITS:
C  FORTRAN SUPPLIED ROUTINES:
C**************************************************  END SCAN INFO  ****
C  GENERAL DESCRIPTION:
C  DESCRIPTION OF KEY VARIABLES:
C  ERROR HANDLING:
C  SPECIAL CONSIDERATIONS:
C***********************************************************************
      SUBROUTINE RVTAP(LPRT,LU3,DXD,DZD,V,MXSAM,MXTRA,RXX,IRX,DATA,
     1vmin,vmax,ierr)
#include <f77/HeaderSize.h>
      dimension ihead(1500), rxx(*), irx(*), data(*)
      dimension v(mxsam,mxtra)

C*******************************************************************
C     READ LINE HEADER -  tape must be open exterior to this routine
C*******************************************************************
      ierr = 0
      jeof = 0
      call rtape (lu3, ihead, jeof)
      if (jeof .eq. 0) then
         write (lprt, *) ' ERROR READING LINE HEADER'
         ierr = 75
         return
      endif
      call saver(ihead, 'NumTrc', ltr, linhed)
      call saver(ihead, 'NumRec', nrec, linhed)
      call saver(ihead, 'SmpInt', isi, linhed)
      call saver(ihead, 'NumSmp', ksamp, linhed)
      call saver(ihead, 'Dx1000', idx, linhed)
      call saver(ihead, 'Dz1000', idz, linhed)
      call saver(ihead, 'MinVel', ivmin, linhed)
      call saver(ihead, 'MaxVel', ivmax, linhed)
      dxn   = idx / 1000.0       
      dzn   = idz / 1000.0       
      vmin  = ivmin
      vmax  = ivmax

C check to see if velocity dataset matches the data to within 1/100%
      xd = abs(dxn-dxd)
      zd = abs(dzn-dzd)
      xp = .0001 * dxd
      zp = .0001 * dzd
      if(xd .gt. xp .or. zd .gt. zp)then
         write(lprt,*)' Velocity tape does not match the data'
         Write(lprt,10)ltr,ksamp,dxn,dzn,dxd,dzd
   10    format(' No. of traces : ',i10,/
     1          ' No. of samples: ',i10,/
     2          ' Trace spacing (velocity): ',f40.20,/
     3          ' Depth spacing (velocity): ',f40.20,/
     4          ' Trace spacing (data): ',f40.20,/
     5          ' Depth spacing (data): ',f40.20)
         ierr = 100
         return
      endif
C     read the tape
      do 110 L = 1,ltr
         jeof = 0
         call rtape (lu3, rxx, jeof)
         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR READING TRACE', l
            ierr = 75
         endif
         if (irx(125) .eq. 30000) then
            write (lprt, *) 'DEAD TRACE ON VELOCITY TAPE, trace = ', l
            ierr = 75
            return
         endif
         do 105 k=1,ksamp
            v(k,l) = data(k)
            if(v(k,l) .le. 0.0)then
               write(lprt,*)' zero velocity found in trace no.',l
               ierr = 75
               return
            endif
  105    continue
  110 continue
C
C     if the min and max velocity are not set in lineheader, pick them out
C     of the data
      if(vmin .le. 0.0 .or. vmax .le. 0.0)then
         vmin = 100000.
         vmax = 0.0
         do 200 l=1,ltr
            do 200 k=1,ksamp
               if(v(k,l) .lt. vmin)vmin = v(k,l)
               if(v(k,l) .gt. vmax)vmax = v(k,l)
  200    continue
         write(lprt,*)' WARNING-Maximum velocity in line header is zero'
         write(lprt,201) vmin
         write(lprt,202) vmax
  201    format(' Minimum velocity on tape is ',f10.2)
  202    format(' Maximum velocity on tape is ',f10.2)
      endif
      call lbclos (lu3)
      return
      end
