C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: RDVMOD   READ VELOCITY MODEL                                 *
C***********************************************************************

      subroutine rdvmod( verbos, nvel, fmax, dtgrid, tmax,
     &                     dzgrid, zmax, strch, nzbar, nzseg, 
     &                     izsnz, zsdz, zsslo, ierr )

      implicit none

#include <f77/iounit.h>

c
c input parameters:
c
      real      dtgrid          ! delta time (ms)
      real      dzgrid          ! delta z for output
      real      fmax            ! maximum frequency (Hz)
      integer   nvel            ! number of velocities in the vel. file
      real      strch           ! stretch factor
      logical   verbos          ! verbose output flag
c
c modified (input and output) parameters:
c
      real      tmax            ! maximum time for migration (ms)
      real      zmax            ! maximum depth of migration
c
c output parameters:
c
      integer   ierr            ! error flag
      integer   izsnz(*)        ! number of z steps per z segment
      integer   nzbar           ! number of z's (irregular grid)
      integer   nzseg           ! number of z segments
      real      zsdz(*)         ! delta z per z segment
      real      zsslo(*)        ! slowness per z segment
c
c local variables
c
      real      dzmax           ! maximum delta z for current z segment
      integer   ivel            ! velocity card sequence number
      integer   jvel            ! velocity loop index
      integer   mz              ! number of z steps in current z segment
      character card*100        ! card image buffer
      real      tend            ! t at bottom of current z segment
      real      tlast           ! t at bottom of last z segment
      real      vel             ! velocity
      real      zend            ! z at bottom of current z segment
      real      zlast           ! z at bottom of last z segment
      real      zstep           ! thickness of current z segment

c-----------------------------------------------------------------------
  900 format( a80 )
  903 format( 10x, i10 )
  901 format( i10, f10.0, 10x, f10.0 )
  912 format( /' ', 'VELOCITIES AND DEPTHS ARE STRETCHED BY', f6.3 )

c-----------------------------------------------------------------------
      read( LUCARD, 900, iostat=ierr ) card
      if( ierr .ne. 0 ) then
         write( LER, * ) '*** ERROR: cannot read velocity card 1 ***'
         ierr = 2001
         return
      endif

      if( card(1:5) .eq. 'NOVEL' ) then
         read( LUCARD, 903, iostat=ierr ) nvel
         if( ierr .ne. 0 ) then
            write( LER, * ) '*** ERROR: cannot read velocity card 2 ***'
            ierr = 2003
            return
         endif
      else if( card(1:5) .eq. 'MODEL' ) then
         read( card, 903, iostat=ierr ) nvel
         if( ierr .ne. 0 ) then
            write( LER, * ) '*** ERROR: cannot read velocity card 2 ***'
            ierr = 2003
            return
         endif
      endif

      if( nvel .le. 0 ) then
         write( LER, * ) '*** ERROR: invalid number of velocities ***'
         ierr = 2004
         return
      endif

      read( LUCARD, 900, iostat=ierr ) card
      if( ierr .ne. 0 ) then
         write( LER, * ) '*** ERROR: cannot read velocity card 3 ***'
         ierr = 2005
         return
      endif

      if( card(1:10) .ne. 'VELOCITIES' ) then
         write( LER, * ) '*** ERROR: invalid velocity card 3 ***'
         ierr = 2006
         return
      endif

      nzbar = 1
      nzseg = 0
      tlast = 0.0
      zlast = 0.0
      do jvel = 1, nvel
         read(LUCARD,901,iostat=ierr)ivel, vel, zend
         if( ierr .ne. 0 ) then
            write( LER, * ) '*** ERROR: cannot read velocity file ***'
            ierr = 3001
            return
         endif
         vel  = vel  * strch
         zend = zend * strch
         if( zend .gt. zmax ) zend = zmax
         tend = tlast + 1000.0 * ( zend - zlast ) / ( 0.5 * vel )
         if( tend .gt. tmax ) then
            tend = tmax
            zend = zlast + 0.0005 * vel * ( tend - tlast )
         endif  
         if( jvel .gt. 1 .or. zend .gt. 0.0 ) then
            nzseg = nzseg + 1
            if( dzgrid .gt. 0.0 ) then
               zend = dzgrid * aint( zend / dzgrid + 1.0 )
               tend = tlast + 1000.0 * ( zend - zlast ) / ( 0.5 * vel )
            else
               tend = dtgrid * aint( tend / dtgrid + 1.0 )
               zend = zlast + 0.0005 * vel * ( tend - tlast )
            endif
            zstep = zend - zlast
            zlast = zend
            tlast = tend
            if( vel .le. 0.0 .or. zstep .le. 0.0 ) then
               write( LER, * ) '*** ERROR: invalid velocity card ***'
               ierr = 3003
               return
            endif
            dzmax = 0.25 * vel / fmax
            mz    = ifix( zstep / dzmax )
            if( mz*dzmax .lt. zstep ) mz = mz + 1
            nzbar = nzbar + mz
            izsnz(nzseg) = mz
            zsdz(nzseg)  = zstep / float( mz )
            zsslo(nzseg) = 2.0 / vel
         endif
         if( tend .ge. tmax .or. zend .ge. zmax ) go to 110
      end do

  110 continue
      tmax = tend
      zmax = zend
      if( verbos .and. strch .ne. 1.0 ) write( LERR, 912 ) strch
      ierr = 0
      return
      end
