C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c NAME: F3WDDS
c PURPOSE: WRITE OUTPUT DDS DICTIONARY FILE
c***********************************************************************
c
c  HISTORY:       MAR 95          REV 1.0         J. Cooperstein, CETech
c
c***********************************************************************
c   In the full 3D case, the data dictionary will contain the following:
c
c   data=   <full_data_file_path_name>
c   format= usp
c   data_type=  complex*8
c   axis=   w kx ky
c   size=   <nw> <nkx> <nky>
c   delta=  <dw> <dkx> <dky>
c   origin= <w0> <kx0> <ky0>
c   txy_size= <nsmp_in> <ntrc_in> <nrec_in>
c***********************************************************************
c   If -2D is specified, then the data dictionary will contain the
c   following:
c
c   data=   <full_data_file_path_name>
c   format= usp
c   data_type=  complex*8
c   axis=   w kx y
c   size=   <nw> <nkx> <ny>
c   delta=  <dw> <dkx> <dy>
c   origin= <w0> <kx0> 0.0
c   txy_size= <nsmp_in> <ntrc_in> <nrec_in>
c***********************************************************************
c
c   If nrec_in = 1, then -2D will be the default and the data dictionary
c   will be:
c
c   data=   <full_data_file_path_name>
c   format= usp
c   data_type=  complex*8
c   axis=   w kx
c   size=   <nw> <nkx>
c   delta=  <dw> <dkx>
c   origin= <w0> <kx0>
c   txy_size= <nsmp_in> <ntrc_in> 1
c
c***********************************************************************
      subroutine f3wdds( outfil, otap, nw, nkx, nky, dw, dkx, dky, w0
     &                     , kx0, ky0, dy, ny, nsmp, ntrc, nrec
     &                     , twod, verbos )
c***********************************************************************
      implicit none
c***********************************************************************
c
#include <f77/iounit.h>
c
c input parameters
c
      real      dkx             ! delta kx
      real      dky             ! delta ky
      real      dw              ! delta w
      real      dy              ! delta y
      real      kx0             ! first kx
      real      ky0             ! first ky
      integer   nkx             ! number of kx_s
      integer   nky             ! number of ky_s
      integer   nrec            ! number of records
      integer   nsmp            ! number of samples per trace
      integer   ntrc            ! number of traces per record
      integer   ny              ! number of y_s
      integer   nw              ! number frequencies (omega) kept
      character otap*(*)        ! full name of DDS file
      character outfil*(*)      ! output data dictionary
      logical   twod            ! if true, perform fft only on first 2 dim
      logical   verbos          ! verbose output flag
      real      w0              ! first omega

c
c local variables
c
      character card*132        ! record on dds file
      integer jcard             ! record index on dds file
c***********************************************************************
c
      open( unit=LUCARD, file=outfil, status='unknown' )
c
      write( LUCARD, '(''data= '',(a))' ) otap
      write( LUCARD, '(''format= usp'')' )
      write( LUCARD, '(''data_type=  complex*8'')' )
c
c===  full 3D case
c
      if( .not. twod ) then
         write( LUCARD, '(''axis=   w kx ky'')'    )
         write( LUCARD, '(''size=     '',3i20)'    ) nw, nkx, nky
         write( LUCARD, '(''delta=    '',3g20.10)' ) dw, dkx, dky
         write( LUCARD, '(''origin=   '',3g20.10)' ) w0, kx0, ky0
         write( LUCARD, '(''txy_size= '',3i20)'    ) nsmp, ntrc, nrec
         go to 900
      endif
c
c=== 2D case
c
      if( nrec .ne. 1 ) then
c
         write( LUCARD, '(''axis=   w kx y'')'     )
         write( LUCARD, '(''size=     '',3i20)'    ) nw, nkx, ny
         write( LUCARD, '(''delta=    '',3g20.10)' ) dw, dkx, dy
         write( LUCARD, '(''origin=   '',3g20.10)' ) w0, kx0, 0.0
         write( LUCARD, '(''txy_size= '',3i10)'    ) nsmp, ntrc, nrec
         go to 900
c
      else
c
         write( LUCARD, '(''axis=   w kx '')'     )
         write( LUCARD, '(''size=     '',3i10)'   ) nw, nkx
         write( LUCARD, '(''delta=    '',3f20.5)' ) dw, dkx
         write( LUCARD, '(''origin=   '',3f20.5)' ) w0, kx0
         write( LUCARD, '(''txy_size= '',3i10)'   ) nsmp, ntrc, 1
         go to 900
      endif
c
c***********************************************************************
900   continue
c
      if ( verbos ) then
         write( LUPRT, * ) ' CONTENTS OF OUTPUT DDS FILE: '
         rewind( LUCARD )
         do jcard = 1, 8
            read( LUCARD, '(a)' ) card
            write( LUPRT, '(a)' ) card
         enddo
      endif
c
      close( LUCARD )
      return
      end
c***********************************************************************
