C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- fillhdr ----- ----- ----- ----- ----- ----- ---
c get machine dependent parameters -----

#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c ----- dimension standard USP variables -----

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     argis

      character   ntap*255, otap*255, name*8

      logical     verbos

c dimension program specific variables

      integer     h1min, h2min
      integer     headval(3000,5000)
      integer     ifmt_tmnem1,l_tmnem1,ln_tmnem1, hval1
      integer     ifmt_tmnem2,l_tmnem2,ln_tmnem2, hval2
      integer     ifmt_tmnem3,l_tmnem3,ln_tmnem3, hval3


      character   ftap*255, tmnem1*6, tmnem2*6, tmnem3*6
      real        value3

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'FILLHDR'/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln( ntap, otap, ftap, ns, ne, irs, ire,
     :            tmnem1, h1min, tmnem2, h2min, tmnem3, verbos )

c open input and output datasets

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LOT,*)'FILLHDR: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
         endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      write(LOT,*)tmnem1,' ',tmnem2,' ',tmnem3
      call savelu(tmnem1,ifmt_tmnem1,l_tmnem1,
     :           ln_tmnem1,TRACEHEADER)
      call savelu(tmnem2,ifmt_tmnem2,l_tmnem2,
     :           ln_tmnem2,TRACEHEADER)
      call savelu(tmnem3,ifmt_tmnem3,l_tmnem3,
     :           ln_tmnem3,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 8, LERR)

c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header

      call savhlh(itr,lbytes,lbyout)
      call wrtape (luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( nsamp, nsi, ntrc, nrec, iform, ntap, otap, ftap, 
     :     tmnem1, h1min, tmnem2, h2min, tmnem3 )

c open flat file as required

      call alloclun ( luflat )
      length = lenth(ftap)
      open ( luflat, file=ftap(1:length), status='old', err=990 )

c BEGIN PROCESSING

c initialize header array:
      do i=1,3000
         do j=1,5000
            headval(i,j)=30300
         enddo
      enddo
c first, read flat file and establish index limits for array:
 10   read(luflat, *, end=777, err=992 ) value1, value2, value3
      i=value1-h1min
      j=value2-h2min
      k=nint(value3)
      headval(i,j)=k
      goto 10

 777  continue
c  process desired trace records 

      DO JJ = 1, nrec
         DO KK = 1, ntrc

c read trace

            nbytes = 0
            call rtape(luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get location trace headers: 

            call saver2(itr,ifmt_tmnem1,l_tmnem1,
     :                 ln_tmnem1,hval1,TRACEHEADER)
            call saver2(itr,ifmt_tmnem2,l_tmnem2,
     :                 ln_tmnem2,hval2,TRACEHEADER)

            i=hval1-h1min
            j=hval2-h2min
            hval3=headval(i,j)

c now write out value into tmnem3:

            call savew2(itr,ifmt_tmnem3,l_tmnem3,
     :                 ln_tmnem3,hval3,TRACEHEADER)
            
c write out trace

            call wrtape (luout, itr, obytes)

         ENDDO
      ENDDO

c  close data files 

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      close(luflat)

      write(LERR,*)'end of prgm, processed',nreco,' record(s)',
     :             ' with ',ntrc, ' traces'

      write(LER,*)' fillhdr: Normal Termination'
      stop

c 	error messages 

 990  write(LERR,*) ' error opening flat file: check spelling'

      stop

c end of flat file before end of data

 991  write(LERR,*)' Encountered EOF on flat file prior to end'
      write(LERR,*)' of data.  Will pass rest of input dataset'
      write(LERR,*)' '
      write(LERR,*)' WARNING '
      write(LERR,*)' '
      Rec = float(ire + 1)
      goto 10

 992  write(LERR,*)' Error reading flatfile.  Check contents'
      write(LERR,*)' and rerun'
      write(LERR,*)' FATAL'
      write(LER,*)' FILLHDR: Error reading flatfile.  Check contents'
      write(LER,*)'           and rerun'
      write(LER,*)' FATAL'
      stop
      
      end

      subroutine verbal (nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :     ftap, tmnem1, h1min, tmnem2, h2min, tmnem3)

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, iform, h1min, h2min

      character   ntap*(*), otap*(*), ftap*(*), tmnem1*(*)
      character   tmnem2*(*), tmnem3*(*)

 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*) ' format of data        =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' flat file name        =  ', ftap
      write(LERR,*) ' Index Header 1        =  ', tmnem1
      write(LERR,*) ' Minimum value of Header 1 =  ', h1min
      write(LERR,*) ' Index Header 2        =  ', tmnem2
      write(LERR,*) ' Minimum value of Header 2 =  ', h2min
      write(LERR,*) ' Value Header          =  ', tmnem3
      return
      end

      subroutine cmdln ( ntap, otap, ftap, ns, ne, irs, ire, tmnem1, 
     :     h1min, tmnem2, h2min, tmnem3, verbos )

#include <f77/iounit.h>

      integer     ns, ne, irs, ire, argis, h1min, h2min 

      character   ntap*(*), otap*(*), ftap*(*), tmnem1*(*)
      character   tmnem2*(*), tmnem3*(*)

      logical     verbos

      call argstr( '-F', ftap, ' ', ' ' )

      call argstr( '-hw1', tmnem1, 'LinInd', 'LinInd' )
      call argstr( '-hw2', tmnem2, 'DphInd', 'DphInd' )
      call argstr( '-hw3', tmnem3, 'WDepDP', 'WDepDP' )

      call argi4 ( '-h1min', h1min ,   0  ,  0    )
      call argi4 ( '-h2min', h2min ,   0  ,  0    )

      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )

      call argstr( '-N', ntap, ' ', ' ' )

      call argstr( '-O', otap, ' ', ' ' )

      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )

      verbos =   (argis('-V') .gt. 0)
      end


      subroutine help

#include <f77/iounit.h>

c...5....0....5....0....5....0....5....0....5....0....5....0....5....0..
      write(LER,*)'                                                    '
      write(LER,*)'FILLHDR is another program for storing values in the'
      write(LER,*)'headers of a 3D dataset. The program reads a file   '
      write(LER,*)'containing 3 columns of numbers (the first two are  '
      write(LER,*)'header values which identify where the value in the '
      write(LER,*)'third column belongs), and stores the value in a    '
      write(LER,*)'specified header location. This file can be arranged'
      write(LER,*)'in ANY order, and DOES NOT have to be in the same   '
      write(LER,*)'order as the data.                                  '
      write(LER,*)'                                                    '
      write(LER,*)' Parameters [default values] :                      '
      write(LER,*)' -N []          req  input 3D data set              '
      write(LER,*)' -O []          req  output 3D data set             '
      write(LER,*)' -F []          req  ascii header data file         '
      write(LER,*)' -hw1 [LinInd]  req  first column header            '
      write(LER,*)' -h1min [0]     opt  minimum value in column 1      '
      write(LER,*)' -hw2 [DphInd]  req  second column header           '
      write(LER,*)' -h2min [0]     opt  minimum value in column 2      '
      write(LER,*)' -hw3 [WDepDP]  req  header to fill                 '
      write(LER,*)' -ns[first]     opt  start trace number             '
      write(LER,*)' -ne[last]      opt  end trace number               '
      write(LER,*)' -rs[first]     opt  start record number            '
      write(LER,*)' -re[last]      opt  end record number              '
      write(LER,*)' -V             opt  verbose printout               '
      write(LER,*)'                                                    '
      write(LER,*)'Usage:                                              '
      write(LER,*)'fillhdr -N[] -O[] -F[] -ns[] -ne[] -rs[] -re[] \    '
      write(LER,*)'-hw1[] -h1min[] -hw2[] -h2min[] -V                  '
      write(LER,*)'                                                    '
      write(LER,*)'Example: top of salt at LI 1962,DI 3001 is at 2390m '
      write(LER,*)'and you want this stored in header Horz01 of your   '
      write(LER,*)'velocity model. The header file would look like     '           
      write(LER,*)'          1962 3001 2390                            '
      write(LER,*)'The command line would be                           '
      write(LER,*)'                                                    '
      write(LER,*)'fillhdr -Nvelmod -Ovelmod.new -Ftopsalt.picks \     '
      write(LER,*)'-hw1LinInd -hw2DphInd -h1min1000 -h2min1200   \     '
      write(LER,*)'-hw3Horz01                                          '
      write(LER,*)'                                                    '
      write(LER,*)'** h1min and h2min are options to reduce the header '
      write(LER,*)'   array size in the program                        '
      write(LER,*)'                                                    '

      return
      end
