/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "flatd2t.h"


#define MAXSTRINGLEN 256

/* Version 1.2
   Added dz option    Gary Murphy      Mar 10, 1993
*/

extern void prhelp();

main(argc,argv)
int argc;
char **argv;
{
  int i,j,k,n,help,verbose,error;
  int nrec,ntr,nsamps;
  int irec,itr,iseq,iseq2;
  int invellhlen,invelluin;
  int invelntr,invelnsamp,invelnrec;
  int iniz;
  int flattrace, flatrec;

  float nines,defvalue;
  float *inveldata,*invelthead,*inveltime;
  float *inpckdata;
  float iz,zmin,zmax;
  float invellh[6000];
  float ration, ratiod, ratio;
  float pkey,skey,olddepth,depth,newvavg,newtime;
  int data_id,orientation;
  float recoffset,trcoffset,smpoffset;
  int no_seg,no_pnts;
  int li,di,ili,idi,liinc,diinc;
  float indz,dz;
  float dx,dy;
  float x1,y1,x2,y2;

  char inflatfilename[MAXSTRINGLEN],outflatfilename[MAXSTRINGLEN];
  char invelfilename[MAXSTRINGLEN];
  char s1[MAXSTRINGLEN],s2[MAXSTRINGLEN],s3[MAXSTRINGLEN],string[MAXSTRINGLEN];
  char *segment="Segment";

  FILE *fpinflat,*fpoutflat,*fopen();
 
  /* handle the command line args */
  nines=999999.;
  defvalue=nines;
  if (help=is_arg("-h",&argc,argv)) prhelp();
  strcpy(inflatfilename,get_arg("-P1","",&argc,argv));
  strcpy(outflatfilename,get_arg("-P2","",&argc,argv));
  strcpy(invelfilename,get_arg("-V1","",&argc,argv));
  verbose=is_arg("-V",&argc,argv);
  defvalue=atoi(get_arg("-D","999999.",&argc,argv));
  ili=atoi(get_arg("-ili","1",&argc,argv));
  idi=atoi(get_arg("-idi","1",&argc,argv));
  liinc=atoi(get_arg("-liinc","1",&argc,argv));
  diinc=atoi(get_arg("-diinc","1",&argc,argv));
  dz=atoi(get_arg("-dz","0.",&argc,argv));
 
  /* ensure all dataset names are given */
  if(!strlen(inflatfilename)) {
    help=1;
    fprintf(stderr,"flatd2t: input ascii pick file -P1 must be specified\n");
  }
  if(!strlen(outflatfilename)) {
    help=1;
    fprintf(stderr,"flatd2t: output ascii pick file -P2 must be specified\n");
  }
  if(!strlen(invelfilename)) {
    help=1;
    fprintf(stderr,"flatd2t: velocity field -V1 must be specified\n");
  }
 
  /* user needs help */
  if (help) prhelp();
 
  /* open input flat ascii pick file */
  fpinflat=fopen(inflatfilename,"r");
  if (!fpinflat) {
    fprintf(stderr,"flatd2t: Can not open\n%s\n",inflatfilename);
    exit(-1);
  }
 
  /* open output flat ascii pick file */
  fpoutflat=fopen(outflatfilename,"w");
  if (!fpoutflat) {
    fprintf(stderr,"flatd2t: Can not open\n%s\n",outflatfilename);
    exit(-1);
  }
 


  /* open the velocity field dataset and get line header */
  if (error=USPOpenAndReadLineHeader(invelfilename,&invelluin,
                                     invellh,&invellhlen)) exit(-1);


  /* fetch crucial line header stuff */
  C_SAVER(invellh,"NumTrc",&invelntr,  LINHED);
  C_SAVER(invellh,"NumRec",&invelnrec,  LINHED);
  C_SAVER(invellh,"NumSmp",&invelnsamp,LINHED);
  C_SAVER(invellh,"Dz1000",&iniz,LINHED);
  indz=(float)iniz*0.001;
  if(dz!=0.)indz=dz;
  nrec=invelnrec;
  ntr=invelntr;

 
  /* allocate data buffers */
  inveldata=(float *)malloc(invelntr*invelnsamp*sizeof(float));
  inveltime=(float *)malloc(invelntr*invelnsamp*sizeof(float));
  invelthead=(float *)malloc(invelntr*ITRWRD*sizeof(float));
  inpckdata=(float *)malloc(invelntr*nrec*sizeof(float));
  if (inveldata==NULL || invelthead==NULL ||
    inveltime==NULL || inpckdata==NULL) {
    fprintf(stderr,"flatd2t: not enough memory - Adios Amigo\n");
    exit(-1);
  }

  /*   load inpckdata with 999999's   */
  for (j=0; j<nrec; j++) {
    for (i=0; i<ntr; i++) {
      iseq2=(j*ntr)+i;
      inpckdata[iseq2]=defvalue;
     }
  }

  if (verbose) {
     printf ("Input file %s\n", inflatfilename);
     printf ("Output file %s\n", outflatfilename);
     printf ("Input velocity file %s\n", invelfilename);
     printf ("Number of records %d\n", nrec);
     printf ("Number of traces %d\n", ntr);
     printf ("Number of samples %d\n", invelnsamp);
     printf ("Nines %f\n", nines);
     printf ("defvalue %f\n", defvalue);
     printf ("Dz %f\n", indz);
  }

  /*  load array of depths */
  iseq2=0;zmin=nines;zmax=-nines;
  while(fscanf(fpinflat,"%d %d %f",&irec,&itr,&iz)==3) {
      li=(irec-ili)/liinc+1;
      di=(itr-idi)/diinc+1;
      if((li>=1)&&(li<=nrec)&&(di>=1)&&(di<=ntr)) {
        iseq=(li-1)*ntr+(di-1);
        inpckdata[iseq]=iz;
        iseq2++;
        if(inpckdata[iseq]>zmax)zmax=inpckdata[iseq];
        if(inpckdata[iseq]<zmin)zmin=inpckdata[iseq];
      }
      fscanf(fpinflat,"\n"); 
  }
  printf ("Number of input depth picks read in is %d.\n", iseq2);
  printf ("Maximum input depth is %f.\n", zmax);
  printf ("Minimum input depth is %f.\n", zmin);

  /* read velocity field */
  for (j=iseq2=0,zmin=nines,zmax=-nines; j<invelnrec; j++) {
    if (error=USPReadDataByRecord(&invelluin,invelthead,inveldata,
      &invelntr,&invelnsamp)) exit(-1);

 
    /* compute time array for velocity field */
    printf("Processing record %d\n",j+1);
    for (i=0; i<invelntr; i++) {
      k=i*invelnsamp;
      inveltime[k]=0.;
      for (n=1; n<invelnsamp; n++) {
         inveltime[k+n]=inveltime[k+n-1]+(2.*indz/inveldata[k+n-1]);
      }
      flattrace=i+1;
      flatrec=j+1;
      olddepth = inpckdata[((flatrec-1)*ntr)+(flattrace-1)];
      if (olddepth != nines) {
        n=olddepth/indz;
        if(n<invelnsamp){
          newtime=1000.*(inveltime[k+n]+(inveltime[k+n+1]-inveltime[k+n])*(olddepth-(n*indz))/indz);
        } else {
          newtime=1000.*inveltime[k+n];
        }
        iseq=(flatrec-1)*ntr+(flattrace-1);
        inpckdata[iseq]=newtime;
        if(inpckdata[iseq]>zmax)zmax=inpckdata[iseq];
        if(inpckdata[iseq]<zmin)zmin=inpckdata[iseq];
        iseq2++;
      }
    }
  }
  printf ("Number of output time picks read in is %d.\n", iseq2);
  printf ("Maximum output time is %f.\n", zmax);
  printf ("Minimum output time is %f.\n", zmin);

  /* Write time picks*/
  for (j=0; j<nrec; j++) {
    for (i=0; i<ntr; i++) {
      irec=j+1;
      itr=i+1;
      iseq=(j*ntr)+i;
      li=(irec-1)*liinc+ili;
      di=(itr-1)*diinc+idi;
      if(inpckdata[iseq]!=nines) {
        fprintf(fpoutflat," ");
        fprintf(fpoutflat,"%d %d %f",li,di,inpckdata[iseq]);
        fprintf(fpoutflat,"\n");
      }
    }
  }

  /* Rewind veltape */
  rwd(invelluin);
  lbclos(invelluin);

 
  /* close flat ascii pick files */
  fclose(fpinflat);
  fclose(fpoutflat);

  exit(0);
}


void prhelp()
{
  fprintf(stderr,"\nPROGRAM flatd2t - convert horizons from depth to time\n\n");
  fprintf(stderr,"ARGUMENTS:\n");
  fprintf(stderr,"  -h   help requested\n");
  fprintf(stderr,"  -P1  input ascii flatfile horizon file    (no default)\n");
  fprintf(stderr,"  -P2  output ascii flatfile horizon file   (no default)\n");
  fprintf(stderr,"  -V1  velocity field                       (no default)\n");
  fprintf(stderr,"  -D   default value for depth              (optional)  \n");
  fprintf(stderr,"       (invoked with no pick or depth of 999999.        \n");
  fprintf(stderr,"       If this values is defaulted, the corresponding\n"   );
  fprintf(stderr,"       pick will not be output.\n");
  fprintf(stderr,"  -ili starting li                          (optional)  \n");
  fprintf(stderr,"       (default is 1)                                   \n");
  fprintf(stderr,"  -idi starting di                          (optional)  \n");
  fprintf(stderr,"       (default is 1)                                   \n");
  fprintf(stderr,"  -liinc starting li                        (optional)  \n");
  fprintf(stderr,"       (default is 1)                                   \n");
  fprintf(stderr,"  -diinc starting di                        (optional)  \n");
  fprintf(stderr,"       (default is 1)                                   \n");
  fprintf(stderr,"  -dz  (default is velocity tape Dz1000)    (optional)  \n");
  fprintf(stderr,"\n");
  fprintf(stderr,"USAGE: flatd2t -P1[] -P2[] -V1[] -ili[] -idi[] -dz -h -V\n");
  exit(-1);
}
