C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C     AUTHOR:  Curtis Kruse
C     REVISED: Mary Ann Thornton     0l/30/92
C     Moved to sun for maintenance/distribution
C     REVISED: Mary Ann Thornton     06/04/92
C     Added calls to saver,savew - code now portable to 32 bit machine
C     REVISED: David Nelson          08/25/92
C     Added savew to make output rec and trc numbers like a veltape
C     REVISED: David Nelson          02/01/93
C     Made the line header buffer bigger, 6000 words
C     REVISED: Mary Ann Thornton V: 3.3    07/08/93
C     Included the hp.h, so logical unit LER is not 0 on the HP
C
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
CCCCC
C     TAPE DATA AND HEADER ARRAYS
CCCCC
      PARAMETER (LHEAD=6000,LCRD=25,LPRT=26,LLIST=27)
      DIMENSION IHEAD(LHEAD)

      PARAMETER (NHEAD=11, MXTRA=2048, MXSAM=2048)
      PARAMETER (MXREC=80) 
      PARAMETER (MXTOT=MXTRA*MXSAM)

      DIMENSION RXX(MXSAM+ITRWRD),DATA(MXSAM),A(MXTOT)
      REAL IMAGE(MXTOT),PICKS(MXSAM),PICKS1(MXSAM),PICKS2(MXSAM)
      REAL TEMPPICK(MXSAM)
      INTEGER*2 IRX(LNTRHD),THDR(LNTRHD,MXTRA)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))

      CHARACTER*1  CARD(80),PARR(66)
      CHARACTER*4 NAME,PPNAME
      CHARACTER*4 VERSION
      EQUIVALENCE (CARD(1),NAME)

      LOGICAL VERBOS
      CHARACTER*128 OTAP,NTAP,NTAP2
      INTEGER LUIN2
      INTEGER IPTR2,IPTR1,ITR,NUMPICKS,IPICK,OUTTYPE
      INTEGER KSAMPP,NRECP,IFORMP
      REAL C1,C2
      INTEGER P1,P2
      REAL MULT


      DATA VERSION/' 3.3'/
      DATA PPNAME/'FSI '/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ','F','O','C','A','L',' ','S',
     2'U','R','F','A','C','E',' ','I','M','A','G','E',' ','F','R','O',
     3'M',' ','V','E','L','O','C','I','T','Y',' ',
     3          'C','U','B','E',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/


      LTRM  = LER
      CALL cmdlin(NTAP,NTAP2,OTAP,IPIPI,IPIPO,LTRM,VERBOS,
     & OUTTYPE,MULT)
      CALL LBOPEN(LUIN2,NTAP2,'r')
      IF(IPIPI.EQ.0)THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN = 0
         LTRM = 2
      ENDIF
      IF(IPIPO.EQ.0)THEN
C        LUOUT IS AN INPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT=1
      ENDIF

      IERR  = 0
      JSTAT = 0
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
c     OPEN PRINTOUTS
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
      NLIN=1
#include <mbsdate.h>
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,NTAP2,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' INPUT PICKS = ',/,A128,/,
     &  ' OUTPUT DATASET = '/,A128)
      JERR = 0
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN CUBE INPUT TAPE, GET PARAMETERS     WRITE THEM OUT         C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JEOF = 0
      CALL RTAPE4(LUIN2,IHEAD,JCOF,JEOF)
      call saver(ihead,'NumTrc',numpicks,linhed)
      call saver(ihead,'NumRec',nrecp,linhed)
      call saver(ihead,'SmpInt',isip,linhed)
      call saver(ihead,'NumSmp',ksampp,linhed)
      call saver(ihead,'Format',iformp,linhed)
      JEOF = 0
      CALL RTAPE4(LUIN,IHEAD,JCOF,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      LEN=4
      call saver(ihead,'NumTrc',ntr,linhed)
      call saver(ihead,'NumRec',nrec,linhed)
      call saver(ihead,'SmpInt',isi,linhed)
      call saver(ihead,'NumSmp',ksamp,linhed)
      call saver(ihead,'Format',iform,linhed)
     
      CALL HLHPRT(IHEAD,JCOF,PPNAME,LEN,LPRT)

      IF(IFORM.NE.3)THEN
         WRITE(LPRT,*)'  INPUT TAPE MUST BE FORMAT 3'
         STOP 100
      ENDIF

      WRITE(LPRT,*)' '
      WRITE(LPRT,*)' '
      WRITE(LPRT,*)'PICK DATASET: ',NTAP2
      WRITE(LPRT,22)KSAMPP,NUMPICKS,NRECP,ISIP,IFORMP
      WRITE(LPRT,*)' '

      WRITE(LPRT,*)'CUBE DATASET: ',NTAP
      WRITE(LPRT,22)KSAMP,NTR,NREC,ISI,IFORM
22    FORMAT(
     *4X,'NO. OF SAMPLES PER TRACE               ', 10x,'=', I10, /,
     *4X,'NO. OF TRACES PER RECORD               ', 10x,'=', I10, /,
     *4X,'NO. OF RECORDS                         ', 10x,'=', I10, /,
     *4X,'SAMPLE INTERVAL                        ', 10x,'=', I10, /,
     *4X,'FORMAT                                 ', 10x,'=', I10, /)

C
      IF(NTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         STOP 100
      ENDIF
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         STOP 100
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C      Read cube data from input tape and extract image
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      DT=.001*ISI
      CALL VCLR(DATA,1,MXSAM)
      LA=1
      J=1

      JEOF = 0
      CALL RTAPE(LUIN2,RXX,JEOF)
      CALL VMOV(DATA,1,PICKS1,1,KSAMP)
      CALL VMOV(DATA,1,PICKS2,1,KSAMP)
      IREC=0
      IPTR1=1
      ENDPICK = 0.0
      IPTR2=IRX(110)
      ITR=1
      IPICK = 1
      IF(VERBOS)WRITE(LPRT,1131)IPICK,IPTR2
      IF(VERBOS)WRITE(LPRT,*)' '
      DO 500 MR=1,NREC


C        ------read picks from input file----------
         IF(IPTR2.LE.ITR.AND.ENDPICK.EQ.0.0)THEN
             IPICK = IPICK + 1
             IF(IPICK.GE.NUMPICKS) THEN
                 ENDPICK=1.0
                 CALL VMOV(PICKS2,1,PICKS1,1,KSAMP)
                 IPTR2 = 999999
             ENDIF
             CALL VMOV(PICKS2,1,PICKS1,1,KSAMP)
             JEOF=0
             CALL RTAPE(LUIN2,RXX,JEOF)
             CALL VMOV(DATA,1,PICKS2,1,KSAMP)
             IPTR1 = IPTR2
             IPTR2 = IRX(110)
             IF(VERBOS)WRITE(LPRT,1131)IPICK,IPTR2
1131         FORMAT('PICK #',I6,' RECNUM=',I6,$)
         ELSE
             WRITE(LPRT,1132)
1132         FORMAT('                          ',$)
         ENDIF

C        -----read a record from the cube ----------
         LA=1
         DO 100 L= 1,NTR
            JEOF=0
            CALL RTAPE(LUIN,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            CALL VMOV(IRX,1,THDR(1,L),1,ITRWRD)
            CALL VMOV(DATA,1,A(LA),1,KSAMP)
            LA = LA + KSAMP
  100    CONTINUE
         ITR = IRX(106)

         IF(VERBOS)WRITE(LPRT,1133)ITR
1133     FORMAT(' CUBE RECORD=',I6,$) 


            IF(OUTTYPE.EQ.1.OR.
     &        (OUTTYPE.EQ.2.AND.IPICK.GT.1.AND.
     &                     ENDPICK.NE.1.0).OR.
     &           (OUTTYPE.EQ.3.AND.ITR.EQ.IPTR2).OR. 
     &           (OUTTYPE.EQ.3.AND.ITR.EQ.IPTR1))THEN
C            ------interpolate picks between locations-----
            icalc = (ITR-IPTR1)/(IPTR2-IPTR1)
            C1 = icalc
            CALL VINTB(PICKS1,1,PICKS2,1,C1,TEMPPICK,1,KSAMP)
            IF(VERBOS)WRITE(LPRT,*)'INTERPOLATE, C1=',C1

            if(mult.le.0.0)mult = 1.0
            scale = 1./mult
            CALL VSMUL(TEMPPICK,1,scale,PICKS,1,KSAMP)

               IREC = IREC+1
               DO 550 I=1,KSAMP
                  IF(PICKS(I).LE.0.0)PICKS(I)=1.0
                  IF(PICKS(I).GT.NTR)PICKS(I)=NTR 
                  P1 = PICKS(I)
                  P2 = PICKS(I)+1.0
                  C2 = PICKS(I)-1.*P1
                  C1 = 1.0 - C2   
                  I1 = (P1-1)*KSAMP+I
                  I2 = (P2-1)*KSAMP+I 
                  IMAGE(J)=A(I1)*C1 + A(I2)*C2
                  J = J + 1
   

550	       CONTINUE
            ELSE
               IF(VERBOS)WRITE(LPRT,*)' '
            ENDIF
500   CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ PICKS AND EXTRACT IMAGE FROM CUBE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C        OUTPUT EXTRACTED IMAGE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      call savew(ihead,'NumRec',1,linhed)
      call savew(ihead,'NumTrc',irec,linhed)
      CALL WRTAPE(LUOUT,IHEAD,JCOF)
      LA=1
         DO 601 L= 1,IREC
            CALL VMOV(THDR(1,L),1,IRX,1,ITRWRD)
            call savew(irx,'RecNum',1,trched)
            call savew(irx,'TrcNum',l,trched)
            CALL VMOV(IMAGE(LA),1,DATA,1,KSAMP)
            CALL WRTAPE(LUOUT,RXX,JEOF)
            LA = LA + KSAMP
601      CONTINUE

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      GO TO 5000

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 100
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR ON RECORD',I5,' TRACE',I5)
      ICODE = 75
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                          READ CARD ERRORS                            C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 3000 CONTINUE
      WRITE(LPRT,*)'  ERROR READING INPUT CARDS ON READ ',IREAD
      ICODE = 50
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      IF(ICODE.EQ.50)STOP 50
      IF(ICODE.EQ.75)STOP 75
      IF(ICODE.EQ.100)STOP 100
      IF(ICODE.EQ.200)STOP 200
      IF(ICODE.EQ.300)STOP 300

      STOP
      END


C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO GET DATASET NAMES                                      *
C  ENTRY POINTS:                                                       *
C      cmdlin(NTAP,NTAP2,OTAP,IPIPI,IPIPO,LTRM,VERBOS,FLAG,MULT)       *
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,NTAP2,OTAP,IPIPI,IPIPO,LTRM,VERBOS,
     &    FLAG,MULT)
      INTEGER ARGIS,FLAG
      REAL MULT
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,NTAP2,OTAP
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--FOCAL SURFACE IMAGE'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-NC[ntap] ........ INPUT CUBE DATASET NAME'
         WRITE(LTRM,*)'-NP[ntap2] ....... INPUT PICK DATASET NAME'
         WRITE(LTRM,*)'-O[otap] ......... OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-a................ Extract an image for every '
         WRITE(LTRM,*)'                   location in the cube. Picks'
         WRITE(LTRM,*)
     &   '                  will be extrapolated as necessary'
         WRITE(LTRM,*)'-b................ Extract image between first' 
         WRITE(LTRM,*)
     &   	'                   and last picked location. Picks' 
         WRITE(LTRM,*)
     &'                   between will be interpolated as '
         WRITE(LTRM,*)'                   necessary.'
         WRITE(LTRM,*)'-n[N] ............ Pick index multiplier.     ' 
         WRITE(LTRM,*)'                   Number of traces picked'
         WRITE(LTRM,*)'                   divided by number of traces ' 
         WRITE(LTRM,*)'                   per record in cube input'
         WRITE(LTRM,*)'                   This is necessary if the'
         WRITE(LTRM,*)'                   cube was interpolated to'
         WRITE(LTRM,*)'                   a finer trace interval  '
         WRITE(LTRM,*)'                   before picking.         '
     
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'-V       .. VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'fsi  -NC[] -NP[] -O[] -V  '
         STOP
      ENDIF
      CALL ARGSTR('-NC',NTAP,' ',' ')
      CALL ARGSTR('-NP',NTAP2,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      FLAG=1
      IF (ARGIS('-a').GT.0) FLAG = 1
      IF (ARGIS('-b').GT.0) FLAG = 2
      IF (ARGIS('-c').GT.0) FLAG = 3
      CALL ARGR4 ('-n',MULT,1.,1.)
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
