C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*********************************************************************
c
c 3-d post stack depth migration using an f-x,y algorithm
c
c*********************************************************************
c
	implicit none
c
#include     <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>

c
 
        integer     itrd (SZLNHD),itrm(SZLNHD),itrz(SZLNHD)
        integer     lhed_d( SZLNHD ),lhed_m( SZLNHD )
        integer     luin_data,luin_model,lbytes,nbytes,lbyout,lbyte
	integer	    luin_zmap
	integer	    lbym,lbyd,lbyz,jerr
c
        real        tri_model( SZLNHD )
        real        tri_data ( SZLNHD )
        real        tri_zmap ( SZLNHD )
c       equivalence ( itrm(129), tri_model (1) )
c       equivalence ( itrd(129), tri_data (1) )
c       equivalence ( itrz(129), tri_zmap (1) )
c
	character*80 data_fn,model_fn,zmap_fn
	character    name*4
c
	logical zmap_here,coeff_flag,restart
c
	integer	nx_aper_max,nops_max,nkx_max
	parameter (nx_aper_max=32,nops_max=513,nkx_max=512)
c
	integer	nx_data,ny_data,nw,nwc,nw_rem,nz_partitions
	integer	nx_model,ny_model,nz,nzc,nz_zmap
	integer	nx_pad,ny_pad
	integer nw_partitions,nw_step
	integer	nx,ny
	integer	firstx_data,firsty_data,lastx_data,lasty_data
	integer	argis
	integer	err,abrt
	integer	dx1000,dy1000,dz1000
	integer	iw_start,nw_mig
	integer	ipz_restart,ipw_restart
c
	real	dx_data,dy_data,x0_data,y0_data,z0
	real	dx_model,dy_model,x0_model,y0_model
	real	dx,dy,dz
	real	dx_here,dy_here,dz_here
	real	w0,dw,w0_here,dw_here
c
c pointers
c
	complex	c_data,c_slice,c_d0,c_d1,c_d2,c_out
	complex c_dtemp
	real	datr,dati,image,model,mult,rem
	real	matrix
	integer	index
c
	pointer (p_c_data,c_data(1))
	pointer (p_c_slice,c_slice(1))
	pointer (p_c_dtemp,c_dtemp(1))
	pointer (p_c_d0,c_d0(1))
	pointer (p_c_d1,c_d1(1))
	pointer (p_c_d2,c_d2(1))
	pointer (p_c_out,c_out(1))
c
	pointer (p_datr,datr(1))
	pointer (p_dati,dati(1))
	pointer (p_image,image(1))
	pointer (p_model,model(1))
	pointer (p_mult,mult(1))
	pointer (p_rem,rem(1))
c
	pointer (p_index,index(1))
	pointer (p_matrix,matrix(1))

        data name/'FX3D'/
c
c see if the idiot wants help
c
        if ( argis ( '-?' ) .gt. 0 )then
            call help()
            stop
        endif
c
	call argstr('-N',data_fn,' ',' ')
	call lbopen(luin_data,data_fn,'r')
	call argstr('-M',model_fn,' ',' ')
	call lbopen(luin_model,model_fn,'r')

        call sislgbuf (luin_data, 'off')
c
c read the line header for the data
c
	call rtape(luin_data,itrd,lbytes)
	lbyd=lbytes
c
c get parameters describing the data
c
	call saver(itrd,'NumSmp',nx_data,LINHED)
	call saver(itrd,'NumTrc',ny_data,LINHED)
	ny_data=ny_data/2
	call saver(itrd,'NumRec',nw,LINHED)
	call saver(itrd,'Dx1000',dx1000,LINHED)
	dx_here=dx1000/1000.
	call saver(itrd,'Dy1000',dy1000,LINHED)
	dy_here=dy1000/1000.
	call getfp(itrd,'ReSpFm',w0_here,LINHED)
	call getfp(itrd,'RATTrc',dw_here,LINHED)
c
#include <f77/open.h>

	write(LER,*)'w0 from the line header=',w0_here
	write(LER,*)'dw from the line header=',dw_here
	write(LER,*)'dx_data from the line header=',dx_here
	write(LER,*)'dy_data from the line header=',dy_here
	write(LERR,*)'w0 from the line header=',w0_here
	write(LERR,*)'dw from the line header=',dw_here
	write(LERR,*)'dx_data from the line header=',dx_here
	write(LERR,*)'dy_data from the line header=',dy_here
c
	call argr4('-x0_data',x0_data,0.,0.)
	call argr4('-y0_data',y0_data,0.,0.)
	call argr4('-w0',w0,w0_here,w0_here)
	call argr4('-dw',dw,dw_here,dw_here)
	call argr4('-dx_data',dx_data,dx_here,dx_here)
	call argr4('-dy_data',dy_data,dy_here,dy_here)
c
c read the line header for the model
c
	call rtape(luin_model,itrm,lbytes)
	lbym=lbytes
c
c get parameters describing the model
c
	call saver(itrm,'NumSmp',nx_model,LINHED)
	call saver(itrm,'NumTrc',ny_model,LINHED)
	call saver(itrm,'NumRec',nz,LINHED)
	call saver(itrm,'Dx1000',dx1000,LINHED)
	dx_here=dx1000/1000.
	call saver(itrm,'Dy1000',dy1000,LINHED)
	dy_here=dy1000/1000.
	call saver(itrm,'Dz1000',dz1000,LINHED)
	dz_here=dz1000/1000.
c
	write(LER,*)'dz from the model line header=',dz_here
	write(LER,*)'dx_model from the line header=',dx_here
	write(LER,*)'dy_model from the line header=',dy_here
	write(LERR,*)'dz from the model line header=',dz_here
	write(LERR,*)'dx_model from the line header=',dx_here
	write(LERR,*)'dy_model from the line header=',dy_here
c
c write a warning
c
	write(LER,*)'If these dont look right, you should kill ',
     1   'this run'
	write(LER,*)'and override these from the command line'
	write(LERR,*)'If these dont look right, you should kill ',
     1   'this run'
	write(LERR,*)'and override these from the command line'
c
	call argr4('-x0_model',x0_model,0.,0.)
	call argr4('-y0_model',y0_model,0.,0.)
	call argr4('-z0',z0,0.,0.)
	call argr4('-dz',dz,dz_here,dz_here)
	call argr4('-dx_model',dx_model,dx_here,dx_here)
	call argr4('-dy_model',dy_model,dy_here,dy_here)
c
c now decide if the model and data are compatible: The migration will be
c done into the model, so we don't want any parts of the data hanging
c out. Also, the grid sizes must be the same.
c
	if(dx_model .ne. dx_data)then
	  write(LER,*)'model and data dx dont agree: fatal'
	  write(LERR,*)'model and data dx dont agree: fatal'
	  stop
	else
	  dx=dx_data
	end if
c
	if(dy_model .ne. dy_data)then
	  write(LER,*)'model and data dy dont agree: fatal'
	  write(LERR,*)'model and data dy dont agree: fatal'
	  stop
	else
	  dy=dy_model
	end if
c
c now, since this is a hale mcclellan code, dx must equal dy
c
	if(dx .ne. dy)then
	  write(LER,*)'dx must equal dy: fatal'
	  write(LERR,*)'dx must equal dy: fatal'
	  stop
	end if
c
c ok now go figure out where the data sits in the model grid
c
	firstx_data=nint((x0_data-x0_model)/dx)+1
	firsty_data=nint((y0_data-y0_model)/dy)+1
	lastx_data=firstx_data+nx_data-1
	lasty_data=firsty_data+ny_data-1
c
	if(firstx_data .lt. 1 )then
	   write(LER,*)'x0 of the data falls outside the model: fatal'
	   write(LERR,*)'x0 of the data falls outside the model: fatal'
	   stop
	end if
c
	if(firsty_data .lt. 1 )then
	   write(LER,*)'y0 of the data falls outside the model: fatal'
	   write(LERR,*)'y0 of the data falls outside the model: fatal'
	   stop
	end if
c
	if(lasty_data .gt. ny_model )then
	   write(LER,*)'lasty of the data falls outside the model: ',
     1       'fatal'
	   write(LERR,*)'lasty of the data falls outside the model: ',
     1       'fatal'
	   stop
	end if
c
	if(lastx_data .gt. nx_model )then
	   write(LER,*)'lastx of the data falls outside the model: ',
     1       'fatal'
	   write(LERR,*)'lastx of the data falls outside the model: ',
     1       'fatal'
	   stop
	end if
c
c See if they are supplying a Zmap for irregular dz
c
	zmap_here=(argis('-IRZ') .gt. 0)
c
	write(LER,*)zmap_here
c
	if(zmap_here)then
c
	   call argstr('-Z',zmap_fn,' ',' ')
	   call lbopen(luin_zmap,zmap_fn,'r')
c
c read the line header for the zmap
c
	   call rtape(luin_zmap,itrz,lbytes)
c
	   call saver(itrz,'NumSmp',nz_zmap,LINHED)
c
	   if(nz_zmap .lt. nz)then
	     write(LER,*)'Error, there have to be as many z levels'
	     write(LER,*)'in the map as in the model'
	     stop
	   end if
c
c go ahead and read it
c
	   call rtape(luin_zmap,itrz,nbytes)
c
	end if 
c
c get some more parameters, that describe how to do the migration,
c have intelligent defaults
c
	call argi4('-nzc',nzc,16,16)
	nzc=2*(nzc/2)
	if(nzc .lt. 2)nzc=2
	nz_partitions=nz/nzc
	if(mod(nz,nzc) .ne. 0)nz_partitions=nz_partitions+1
c
c see if they are asking to restart
c
	restart=(argis('-restart') .gt. 0)
c
c allow the user to subset the frequency slices
c
	call argi4('-iw_start',iw_start,1,1)
c
	call argi4('-nw_mig',nw_mig,nw-(iw_start-1),nw-(iw_start-1))
c
c ask for the number of frequencies to carry at the same time
c
	call argi4('-nw_step',nw_step,4,4)
c
	call argi4('-nwc',nwc,16,16)
c
c nwc has to be an even multiple of nw_step
c
	nwc=nw_step*(nint ( float(nwc)/float(nw_step) ) )
	nw_partitions=nw_mig/nwc
	if(mod(nw_mig,nwc) .ne. 0)nw_partitions=nw_partitions+1
c
c if we are restarting, find out where
c
	if(restart)then
c
	   call argi4('-ipw_restart',ipw_restart,0,0)
c
	   if(ipw_restart .eq. 0)then
	     write(LER,*)'Error, you asked to restart, but didnt say'
	     write(LER,*)'which frequency chunk -ipw_restart'
	     stop
	   end if
c
	   call argi4('-ipz_restart',ipz_restart,0,0)
c
	   if(ipz_restart .eq. 0)then
	     write(LER,*)'Error, you asked to restart, but didnt say'
	     write(LER,*)'which depth chunk -ipz_restart'
	     stop
	   end if
c
	end if
c
c decide if we are doing least squares ops
c
	coeff_flag=(argis('-lsq') .gt. 0)
c
c allocate memory needed for everything
c
	nx_pad=nx_model+6
	ny_pad=ny_model+6
	call galloc(p_c_data,2*SZSMPD*nx_model*ny_model*nwc,err,abrt)
	call galloc(p_c_slice,2*SZSMPD*nx_model*ny_model*nw_step,err,
     1								abrt)
	call galloc(p_c_dtemp,2*SZSMPD*nx_pad*ny_pad,err,abrt)
	call galloc(p_c_d0,2*SZSMPD*nx_model*ny_model,err,abrt)
	call galloc(p_c_d1,2*SZSMPD*nx_model*ny_model,err,abrt)
	call galloc(p_c_d2,2*SZSMPD*nx_model*ny_model,err,abrt)
	call galloc(p_c_out,2*SZSMPD*nx_model*ny_model,err,abrt)
	call galloc(p_model,SZSMPD*nx_model*ny_model*nzc,err,abrt)
	call galloc(p_image,SZSMPD*nx_model*ny_model*nzc,err,abrt)
	call galloc(p_mult,SZSMPD*nx_model*ny_model,err,abrt)
	call galloc(p_datr,SZSMPD*nx_model,err,abrt)
	call galloc(p_dati,SZSMPD*nx_model,err,abrt)
	call galloc(p_index,SZSMPD*nx_model*ny_model,err,abrt)
	call galloc(p_rem,SZSMPD*nx_model*ny_model,err,abrt)
	if(coeff_flag)then
	   call galloc(p_matrix,SZSMPD*nx_aper_max*nkx_max*nops_max,
     1          err,abrt)
	else
	   call galloc(p_matrix,SZSMPD*nx_aper_max*nops_max,err,abrt)
	end if
c
c ok do the work
c
	call fx3dmain(luin_data,luin_model,luin_zmap,nw,nx_data,
     1	  ny_data,firstx_data,firsty_data,w0,nz,nx_model,ny_model,
     2	  dw,dx,dy,dz,nw_step,nwc,nw_partitions,nw_mig,
     3	  nzc,nz_partitions,itrm,tri_model,itrd,tri_data,lbym,lbyd,
     4	  c_data,c_slice,c_d0,c_d1,c_d2,c_out,model,image,mult,
     5	  datr,dati,index,rem,c_dtemp,iw_start,zmap_here,tri_zmap,
     6    coeff_flag,matrix,restart,ipw_restart,ipz_restart)
c
	stop 
	end
c
c -------------------------------------------------------------------------
c MAIN subroutine
c -------------------------------------------------------------------------
c
	subroutine fx3dmain(luin_data,luin_model,luin_zmap,nw,nx_data,
     1		ny_data,firstx,firsty,w0,nz,nx,ny,dw,dx,dy,dz,nw_step,
     2	    	nwc,nw_partitions,nw_mig,nzc,nz_partitions,
     3		itrm,tri_model,itrd,tri_data,lbym,lbyd,
     4		c_data,c_slice,c_d0,c_d1,c_d2,c_out,model,image,mult,
     5		datr,dati,index,rem,c_dtemp,iw_start,zmap_here,zmap,
     6          coeff_flag,matrix,restart,ipw_restart,ipz_restart)
c
	implicit none
c
#include     <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>

c
        integer     itri( SZLNHD )
        integer     itrm( SZLNHD )
        integer     itrd( SZLNHD )
        integer     lhed( SZLNHD )
        integer     luin_model,luout_image,lbytes,nbytes,lbyout
	integer	    luin_data,lbym,lbyd,argis,luout_dwn
	integer	    luin_zmap
c
c
        real        tri_model( SZLNHD )
        real        tri_image( SZLNHD )
        real        tri_data ( SZLNHD )
        character*80   image_fn,dwn_fn
	character*5	name
c
	logical dwn_out,zmap_here,coeff_flag,restart,qc
c
c normal declarations
c
	integer	nw,nz,nx_data,ny_data
	integer	nkx,nxaper,na,nabs
	integer	nwc,nzc,nz_partitions,nw_partitions
	integer	nw_step,iz_partition,nw_rem
	integer	iz,iwc,izhere,ix,iy,iw,iz_dwn,izp_dwn,izp1
	integer	iytrue,ixtrue,firstx,firsty
	integer	nx,ny
	integer	obytes,ipos,iform,obytes_dwn
	integer	iln2,dx1000,dy1000
	integer	iw_start,iposd,nw_mig
	integer	ipw_restart,ipz_restart,ipw_1,ipw_actually_done
	integer	nz_partitions_max,nx_aper_max,nops_max
	integer	nzc_here,nwc_here
	integer	code,mincode,maxcode
	parameter (nz_partitions_max=1025)
	parameter (nx_aper_max=32,nops_max=513)
c
	real	dw,w0,awov0,dawov,dx,dy,dz,wmin,wmax,switch,dz_use
	real	w0p,base,w0_here
	real	kmaxpercent,pi,pi2
	real	vmin(nz_partitions_max),vmax(nz_partitions_max)
	real	datr(nx),dati(nx)
	real	zmap(nz)
c
	real	matrix(nx_aper_max,nops_max)
c
	complex c_data(nx,ny,nwc)
	complex c_slice(nx,ny,nw_step)
	complex c_table(nx_aper_max,nops_max)
c
	complex	c_dtemp(-2:nx+3,-2:ny+3),c_out(nx,ny),c_d0(nx,ny)
	complex	c_d1(nx,ny),c_d2(nx,ny)
c
	real	model(nx,ny,nzc),image(nx,ny,nzc)
	real	mult(nx,ny),rem(nx,ny)
c
	integer	index(nx,ny)
c
c setup the equivalences into the trace headers and data
c
c       equivalence ( itri(129), tri_image (1) )
        equivalence ( itri(  1), lhed(1) )
        data lbytes / 0 /, nbytes / 0 /, name/'FX3D'/
c

      write(0,*)'ITHWP1= ',ITHWP1

        pi=3.14159265358979323846
        pi2 = 2 * pi
	qc=(argis('-qc').gt.0)
c
c a few more parameters, that are usually not messed with
c
	call argi4('-nx_ops',nxaper,26,26)
	call argi4('-nkx_ops',nkx,256,256)
	nkx=2**iln2(nkx)
c
	call argr4('-switch',switch,.95,.95)
	call argi4('-nops',na,512,512)
	call argr4('-base',base,.99,.99)
	call argi4('-nabsorb',nabs,10,10)
c
c get some info about the accuracy level
c
	call argi4('-max_acc',maxcode,2,2)
	call argi4('-min_acc',mincode,2,2)
c
c ok, get the output image file name
c
	call argstr('-O',image_fn,' ',' ')
c
	luout_image=2
	iform=3
	if(restart)then
	  call lbopen(luout_image,image_fn,'r+')
          call rwd(luout_image)
	else
	  call lbopen(luout_image,image_fn,'w+')
	end if
        call sislgbuf (luout_image, 'off')
c
c if restarting, skip the line header
c
	if(restart)then
	  call rtape(luout_image,itri,lbytes)
	else
c
c make a line header output for the image
c
          call savew(itrm, 'NumSmp', nx, LINHED)
          call savew(itrm, 'NumTrc', ny , LINHED)
          call savew(itrm, 'NumRec', nz , LINHED)
          call savew(itrm, 'Format', iform , LINHED)
          call savew(itrm, 'SmpInt', 1 , LINHED)
c
c save the line header from the model to the image
c
          call savhlh(itrm,lbym,lbyout)
	  call wrtape ( luout_image, itrm, lbyout)
	end if
c
c  number output bytes for output traces
c
        obytes = SZTRHD + nx * SZSMPD
c
c ok, see if the user wants downward continued data spit out
c
	dwn_out=(argis('-dwn_out') .gt. 0)
c
	if(dwn_out)then
	  call argstr('-D',dwn_fn,' ',' ')
c
	  if(dwn_fn(1:1) .eq. ' ')then
	    write(LER,*)'If you want downward continued data, you must' 
	    write(LER,*)'specify a filename with -Dfilename'
	    write(LERR,*)'If you want downward continued data, you must'
	    write(LERR,*)'specify a filename with -Dfilename'
	    stop
	  end if
c
c ask where they want the downward continued data saved at
c
	  call argi4('-iz_dwn',iz_dwn,nz,nz)
	  izp_dwn=int(iz_dwn/nzc)+1
c
	  luout_dwn=3
	  iform=3
c
c  number output bytes for output traces
c
          obytes_dwn = SZTRHD + nx * SZSMPD
c
	  call lbopen(luout_dwn,dwn_fn,'w+')
c
c make a line header output for the downward continued data
c
          call savew(itrd, 'NumSmp', nx, LINHED)
          call savew(itrd, 'NumTrc', 2*ny , LINHED)
          call savew(itrd, 'NumRec', nw_mig , LINHED)
          call savew(itrd, 'Format', iform , LINHED)
          call savew(itrd, 'SmpInt', 1 , LINHED)
c
	  dx1000=int(dx*1000)
	  dy1000=int(dy*1000)
c
	  call savew(itrd,'Dx1000',dx1000,LINHED)
	  call savew(itrd,'Dy1000',dy1000,LINHED)
c	  
	  w0_here=w0+(iw_start-1)*dw
          call putfp(itrd,'ReSpFm',w0_here,LINHED)
          call putfp(itrd,'RATTrc',dw,LINHED)
c
c save the line header from the data to the downward continued data
c
          call savhlh(itrd,lbyd,lbyout)
	  call wrtape ( luout_dwn, itrd, lbyout)
c
	end if
c
c 
c
c write out a description of what we are going to do
c
	write(LER,*)
     1	'Migrating ',nw_partitions,' blocks of ',nwc,' frequecies'
	write(LER,*)'nw_partitions= ',nw_partitions
	write(LER,*)'nwc= ',nwc
	write(LER,*)
     1  'Migrating through ',nz,' depth levels in chunks of ',nzc
	write(LER,*)'w0 and dw being used are: ',w0,dw
	write(LER,*)'nx and ny being used are: ',nx,ny
	write(LER,*)'dx and dy being used are: ',dx,dy
	write(LER,*)'dz is: ',dz
	write(LER,*)
     1  'The offset in x,y grid points of the origin of the data'
	write(LER,*)'and the origin of the model is: ',firstx-1,
     1        firsty-1
	write(LER,*)
     1	'If the data and model are already registered, these values'
	write(LER,*)'should be 0,0'
	write(LER,*)'Other misc parameters:'
	write(LER,*)'1/2 aperture of the operator, nx_ops= ',nxaper
	write(LER,*)'width of the absorbing boundaries, nabsorb= ',nabs
	write(LER,*)'number of operators in a table, nops= ',na
c
	if(dwn_out)then
	  write(LER,*)'You asked for downward continued data to '
	  write(LER,*)'be output to a separate file'
	  write(LER,*)'The downward continued data will be at the '
	  write(LER,*)'top of depth level : ',(izp_dwn-1)*nzc+1
	  write(LER,*)
     1	  'This is as close as possible to the level you specified',
     1			iz_dwn
	end if
c
	if(restart)then
	  write(LER,*)'We are attempting a restart... '
	  write(LER,*)'... from data partition',ipw_restart
	  write(LER,*)'... from image partition',ipz_restart
	end if
c
	write(LERR,*)
     1	'Migrating ',nw_partitions,' blocks of ',nwc,' frequecies'
	write(LERR,*)'nw_partitions= ',nw_partitions
	write(LERR,*)'nwc= ',nwc
	write(LERR,*)
     1	'Migrating through ',nz,' depth levels in chunks of ',nzc
	write(LERR,*)'w0 and dw being used are: ',w0,dw
	write(LERR,*)'nx and ny being used are: ',nx,ny
	write(LERR,*)'dx and dy being used are: ',dx,dy
	write(LERR,*)'dz is: ',dz
	write(LERR,*)
     1	'The offset in x,y grid points of the origin of the data'
	write(LERR,*)'and the origin of the model is: ',firstx-1,
     1        firsty-1
	write(LERR,*)'If the data and model are already registered'
	write(LERR,*)'these values should be 0,0'
	write(LERR,*)'Other misc parameters:'
	write(LERR,*)'1/2 aperture of the operator, nx_ops= ',nxaper
	write(LERR,*)'width of the absorbing boundaries, nabsorb= ',nabs
	write(LERR,*)'number of operators in a table, nops= ',na
c
	if(dwn_out)then
	  write(LERR,*)
     1		'You asked for downward continued data to be output'
	  write(LERR,*)'to a separate file'
	  write(LERR,*)'The downward continued data will be at the '
	  write(LERR,*)'top of depth level : ',(izp_dwn-1)*nzc+1
	  write(LERR,*)'This is as close as possible to the level',
     1			' you specified',iz_dwn
	end if
c
	if(restart)then
	  write(LERR,*)'We are attempting a restart... '
	  write(LERR,*)'... from data partition',ipw_restart
	  write(LERR,*)'... from image partition',ipz_restart
	end if
c
c
c
c go make the absorbing boundary multipliers
c
	call absorb(mult,nx,ny,nabs,base)
c
c zero the temp array
c
	do iy=-2,ny+3
	   do ix=-2,nx+3
		c_dtemp(ix,iy)=cmplx(0.,0.)
	   end do
	end do
c
c If we are restarting, seek forward the right amount
c
	if(restart)then
c
	  if(iw_start .eq. 1)then
c
	    iposd=1+(ipw_restart-1)*nwc*2*ny
	    call sisseek(luin_data,iposd)
c	
	  end if
c
c if we are restarting, and also not starting at the beginning, 
c   say so, and seek forward
c
	  if(iw_start .ne. 1)then
	    write(LER,*)'previous migration started with frequency ',
     1          'slice: ',iw_start
	    write(LERR,*)'previous migration started with frequency ',
     1          'slice: ',iw_start
	    iposd=(iw_start-1)*2*ny+1+(ipw_restart-1)*nwc*2*ny
	    call sisseek(luin_data,iposd)
	    w0=w0+dw*(iw_start-1)
          end if
c
	  ipw_1=ipw_restart
c
	else   
c
c if we are not restarting, and also not starting at the beginning, 
c   say so, and seek forward
c
	  if(iw_start .ne. 1)then
	    write(LER,*)'starting migration with frequency slice: ',
     1			iw_start
	    write(LERR,*)'starting migration with frequency slice: '
     1				,iw_start
	    iposd=(iw_start-1)*2*ny+1
	    call sisseek(luin_data,iposd)
	    w0=w0+dw*(iw_start-1)
          end if
c
c in any case if we aren't restarting
c
	  ipw_1=1
c
	end if
c
	ipw_actually_done=0
	if (qc) call ccexit(111)
c
c--------------------------------------------------------------------------
c Outermost loop over hopefully big frequency chunks
c--------------------------------------------------------------------------
c
	do iwc=ipw_1,nw_partitions
c
	  ipw_actually_done=ipw_actually_done+1
c
	   if(iwc .lt. nw_partitions)then
	      nwc_here=nwc
	   else
	      nwc_here=nw_mig-(nw_partitions-1)*nwc
	   end if
c
c write out some stuff saying where we are
c
	   write(LER,*)'starting frequency chunk ',iwc
	   write(LERR,*)'starting frequency chunk ',iwc
c
c some initialization
c
	   do iw=1,nwc
	      do iy=1,ny
		do ix=1,nx
		   c_data(ix,iy,iw)=cmplx(0.,0.)
		end do
	      end do
	   end do
c
c read this chunk of the data and pack it into the array for downward
c continuation
c
c
	   do iw=1,nwc_here
	      do iy=1,ny_data
c
		iytrue=iy-1+firsty
c
                nbytes = 0
                call rtape( luin_data, itrd, nbytes)
                call vmov (itrd(ITHWP1), 1, tri_data, 1, nx_data)
	        do ix=1,nx_data
	           datr(ix)=tri_data(ix)
	        end do
c
                nbytes = 0
                call rtape( luin_data, itrd, nbytes)
                call vmov (itrd(ITHWP1), 1, tri_data, 1, nx_data)
	        do ix=1,nx_data
	           dati(ix)=tri_data(ix)
	        end do
c
	  	do ix=1,nx_data
		   ixtrue=ix-1+firstx
		   c_data(ixtrue,iytrue,iw)=cmplx(datr(ix),dati(ix))
		end do
c
	      end do
	   end do
c
c max and min frequencies for this chunk of frequencies
c
	   wmin=(iwc-1)*nwc*dw+w0
c
c possible bug here
c   	   wmax=wmin+(nwc_here-1)*dw
   	   wmax=wmin+(nwc-1)*dw
c
	   write(LER,*)'frequencies in this chunk '
     1		,wmin/pi2,' to ',wmax/pi2
	   write(LERR,*)'frequencies in this chunk '
     1		,wmin/pi2,' to ',wmax/pi2
c
c reset to top of model if this is not the first pass
c
	   if(ipw_actually_done .ne.1)then
c
	     call rwd(luin_model)
	     call rwd(luout_image)
c
c blow through the line headers
c
	     call rtape(luin_model,itrm,lbytes)
	     call rtape(luout_image,itri,lbytes)
c
	   end if
c
c now loop over all depth chunks
c
	   do iz_partition=1,nz_partitions
c
	     if(iz_partition .lt. nz_partitions)then
		nzc_here=nzc
	     else
		nzc_here=nz-(nz_partitions-1)*nzc
	     end if
	      
c
	     write(LER,*)'downward continuing through depth ',
     1		'partition ',iz_partition
	     write(LERR,*)'downward continuing through depth ',
     1		'partition ',iz_partition
c
c read the model
c
	        do iz=1,nzc_here
	           do iy=1,ny
c
                     nbytes = 0
                     call rtape( luin_model, itrm, nbytes)
                     call vmov (itrm(ITHWP1), 1, tri_model, 1, nx)
c
	  	     do ix=1,nx
		        model(ix,iy,iz)=tri_model(ix)/2.
		     end do
c
	           end do
	        end do
c
c if not the first frequency chunk, read the image, otherwise zero it
c
		if(iwc .ne. 1)then
	          do iz=1,nzc_here
	             do iy=1,ny
c
                       nbytes = 0
                       call rtape( luout_image, itri, nbytes)
                       call vmov (itri(ITHWP1), 1, tri_image, 1, nx)
c
	  	       do ix=1,nx
		          image(ix,iy,iz)=tri_image(ix)
		       end do
c
	             end do
	          end do
c
	  	else
c
		  do iz=1,nzc_here
		    do iy=1,ny
		      do ix=1,nx
		        image(ix,iy,iz)=0.
		      end do
		    end do
		  end do
c
	        end if
c
c find max and min velocities in this chunk and store
c
	        if(ipw_actually_done .eq. 1)then
c
	          vmax(iz_partition)=model(1,1,1)
	          vmin(iz_partition)=model(1,1,1)
c
	          do iz=1,nzc_here
	            do iy=1,ny
	               do ix=1,nx
	                  vmax(iz_partition)=max(vmax(iz_partition),
     1					        model(ix,iy,iz))
	                  vmin(iz_partition)=min(vmin(iz_partition),
     1					        model(ix,iy,iz))
	               end do
	            end do
	          end do
c
	        end if
c
c decide what the local dz is for this chunk
c
	        if(zmap_here)then
		  dz_use=zmap((iz_partition-1)*nzc+2)-
     1			 zmap((iz_partition-1)*nzc+1)
	        else
	          dz_use=dz
	        end if
c
c make the extrapolators for this frequency chunk for velocities in these
c layers
c
	        if(coeff_flag)then
                  call coeffslsq(c_table,vmax(iz_partition),
     1		         vmin(iz_partition),wmax,wmin,na,switch,
     2		         dz_use,nxaper,nkx,dx,awov0,dawov,matrix)
	        else
                  call coeffs(c_table,vmax(iz_partition),
     1		         vmin(iz_partition),wmax,wmin,na,switch,
     2		         dz_use,nxaper,nkx,dx,awov0,dawov)
	        end if
c
c figure out the size of the mcclellan xform to use
c
	        kmaxpercent=(wmax/vmin(iz_partition))
		kmaxpercent=kmaxpercent/(pi/dx)
c
		code=1
	        if(kmaxpercent .gt. .25)code=2
	        if(kmaxpercent .gt. .5)code=3
c
		code=min(code,maxcode)
		code=max(code,mincode)
c
		write(LER,*)'accuracy level=',code
		write(LER,*)'depth step size=',dz_use
c
c loop over little frequency chunks
c
	        do iw=1,nwc,nw_step
c
c load up this set of w's from the buffer
c
	           call w_get(c_slice,c_data,nx,ny,iw,nwc,nw_step)
c
c case low wavenumber ------------------------------------------------------
c
		   if(code .eq. 1)then
c
c loop over the individual z levels in a depth chunk
c
	             do iz=1,nzc_here
	  	       izhere=iz+(iz_partition-1)*nzc
 		       w0p=((iwc-1)*nwc+iw-1)*dw+w0
c
c image for this new level
c
		       call image3d(image,c_slice,nzc,nw_step,nx,ny,iz)
c
c downward continue a frequency chunk of the data one level
c
		       call dwn3d(c_slice,model,nx,ny,c_table,nzc,
     1		            dawov,awov0,nxaper,iz,nw_step,w0p,dw,mult,
     2		          c_dtemp,c_d0,c_d1,c_d2,c_out,index,rem)
c
c end loop over individual z levels
c
	             end do
c
		   end if
c
c case medium wavenumber ------------------------------------------------------
c
		   if(code .eq. 2)then
c
c loop over the individual z levels in a depth chunk
c
	             do iz=1,nzc_here
	  	       izhere=iz+(iz_partition-1)*nzc
 		       w0p=((iwc-1)*nwc+iw-1)*dw+w0
c
c image for this new level
c
		       call image3d(image,c_slice,nzc,nw_step,nx,ny,iz)
c
c downward continue a frequency chunk of the data one level
c
		       call dwn3di(c_slice,model,nx,ny,c_table,nzc,
     1		           dawov,awov0,nxaper,iz,nw_step,w0p,dw,mult,
     2		           c_dtemp,c_d0,c_d1,c_d2,c_out,index,rem)
c
c end loop over individual z levels
c
	             end do
c
		   end if
c
c case high wavenumber ------------------------------------------------------
c
		   if(code .eq. 3)then
c
c loop over the individual z levels in a depth chunk
c
	             do iz=1,nzc_here,2
	  	       izhere=iz+(iz_partition-1)*nzc
 		       w0p=((iwc-1)*nwc+iw-1)*dw+w0
c
c image for this new level
c
		       call image3d(image,c_slice,nzc,nw_step,nx,ny,iz)
c
c downward continue a frequency chunk of the data one level
c
		       call dwn3dm(c_slice,model,nx,ny,c_table,nzc,
     1		  	   dawov,awov0,nxaper,iz,nw_step,w0p,dw,mult,
     2			   c_dtemp,c_d0,c_d1,c_d2,c_out,index,rem)
c
		        izhere=izhere+1
			izp1=iz+1
c
c image for this new level
c
		       call image3d(image,c_slice,nzc,nw_step,
     1					nx,ny,izp1)
c
c downward continue a frequency chunk of the data one level
c
		       call dwn3db(c_slice,model,nx,ny,c_table,nzc,
     1		  	  dawov,awov0,nxaper,izp1,nw_step,w0p,dw,mult,
     2			  c_dtemp,c_d0,c_d1,c_d2,c_out,index,rem)
c
c end loop over individual z levels
c
	             end do
c
		   end if
c
c put the downward continued freq slice back to the buffer
c
		   call w_put(c_slice,c_data,nx,ny,iw,nwc,nw_step)
c
c end loop over small w chunks
c
	        end do
c
c decide what to do with the results/ depending on restarting or not
c
	        if(restart .and. ipw_actually_done .eq. 1 .and.
     1		   iz_partition .lt. ipz_restart)then
c
	           write(LER,*)'skipping update of depth chunk',
     1				iz_partition
	           write(LER,*)'already updated for frequency chunk',
     1				iwc
c
	        else
c
c ok, now write out the image
c
		  if(iwc .ne. 1)then
		    ipos=(iz_partition-1)*nzc*ny+1
		    call sisseek(luout_image,ipos)
		  end if
c
	          do iz=1,nzc_here
	             do iy=1,ny
		        do ix=1,nx
		  	   tri_image(ix)=image(ix,iy,iz)
		        end do
c
                        call vmov (tri_image, 1, itri(ITHWP1), 1, nx)
		        call wrtape(luout_image,itri,obytes)
		     end do
		  end do
c
	        end if
c
c if the user asked for downward continued data, we'll write it out now
c if this is the depth chunk whose bottom is past where he asked for it.
c
	       if(dwn_out)then
c
	         if(iz_partition .eq. izp_dwn)then
c
	           do iw=1,nwc_here
	              do iy=1,ny
c
		         do ix=1,nx
		   	   tri_image(ix)=real(c_data(ix,iy,iw))
		         end do
c
                         call vmov (tri_image, 1, itrd(ITHWP1), 1, nx)
		         call wrtape(luout_dwn,itrd,obytes_dwn)
c
		         do ix=1,nx
		   	   tri_image(ix)=aimag(c_data(ix,iy,iw))
		         end do
c
                         call vmov (tri_image, 1, itrd(ITHWP1), 1, nx)
		         call wrtape(luout_dwn,itrd,obytes_dwn)
c
		      end do
		   end do
c
		 end if
c
	       end if
c
c end loop over z partitions
c
	   end do
c
c end of outer loop over w partitions
c
	end do
c
c close data files
c
      	call lbclos ( luin_data )
      	call lbclos ( luin_model )
      	call lbclos ( luout_image )
c
	if(dwn_out)call lbclos( luout_dwn )
c
c all done
c
	return
	end
 
c 
c***********************************************************************
C***********************************************************************
      subroutine help

c
c     include file for usp programs written by Bill Done & Paul Gutowski
c
c     define logical unit numbers
c
      integer LER, LERR, LOT, LIN, LUN, LUTEMP, LPRT
      integer LUER, LUSI, LUSO
      integer LUCARD, LUPRT, LUTERM, LUPPRT, LUTERI, LUTERO, LUDISK

      parameter (LER=0,LUER = 0)

      parameter (LIN=5,LOT=6,LUN=9,LERR=37, LUTEMP=39, LPRT=6)
      parameter (LUSI = 5, LUSO = 6)
      parameter (LUCARD = 20, LUPRT = 21, LUTERM = 22, LUPPRT = 23)
      parameter (LUDISK = 24)
      parameter (LUTERI = 100, LUTERO = 101)

         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'fx3d 3D post-stack depth migration using Hale-McClellan'
        write(LER,*)
     :'execute fx3d with the following command line'
        write(LER,*)
     : 'fx3d -Nfreq_slices -Mvel_slices -Omig_depth_slices -Ddwn_freqs'
        write(LER,*)
     :'other needed parameters'
        write(LER,*)' '
        write(LER,*)
     :'-x0_dataX0 -y0_dataY0 -dx_dataDX -dy_dataDY or use line header'
        write(LER,*)
     :'-x0_modelX0 -y0_modelY0 '
        write(LER,*)
     :'-dx_modelDX -dy_modelDY or use line header'
        write(LER,*)
     :'-dzDZ -z0Z0 -dwDOMEGA -w0Omega0'
        write(LER,*)
     :'  '
        write(LER,*)
     :'other optional parameters'
        write(LER,*)
     :'-nzc (def=16) number of depth chunks'
        write(LER,*)
     :'-nw_mig (def=# freq in transform) number of freq to migrate'
        write(LER,*)
     :'-nwc (def=16) number of frequencies/depth chunk'
        write(LER,*)
     :'-nw_step (def=4) number of frequencies to carry at once'
        write(LER,*)
     :'-iw_start (def=1) frequency number to start'
        write(LER,*)
     :'-w0_here (def=LH) frequency in radians to start migration'
        write(LER,*)
     :'-w0 (def=w0_here) frequency in radians to start migration'
        write(LER,*)
     :'-dw_here (def=LH) frequency inc in radians to start migration'
        write(LER,*)
     :'-dw (def=dw_here) frequency inc in radians to start migration'
        write(LER,*)
     :'-iw_start (def=1) frequency number to start'
        write(LER,*)
     :'-nx_opsNN NN=1/2 aperture of extrapolation operator'
        write(LER,*)
     :'-nx_opsNN NN has to be one of the following numbers'
        write(LER,*)
     :'17,20,23,26,29,32'
        write(LER,*)
     :'  '
        write(LER,*)
     :'-lsq turns on minimax operator design'
        write(LER,*)
     :'which is  more expensive, but produces better operators'
        write(LER,*)
     :'  '
        write(LER,*)
     :'-max_acc[1,2,3] -min_acc[1,2,3]'
        write(LER,*)
     :'control maximum and minimum accuracy levels'
        write(LER,*)
     :'1 is fastest and least accurate 3 the slowest and most accurate'
        write(LER,*)
     :'for fast bad results (model building), use -max_acc1 -min_acc1'
        write(LER,*)
     :'for migrations up to 60 degrees dip use -min_acc2 -max_acc2'
        write(LER,*)
     :'this is the default'
        write(LER,*)
     :'for migrations up to 80 degrees dip use -min_acc1 -max_acc3'
        write(LER,*)
     :'  '
        write(LER,*)
     :'to restart, use the same command as the original run'
        write(LER,*)
     :'add -restart and -ipz_restart[ZP] -ipw_restart[WP]'
        write(LER,*)
     :'where [ZP] is depth partition being worked on when fx3d died'
        write(LER,*)
     :'and [WP] is frequency partition being worked on when fx3d died'
        write(LER,*)
     :' (you did save a copy of stderr did you not?)'
        write(LER,*)
     :'  '
        write(LER,*)
     :'-Ddwn_file filename for downward continued data'
        write(LER,*)
     :'-dwn_out flag to enable outputting of downward continued data'
        write(LER,*)
     :'-iz_dwn depth slice to output downward continued data'
        write(LER,*)
     :'Youll actually get the downward continued data at the bottom '
        write(LER,*)
     :'of the depth chunk that contains iz_dwn'
        write(LER,*)
     :'***************************************************************'
      return
      end
