C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c subroutine to calculate absorbing boundaries to use after a depth step
c
	subroutine absorb(mult,nx,ny,nabs,base)
c
	integer	nx,ny,ix,iy,nabs
c
	real	mult(nx,ny),base
c
c main grid
c
	do iy=1,ny
	   do ix=1,nx
		mult(ix,iy)=1.
	   end do
	end do
c
c now for the boundaries
c
	do iy=1,nabs
	   do ix=nabs-iy+1,nx-nabs+iy-1
	      mult(ix,ny-nabs+iy)=base**iy
	      mult(ix,nabs-iy+1)=base**iy
	   end do
	end do
c
	do ix=1,nabs
	   do iy=nabs-ix+1,ny-nabs+ix-1
	      mult(nx-nabs+ix,iy)=base**ix
	      mult(nabs-ix+1,iy)=base**ix
	   end do
	end do
c
c all done making absorbing boundary multiplier
c
	return
	end
c
c subroutine to image the downward continued data by summing
c over frequencies
c
	subroutine image3d(image,c_data,nzc,nw_step,nx,ny,iz)
c
	implicit none
c
	integer	nzc,nw_step,iz,iw,nx,ny,ix,iy
c
	real	image(nx,ny,nzc)
	complex c_data(nx,ny,nw_step)
c
c sum over all w's
c
	do iw=1,nw_step
C$DOACROSS LOCAL(ix,iy)
	   do iy=1,ny
	      do ix=1,nx
		image(ix,iy,iz)=image(ix,iy,iz)+real(c_data(ix,iy,iw))
	      end do
	   end do
	end do
c
c all done
c
	return
	end
c
c integer function to take the log based 2 of a number,
c returns the nearset power of 2 greater than or equal to
c the number presented
c
	integer function iln2(num)
c
	integer ln,num
c
	real a
c
	a=num
	ln=0
c
	do while(a .gt. 1)
	  a=a/2.
  	  ln=ln+1
	end do
c
	iln2=ln
c
	return
	end
c
c Subroutine to load complex data into small bite-sized chunks
c for downward continuation
c
	subroutine w_get(c_slice,c_data,nx,ny,iw_here,nwc,nw_step)
c
	implicit none
c
	integer	iw,nwc,nx,ny,nw_step,iw_here,ix,iy
c
	complex c_data(nx,ny,nwc),c_slice(nx,ny,nw_step)
c
c Get a small frequency chunk of the data from the big buffer
c
	do iw=1,nw_step
C$DOACROSS LOCAL(ix,iy)
	  do iy=1,ny
	   do ix=1,nx
	     c_slice(ix,iy,iw)=c_data(ix,iy,iw_here+iw-1)
	   end do
	  end do
	end do
c
c ok, all done
c
	return
	end
c
c Subroutine to load complex data into small bite-sized chunks
c for downward continuation
c
	subroutine w_put(c_slice,c_data,nx,ny,iw_here,nwc,nw_step)
c
	implicit none
c
	integer	iw,nwc,nx,ny,nw_step,iw_here,ix,iy
c
	complex c_data(nx,ny,nwc),c_slice(nx,ny,nw_step)
c
c put back a small frequency chunk of the data to the big buffer
c
	do iw=1,nw_step
C$DOACROSS LOCAL(ix,iy)
	   do iy=1,ny
	      do ix=1,nx
		c_data(ix,iy,iw_here+iw-1)=c_slice(ix,iy,iw)
	      end do
	   end do
	end do
c
c ok, all done
c
	return
	end
