C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE cmimag (JBLK, IXS, IMG, PRCNT, EPSLN,
     &  INDREC, CINC, CRFL, BMWTHR, IDIPZ, VMIN, VMAX, iextrp, ixtap ,
     &            numvel , slop, maxna,maxnv ,gwrk1,gwrk2,gwrk3,
     &            gwrk4, gwrk5, work, ivv2,ivv,ixp,ivp2,ixp2,map,
     &            gxr1,gxr2,sxr1,sxr2,
     &            pwpr,pwnr,pwni,pwpi  )
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C
C     maxnt should be maxnv * maxna + 1
      PARAMETER (maxnt = 4096)
C
C  PARAMETERS:
C
      INTEGER JBLK
C                        INPUT BLOCK (RECORD) INDEX
      INTEGER IXS
C                        INPUT HORIZONTAL SEGMENT INDEX
      INTEGER IMG
C                        INPUT IMAGING FLAG
      REAL    PRCNT
C                        INPUT RAMP PERCENT VALUE
      REAL    EPSLN
C                        INPUT EPSILON VALUE
      INTEGER INDREC(*)
C                        SCRATCH INDEX RECORD
      COMPLEX CINC  (*)
C                        SCRATCH INCIDENT FIELD
      COMPLEX CRFL  (*)
C                        SCRATCH REFLECTED FIELD
      REAL    BMWTHR
C                        REFLECTED BEAM WIDTH
      INTEGER IDIPZ
C                        DIP FILTER RATE ( EVERY IDIPZ Z ROW )
      REAL VMIN(*)
C                        MINIMUM VELOCITIES
      REAL VMAX(*)
C                        MAXIMUM VELOCITIES
C
C * * * PWMBS COMMON (BEGIN) * * *
C
C     DEPTH COMMON ---------------------------------------------------
C
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=105,IZSEGM=20)
C
      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)
C
      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C
C     DEPTH COMMON ---------------------------------------------------
C
C
C     WIDTH COMMON ---------------------------------------------------
C
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=100,IXSEGM=4,IXMAX=4096)
C
      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C
      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C
C     WIDTH COMMON ---------------------------------------------------
C
C
C     FREQ COMMON ----------------------------------------------------
C
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)
C
      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI
C
      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ----------------------------------------------------
C
C
C     LUNITS ---------------------------------------------------------
C
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C
      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS ---------------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS----------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)
C
      INTEGER IHEAD(SZLNHD)
      INTEGER THEAD(3000)
      INTEGER *2 ITRH(LNTRHD)
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)
C
      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ----------------------------------------------------
C
C
C     MISCL COMMON ---------------------------------------------------
C
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY
C
      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C
C     MISCL COMMON ---------------------------------------------------
C
C
C * * * PWMBS COMMON (END) * * * *
C
C
C  LOCAL DECLARATIONS:
C
      REAL    FINC(2*IXMAX), FRFL(2*IXMAX), PARM(5)
C
C  VERSION F01
C
      REAL    RIMAGE(IXMAX*IZMAX*IZSEGM)
CCCy  2*izmax*izsegm must be >= ixmax
      parameter (lwrk2=2*IZMAX*IZSEGM)
      parameter (lwrk3=8*IZMAX*IZSEGM+2)
      parameter (lwrk4=18*IZMAX*IZSEGM+8)
      REAL    WRK1(NSMAX), WRK2(2*IZMAX*IZSEGM)
      REAL    WRK3(8*IZMAX*IZSEGM+2),WRK4(18*IZMAX*IZSEGM+8)
      data    wrk1/nsmax*0./, wrk2/lwrk2*0./, wrk3/lwrk3*0./, 
     &        wrk4/lwrk4*0./
      INTEGER IWRK(NSMAX)
C
C  VERSION F02
C
      REAL    RII(IXMAX*IZMAX), RRI(IXMAX*IZMAX)
C
C  VERSION F04
C
      INTEGER INDEX(IXMAX*IZMAX)
C
C  VERSION F8a
C
      REAL    GWRK1( 3*maxnv*(maxna+1) ),
     &        GWRK2( 2*maxna-1 ),
     &        GWRK3( maxnv*(maxna+1) ),
     &        GWRK4( maxnv*(maxna+1) ),
     &        GWRK5( maxna*maxna ), WORK(4*IXMAX)
C     real gwrk1(*),gwrk2(*),gwrk3(*),gwrk4(*),gwrk5(*)
C     integer ivv2(*),ivv(*),ixp(*),ivp2(*),ixp2(*),map(*)
C     real gxr1(ixmax+1,*),gxr2(ixmax+1,*)
C     real sxr1(ixmax+1,*),sxr2(ixmax+1,*)
c
c  version x01
c
c     Green's function tables
      real str1(maxnt), str2(maxnt)
      real gtr1(maxnt), gtr2(maxnt)
      integer ivp (izmax+1),        ivv (izmax*maxnv),
     &        ivp2(izmax+1),        ivv2(izmax*maxnv),
     &        ixp (izmax*maxnv+1),  ixx (ixmax*izmax),
     &        ixp2(izmax*maxnv+1),  ixx2(ixmax*izmax)
      real    sxr1(ixmax+1, maxna), sxr2(ixmax+1,maxna),
     &        gxr1(ixmax+1, maxna), gxr2(ixmax+1,maxna)

C     pointer (pwpr,wpr),(pwnr,wnr),(pwni,wni),(pwpi,wpi)

cv7
      real wvwk1(ixmax), wvwk2(ixmax)
      integer map(maxnv)
cv8b  integer map(maxnv)



c     fft table
      real ffttab(5*ixmax)

c     number of velocities per depth segment
      integer numvel(izsegm)

c     reciprocical of velocities per depth segment
      real slop(maxnv,izsegm)

C
      DATA DIRINC, DIRRFL / -1.0, 1.0 /
C
C---------------------------------------------------------------------
C
CCC   INITIALIZE AND VALIDATE DIMENSIONS
C
      NX     = IXLN0(IXS)
      NXLN   = IXLN(IXS)
      NXLN1  = IXLN1(IXS)
      JXOFF  = IXST0(IXS)
      JXST   = IXST(IXS)-1
      JXBIAS = IXBIAS(IXS)
      NXBYTE = 4 * IXLEN
      NT2    = 2 * NV * NA
      NX2    = 2 * NX
      NX8    = 8 * NX
      NP     = 2 * NA + NV + 17
cv7   set na2 = msk
      na2 = msk
C
C     COMPUTE CONSTANTS FOR DIP FILTER K LIMITS
C
      PIRAD = PI / 180.0
      CALL PWROF2 (NX, IPWR2)
      NXPW2  = 2 ** IPWR2
      DKOVER = ( DX0 * NXPW2 ) / (2.0 * PI)
C
C     COMPUTE LARGEST AND SMALLEST ANGLES TO PASS
C
      PID2  = PI / 2.0
      ANGR1 = AMAX1( -PID2, ( ANGL(JBLK) - BMWTHR) * PIRAD )
      ANGR2 = AMIN1(  PID2, ( ANGL(JBLK) + BMWTHR) * PIRAD )
C
C     COMPUTE SLOWNESS LIMITS FOR DIP FILTER K LIMITS
C
      P1R =  2. * SIN( ANGR1 ) / VMIN(1)
      P2R =  2. * SIN( ANGR2 ) / VMIN(1)
C
C     SET INITIAL K LIMITS
C
      K1I = 0
      K2I = 0
      K1R = 0
      K2R = 0
      KR  = 25
      KFF = IDIPZ
C
      PARM(1) = DX0
      PARM(2) = DX
      PARM(3) = EPSLN
C
CCC   LOOP 130: VERTICAL SEGMENTS
C
      DO 130 IZS = 1, IZSEG
      IF(IZS.GT.1) KFF = 0
C
c        WRITE (LUPRT, *) 'BEGIN VERTICAL SEGMENT ', IZS
c        IF(JBLK.EQ.1) CALL PWPRTC (LUPRT, IXS, IZS, 1)
C
         NZ  = JZROW(IZS)
         NXZ = NX * NZ
         JZB = IZB(IZS)
         DZ0 = DZ(IZS)
C
CCC      FETCH VELOCITY INDEX TABLE FROM DISK
#ifdef CRAYSYSTEM
         cptime1 = second()
#endif
C
         KZ = 1 - NX
         DO 110 JZ = 1, NZ
            KZ = KZ + NX
            LZ = JZ + JZB
            CALL DAREAD (LZ, INDREC, LUMTX, NXBYTE)
            CALL VMOV (INDREC(JXOFF), 1, INDEX(KZ), 1, NX)
  110    CONTINUE
CCCy
CCCy     scan index matrix for horizontal changes
         call xgenix(nx, nz, index, iwrk, ivp, ivv, ixp, ixx)
         call xgenix(nx, nz, index, iwrk,ivp2,ivv2,ixp2,ixx2)
         call scnmtx(index,nx,nz,map,nv)

C
CCC      PERFORM CONTINUATION AND IMAGING FOR EACH OMEGA
C
         DO 120 JW = 1, NW
C
CCC         FETCH THE WAVEFIELDS AT TOP OF Z SEGMENT FROM DISK
C
            CALL DAREAD (JW, CRFL, LURFL, NX8)
C
CCC         COMPUTE GREEN'S FUNCTION TABLES
C
            MSK1 = .5 * PI * VMIN(IZS) / OMEGA(JW) / DX0 -1
            IF(MSK1.GT.8) MSK1 =  8
            IF (MSK1 .LE. 0) MSK1 = 1
            DX1 = DX0 * FLOAT( MSK1 )
cv6***
            mskbig = 8

            dz1 = dz0
            izskp = 1
            if(iextrp.gt.0) then
             izskp = iextrp
             if(izskp.gt.6) izskp = 6
             if(izskp.eq.5) izskp = 4
             dz1 = dz0 * (izskp)
            endif
cv6***
C
CNDW12-3-86 COMPUTE NA1 FROM VMAX,OMEGA,ETC
          na1 = nabot
          if(izseg.gt.1) na1 =
     &    nabot - (izseg-izs)/(izseg-1)*(nabot-natop)

c         prcnt = 10
          prcnt = 50
          if(izseg.gt.1) prcnt =
     &    82.- (izseg-izs)/(izseg-1)*(82.-50.)
CCCy      WRITE(0,*) 'JW,F,MSK1,NA1=',JW,OMEGA(JW)/(2.*PI),MSK1,NA1
CCCy
cv8b
            nvs = numvel(izs)
            CALL XGTABM(PRCNT,2.*OMEGA(JW),DX1,DZ1,DIRRFL,SLOP(1,izs),
     &      map, GWRK1, GWRK2, GWRK3, GWRK4, GWRK5, gtr1, gtr2,NVS, NA1)
           if(izskp.gt.1) then
            CALL XGTABM(PRCNT,2.*OMEGA(JW),DX1,DZ0,DIRRFL,SLOP(1,izs),
     &      map, GWRK1, GWRK2, GWRK3, GWRK4, GWRK5, str1, str2,NVS, na2)
           endif
cv6
C
C           GENERATE WAVEFIELD FILTERS
C
            K1R = DKOVER * OMEGA(JW) * P1R
            K2R = DKOVER * OMEGA(JW) * P2R
C
            CALL GCFILT (0.0, 1.0, K1R, K2R, KR, FRFL, NX, MX)
C
C
CCC         DOWNWARD CONTINUE WAVEFIELDS AND IMAGE OVER THE Z SEGMENT
CCCy
cv7
            nalarg = max0(na,natop,nabot,na1,na2)
            CALL XDCIMC (NA1,na2,NX,NZ,JW,MSK1, IMG, KFF, FINC, FRFL,
     &                  gtr1, gtr2, gxr1, gxr2,
     &                  ivp, ivv, ixp, ixx, cinc, crfl,
     &                  wrk1, wrk2, wrk3, wrk4, ffttab, rii, rri,
     &                  str1, str2, sxr1, sxr2,
     &                  ivp2, ivv2, ixp2, ixx2,
     &                  wvwk1, wvwk2, izskp ,ixtap,izs,mskbig,
     &                  pwpr,pwnr,pwni,pwpi,nalarg)
cv7
C
CCC         STORE THE WAVEFIELDS AT BOTTOM OF Z SEGMENT ON DISK
C
            CALL DAWRTE (JW, CRFL, LURFL, NX8)
C
  120    CONTINUE
C
CCC      COMPUTE REFLECTIVITY, RESAMPLE, AND TRANSPOSE
C
         CALL FRRST (NX, NZ, NXLN, IZLN, JZB, IMG, PARM, RII, RRI,
     &               RIMAGE)
  130 CONTINUE
C
CCC   RESAMPLE DEPTH SECTION, APPEND TRACE HEADERS + OUTPUT TO OTAP
C
      PARM(1) = ZTABLE(1)
      PARM(2) = DZOUT
      PARM(3) = 0.5
      PARM(4) = 0.5
      PARM(5) = 0.0
C
      IFLAG  = 0
      ICINIT = 1
      nbytes = 512 + 4 *JZLN
CCCy  tapeio actually writes bytes
      ncrayb = nbytes * 2
      nbytes = (jzln+ITRWRD)*ISZBYT
      KX     = (JXBIAS -JXST) * IZLN + 1
cvf3
      do 319 jz = 1,jzln
 319  wrk4(jz) = float(jz-1)*dzout

      DO 210 JX = 1, NXLN1
c        CALL XFSMP (ZTABLE, RIMAGE(KX), IZLN, DATA, JZLN, PARM,
c    &               IWRK, WRK1, WRK2, WRK3, WRK4, IFLAG)
cmat11/09/93 set first sample to zero and interpolate starting with data(2)
      data(1) = 0.0
      CALL
     &CCUINT(ZTABLE,RIMAGE(KX),IZLN,WRK4,data(2),jzln,iwrk,wrk1,ICINIT)
         IFLAG = 1
         ICINIT = 0
C
         JNTR = JX + JXBIAS
         CALL DAREAD (JNTR, ITRH, LUHDR, ITRWRD*4)
C
         CALL SAVEW(ITRH, 'RecNum', JBLK, 1)
         CALL SAVEW(ITRH, 'TrcNum', JNTR, 1)

         CALL WRTAPE (lu24, TRACE, nbytes)
C
         KX = KX + IZLN
  210 CONTINUE
C
      RETURN
      END
