C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CMJOBP ( BMWTHR, IDIPZ, PRCNT, iextrp , ixtap ,
     &  luv , dxtap , dztap )

#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C * * * BEGIN MEMORY SPACE ALLOCATION * * * * * *

C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=105,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=100,IXSEGM=4,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(SZLNHD)
      INTEGER THEAD(3000)
      INTEGER *2 ITRH(LNTRHD)
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------

C * * * PWMBS COMMON (END) * * * *

C * * DATA ARRAYS NOT IN COMMON * *

CCCy  -- print out, tape header stuff

      CHARACTER*4 VERSION
      CHARACTER*7 PPNAME
      CHARACTER*1 PARR(66)
      CHARACTER*128 NTPV,NTAP,OTAP,INPUT,MODEL
CCCy

C     WORK SPACE
      CHARACTER WORD*4,WORD5*5,WORD9*9,CARD*80

C * * * END MEMORY SPACE ALLOCATION * * * * * * *


      DATA VERSION/' 4.7'/
      DATA PPNAME/'FXCMMIG'/

C     GAMOCO DATA STATEMENT
      DATA PARR/23*' ','C','O','M',' ','M','I','D',' ','P','T',
     1' ','M','I','G','R','A','T','I','O','N',23*' '/


CCCy  opens:
      ltrm = 2
      ltrm = ler
      call cmdlin(ntpv,ntap,otap,input,model,ipipi,ipipo,ltrm,
     &dxtap,dztap,ipipiv,msk,iextrp)
cv8d
c     OPEN PRINTOUT
      LLIST = 37
      CALL OPENPR(LLIST,LUPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
      lprt=ler
#include <mbsdate.h>
      lprt = luprt
#include <mbsdate.h>
c     WRITE(LUPRT,37)
   37 FORMAT(//,
     1'**************************************************************',/
     2' FXCMMIG    FX V(X,Z) MIGRATION AFTER STACK                   ',/
     3'**************************************************************',/
     4 '                                                ',/)
cv8d
C     open card file
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LUIPT,FILE=INPUT,STATUS='OLD')
      ELSE
         N=ICOPEN('-fxcmmig.crd',LUIPT)
      ENDIF

C***********************************************************************
C
C     OPEN TAPE, CALL GAMOCO, READ LINEHEADER, WRITE LINEHEADER OUT
C
C***********************************************************************
      if(ipipi.eq.0) then
c     lu14 is a input dataset
       call lbopen(lu14,ntap,'r')
      else
c      we know lu14 is a pipe
       lu14=0
      endif

C***********************************************************************
C     READ VELOCITY TAPE
C***********************************************************************
      IF(IPIPIV.EQ.0)THEN
C        LUV IS AN INPUT DATASET
         CALL LBOPEN(LUV,NTPV,'r')
      ELSE
C        WE KNOW LUV IS NOT SPECIFIED
         WRITE(LUPRT,*) 'ERROR NO INPUT VELOCITY DATASET'
         STOP 100
      ENDIF

      IEOF = 0
      CALL RTAPE(lu14,IHEAD,IEOF)
      IF(IEOF.EQ.0)THEN
         WRITE(LUPRT,1020)
 1020    FORMAT(1X,'END OF FILE ON INPUT LINEHEADER')
         STOP
      ENDIF
      CALL SAVER(IHEAD, 'NumTrc', NTR, 0)
      CALL SAVER(IHEAD, 'NumRec', NREC, 0)
      CALL SAVER(IHEAD, 'SmpInt', ISI, 0)
      CALL SAVER(IHEAD, 'NumSmp', NSAMP, 0)
      CALL SAVER(IHEAD, 'Format', ITPFMT, 0)
      IERR = 0
      NLIN = 1
      CALL GAMOCO(PARR,NLIN,LUPRT)
      LEN = 7
      CALL HLHPRT(IHEAD,IEOF,PPNAME,LEN,LUPRT)
c     WRITE(LUPRT,*)
c    &'NTR,NREC,ISI,NSAMP,ITPFMT,IEOF=',NTR,NREC,ISI,NSAMP,ITPFMT,IEOF
      IF(ITPFMT.NE.IFMT) THEN
       WRITE(LUPRT,*) 'INPUT TAPE FORMAT NE 3 - JOB TERMINATED'
       CALL CCEXIT(100)
      ENDIF

      WRITE(LUPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      WRITE(LUPRT,39)NTPV
   39 FORMAT('  INPUT VELOCITY DATASET = '/,A128)

C     JOB CONSTANT TIME PARAMETERS
      T0=0.0
      READ(LUIPT,'(A80)') CARD
      READ(LUIPT,'(A4,6X,4F10.0)') WORD,TEND,TPAD0,TBEG,DTMS
      IF(WORD.NE.'TIME') THEN
       WRITE(LUPRT,*) '"TIME" CARD MISORDERED',WORD,' CARD ENTERED'
       CALL CCEXIT(100)
      ENDIF
      IF(DTMS.LE.0.) DTMS=FLOAT(ISI)
      DT=DTMS/1000.
      IF(TEND.LE.0.) TEND=NSAMP*DTMS
      IF(TPAD0.LE.0.) TPAD0=0.
      IF(TBEG.LE.0.) TBEG=0
      ITBEG=TBEG/DTMS + 1
      WRITE(LUPRT,'(A80)') CARD
      WRITE(LUPRT,'(A4,6X,4F10.0)') WORD,TEND,TPAD0,TBEG,DTMS
      IWIDTH=0

C     JOB CONSTANT FREQUENCY PARAMETERS
      READ(LUIPT,'(A80)') CARD
      READ(LUIPT,'(A9,1X,4F10.0)') WORD9,FMIN,F2,F3,FMAX
      IF(WORD9.NE.'FREQUENCY') THEN
      WRITE(LUPRT,*) '"FREQUENCY" CARD MISORDERED',WORD9,' CARD ENTERED'
       CALL CCEXIT(100)
      ENDIF
      WRITE(LUPRT,'(A80)') CARD
      WRITE(LUPRT,'(A9,1X,4F10.0)') WORD9,FMIN,F2,F3,FMAX
CCCy   prevent minimum frequency from being zero
       if(fmin.eq.0.0) fmin = 1.
       OMMIN=2*PI*FMIN
       OMMAX=2*PI*FMAX
C7-3

C     DEPTH PARAMETERS
      READ(LUIPT,'(A80)') CARD
cv6
      READ(LUIPT,'(A5,5X,2F10.0)') WORD5,ZMAX,DZOUT
      IF(WORD5.NE.'DEPTH') THEN
      WRITE(LUPRT,*) '"DEPTH" CARD MISORDERED',WORD5,' CARD ENTERED'
       CALL CCEXIT(100)
      ENDIF
       JZLN=ZMAX/DZOUT+ .1
       IZSEG=20
       IF(IZSEG.LE.0) IZSEG=1
       IF(IZSEG.GT.IZSEGM) IZSEG=IZSEGM
cv6
      WRITE(LUPRT,'(A80)') CARD
      WRITE(LUPRT,'(A5,5X,2F10.0,2I10)') WORD5,ZMAX,DZOUT

C     WIDTH PARAMETERS
      READ(LUIPT,'(A80)') CARD
cvf3  READ(LUIPT,'(A5,5X,3F10.0,I10,F10.0)')
cvf3 &WORD5,DX,XBEGIN,XPAND,IXSEG,XOVPC
c           x                 x     x
      READ(LUIPT,'(A5,5X,F10.0,2I10)')
     &WORD5,DX,ITRBEG,JXNTR
      IF(WORD5.NE.'WIDTH') THEN
      WRITE(LUPRT,*) '"WIDTH" CARD MISORDERED',WORD5,' CARD ENTERED'
       CALL CCEXIT(100)
      ENDIF
      IF(DX.LE.0.) WRITE(LUPRT,*) 'ERROR --DX LE 0 '
      IF(DX.LE.0.) CALL CCEXIT(100)
      IF(ITRBEG.LE.0) ITRBEG = 1
      IF(JXNTR.LE.0) JXNTR = NTR*NREC-ITRBEG+1
      WRITE(LUPRT,'(A80)') CARD
      WRITE(LUPRT,'(A5,5X,F10.2,2I10)')
     &WORD5,DX,ITRBEG,JXNTR

C     LEAD IN SKIP
      IXSKP=ITRBEG-1
      IXBLK=1
C     BLOCK (RECORD) PARAMETERS
      JXSKIP=0
      JXBLK=1
      IXSEG=1
      XOVPC=30

C     SET XSHOT AND XSHFT = 0. (THESE APPLY TO COMMON SHOT MIGRATION)
      XSHOT=0.0
      XSHFT=0.0

C     NUMBER OF VELOCITIES,REF VEL,REFL BWIDTH,STARTING X, XTAPER
      READ(LUIPT,'(A80)') CARD
      READ(LUIPT,'(A5,5X,10X,F10.0,F10.0,F10.0,I10)') WORD5
     & ,VELREF,BMWTHR, XBEGIN, IXTAP
      IF(WORD5.NE.'MODEL') THEN
       WRITE(LUPRT,*) '"MODEL" CARD MISORDERED',WORD5,' CARD ENTERED'
       CALL CCEXIT(100)
      ENDIF

       BMWTHI=10.
       IF(BMWTHR.EQ.0.) BWMTHR=45.
       IF(IXTAP.LT.0) IXTAP=0

      WRITE(LUPRT,'(A80)') CARD
      WRITE(LUPRT,'(A5,5X,10X,F10.0,F10.0,F10.0,I10)') WORD5
     & ,VELREF,BMWTHR, XBEGIN, IXTAP

C     UPDATE XBEGIN BY BIASING TO THE BEGINNING TRACE
       XBEGIN=XBEGIN+(ITRBEG-1)*DX

C     IMAGING CONTROL PARAMETERS
      READ(LUIPT,'(A80)') CARD
cmat  take out the read on msk and iextrp, let them be hidden command
cmat  line arguments
cmat  READ(LUIPT,'(A5,5X,4I10,F10.0)') WORD5
cmat & ,NATOP,NABOT,MSK,IEXTRP,XPAND
      if(msk.le.0)msk = 1
      if(iextrp.lt.0)iextrp = 0
      read(luipt,'(a5,5x,2i10,20x,f10.0)') word5
     & ,natop,nabot,           xpand
      IF(WORD5.NE.'IMAGE') THEN
      WRITE(LUPRT,*) '"IMAGE" CARD MISORDERED',WORD5,' CARD ENTERED'
       CALL CCEXIT(100)
      ENDIF
       NA=NAPMAX
       IF(NA.LE.0) NA=24
       PRCNT = 70
       IF( PRCNT  .GT.100. ) PRCNT = 80.
       IF( PRCNT  .LE.  0. ) PRCNT = 80.
       if(iextrp .le. 0) iextrp = 0
       if(iextrp .gt. 1) iextrp = 1
       IDIPZ=1000
       IF( BMWTHR .LT.  0. ) IDIPZ = 0
      nachg = 0
      WRITE(LUPRT,'(A80)') CARD
      WRITE(LUPRT,'(A5,5X,4I10,F10.2)') WORD5
cvf3 & ,NA,XPAND,MSK,IEXTRP,PRCNT
     & ,NATOP,NABOT,MSK,IEXTRP,XPAND
      IF(NATOP.LT.NAPMIN) then
         NATOP=NAPMIN
         nachg = 1
      endif
      IF(NABOT.LT.NAPMIN) then
        NABOT=NAPMIN
         nachg = 1
      endif
      IF(NATOP.GT.NAPMAX) then
         NATOP=NAPMAX
         nachg = 1
      endif
      IF(NABOT.GT.NAPMAX) then
         NABOT=NAPMAX
         nachg = 1
      endif
      if(nachg.gt.0)then
         write(luprt,*)'  The natop/nabot parameters exceed program',
     &                 ' limits - Changed to:'
         WRITE(LUPRT,'(A80)') CARD
         WRITE(LUPRT,'(A5,5X,4I10,F10.2)') WORD5
     &    ,NATOP,NABOT,MSK,IEXTRP,XPAND
         write(ler,*)'  The natop/nabot parameters exceed program',
     &                 ' limits - Changed to:'
         WRITE(Ler,'(A80)') CARD
         WRITE(Ler,'(A5,5X,4I10,F10.2)') WORD5
     &    ,NATOP,NABOT,MSK,IEXTRP,XPAND
      endif
      IF(MSK.LE.0) MSK=1
       IF(XPAND.LE.0.0) XPAND=1.0
       IF(XPAND.LT.0.33333) XPAND=.33333
       IF(XPAND.GT.3.0) XPAND=3.0
       DX0=DX*XPAND

C     ANGLES
cmmas
       angl(1) = 0.


C      COMPUTE FOR ALL HORIZONTAL SEGMENTS:
C         STARTING OUTPUT LOCATION (IXBIAS)
C         NUMBER OF X'S TO PROCESS (IXLN)
C         NUMBER OF X'S AFTER RESAMPLING (IXLN0)
C         NUMBER OF OUTPUT TRACES (IXLN1)
       IXSEG = 0
       XOVPC = 30.
  999 IXSEG = IXSEG + 1
       write(luprt,*)' Number of horizontal segments = ',ixseg
       If(IXSEG.GT.IXSEGM) THEN 
       WRITE(0,*) 'TOO MANY TRACES TO MIGRATE'
       WRITE(0,*) 'TRY INCREASING THE X-EXPANSION PARAMETER'
       WRITE(0,*) 'AND RERUNNING THE JOB'
       WRITE(LUPRT,*) 'TOO MANY TRACES TO MIGRATE'
       WRITE(LUPRT,*) 'TRY INCREASING THE X-EXPANSION PARAMETER'
       WRITE(LUPRT,*) 'AND RERUNNING THE JOB'
       CALL CCEXIT(100)
       ENDIF
       LXLN1=JXNTR/IXSEG

       IXBIAS(1)=0
       IF(IXSEG.GT.1) THEN
        DO 20 IXS=2,IXSEG
  20    IXBIAS(IXS)=IXBIAS(IXS-1)+LXLN1
        DO 21 IXS=1,IXSEG-1
  21    IXLN1(IXS)=LXLN1
       ENDIF
       IXLN1(IXSEG)=JXNTR-(IXSEG-1)*LXLN1

       XMULT=XOVPC/100.

       IXST(1)=1
       IXST0(1)=1
      IF(IXSEG.EQ.1) THEN
       IXLN(1)=JXNTR
       IXLN0(1)=JXNTR/XPAND+.5
cmat   moved the next line inside this if loop
       IF(IXLN0(1).GT.IXMAX)GO TO 999
      ENDIF
      IF(IXSEG.EQ.2) THEN
       IXLN(1)=(1.+XMULT)*LXLN1
       IXLN0(1)=IXLN(1)/XPAND+.5
      IF(IXLN0(1).GT.IXMAX)GO TO 999
       IXST(2)=IXBIAS(2)-XMULT*LXLN1
       IXST0(2)=IXST(2)/XPAND
       IXLN(2)=JXNTR-IXST(2)+1
       IXLN0(2)=IXLN(2)/XPAND+.5
      IF(IXLN0(2).GT.IXMAX)GO TO 999
      ENDIF
      IF(IXSEG.GT.2) THEN
       IXLN(1)=(1.+XMULT)*LXLN1
       IXLN0(1)=IXLN(1)/XPAND+.5
       DO 23 IXS=2,IXSEG-1
       IXST(IXS)=IXBIAS(IXS)-XMULT*LXLN1
       IXST0(IXS)=IXST(IXS)/XPAND
       IXLN(IXS)=(1+2.*XMULT)*LXLN1
       IXLN0(IXS)=IXLN(IXS)/XPAND+.5
   23  IF(IXLN0(IXS).GT.IXMAX) GO TO 999
       IXST(IXSEG)=IXBIAS(IXSEG)-XOVPC/100.*LXLN1
       IXST0(IXSEG)=IXST(IXSEG)/XPAND
       IXLN(IXSEG)=JXNTR-IXST(IXSEG)+1
       IXLN0(IXSEG)=IXLN(IXSEG)/XPAND+.5
       IF(IXLN0(IXSEG).GT.IXMAX) GO TO 999
      ENDIF
C7/3
       IF(IXLN(1).GT.IXMAX) THEN
        WRITE(LUPRT,*)
     &  'WIDTH IN A SEGMENT ',IXLN(1),' GREATER THAN ',IXMAX
        WRITE(LUPRT,*) 'INCREASING THE NUMBER OF HORIZONTAL SEGMENTS'
        GO TO 999
       ENDIF
       IF(IXLN0(1).GT.IXMAX) THEN
        WRITE(LUPRT,*)
     &  'WIDTH IN A SEGMENT ',IXLN0(1),' GREATER THAN ',IXMAX
        WRITE(LUPRT,*) 'INCREASING THE NUMBER OF HORIZONTAL SEGMENTS'
        GO TO 999
       endif

C***********************************************************************
C     OPEN OUTPUT TAPE AND WRITE HEADER TO TAPE
C***********************************************************************
      idx=dx*1000.0
      idz=dzout*1000.0
      CALL SAVEW(IHEAD, 'NumTrc', JXNTR, 0)
      CALL SAVEW(IHEAD, 'NumRec', 1, 0)
      CALL SAVEW(IHEAD, 'NumSmp', JZLN, 0)
      call savew(lhead, 'Dx1000', idx , LINHED)
      call savew(lhead, 'Dz1000', idz , LINHED)


      if(ipipo.eq.0) then
c     lu24 is a output dataset
       call lbopen(lu24,otap,'w')
      else
c      we know lu24 is a pipe
       lu24=1
      endif

      call savhlh(ihead,ieof,lbyout)
      CALL WRTAPE(lu24,IHEAD,lbyout)

      RETURN

 9940 WRITE(LUPRT,*) 'NOT ENOUGH ANGLE CARDS'
      CALL CCEXIT(100)
      RETURN

      END
C***********************************************************************
       SUBROUTINE pwblkp(JBLK)
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C      COMPUTES BLOCK DEPENDENT PARAMETERS



C * * * BEGIN MEMORY SPACE ALLOCATION * * * * * *

C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=105,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=100,IXSEGM=4,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(SZLNHD)
      INTEGER THEAD(3000)
      INTEGER *2 ITRH(LNTRHD)
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------


C * * * PWMBS COMMON (END) * * * *

C * * DATA ARRAYS NOT IN COMMON * *

C * * * END MEMORY SPACE ALLOCATION * * * * * * *



C     DETERMINE MAX WIDTH FOR A GIVEN SEGMENT AND
C     A CORRESPONDING ZERO PAD FOR DFT
      IWIDTH=0
      DO 10 IXS=1,IXSEG
   10 IF(IXLN(IXS).GE.IWIDTH) IWIDTH=IXLN(IXS)
      ITPAD=TPAD0/DTMS+.5*ABS(PRAY)*IWIDTH*DX*1000./DTMS
      NDFT=TEND/DTMS-ITBEG+ITPAD
CCCy
C     COMPUTE THE NEXT NDFT FOR THE MIXED RADIX FFT

      ndft = nrfft(ndft)

      TDFT=NDFT
      timems = tdft * dtms
      TIMES=TIMEMS/1000.

C     COMPUTE FREQUENCY PARAMETERS
      DF=1./TIMES
      IF0=FMIN*TIMES+.5
      F0=IF0
c***  SCALF=DT*DF new dft normalizes the scale so set scalf to 1.0
      scalf = 2.0
      DOMEGA=2.*PI*DF
      IWMIN=1
      NW=(FMAX-FMIN)*TIMES
      ommin=2.*pi*f0*df
      DO 20 JWL=1,NW
   20 OMEGA(JWL)=OMMIN+(JWL-1)*DOMEGA

      IWSEG=FLOAT(NW)/IWMAX+.9999
      ICHUNK=NW/IWSEG
      IWST=1
      DO 30 IWS=1,IWSEG
      IWBEG(IWS)=IWST
      IWEN=IWST+ICHUNK
      IF(IWEN.GT.NW) IWEN=NW
      IWBEG(IWS)=IWST
      IWEND(IWS)=IWEN
   30 IWST=IWEN+1


       NWBYT=NW*4

C      TRAPEZOIDAL FREQUENCY FILTER
       CALL TRPFLT(FILT,FMIN,F2,F3,FMAX,DF,SCALF,LUPRT)

       RETURN
       END
      SUBROUTINE trpflt(FILT,F1,F2,F3,F4,DF,SCALF,LUPRT)
C     THIS ROUTINE COMPUTES A TRAPEZOIDAL FREQUENCY WINDOW FOR
C     FREQUENCY DOMAIN FILTERING.

      REAL FILT(*)

      IF(F1.GE.0.) THEN
       IF(F2.GE.F1) THEN
        IF(F3.GE.F2) THEN
         IF(F4.GE.F3) THEN
C**       WRITE(LUPRT,*)'FILTER PARAMETERS:'
C**       WRITE(LUPRT,*)'F1,F2,F3,F4 =    ',F1,F2,F3,F4
C**       WRITE(LUPRT,*)'                                           '
         ELSE
          WRITE(LUPRT,*)'FILTER ERROR: F1,F2,F3,F4=',F1,F2,F3,F4
          STOP 1000
         ENDIF
        ELSE
         WRITE(LUPRT,*)'FILTER ERROR: F1,F2,F3,F4=',F1,F2,F3,F4
        ENDIF
       ELSE
        WRITE(LUPRT,*)'FILTER ERROR: F1,F2,F3,F4=',F1,F2,F3,F4
        STOP 1000
       ENDIF
      ELSE
       WRITE(LUPRT,*)'FILTER ERROR: F1,F2,F3,F4=',F1,F2,F3,F4
       STOP 1000
      ENDIF

      J1=1
      J2=(F2-F1)/DF
      J3=(F3-F1)/DF
      J4=(F4-F1)/DF

      IF(J4.GT.J1) THEN
       DO 20 J=1,J4
  20   FILT(J)=1.0*SCALF
      ELSE
       WRITE(LUPRT,*)'FILTER ERROR, F1,F2,F3,F4=',F1,F2,F3,F4
       STOP 1000
      ENDIF

      IF(J1.LT.J2) THEN
       DO 30,I=J1,J2
   30  FILT(I)=SCALF*(I*DF)/(F2-F1)
      ENDIF

      IF(J3.LT.J4-1) THEN
       DO 40,I=J3,J4-1
   40  FILT(I)=SCALF*(J4-I)*DF/(F4-F3)
      ENDIF
      FILT(J4)=FILT(J4-1)
      FILT(J4+1)=FILT(J4-1)

      RETURN
      END
      SUBROUTINE pwprtc(LU,IXS,IZS,IWS)
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=105,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=100,IXSEGM=4,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(SZLNHD)
      INTEGER THEAD(3000)
      INTEGER *2 ITRH(LNTRHD)
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------

      WRITE(LU,*) ' '
      WRITE(LU,*) ' ** ** ** ** ** COMMON BLOCKS ** ** ** ** ** ** '
      WRITE(LU,*) ' '

      WRITE(LU,*) ' '
      WRITE(LU,*) 'DEPTH COMMON'
      WRITE(LU,*) 'IZMAX,IZSEGM=', IZMAX,IZSEGM

      WRITE(LU,*) 'IZS,IZB(IZS),JZROW(IZS),IZLN,IZXTR,JZLN='
      WRITE(LU,1001) IZS,IZB(IZS),JZROW(IZS),IZLN,IZXTR,JZLN
 1001 FORMAT(I4,I9,I11,I5,I6,I5)
      WRITE(LU,*) 'ZBEG(IZS),ZEND(IZS),DZ(IZS),DZOUT'
      WRITE(LU,1002) ZBEG(IZS),ZEND(IZS),DZ(IZS),DZOUT
 1002 FORMAT(F9.3,1X,F9.3,1X,F7.3,1X,F7.3)
      WRITE(LU,*) 'ZMAX,ZDEP'
     &,ZMAX,ZDEP
      WRITE(LU,*) ' '
      WRITE(LU,*) 'WIDTH COMMON'
      WRITE(LU,*) 'JBMAX,IXSEGM,IXMAX'
     &,JBMAX,IXSEGM,IXMAX
      WRITE(LU,*) 'IXS,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP'
      WRITE(LU,1003)
     &IXS,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
 1003 FORMAT(I4,I4,I5,I6,I6,I6,I6,I6,I7)
      WRITE(LU,*) 'IXLN(IXS),IXLN0(IXS),IXLN1(IXS)'
      WRITE(LU,1004) IXLN(IXS),IXLN0(IXS),IXLN1(IXS)
 1004 FORMAT(I10,I11,I11)
      WRITE(LU,*) 'IXBIAS(IXS),IXST(IXS),IXST0(IXS)'
      WRITE(LU,1005) IXBIAS(IXS),IXST(IXS),IXST0(IXS)
 1005 FORMAT(I12,I10,I11)
      WRITE(LU,*) 'XOVPC,   DX, XPAND,  DX0,XBEGIN,  XWTH, XSHOT,XSHFT'
      WRITE(LU,1006)
     &XOVPC,DX,XPAND,DX0,XBEGIN, XWTH,XSHOT,XSHFT
 1006 FORMAT(F5.2,2X,F6.2,1X,F5.2,1X,F6.2,F6.1,1X,F7.1,F6.1,F6.1)


      WRITE(LU,*) ' '
      WRITE(LU,*) 'TIME COMMON'
      WRITE(LU,*) 'ISI,NSAMP,ITPAD,NDFT,ITBEG'
      WRITE(LU,1007)
     &ISI,NSAMP,ITPAD,NDFT,ITBEG
 1007 FORMAT(I4,I6,I6,I5,I5)
      WRITE(LU,*) '  DTMS,    DT,  TBEG,  TEND, TPAD0, TIMEMS, TIMES'
      WRITE(LU,1008)
     &DTMS,DT,TBEG, TEND, TPAD0, TIMEMS, TIMES
 1008 FORMAT(F7.2,F7.2,F7.2,F7.2,F7.2,F7.2,F7.2)


      WRITE(LU,*) ' '
      WRITE(LU,*) 'FREQ COMMON'
      WRITE(LU,*) 'IWSEGM,IWMAX'
     &,IWSEGM,IWMAX
      WRITE(LU,*) 'IWS,IWBEG(IWS),IWEND(IWS),IWMIN, NW'
      WRITE(LU,1009)
     &IWS,IWBEG(IWS),IWEND(IWS),IWMIN,NW
 1009 FORMAT(I5,I11,I11,I6,I3)
      WRITE(LU,*) '  F0, FMIN,   F2,   F3, FMAX,   DF, SCALF'
      WRITE(LU,1010)
     &F0,FMIN,F2,F3,FMAX,DF,SCALF
 1010 FORMAT(F6.2,F6.2,F6.2,F6.2,F6.2,F6.2,F6.2)
      WRITE(LU,*) ' OMMIN, OMMAX, DOMEGA,   PI ='
      WRITE(LU,1011)
     &OMMIN,OMMAX,DOMEGA,PI
 1011 FORMAT(F7.2,F7.2,F7.2,F7.2)

      WRITE(LU,*) ' '
      WRITE(LU,*) 'TAPE COMMON'
      WRITE(LU,*) 'NSMAX=',NSMAX

      WRITE(LU,*) ' '
      WRITE(LU,*) 'MISCL COMMON'
      WRITE(LU,*) 'ISYS,IFMT,ITPFMT='
     &,ISYS,IFMT,ITPFMT
      WRITE(LU,*) 'MSK,NA,NAPMIN,NAPMAX,NV'
      WRITE(LU,1012)
     &MSK,NA,NAPMIN,NAPMAX,NV
 1012 FORMAT(/,I4,I3,I7,I7,I3)
      WRITE(LU,*) 'VELREF,PRAY='
     &,VELREF,PRAY
      WRITE(LU,*) ' '

      RETURN
      END
      SUBROUTINE crsmp (DATI,DXI,MXI,DATO,DXO,MXO,IXM,XM,IFLAG)

      COMPLEX DATI(*), DATO(*)
c     INTEGER*4 IXM(1)
      INTEGER   IXM(*)
c     REAL XM(1)
      REAL XM(*)
C     LINEARLY RESAMPLE DATI TO DATO (SAMPLE RATES DXI TO DXO)
C     COMPUTE INDIRECT INDEX ARRAY IXM

      RATE=DXO/DXI
      IF(RATE.EQ.1.) THEN
       MBYTES=MXO*8
       call vmov(dati,1,dato,1,mxo*2)
       RETURN
      ENDIF

      IF(IFLAG.NE.0) GO TO 30

C     COMPUTE INDEX AND SCALING ARRAYS (IXM AND XM) IF IFLAG=0
      IXM(1)=1
      XMM=1.00001
      DO 10 M=2,MXO
      XMM=XMM+RATE
      IXM(M)=XMM
   10 XM(M)=(XMM-IXM(M))
      IF(RATE.GT.1.) IXM(MXO+1)=IXM(MXO)

   30 CONTINUE

C     COMPUTE LINEAR INTERPOLATION
      DATO(1)=DATI(1)
      DO 20 M=2,MXO
   20 DATO(M) =( DATI(IXM(M)+1)-DATI(IXM(M)) )*XM(M) + DATI(IXM(M))
      IF(RATE.GT.1.) DATO(MXO+1)=DATO(MXO)

      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       PWROF2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PWROF2  (N,IPWR)                                                *
C  ARGUMENTS:                                                          *
C      N       INTEGER  ??IOU* -                                       *
C      IPWR    INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 84/06/18  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 86/09/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C     LANGUAGE - FORTRAN
C     AUTHOR - BRUCE CROWL
C     DATE WRITTEN - JAN, 1979
C     DATE LAST MOD -
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE.
C
C     ABSTRACT - GIVEN A NUMBER(N) THIS ROUTINE RETURNS THE BASE TWO
C                EXPONENT(IPWR) WHICH WILL GIVE 2**(IPWR-1).GT.N.LE.2**IPWR
C
C     USAGE - CALL PWROF2 (N,IPWR)
C               N    -INPUT VALUE (INTEGER)
C               IPWR - POWER OF TWO RETURNED.
C
C************************************************************************
C
      SUBROUTINE pwrof2 (N,IPWR)
C
C
      IPWR = 0
      IF (N.LE.0) GO TO 200
100   CONTINUE
      IF (2**IPWR.GE.N) GO TO 200
      IPWR = IPWR+1
      IF (IPWR.LT.30) GO TO 100
200   CONTINUE
C
      RETURN
      END
C********************************************************************C
C NAME: XGTABM  GREEN'S FUNCTION TABLE W MAP    REV 2.0     JUL 87   C
C********************************************************************C
C
C  PURPOSE:
C       COMPUTES THE GREEN'S FUNCTION TABLE WITH VELOCITIES SELECTED
C       VIA A MAP.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                SEP 87          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL XGTABM (PRCNT, OMEGA, DX, DZ, DIR, SLOW, MAP,
C      &             WRK, RAMP, CXR, CXI, TEMP, GTR, GTI, NV, NA)
C
C  PARAMETERS:
C       PRCNT   REAL INPUT SCALAR
C               PERCENT RAMP (0. = NO RAMP, 100. = ALL RAMP).
C
C       OMEGA   REAL INPUT SCALAR
C               ANGULAR FREQUENCY.
C
C       DX      REAL INPUT SCALAR
C               DELTA X.
C
C       DZ      REAL INPUT SCALAR
C               DELTA Z.
C
C       DIR     REAL INPUT SCALAR
C               DIRECTION (-1.0 = INCIDENT, 1.0 = REFLECTED).
C
C       SLOW    REAL INPUT VECTOR OF LENGTH NV
C               SLOWNESS VECTOR WHERE SLOW(I) = 1.0 / VELOCITY(I).
C
C       MAP     INTEGER INPUT VECTOR OF LENGTH NV
C               VELOCITY SELECTION MAP.  MAP(I) <> 0, IF VALUES FOR
C               VELOCITY(I) ARE TO BE COMPUTED.
C
C       WRK     REAL SCRATCH VECTOR OF LENGTH MAX( NA**2, 3*NV*(NA+1) )
C
C       RAMP    REAL SCRATCH VECTOR OF LENGTH 2*NA-1
C
C       CXR     REAL SCRATCH MATRIX OF DIMENSION (NA+1) X NV
C
C       CXI     REAL SCRATCH MATRIX OF DIMENSION (NA+1) X NV
C
C       TEMP    REAL SCRATCH VECTOR OF LENGTH NA**2
C
C       GTR     REAL OUTPUT MATRIX OF DIMENSION NA X NV
C               REAL COMPONENTS GREEN'S FUNCTION TABLE.
C
C       GTI     REAL OUTPUT MATRIX OF DIMENSION NA X NV
C               IMAGINARY COMPONENTS GREEN'S FUNCTION TABLE.
C
C       NV      INTEGER INPUT SCALAR
C               NUMBER OF VELOCITIES.
C
C       NA      INTEGER INPUT SCALAR
C               NUMBER OF APERTURES.
C
C
C  DESCRIPTION:
C       COMPUTES THE GREEN'S FUNCTION TABLE FOR DIR = 1.0 BY:
C
C       (GTR(J,I),GTI(J,I)) = (0.0, 0.0)     , IF MAP(I) = 0
C                           = 0.5 * GTAB(I,J), IF J = 1 AND MAP(I) <> 0
C                           = GTAB(I,J)      , IF J > 1 AND MAP(I) <> 0
C
C       GTAB(I,J) = RAMP(J) * SUM( CXTAB(K,I) * TEMP(J,K), K = 1, NA )
C          FOR I = 1, NV; J = 1, NA
C
C       WHERE:
C          CXTAB(K,I) = CEXP( (0.0,1.0) * DZ * CSQRT( ARG ) )
C
C          ARG        = (OMEGA * SLOW(I))**2 - ((K-1) * DK)**2
C
C          DK         = 2.0 * PI / (DX * FLOAT( 2*NA-1 ))
C
C          TEMP(J,K)  = 1.0, K = 1
C                     = 2.0 * COS( (J-1) * K * DXDK ), K > 1
C
C          DXDK       = 2.0 * PI / FLOAT( 2*NA-1 )
C
C       IF DIR = -1.0, THEN THE COMPLEX CONJUGATE OF THE ABOVE IS
C       USED.
C
C  SUBPROGRAMS CALLED:
C       FORTRAN INTRINICS: FLOAT, ABS, SQRT, EXP, SIN, COS
C       MATH ADVANTAGE   : VRAMP
C       SCILIB           : WHENFLT, WHENFGE, GATHER, SCATTER
C       OTHER            : CGTAB2
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE XGTABM (PRCNT, OMEGA, DX, DZ, DIR, SLOW, MAP,
     &                   WRK, RAMP, CXR, CXI, TEMP, GTR, GTI, NV, NA)
C
      INTEGER MAP(*)
      REAL    SLOW(*), WRK(*), RAMP(*), CXR(*), CXI(*), TEMP(*),
     &        GTR(*), GTI(*)
C
      DATA TWOPI / 6.283185307179586 /
C
C---------------------------------------------------------------------
C
C  DO SCALAR CALCULATIONS
C
      NCT    = NA + NA - 1
      WIDTHI = FLOAT( NCT )
      WIDTH  = WIDTHI * DX
      if(width.le.0.0 .or. widthi.le.0.0)
     & print *,' width,widthi',width,widthi
      OVERW  = 1.0   / WIDTHI
      DXDK   = TWOPI / WIDTHI
      DK     = TWOPI / WIDTH
C
      ITAPER = FLOAT( NA ) * (100.0 - ABS( PRCNT )) / 100.0
      IF (ITAPER .LT. 1) ITAPER = 1
      NTAPER = NA - ITAPER + 1
      if(ntaper.le.0)print *, 'ntaper ',ntaper
      STAPER = - OVERW / FLOAT( NTAPER )
C
C  BUILD TABLES
C
      MV = 0
      DO 105 I = 1, NV
         IF (MAP(I) .NE. 0) THEN
            MV = MV + 1
            TEMP(MV) = SLOW(I)
         ENDIF
  105 CONTINUE
      IF (MV .EQ. 0) GO TO 200
C
      MA = NA
      IF (MV .GT. NA) THEN
         IF (MOD( MA, 2 ) .EQ. 0) MA = MA + 1
      ENDIF
C
      N  = NV * MA
C
      I1 = 1
      I2 = I1 + N
      I3 = I2 + N
      CALL VRAMP  (0.0, DK, RAMP, 1, MA)
      CALL XGTAB1 (RAMP, TEMP, OMEGA, DZ, DIR,
     &             WRK(I1), WRK(I2), WRK(I3), CXR, CXI, MA, MV)
C
      CALL VRAMP (0.0, DXDK, RAMP, 1, NCT)
C     RAMP(1:NCT) = 2.0 * COS( RAMP(1:NCT) )
      do 106 n=1,nct
         ramp(n) = 2.0 * cos( ramp(n) )
  106 continue
C
      KNT = NA / 2
      K   = 0
      DO 120 J = 1, KNT
         DO 110 I = 1, NCT
            K = K + 1
            WRK(K) = RAMP(I)
  110    CONTINUE
  120 CONTINUE
C
C     RAMP(1:NA) = OVERW
      do 121 n=1,na
         ramp(n) = overw
  121 continue
      CALL VRAMP (OVERW, STAPER, RAMP(ITAPER), 1, NTAPER)
      RAMP(1) = 0.5 * RAMP(1)
C
      DO 130 I = 1, NA
         TEMP(I) = RAMP(I)
  130 CONTINUE
C
      K = NA + 1
      DO 150 J = 2, NA
         JM1 = J - 1
         L   = 1
         DO 140 I = 1, NA
            TEMP(K) = RAMP(I) * WRK(L)
            K = K + 1
            L = L + JM1
  140    CONTINUE
  150 CONTINUE
C
C  BUILD GREEN'S TABLE
C
      CALL CGTAB2 (TEMP, CXR, CXI, GTR, GTI, MA, NA, MV)
C
  200 CONTINUE
      IF (MV .EQ. NV) GO TO 800
      K2 = NA * MV
      K1 = K2 + 1 - NA
      J2 = NA * NV
      J1 = J2 + 1 - NA
C
      DO 210 I = NV, 1, -1
         IF (MAP(I) .EQ. 0) THEN
C           GTR(J1:J2) = 0.0
C           GTI(J1:J2) = 0.0
            call vclr(gtr(j1),1,j2-j1+1)
            call vclr(gti(j1),1,j2-j1+1)
         ELSE
C           GTR(J1:J2) = GTR(K1:K2)
C           GTI(J1:J2) = GTI(K1:K2)
            call vmov(gtr(k1),1,gtr(j1),1,na-1+1)
            call vmov(gti(k1),1,gti(j1),1,na-1+1)
            K1 = K1 - NA
            K2 = K2 - NA
         ENDIF
C
         J1 = J1 - NA
         J2 = J2 - NA
  210 CONTINUE
C
  800 CONTINUE
      RETURN
      END
C
C****** XGTAB1 - SPECIAL VERSION OF XCXFUN FOR XGTAB
C
      SUBROUTINE XGTAB1 (K, S, W, DZ, DIR, W1, W2, W3, CR, CI, NK, NS)
C
      INTEGER NK, NS
      REAL    K(*), S(*), W, DZ, DIR, W1(*), W2(*), W3(*), CR(*), CI(*)
C
C---------------------------------------------------------------------
C
      N = NK * NS
C
      I = 0
      DZSQ  = DZ * DZ
      DO 120 IS = 1, NS
         S0 = (W * S(IS)) ** 2
         DO 110 IK = 1, NK
            I    = I + 1
            W1(I) = (S0 - K(IK) * K(IK)) * DZSQ
  110    CONTINUE
  120 CONTINUE
C
C     CI(1:N) = 0.0
      call vclr(ci,1,n)
C
       CALL WHENFLT (N, W1, 1, 0.0, W2, M)
C
      IF (M .GT. 0) THEN
         CALL GATHER  (M, W3, W1, W2)
C
         DO 210 I = 1, M
            X = SQRT( - W3(I) )
            W3(I) = EXP( - X )
  210    CONTINUE
C
         CALL SCATTER (M, CR, W2, W3)
      ENDIF
C
      CALL WHENFGE (N, W1, 1, 0.0, W2, M)
C
      IF (M .GT. 0) THEN
         CALL GATHER (M, W3, W1, W2)
C
         DO 310 I = 1, M
            X = DIR * SQRT( W3(I) )
            W3(I) = COS( X )
            W1(I) = SIN( X )
  310    CONTINUE
C
         CALL SCATTER (M, CR, W2, W3)
         CALL SCATTER (M, CI, W2, W1)
      ENDIF
C
      RETURN
      END
C********************************************************************C
C NAME: GCFILT  GENERATE COMPLEX FILTER         REV 1.0     SEP 86   C
C********************************************************************C
C
C  PURPOSE:
C       GENERATES THE FILTER FOR USE BY FCFILT, PCFILT, OR PDCIMF.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                SEP 86          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL GCFILT (V1, V2, K1, K2, KR, FILT, N, M)
C
C  PARAMETERS:
C       V1      REAL INPUT SCALAR
C               FIRST FILTER VALUE.
C
C       V2      REAL INPUT SCALAR
C               SECOND FILTER VALUE.
C
C       K1      INTEGER INPUT SCALAR
C               FIRST INDEX.
C
C       K2      INTEGER INPUT SCALAR
C               SECOND INDEX.
C
C       KR      INTEGER INPUT SCALAR
C               RAMP LENGTH.
C
C       FILT    COMPLEX OUTPUT VECTOR OF LENGTH M
C               RESULT FILTER IN FFT ORDER.
C
C       N       INTEGER INPUT SCALAR
C               ELEMENT COUNT OF VECTOR TO BE FILTERED.
C
C       M       INTEGER OUTPUT SCALAR
C               ELEMENT COUNT OF FILTER.
C
C
C  DESCRIPTION:
C       CONSTRUCTS A FILTER AS FOLLOWS:
C          (1) FIND M SUCH THAT M = 2**K WHERE 2**(K-1) < N <= 2**K.
C          (2) FILLS FILT AS FOLLOWS:
C               FILT(I(K)) = (V2,V2), K1 <= K <= K2
C                          = (V1,V1), K <= K1-KR AND K >= K2+KR
C                          = (VR,VR), WHERE VR = V2 + KK * VSTEP
C                                  VR    = V2 + KK * VSTEP
C                                  KK    = K1 - K, K1-KR < K < K1
C                                        = K - K2, K2    < K < K2+KR
C                                  VSTEP = (V1 - V2) / KR
C               WHERE I(K) = K + 1,     K >= 0
C                          = M + K + 1, K < 0
C
C       IF K2 < K1, FILT IS FILLED WITH (V1,V1).  IF KR < 1, THEN
C       IT PERFORMS AS IF KR = 1 (RETANGULAR FILTER). IF EITHER K1
C       OR K2 IS OUT OF RANGE (1-M/2,M/2) THE ENDS ARE PROPERLY
C       TRUNCATED.
C
C  SUBPROGRAMS CALLED:
C       MATH ADVANTAGE: VFILL
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE gcfilt (V1, V2, K1, K2, KR, FILT, N, M)
C
      INTEGER K1, K2, KR, N, M
      REAL    V1, V2, FILT(2,*)
C
C---------------------------------------------------------------------
C
      M = 1
  110 CONTINUE
         MD2 = M
         M   = M + M
         IF (M .LT. N) GO TO 110
C
      M2 = M + M
C
      CALL VFILL (V1, FILT, 1, M2)
      IF (K2 .LT. K1) GO TO 800
C
      L1 = K1
      L2 = K2
      IF (L1 .LT. 1-MD2) L1 = 1 - MD2
      IF (L2 .GT. MD2  ) L2 = MD2
C
      DO 120 L = L1, L2
         I = L + 1
         IF (L .LT. 0) I = M + L + 1
         FILT(1,I) = V2
         FILT(2,I) = V2
  120 CONTINUE
C
      IF (KR .LE. 1) GO TO 800
C
      VSTEP = (V1 - V2) / FLOAT( KR )
      V     = V2
      DO 130 LL = 1, KR-1
         V = V + VSTEP
C
         L = L1 - LL
         IF (L .GE. 1-MD2) THEN
            I = L + 1
            IF (L .LT. 0) I = M + L + 1
            FILT(1,I) = V
            FILT(2,I) = V
         ENDIF
C
         L = L2 + LL
         IF (L .LE. MD2) THEN
            I = L + 1
            IF (L .LT. 0) I = M + L + 1
            FILT(1,I) = V
            FILT(2,I) = V
         ENDIF
C
  130 CONTINUE
C
  800 CONTINUE
      RETURN
      END
C********************************************************************C
C NAME: XCFILT  COMPLEX FILTER (FFT)            REV 1.0     MAR 87   C
C********************************************************************C
C
C  PURPOSE:
C       PERFORMS A FILTER OPERATION ON A COMPLEX VECTOR USING FFT'S.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                MAR 87          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL XCFILT (A, B, WRK, N, IFLG)
C
C  PARAMETERS:
C       A       COMPLEX INPUT/OUTPUT VECTOR OF LENGTH N
C               SOURCE AND RESULT VECTOR.
C
C       B       COMPLEX INPUT VECTOR OF LENGTH N
C               FILTER.
C
C       WRK     REAL SCRATCH VECTOR OF LENGTH 5 * M
C               NOTE: M = 2**K >= N
C
C       N       INTEGER INPUT SCALAR
C               ELEMENT COUNT.
C
C       IFLG    INTEGER INPUT SCALAR
C               INITIALIZATION FLAG - IF IFLG <> 0, THEN INITIALIZE
C
C  DESCRIPTION:
C       PERFORMS THE FOLLOWING PROCEDURE:
C          (1) IF IFLG <> 0, THEN PERFORM INITIALIZATION
C          (2) IF M > N, THEN A(I) = (0.0,0.0) , I = N+1, M.
C          (3) A = FCFFT(A,M)
C          (4) REAL( A(I) ) = REAL( A(I) ) * REAL( B(I) ), I = 1, M
C              IMAG( A(I) ) = IMAG( A(I) ) * IMAG( B(I) ), I = 1, M
C          (5) A = ICFFT(A,M)
C
C  SUBPROGRAMS CALLED:
C       SCILIB: CFFT2
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE XCFILT (A, B, WRK, N, IFLG)
C
      INTEGER N
      REAL    A(*), B(*), WRK(*)
C
      SAVE M, M2, N2, RM
C
C---------------------------------------------------------------------
C
      IF (IFLG .EQ. 0) GO TO 200
C
      M = 1
  110 CONTINUE
         M = M + M
         IF (M .LT. N) GO TO 110
C
      CALL CFFT2 (1, -1, M, A, WRK, A)
C
      N2 = N + N
      M2 = M + M
      RM = 1.0 / FLOAT( M )
C
  200 CONTINUE
C     IF (M .GT. N) A(N2+1:M2) = 0.0
      IF (M .GT. N) call vclr(a(n2+1),1,m2-n2+1+1)
C
      CALL CFFT2 (0, -1, M, A, WRK, A)
C
      DO 210 I = 1, M2
         A(I) = RM * A(I) * B(I)
  210 CONTINUE
C
      CALL CFFT2 (0,  1, M, A, WRK, A)
C
      RETURN
      END
C********************************************************************C
C NAME: XDCIMC   DOWNWARD CONTINUE & IMAGE       REV 1.0     MAR 87   C
C********************************************************************C
C
C  PURPOSE:
C       DOWNWARD CONTINUES THE INCIDENT AND REFLECTED WAVE FIELDS AND
C       COMPUTES THE AUTO AND CROSS CORRELATIONS (IMAGES).  THE FIELDS
C       ARE OPTIONALLY FILTERED AT PERIODIC INTERVALS.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                MAR 87          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
cv7
c           CALL XDCIMC (NA,na2, NX, NZ, JW, MSK, IMG, KFF, FINC, FRFL,
c    &                  gtr1, gtr2, gxr1, gxr2,
c    &                  ivp, ivv, ixp, ixx, cinc, crfl,
c    &                  wci1, wci2, wcr1, wcr2, wfft, rii, rri,
c    &                  str1, str2, sxr1, sxr2,
c    &                  ivp2, ivv2, ixp2, ixx2,
c    &                  wvwk1, wvwk2, izskp ,ixtap ,izs, mskbig,
c    &                  pwpr,pwnr,pwni,pwpi,nalarg)
cv7
C  PARAMETERS:
C
C       NA      INTEGER INPUT SCALAR
C               NUMBER OF APERTURES.
C
C       NA2     INTEGER INPUT SCALAR
C               NUMBER OF APERTURES.
C
C       NX      INTEGER INPUT SCALAR
C               NUMBER OF X'S.
C
C       NZ      INTEGER INPUT SCALAR
C               NUMBER OF Z'S.
C
C       JW      INTEGER INPUT SCALAR
C               FREQUENCY INDEX.
C
C       MSK     INTEGER INPUT SCALAR
C               APERTURE SKIP VALUE.
C
C       IMG     INTEGER INPUT SCALAR
C               IMAGING FLAG.
C
C       KFF     INTEGER INPUT SCALAR
C               FILTER FREQUENCY.
C
C       FINC    COMPLEX INPUT VECTOR OF LENGTH NX
C               INCIDENT  WAVE FIELD FILTER.
C
C       FRFL    COMPLEX INPUT VECTOR OF LENGTH NX
C               REFLECTED WAVE FIELD FILTER.
C
C       GTR1    REAL INPUT MATRIX OF DIMENSION NA X NV
C               REAL COMPONENTS OF REFLECTED GREEN'S FUNCTION TABLE.
C
C       GTR2    REAL INPUT MATRIX OF DIMENSION NA X NV
C               IMAGINARY COMPONENTS OF REFLECTED GREEN'S FUNCTION TABLE.
C
C       GXR1    REAL SCRATCH MATRIX OF DIMENSION MX X NA
C               REAL COMPONENTS OF REFLECTED GREEN'S FUNCTION MATRIX.
C
C       GXR2    REAL SCRATCH MATRIX OF DIMENSION MX X NA
C               IMAG. COMPONENTS OF REFLECTED GREEN'S FUNCTION MATRIX.
C
C       IVP     INTEGER INPUT VECTOR OF LENGTH NZ + 1
C               VELOCITY INDEX POINTER VECTOR. (SEE XGENIX)
C
C       IVV     INTEGER INPUT VECTOR OF IMPLIED LENGTH
C               VELOCITY INDEX VALUE VECTOR. (SEE XGENIX)
C
C       IXP     INTEGER INPUT VECTOR OF IMPLIED LENGTH
C               X INDEX POINTER VECTOR. (SEE XGENIX)
C
C       IXX     INTEGER INPUT VECTOR OF IMPLIED LENGTH
C               X INDEX VALUE VECTOR. (SEE XGENIX)
C
C       CINC    COMPLEX INPUT/OUTPUT VECTOR OF LENGTH NX
C               INCIDENT  WAVE FIELD.
C
C       CRFL    COMPLEX INPUT/OUTPUT VECTOR OF LENGTH NX
C               REFLECTED WAVE FIELD.
C
C       WCI1    REAL SCRATCH VECTOR OF LENGTH NX
C               REAL COMPONENTS OF INCIDENT WAVE FIELD.
C
C       WCI2    REAL SCRATCH VECTOR OF LENGTH NX
C               IMAGINARY COMPONENTS OF INCIDENT WAVE FIELD.
C
C       WCR1    REAL SCRATCH VECTOR OF LENGTH NX
C               REAL COMPONENTS OF REFLECTED WAVE FIELD.
C
C       WCR2    REAL SCRATCH VECTOR OF LENGTH NX
C               IMAGINARY COMPONENTS OF REFLECTED WAVE FIELD.
C
C       WFFT    REAL SCRATCH VECTOR OF LENGTH 5 * LX
C               FFT TABLES.  NOTE: LX = 2**K SUCH THAT
C               2**(K-1) < NX <= 2**K.
C
C       RII     REAL INPUT/OUTPUT MATRIX OF DIMENSION NX X NZ
C               ZERO LAG AUTO  CORRELATION. (dummy in the cmp code)
C
C       RRI     REAL INPUT/OUTPUT MATRIX OF DIMENSION NX X NZ
C               ZERO LAG CROSS CORRELATION.
C
cv6
C       str1    REAL INPUT vector OF DIMENSION nv
C               real part of statics Green's function
C
C       str2    REAL INPUT vector OF DIMENSION nv
C               imaginary part of statics Green's function
C
cv6
C
C  DESCRIPTION:
C       XDCIMC IS DESCRIBED BY THE FOLLOWING PSEUDO CODE:
C
C       IF JW = 1, CLEAR RRI
C       IF KFF > 0, FILTER CRFL
C
C       NF = KFF
C       DO JZ = 1, NZ
C          DOWNWARD CONTINUE CRFL
C          NF = NF - 1
C          IF NF = 0, FILTER CRFL, NF = KFF
C          RRI(JZ) = RRI(JZ) + REAL(CRFL)
C       END DO
C
C  SUBPROGRAMS CALLED:
C       XCFILT, CGXBLD, FXCONT
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
cv7
      subroutine XDCIMC (NA,na2, NX, NZ, JW, MSK, IMG, KFF, FINC, FRFL,
     &                  gtr1, gtr2, gxr1, gxr2,
     &                  ivp, ivv, ixp, ixx, cinc, crfl,
     &                  wci1, wci2, wcr1, wcr2, wfft, rii, rri,
     &                  str1, str2, sxr1, sxr2,
     &                  ivp2, ivv2, ixp2, ixx2,
     &                  wvwk1, wvwk2, izskp , ixtap ,izs ,mskbig,
     &                  pwpr,pwnr,pwni,pwpi,nalarg )
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
cv7
C
      INTEGER NA, na2, NX, NZ, JW, MSK, IMG, KFF, IVP(*), IVV(*),
     &        IXP(*), IXX(*) , ivp2(*), ivv2(*), ixp2(*), ixx2(*)
      REAL    FINC(*), FRFL(*), CINC(*), CRFL(*), RII(*), RRI(*),
     &        GTR1(*), GTR2(*), gxr1(*), gxr2(*),
     &        WCI1(*), WCI2(*), WCR1(*), WCR2(*), WFFT(*)
      real xramp(1000)
      data xramp/1000*0./
cv7
      real str1(*), str2(*) , sxr1(*) ,sxr2(*)
      real wvwk1(*), wvwk2(*)

      pointer(pwpr,wpr),(pwnr,wnr),(pwni,wni),(pwpi,wpi) 
C
C---------------------------------------------------------------------
      logical first
      data first/.true./
      save first
   
      if(first)then
      first = .false.
      jerr = 0
      iabort = 0
CMAT  na2use = max0(na,na2)
      isize = (nx+(nalarg)*mskbig) * ISZBYT
      call galloc(pwpr, isize, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'error allocating work space: ', jerr
         stop
      endif
      jerr = 0
      iabort = 0
      call galloc(pwpi, isize, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'error allocating work space: ', jerr
         stop
      endif
      jerr = 0
      iabort = 0
      call galloc(pwnr, isize, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'error allocating work space: ', jerr
         stop
      endif
      jerr = 0
      iabort = 0
      call galloc(pwni, isize, jerr, iABORT )
      if ( jerr .ne. 0 .or. iabort.ne.0) then
         write(ler,*)'error allocating work space: ', jerr
         stop
      endif
      endif

c    if first omega build boundary ramp
      if(jw .eq. 1 .and. ixtap.gt.0 ) then
       xtap = ixtap + 1
       ytap = 1./ xtap
       do 9089 jx = 1,ixtap
 9089 xramp(jx) = (jx*ytap)**.05
      endif

      NXZ = NX * NZ
      NX2 = NX + NX
      MX  = NX
      IF (MOD( NX, 2 ) .EQ. 0) MX = NX + 1
C
CCC   IF FIRST OMEGA, CLEAR RRI
C
      IF (JW .EQ. 1) THEN
         CALL VCLR (RRI, 1, NXZ)
      ENDIF
C
CCC   IF KFF > 0, FILTER THE WAVE FIELDS
cvf3
      IF (KFF .GT. 0 .and. izs.eq. 1) THEN
         CALL XCFILT (CRFL, FRFL, WFFT, NX, 1)
      ENDIF
C
CCC   DOWNWARD CONTINUE AND IMAGE WAVES FOR EACH Z
C
      CALL VMOV (CRFL(1), 2, WCR1, 1, NX)
      CALL VMOV (CRFL(2), 2, WCR2, 1, NX)
C
cv6
      ncont = 1
      nf0 = (kff+izskp-1)/izskp
      nf = nf0
      KZ = 1 - NX
      DO 130 JZ = 1, NZ
         KZ = KZ + NX
C
         CALL CGXBLD (NA, MX, JZ, IVP, IVV, IXP, IXX, GTR1, GTR2,
     &                GXR1, GXR2)
         CALL CGXBLD (NA2, MX, JZ,ivp2,ivv2,ixp2,ixx2, str1, str2,
     &                sxr1, sxr2)
C

cv6      if static upward continuation required, save wavefield
         if(izskp.gt.1 .and. ncont.eq.1) then
          call vmov(wcr1, 1, wvwk1, 1, nx)
          call vmov(wcr2, 1, wvwk2, 1, nx)
         endif

cv6      static upward continuation
         if(ncont.lt.izskp) then
         CALL FXCONT (sxr1, sxr2, WCR1, WCR2, NA2, NX, 1, MSK, MX,
     &                wpr, wpi, wnr, wni)
         endif
cv6      if static upward continuation applied, restore wavefield
         if(izskp.eq.ncont .and. izskp.gt.1) then
          call vmov(wvwk1, 1, wcr1, 1, nx)
          call vmov(wvwk2, 1, wcr2, 1, nx)
         endif

cv6
      if(ncont.eq.izskp) then

C        ramp data at sides of grid
         if(ixtap.gt.0) then
         do 9090 jx = 1,ixtap
         wcr1(jx)= wcr1(jx)*xramp(jx)
         wcr2(jx)= wcr2(jx)*xramp(jx)
         wcr1(nx-jx+1) = wcr1(nx-jx+1)*xramp(jx)
 9090    wcr2(nx-jx+1) = wcr2(nx-jx+1)*xramp(jx)
         endif


         CALL FXCONT (GXR1, GXR2, WCR1, WCR2, NA, NX, 1, MSK, MX,
     &                wpr, wpi, wnr, wni)

         NF = NF - 1
         IF (NF .EQ. 0) THEN
cv6
            NF = nf0
            CALL VMOV (WCR1, 1, CRFL(1), 2, NX)
            CALL VMOV (WCR2, 1, CRFL(2), 2, NX)
            CALL XCFILT (CRFL, FRFL, WFFT, NX, 0)
            CALL VMOV (CRFL(1), 2, WCR1, 1, NX)
            CALL VMOV (CRFL(2), 2, WCR2, 1, NX)
         ENDIF
C
      endif
cv6
         J = KZ
         DO 110 I = 1, NX
            RRI(J) = RRI(J) + WCR1(I)
            J = J + 1
  110    CONTINUE
C

      ncont = ncont + 1
      if(ncont.gt.izskp) ncont = 1

  130 CONTINUE
C
      CALL VMOV (WCR1, 1, CRFL(1), 2, NX)
      CALL VMOV (WCR2, 1, CRFL(2), 2, NX)
C
      RETURN
      END
C********************************************************************C
C NAME: XGENIX  GENERATE COMPRESSED INDEX DATA  REV 1.0     MAR 87   C
C********************************************************************C
C
C  PURPOSE:
C       GENERATES THE COMPRESSED INDEX DATA STRUCTURE GIVEN THE
C       INDEX MATRIX.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                MAR 87          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL XGENIX (NX, NZ, INDEX, ITEMP, IVP, IVV, IXP, IXX)
C
C  PARAMETERS:
C       NX      INTEGER INPUT SCALAR
C               NUMBER OF X'S.
C
C       NZ      INTEGER INPUT SCALAR
C               NUMBER OF Z'S.
C
C       INDEX   INTEGER INPUT MATRIX OF DIMENSION NX BY NZ
C
C       ITEMP   INTEGER SCRATCH VECTOR OF LENGTH NX
C
C       IVP     INTEGER OUTPUT VECTOR OF LENGTH NZ + 1
C               VELOCITY INDEX POINTER VECTOR.
C
C       IVV     INTEGER OUTPUT VECTOR OF IMPLIED LENGTH
C               VELOCITY INDEX VALUE VECTOR.
C
C       IXP     INTEGER OUTPUT VECTOR OF IMPLIED LENGTH
C               X INDEX POINTER VECTOR.
C
C       IXX     INTEGER OUTPUT VECTOR OF IMPLIED LENGTH
C               X INDEX VALUE VECTOR.
C
C  DESCRIPTION:
C       GIVEN THE NX BY NZ INDEX MATRIX, XGENIX GENERATES THE
C       COMPRESSED INDEX DATA STRUCTURE: IVP, IVV, IXP, AND IXX.
C       THE COMPRESSED DATA STRUCTURE CONTAINS COMPLETE INDEX INFOR-
C       MATION FOR IZ = 1.  IF IZ > 1, THEN IT ONLY CONTAINS DATA
C       ON DIFFERENCES BETWEEN THE INDICES AT IZ-1 AN IZ.
C
C       THE VECTOR IVP CONTAINS POINTERS INTO THE VECTORS IVV AND
C       IXP.  GIVEN A Z INDEX, IZ, THE DATA IN IVV AND IXP THAT IS
C       ASSOCIATED WITH THAT Z IS CONTAINED IN ELEMENTS J1 = IVP(IZ)
C       THROUGH J2 = IVP(IZ+1)-1.  IF IVP(IZ) = IVP(IZ+1), THEN
C       THERE ARE NO DIFFERENCES BETWEEN THE INDICES AT IZ-1 AND IZ.
C       IVP(NZ+1) POINTS TO THE LAST ELEMENT PLUS ONE IN IVV AND IXP.
C
C       THE VECTOR IVV CONTAINS VALUES OF VELOCITY INDICES AND THE
C       CORRESPONDING ELEMENTS IN IXP CONTAINS POINTERS INTO IXX
C       WHICH CONTAINS LISTS OF X INDICES THAT HAVE THE VELOCITY
C       INDEX.  THAT IS, THE ELEMENTS IXX(I1) THROUGH IXX(I2)
C       WHERE I1 = IXP(J) AND I2 = IXP(J+1)-1 ARE X INDICES WHICH
C       HAVE THE VELOCITY INDEX IVV(J).
C
C       EXAMPLE:
C          GIVEN THE INPUTS:
C             NX = 10
C             NZ =  4
C
C             TRANSPOSE( INDEX ) =  2 2 4 4 4 2 3 3 1 4
C                                   2 2 2 4 2 2 3 3 3 4
C                                   2 2 2 4 2 2 3 3 3 4
C                                   2 2 2 2 2 2 3 3 3 3
C
C          THEN THE OUTPUTS ARE:
C
C             I   IVP(I)   IVV(I)   IXP(I)   IXX(I)
C
C             1      1        2        1        1
C             2      5        4        4        2
C             3      7        3        8        6
C             4      7        1       10        3
C             5      9        2       11        4
C             6               3       13        5
C             7               2       14       10
C             8               3       15        7
C             9                       16        8
C            10                                 9
C            11                                 3
C            12                                 5
C            13                                 9
C            14                                 4
C            15                                10
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE XGENIX (NX, NZ, INDEX, ITEMP, IVP, IVV, IXP, IXX)
C
      INTEGER NX, NZ, INDEX(NX,NZ), ITEMP(NX),
     &        IVP(*), IVV(*), IXP(*), IXX(*)
C
C-----------------------------------------------------------------------
C
      II = 0
      KK = 0
      DO 300 IZ = 1, NZ
         IVP(IZ) = KK + 1
C
         DO 110 I = 1, NX
            ITEMP(I) = INDEX(I,IZ)
  110    CONTINUE
C
         I1 = 1
         IF (IZ .EQ. 1) GO TO 200
C
         DO 120 I = 1, NX
            IF (INDEX(I,IZ) .EQ. INDEX(I,IZ-1)) ITEMP(I) = 0
  120    CONTINUE
C
  200    CONTINUE
         DO 210 I = I1, NX
            IF (ITEMP(I) .NE. 0) GO TO 220
  210    CONTINUE
         GO TO 300
C
  220    CONTINUE
         I1 = I
         JV = ITEMP(I1)
         ITEMP(I1) = 0
         II = II + 1
         IXX(II) = I1
         KK = KK + 1
         IVV(KK) = JV
         IXP(KK) = II
         DO 230 I = I1, NX
            IF (ITEMP(I) .EQ. JV) THEN
               ITEMP(I) = 0
               II = II + 1
               IXX(II) = I
            ENDIF
  230    CONTINUE
         GO TO 200
C
  300 CONTINUE
C
      IVV(KK+1) = 0
      IXP(KK+1) = II + 1
      IVP(NZ+1) = KK + 1
C
      RETURN
      END
C********************************************************************C
C NAME: FRRST   REFLECT., RESAMPLE, & TRANSPOSE REV 1.0     MAY 86   C
C********************************************************************C
C
C  PURPOSE:
C       FORTRAN EQUIVALENT OF THE ST-100 PROCESS PRRST.
C       GIVEN THE AUTO CORRELATION OF THE INCIDENT WAVE FIELD (RII)
C       AND THE CROSS CORRELATION BETWEEN THE INCIDENT AND REFLECTED
C       WAVE FIELDS (RRI), FRRST COMPUTES THE RELECTIVELY THEN
C       RESAMPLES AND TRANPOSES IT TO PRODUCE THE OUTPUT IMAGE.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                MAY 86          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL FRRST (NX, NZ, NXLN1, IZLN, JZB, IMG, PARM, RII, RRI,
C      &            RIMAGE)
C
C  PARAMETERS:
C       NX      INTEGER INPUT SCALAR
C               NUMBER OF X'S - ROW DIMENSION OF INPUT MATRICES.
C
C       NZ      INTEGER INPUT SCALAR
C               NUMBER OF Z'S - COLUMN DIMENSION OF INPUT MATRICES.
C
C       NXLN1   INTEGER INPUT SCALAR
C               COLUMN DIMENSION OF OUTPUT MATRIX.
C
C       IZLN    INTEGER INPUT SCALAR
C               ROW DIMENSION OF OUTPUT MATRIX.
C
C       JZB     INTEGER INPUT SCALAR
C               OFFSET INTO THE OUTPUT MATRIX.
C
C       IMG     INTEGER INPUT SCALAR
C               IMAGE FLAG.  IF IMG = 0, THEN THE REFLECTIVITY IS
C               COMPUTED AND RESAMPLED; OTHERWISE, THE CROSS
C               CORRELATION IS RESAMPLED.
C
C       PARM    REAL INPUT ARRAY OF LENGTH 3
C               PARM(1) = INPUT DELTA X
C               PARM(2) = OUTPUT DELTA X
C               PARM(3) = EPSILON
C
C       RII     REAL INPUT MATRIX OF DIMENSION NX BY NZ
C               AUTO CORRELATION OF THE INCIDENT WAVE FIELD.
C
C       RRI     REAL INPUT MATRIX OF DIMENSION NX BY NZ
C               CROSS CORRELATION BETWEEN THE INCIDENT AND REFLECTED
C               WAVE FIELDS.
C
C       RIMAGE  REAL OUTPUT MATRIX OF DIMENSION IZLN BY NXLN1
C               OUTPUT IMAGE.
C
C  DESCRIPTION:
C       IF IMG = 0, THE REFLECTIVITY IS COMPUTED BY
C          REF(I,J) = RRI(I,J) / (RII(I,J) + EPSILON), I=1,NX, J=1,NX
C       IF IMG # 0, THEN THE CROSS CORRELATION IS USED IN PLACE OF THE
C       REFLECTIVITY (OR REF(I,J) = RRI(I,J)).  EACH COLUMN OF REF IS
C       THEN RESAMPLED TO PRODUCE NXLN1 VALUES PER COLUMN.  FINALLY,
C       THE TRANSPOSE OF THE RESAMPLED REF IS STORED INTO A SUBMATRIX
C       OF RIMAGE BEGINING AT RIMAGE(1+JZB,1).
C
C       WARNING: THE CONTENTS OF RII AND RRI ARE DESTROYED BY THIS
C                ROUTINE.
C
C  SUBPROGRAMS CALLED:
C       MATH ADVANTAGE: VADD, VDIV
C       OTHERS        : FRSMP
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE frrst (NX, NZ, NXLN1, IZLN, JZB, IMG, PARM,
     &                  RII, RRI, RIMAGE)
C
      REAL    PARM(3), RII(*), RRI(*), RIMAGE(*)
C
C --------------------------------------------------------------------
C
C     IF IMG = 0, THEN COMPUTE REFLECTIVITY
C
      IF (IMG .EQ. 0) THEN
         NXZ = NX * NZ
         CALL VADD (RII, 1, PARM(3), 0, RII, 1, NXZ)
         CALL VDIV (RRI, 1, RII, 1, RRI, 1, NXZ)
      ENDIF
C
C     RESAMPLE AND TRANSPOSE
C
      IFLAG = 0
      JXZ   = 1
      DO 120 JZ = 1, NZ
         CALL FRSMP (RRI(JXZ), 1, NX, RIMAGE(JZ+JZB), IZLN, NXLN1,
     &               PARM, RII, RII(NXLN1+1), IFLAG)
         IFLAG = 1
         JXZ   = JXZ + NX
  120 CONTINUE
C
      RETURN
      END
C********************************************************************C
C NAME: FRSMP   REAL RESAMPLE                   REV 1.0     MAY 86   C
C********************************************************************C
C
C  PURPOSE:
C       FORTRAN EQUIVALENT OF THE ST-100 PROCESS PRSMP.
C       LINEARLY RESAMPLES YI TO YO WITH CORRESPONDING STEPS OF
C       DX(1) AND DX(2).
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                MAY 86          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL FRSMP (YI, IYI, NI, YO, IYO, NO, DX, IX, XX, IFLAG)
C
C  PARAMETERS:
C       YI      REAL INPUT VECTOR (IMPLIED LENGTH)
C               SOURCE VECTOR.
C
C       IYI     INTEGER INPUT SCALAR
C               STRIDE FOR YI.
C
C       NI      INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR YI.
C
C       YO      REAL OUTPUT VECTOR (IMPLIED LENGTH)
C               RESULT VECTOR.
C
C       IYO     INTEGER INPUT SCALAR
C               STRIDE FOR YO.
C
C       NO      INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR YO.
C
C       DX      REAL INPUT VECTOR OF LENGTH 2
C               DX(1) AND DX(2) CONTAIN THE X STEP SIZES FOR YI AND YO
C               RESPECTIVELY.
C
C       IX      INTEGER INPUT/OUTPUT VECTOR OF LENGTH NO
C               INDEX VECTOR (NOT USED IN THE ST-100 VERSION).
C
C       XX      REAL INPUT/OUTPUT VECTOR OF LENGTH NO
C               X REMAINER VECTOR (NOT USED IN THE ST-100 VERSION).
C
C       IFLAG   INTEGER INPUT SCALAR
C               INITIALIZATION FLAG (NOT USED IN THE ST-100 VERSION).
C               IF IFLAG = 0, THEN IX AND XX ARE COMPUTED; OTHERWISE,
C               IX AND XX ARE ASSUMED TO BE INITIALIZED.  WHENEVER
C               NEW VALUES OF NI, NO, IYI, AND DX ARE USED, IFLAG MUST
C               BE 0.
C
C  DESCRIPTION:
C       GIVEN A SET OF (X,Y) COORDINATES (XI,YI), FRSMP PERFORMS A
C       LINEAR INTERPOLATION TO OBTAIN AN OUTPUT SET OF (X,Y)
C       COORDINATES (XO,YO).  THE VALUES OF XI AND XO ARE IMPLIED
C       SINCE BOTH ARE UNIFORMLY SPACED BY DX(1) AND DX(2)
C       RESPECTIVELY AND XI(1) = XO(1).
C
C       THE CONTENTS OF IX AND XX ARE GIVEN BY
C          IX(I) = 1 + IYI * IFIX( (I-1)*DX(2)/DX(1) )
C          XX(I) = (I-1)*DX(2)/DX(1) - IFIX( (I-1)*DX(2)/DX(1) )
C       THESE VECTORS ARE COMPUTED WHEN IFLAG = 0 AND CAN THEN USED IN
C       SUBSEQUENT CALLS TO FRSMP SO LONG AS NI, NO, IYI, AND DX
C       DO NOT CHANGE.
C
C  SUBPROGRAMS CALLED:
C       FORTRAN INTRINSICS: FLOAT, IFIX
C       MATH ADVANTAGE    : VMOV
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE frsmp (YI, IYI, NI, YO, IYO, NO, DX, IX, XX, IFLAG)
C

      REAL    YI(*), YO(*), DX(2), XX(NO)
      INTEGER IYI, NI, IYO, NO, IX(NO)
C
C---------------------------------------------------------------------
C
C
      IF (DX(2) .EQ. DX(1)) GO TO 100
      IF (IFLAG .EQ.     0) GO TO 200
      GO TO 300
C
C     EQUAL STEP SIZES - JUST MOVE DATA, PAD IF NECESSARY
C
  100 CONTINUE
      IF (NO .LE. NI) THEN
         CALL VMOV (YI, IYI, YO, IYO, NO)
      ELSE
         LASTI = 1 + IYI * (NI - 1)
         CALL VMOV (YI, IYI, YO, IYO, NI)
         CALL VMOV (YI(LASTI), 0, YO(IYO*NI+1), IYO, NO-NI)
      ENDIF
C
      GO TO 800
C
C     COMPUTE INDEX AND SCALING ARRAYS (IX AND XX) IF IFLAG = 0
C
  200 CONTINUE
      LASTI = 1 + IYI * (NI - 1)
      X     = 0.0
      STEP  = DX(2) / DX(1)
      IX(1) = 1
      XX(1) = 0.0
      DO 210 I = 2, NO
         X     = X + STEP
         JX    = IFIX( X )
         IX(I) = 1 + IYI * JX
         XX(I) = X - FLOAT( JX )
         IF (IX(I) .GE. LASTI) GO TO 220
  210 CONTINUE
      GO TO 300
C
  220 CONTINUE
      I1 = I
      DO 230 I = I1, NO
         IX(I) = LASTI - IYI
         XX(I) = 1.0
  230 CONTINUE
C
C     COMPUTE LINEAR INTERPOLATION
C
  300 CONTINUE
      K = 1
      YO(K) = YI(1)
      DO 310 I = 2, NO
         J = IX(I)
         K = K + IYO
         YO(K) = YI(J) + (YI(J+IYI) - YI(J)) * XX(I)
  310 CONTINUE
C
  800 CONTINUE
      RETURN
      END
c     nrfft -- computes next mixed radix integer for rfftm
      FUNCTION NRFFT (N)
C
      PARAMETER (MAX = 248)
C
      INTEGER NUM(MAX), IFAC(30)
C
      DATA (NUM(I), I = 1, 190) /
     &        2,    4,    6,    8,   10,   12,   14,   16,   18,   20,
     &       24,   28,   30,   32,   36,   40,   42,   48,   50,   54,
     &       56,   60,   64,   70,   72,   80,   84,   90,   96,   98,
     &      100,  108,  112,  120,  126,  128,  140,  144,  150,  160,
     &      162,  168,  180,  192,  196,  200,  210,  216,  224,  240,
     &      250,  252,  256,  270,  280,  288,  294,  300,  320,  324,
     &      336,  350,  360,  378,  384,  392,  400,  420,  432,  448,
     &      450,  480,  486,  490,  500,  504,  512,  540,  560,  576,
     &      588,  600,  630,  640,  648,  672,  686,  700,  720,  750,
     &      756,  768,  784,  800,  810,  840,  864,  882,  896,  900,
     &      960,  972,  980, 1000, 1008, 1024, 1050, 1080, 1120, 1134,
     &     1152, 1176, 1200, 1250, 1260, 1280, 1296, 1344, 1350, 1372,
     &     1400, 1440, 1458, 1470, 1500, 1512, 1536, 1568, 1600, 1620,
     &     1680, 1728, 1750, 1764, 1792, 1800, 1890, 1920, 1944, 1960,
     &     2000, 2016, 2048, 2058, 2100, 2160, 2240, 2250, 2268, 2304,
     &     2352, 2400, 2430, 2450, 2500, 2520, 2560, 2592, 2646, 2688,
     &     2700, 2744, 2800, 2880, 2916, 2940, 3000, 3024, 3072, 3136,
     &     3150, 3200, 3240, 3360, 3402, 3430, 3456, 3500, 3528, 3584,
     &     3600, 3750, 3780, 3840, 3888, 3920, 4000, 4032, 4050, 4096/
      DATA (NUM(I), I = 191, 248) /
     &     4116, 4200, 4320, 4374, 4410, 4480, 4500, 4536, 4608, 4704,
     &     4800, 4802, 4860, 4900, 5000, 5040, 5120, 5184, 5250, 5292,
     &     5376, 5400, 5488, 5600, 5670, 5760, 5832, 5880, 6000, 6048,
     &     6144, 6174, 6250, 6272, 6300, 6400, 6480, 6720, 6750, 6804,
     &     6860, 6912, 7000, 7056, 7168, 7200, 7290, 7350, 7500, 7560,
     &     7680, 7776, 7840, 7938, 8000, 8064, 8100, 8192/
C
C-----------------------------------------------------------------------
C
      IF (N .GT. NUM(MAX)) GO TO 200
C
      I1 = 0
      I2 = MAX
  100 CONTINUE
      I = (I1 + I2) / 2
      M = NUM(I)
      IF      (M .LT. N) THEN
         I1 = I
      ELSE IF (M .GT. N) THEN
         I2 = I
      ELSE
         GO TO 800
      ENDIF
      IF (I2 .GT. I1+1) GO TO 100
C
      M = NUM(I2)
      GO TO 800
C
  200 CONTINUE
      M = N - 2
      IF (MOD(M,2) .EQ. 1) M = M + 1
  210 CONTINUE
         M = M + 2
         CALL NRFFTF (M, IFAC, NF)
         IF (NF .EQ. 0) GO TO 210
C
  800 CONTINUE
      NRFFT = M
C
      RETURN
      END
C
C=======================================================================
C
        SUBROUTINE NRFFTF (N, NFAC, M)
C
        INTEGER NFAC(*)
        INTEGER N, M, NTMP
C
        NTMP = N
        M = 0
C
10      IF ((NTMP/2)*2 .NE. NTMP) GOTO 20
                NTMP = NTMP / 2
                M = M + 1
                NFAC(M) = 2
                GOTO 10
C
20      IF ((NTMP/3)*3 .NE. NTMP) GOTO 30
                NTMP = NTMP / 3
                M = M + 1
                NFAC(M) = 3
                GOTO 20
C
30      IF ((NTMP/5)*5 .NE. NTMP) GOTO 40
                NTMP = NTMP / 5
                M = M + 1
                NFAC(M) = 5
                GOTO 30
C
40      IF ((NTMP/7)*7 .NE. NTMP) GOTO 50
                NTMP = NTMP / 7
                M = M + 1
                NFAC(M) = 7
                GOTO 40
C
50      IF (NTMP .EQ. 1) RETURN
C
        M = 0
        RETURN
C
        END
      SUBROUTINE RFFTMR(A, INC, N, IFLG, IWRK, RWRK)
C
      INTEGER INC, N, IFLG, IWRK(*), IFAC(30)
      REAL    A(*), RWRK(*), CNST(11)
C
      SAVE LN, LINC, LFLG, NF, NP, N2, N4, I1, I2, I3, I4, CNST, IFAC
C
      DATA LN / 0 /
C
C-----------------------------------------------------------------------
C
      IF (N .LE. 0 .OR. INC .LE. 0) GO TO 800
C
      JFLG = -1
      IF (IFLG .GE. 0) JFLG = 1
C
      IF (N    .NE. LN  ) GO TO 100
      IF (INC  .NE. LINC) GO TO 100
      IF (JFLG .NE. LFLG) GO TO 200
      GO TO 300
C
  100 CONTINUE
      LN = 0
      N2 = N / 2
      N4 = N / 4
      IF (N2 + N2 .LT. N) GO TO 800
C
      I1 = 1
      I2 = I1 + N2
      I3 = I2 + N2
      I4 = I3 + N4
C
      CALL GGRFFT (INC, N, JFLG, IFAC, NF, CNST, RWRK(I1), RWRK(I2),
     &             RWRK(I3), RWRK(I4), IWRK(I1), IWRK(I2), NP)
      IF (NF .EQ. 0) GO TO 800
C
      LN   = N
      LINC = INC
      LFLG = JFLG
      GO TO 300
C
  200 CONTINUE
      LFLG = JFLG
      DO 210 I = 1, N2
         RWRK(I) = - RWRK(I)
  210 CONTINUE
      DO 220 I = 1, 11, 2
         CNST(I) = - CNST(I)
  220 CONTINUE
      DO 230 I = I4, I4+N4-1
         RWRK(I) = - RWRK(I)
  230 CONTINUE
C
  300 CONTINUE
      CALL FGRFFT (A, INC, N, JFLG, IFAC, NF, CNST, RWRK(I1), RWRK(I2),
     &             RWRK(I3), RWRK(I4), IWRK(I1), IWRK(I2), NP)
C
  800 CONTINUE
      RETURN
      END
C********************************************************************C
C NAME: FGRFFT  REAL GENERAL FFT                REV 1.0     DEC 86   C
C********************************************************************C
C
C  PURPOSE:
C       COMPUTES THE FORWARD OR INVERSE IN-PLACE FFT OF A REAL
C       ARRAY WITH LENGTH FACTORABLE BY 2, 3, 5, AND/OR 7.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C
C  CALLING FORMAT:
C       CALL FGRFFT (A, INC, N, IFLG, NFAC, M, CNST, STABLE,
C                    CTABLE, SRTAB, CRTAB, ISRC, IDST, NPERM)
C
C  PARAMETERS:
C
C       A       REAL INPUT/OUTPUT ARRAY OF LENGTH N.
C
C       INC     INTEGER INPUT SCALAR
C               STRIDE OF ARRAY A, MUST BE POSITIVE.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF ARRAY A, MUST BE EVEN.
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORM, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       NFAC    INTEGER INPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N/2.
C
C       M       INTEGER INPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C       CNST    REAL INPUT ARRAY OF LENGTH 11
C               CONSTANTS, DEPENDENT ON IFLG.
C
C       STABLE  REAL INPUT ARRAY OF LENGTH N/2
C               SINE TWIDDLE FACTORS, DEPENDENT
C               ON IFLG.
C
C       CTABLE  REAL INPUT ARRAY OF LENGTH N/2
C               COSINE TWIDDLE FACTORS.
C
C       SRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               SINE VALUES FOR RGSCR.
C
C       CRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               COSINE VALUES FOR RGSCR.
C
C       ISRC    INTEGER INPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       IDST    INTEGER INPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       NPERM   INTEGER INPUT SCALAR
C               NUMBER OF INDICIES IN ISRC AND IDST,
C               ALWAYS LESS THAN N/2.
C
C  DESCRIPTION:
C       THIS ROUTINE COMPUTES THE IN-PLACE FORWARD OR INVERSE
C       FAST FOURIER TRANSFORM OF A REAL ARRAY.  THE LENGTH OF
C       THE ARRAY, N, MUST BE EVEN AND FACTORABLE BY THE PRIME
C       FACTORS 2, 3, 5, AND/OR 7.  THE TRANFORM IS PERFORMED
C       IN PLACE USING PRE-COMPUTED SINE, COSINE, FACTOR,
C       CONSTANT, AND PERMUTATION TABLES.  THE TABLES ARE UNIQUE
C       FOR EACH VALUE OF N, INC, AND IFLG.
C
C       THE REAL TRANSFORM IS COMPUTED USING A COMPLEX FFT OF
C       LENGTH N/2 AND A REAL/COMPLEX SCRAMBLE ALGORITHM.  FOR AN
C       EXPLANATION OF THIS TECHNIQUE SEE E.O. BRIGHAM, "THE FAST
C       FOURIER TRANSFORM", PRENTICE-HALL, 1974, PP. 167-169.
C       THE COMPLEX FFT IS COMPUTED USING FGCFFT, A MIXED RADIX FFT
C       ROUTINE.  SEE THE HEADER OF FGCFFT FOR A DESCRIPTION AND
C       REFERENCES TO THE COMPLEX FFT ALGORITHM.  THE SUBROUTINE
C       THAT COMPUTES THE REAL/COMPLEX SCRAMBLE PASS IS NAMED
C       RGSCR.  SEE THE HEADER OF THAT ROUTINE FOR DETAILS OF THE
C       ALGORITHM.
C
C       THE DESIGN STRATEGY FOR THIS ROUTINE ASSUMES THAT IT WILL BE
C       CALLED MANY TIMES WITH THE SAME VALUES OF N, INC, AND IFLG,
C       SO THAT THE OVERHEAD ASSOCIATED WITH CREATING THE TABLES IS
C       INSIGNIFICANT.  SEE THE ROUTINE GGRFFT FOR THE TABLE
C       INITIALIZATION ALGORITHMS.
C
C       THE DISCRETE FOURIER TRANSFORM OF A REAL ARRAY OF LENGTH N IS
C       A COMPLEX ARRAY OF LENGTH N.  SINCE THE REAL ARRAY ONLY
C       OCCUPIES N STORAGE LOCATIONS, THERE IS ONLY ROOM FOR HALF OF
C       THE COMPLEX RESULT WHEN THE TRANSFORM IS COMPUTED IN PLACE.
C       FORTUNATELY THE TRANSFORM OF A REAL ARRAY IS HERMITIAN.  THE
C       NEGATIVE FREQUENCY COEFFICIENTS THAT FILL THE LAST HALF OF
C       THE ARRAY ARE THE COMPLEX CONJUGATES OF THE POSITIVE
C       FREQUENCY COMPONENTS.  ALSO, THE COMPONENTS AT ZERO FREQUENCY
C       AND AT THE NYQUIST POINT ARE PURELY REAL.  THIS ALLOWS US TO
C       PACK THE RESULTS OF A FORWARD REAL FFT IN TO THE SAME STORAGE
C       LOCATIONS AS THE ORIGINAL ARRAY.  THE FIRST VALUE IS THE REAL
C       PART OF THE ZERO FREQUENCY COMPONENT.  THE SECOND VALUE IS THE
C       REAL PART OF THE NYQUIST FREQUENCY COMPONENT.  THE THIRD AND
C       FOURTH VALUES ARE A COMPLEX PAIR REPRESENTING THE FIRST
C       NON-ZERO POSITIVE FREQUENCY COEFFICIENT.  SUBSEQUENT PAIRS
C       ALSO REPRESENT REAL AND IMAGINARY PORTIONS OF THE POSITIVE
C       FREQUENCY COEFFIENTS.   TO COMPUTE AN INVERSE TRANSFORM, THE
C       INPUT ARRAY MUST BE LOADED IN THE SAME SPECIAL PACKED FORMAT.
C       (NOTE: THIS FORMAT IS COMPATIBLE WITH THE MATH ADVANTAGE RFFT)
C
C  SUBPROGRAMS CALLED:
C       MATH ADVANTAGE: VSMUL
C       OTHERS        : FGCFFT, RGSCR
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
        SUBROUTINE FGRFFT (A, INC, N, IFLG, NFAC, M, CNST, STABLE,
     &                     CTABLE, SRTAB, CRTAB, ISRC, IDST, NPERM)
C
c       REAL A(1), CNST(11), STABLE(1), CTABLE(1), SRTAB(1), CRTAB(1)
c       INTEGER N,INC,IFLG, NFAC(1), M, ISRC(1), IDST(1), NPERM, K
        REAL A(*), CNST(11), STABLE(*), CTABLE(*), SRTAB(*), CRTAB(*)
        INTEGER N,INC,IFLG, NFAC(*), M, ISRC(*), IDST(*), NPERM, K
C
C--------------------
C Forward Transform
C--------------------
C
        IF (IFLG .GE. 0) THEN
C
             K = N/2
             CALL FGCFFT (A, A(1+INC), 2*INC, K, IFLG, NFAC, M, CNST,
     +                  STABLE, CTABLE, ISRC, IDST, NPERM)
C
             CALL RGSCR (A, INC, N, IFLG, SRTAB, CRTAB)
C
C--------------------
C Inverse Transform
C--------------------
C
        ELSE
C
             CALL RGSCR (A, INC, N, IFLG, SRTAB, CRTAB)
C
             CALL FGCFFT (A, A(1+INC), 2*INC, N/2, IFLG, NFAC, M, CNST,
     +                  STABLE, CTABLE, ISRC, IDST, NPERM)
C
        ENDIF
C
        RETURN
        END
C
C=======================================================================
C
C       RGSCR - Real/Complex FFT Scramble Subroutine
C
C       (c) 1986 - Quantitative Technology Corporation
C
C       History: 12/4/86        Dan Benua       Original.
C
C-----------------------------------------------------------------------
C
C  This routine implements the real/complex scramble agorithm
C  that permits a real FFT of length N to be computed with
C  a complex FFT of length N/2.  For an explanation of
C  this technique see E.O. Brigham, "The Fast Fourier Transform",
C  Prentice-Hall, 1974, pp. 167-169.
C
C  To compute a forward real FFT, this routine is called after
C  the complex FFT computation.   To compute the inverse FFT,
C  this routine is called first, followed by a complex inverse
C  FFT.
C
C       INPUT DATA:
C
C               A       Real array of complex input values for forward
C                       transform.  For inverse transform, the
C                       first two values are real and the subsequent
C                       values are alternately real and imaginary.
C                       See the header of RGFFT for details of the
C                       packed format.
C
C               INC     Integer stride of array A.
C                       Must be greater than zero.
C
C               N       Integer length of array A.  Must be
C                       even and factorable by 2, 3, 5, and 7
C                       only.   The arrays SRTAB and CRTAB
C                       have length N/4.
C
C               IFLG    Integer direction flag. Positive for
C                       forward transform.
C
C               SRTAB   Real array of sine values, length N/4.
C
C               CRTAB   Real array of cosine values, length N/4.
C
C
C       OUTPUT DATA:
C
C               A       Real array of complex output values.  For
C                       a forward transform, the first two values
C                       are real and the subsequent values are
C                       alternately real and imaginary.  See
C                       details of the packed format explained
C                       in the header of RGFFT.  For an inverse
C                       transform, all the values in A are
C                       alternately real and imaginary.
C
C               Note:   All other input data is unchanged.
C
C-----------------------------------------------------------------------
C
        SUBROUTINE RGSCR (A, INC, N, IFLG, SRTAB, CRTAB)
C
        REAL A(*), SRTAB(*), CRTAB(*)
        INTEGER INC, N, IFLG
C
        IPRL = 1
        IPIL = 1 + INC
C
C----------------------------
C  First Pair, special case
C----------------------------
C
        ARL = A(IPRL)
        AIL = A(IPIL)
C
        IF (IFLG .GE. 0) THEN
                A(IPRL) = 0.5 * (ARL + AIL)
                A(IPIL) = 0.5 * (ARL - AIL)
        ELSE
                A(IPRL) = ARL + AIL
                A(IPIL) = ARL - AIL
        ENDIF
C
C-------------
C  Main Loop
C-------------
C
        IPRH = 1 + N*INC
C
        DO 10 I=1,N/4
C
                IPRL = IPIL + INC
                IPIL = IPRL + INC
                ARL = A(IPRL)
                AIL = A(IPIL)
C
                IPIH = IPRH - INC
                IPRH = IPIH - INC
                ARH = A(IPRH)
                AIH = A(IPIH)
C
                BRPR = ARL + ARH
                BRMR = ARL - ARH
                BIPI = AIL + AIH
                BIMI = AIL - AIH
C
                CF = CRTAB(I)
                SF = SRTAB(I)
C
                A(IPRL) = BRPR + CF*BIPI - SF*BRMR
                A(IPIL) = BIMI - SF*BIPI - CF*BRMR
C
                A(IPRH) = BRPR - CF*BIPI + SF*BRMR
                A(IPIH) = -BIMI - SF*BIPI - CF*BRMR

C
10      CONTINUE
C
C------------
C  Scaling
C------------
C
        IF (IFLG .GE. 0) THEN
C
                IPRL = 1 + INC + INC
                CALL VSMUL( A(IPRL), INC, 0.25, A(IPRL), INC, N-2)
C
        ENDIF
C
        RETURN
        END
C********************************************************************C
C NAME: GGRFFT  INITIALIZE TABLES FOR FGRFFT    REV 1.0     DEC 86   C
C********************************************************************C
C
C  PURPOSE:
C       INITIALIZES CONSTANT, TWIDDLE FACTOR, FACTOR, AND
C       PERMUTATION TABLES NEEDED BY FGRFFT.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C
C  CALLING FORMAT:
C       CALL GGRFFT (INC, N, IFLG, NFAC, M, CNST, STABLE, CTABLE,
C      &             SRTAB, CRTAB, ISRC, IDST, NPERM)
C
C  PARAMETERS:
C
C       INC     INTEGER INPUT SCALAR
C               STRIDE OF DATA ARRAY USED BY FGRFFT,
C               MUST BE POSITIVE.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF DATA ARRAY USED BY FGRFFT,
C               MUST BE EVEN.
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORMS, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       NFAC    INTEGER OUTPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N/2.
C
C       M       INTEGER OUTPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C       CNST    REAL OUTPUT ARRAY OF LENGTH 11
C               CONSTANTS USED BY FGRFFT, DEPENDENT
C               ON IFLG.
C
C       STABLE  REAL OUTPUT ARRAY OF LENGTH N/2
C               SINE TWIDDLE FACTORS, DEPENDENT
C               ON IFLG.
C
C       CTABLE  REAL OUTPUT ARRAY OF LENGTH N/2
C               COSINE TWIDDLE FACTORS.
C
C       SRTAB   REAL OUTPUT ARRAY OF LENGTH N/4
C               SINE VALUES FOR RGSCR.
C
C       CRTAB   REAL OUTPUT ARRAY OF LENGTH N/4
C               COSINE VALUES FOR RGSCR.
C
C       ISRC    INTEGER OUTPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       IDST    INTEGER OUTPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       NPERM   INTEGER OUTPUT SCALAR
C               NUMBER OF INDICIES IN ISRC AND IDST,
C               ALWAYS LESS THAN N/2.
C
C  DESCRIPTION:
C       THIS ROUTINE FACTORS N, LOADS THE CONSTANT AND TWIDDLE
C       FACTOR TABLES, AND LOADS THE PERMUTATION ARRAYS.
C       IT MUST BE CALLED ONCE BEFORE ANY NUMBER OF CALLS TO
C       FGRFFT THAT USE THE SAME N, INC, AND IFLG.
C
C  SUBPROGRAMS CALLED:
C       MATH ADVANTAGE:
C       OTHERS        : GGCFFT, FACTORS, DIGREV
C
C  ERROR CONDITIONS:
C       IF M .EQ. 0, N IS NOT FACTORABLE BY 2, 3, 5, OR 7.
C
C---------------------------------------------------------------------
C
        SUBROUTINE GGRFFT (INC, N, IFLG, NFAC, M, CNST, STABLE,
     &                     CTABLE, SRTAB, CRTAB, ISRC, IDST, NPERM)
C
c       REAL CNST(11), STABLE(1), CTABLE(1), SRTAB(1), CRTAB(1)
c       INTEGER N,INC,IFLG, NFAC(1), M, ISRC(1), IDST(1), NPERM
        REAL CNST(11), STABLE(*), CTABLE(*), SRTAB(*), CRTAB(*)
        INTEGER N,INC,IFLG, NFAC(*), M, ISRC(*), IDST(*), NPERM
C
C-----------------------------
C  Initialize Tables for GCFFT
C-----------------------------
C
        CALL GGCFFT (INC*2, N/2, IFLG, NFAC, M, CNST, STABLE, CTABLE,
     +                  ISRC, IDST, NPERM)
C
        IF (M .EQ. 0) RETURN
C
C------------------------------
C  Initialize Tables for RGSCR
C------------------------------
C
        AK = (ATAN(1.0) * 8.0) / FLOAT(N)
C
        IF (IFLG .GE. 0) THEN
C
            DO 10 I=1,N/4
                ARG = AK * FLOAT(I)
                SRTAB(I) = SIN( ARG )
                CRTAB(I) = COS( ARG )
10          CONTINUE
C
        ELSE
C
            DO 20 I=1,N/4
                ARG = AK * FLOAT(I)
                SRTAB(I) = SIN( ARG )
                CRTAB(I) = -COS( ARG )
20          CONTINUE
C
        ENDIF
C
        RETURN
        END
C********************************************************************C
C NAME: FGCFFT  GENERAL COMPLEX FFT             REV 1.0     DEC 86   C
C********************************************************************C
C
C  PURPOSE:
C       COMPUTES A FORWARD OR INVERSE COMPLEX IN-PLACE FFT WHERE
C       THE LENGTH OF THE ARRAY IS FACTORABLE BY 2, 3, 5, AND/OR 7.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C
C  CALLING FORMAT:
C       CALL FGCFFT (A, B, INC, N, IFLG, NFAC, M, CNST, STABLE,
C      &             CTABLE, ISRC, IDST, NPERM)
C
C  PARAMETERS:
C
C       A       REAL INPUT/OUTPUT VECTOR OF LENGTH N
C               REAL ARRAY ELEMENTS.
C
C       B       REAL INPUT/OUTPUT VECTOR OF LENGTH N
C               IMAGINARY ARRAY ELEMENTS.
C
C       INC     INTEGER INPUT SCALAR
C               STRIDE OF VECTORS A AND B.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF VECTORS A, B, STABLE, AND
C               CTABLE.
C
C       IFLG    INTEGER INPUT SCALAR
C               TRANSFORM DIRECTION FLAG, POSITIVE
C               FOR FORWARD, NEGATIVE FOR INVERSE.
C
C       NFAC    INTEGER INPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N.
C
C       M       INTEGER INPUT SCALAR
C               NUMBER OF PRIME FACTORS IN ARRAY NFAC.
C
C       CNST    REAL INPUT ARRAY OF LENGTH 11
C               CONSTANTS, DEPENDENT ON IFLG.
C
C       STABLE  REAL INPUT ARRAY OF LENGTH N
C               SINE TWIDDLE FACTORS.
C
C       CTABLE  REAL INPUT ARRAY OF LENGTH N
C               COSINE TWIDDLE FACTORS.
C
C       ISRC    INTEGER INPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       IDST    INTEGER INPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       NPERM   INTEGER INPUT SCALAR
C               NUMBER OF ELEMENTS IN ARRAYS ISRC
C               AND IDST, ALWAYS LESS THAN N.
C
C  DESCRIPTION:
C       THIS ROUTINE COMPUTES THE FORWARD OR INVERSE FAST FOURIER
C       TRANSFORM OF A COMPLEX ARRAY.  THE LENGTH OF THE ARRAY,
C       N, MUST BE FACTORABLE BY THE PRIME FACTORS 2, 3, 5, AND/OR
C       7.  THE TRANFORM IS PERFORMED IN PLACE USING PRE-COMPUTED
C       SINE, COSINE, FACTOR, CONSTANT, AND PERMUTATION TABLES.
C       THE TABLES ARE UNIQUE FOR EACH VALUE OF N, INC, AND IFLG.
C
C       THE ALGORITHM USED HERE IS ADAPTED FROM THE MIXED RADIX
C       FFT PROGRAM BY R. C. SINGLETON PUBLISHED IN "PROGRAMS FOR
C       DIGITAL SIGNAL PROCESSING", IEEE PRESS, 1979, SEC. 1.4.
C       THE PRIMARY DIFFERENCES ARE THAT THE PRIME FACTORS ARE
C       RESTRICTED TO 2, 3, 5, AND 7, SINE AND COSINE TABLES ARE
C       USED, A PERMUTATION TABLE IS USED, AND THE ORDER OF THE
C       RESULT ARRAY IS FLIPED ABOUT THE N/2 POINT. (EG. FOR A
C       FORWARD TRANFORM, THE POSITIVE FREQUENCY COEFFICIENTS
C       APPEAR IN THE FIRST HALF OF THE ARRAY RATHER THAN IN THE
C       LAST HALF AS THEY DO IN THE SINGLETON ALGORITHM)  THE
C       RESULTS PRODUCED BY THIS ROUTINE FOLLOW THE ORDER DEFINED
C       IN THE FORMAL DEFINITION OF THE DISCRETE FOURIER TRANSFORM
C       GIVEN BY MOST AUTHORS.
C
C       THE DESIGN STRATEGY FOR THIS ROUTINE ASSUMES THAT IT WILL
C       BE CALLED MANY TIMES WITH THE SAME VALUES OF N, INC, AND
C       IFLG, SO THAT THE OVERHEAD ASSOCIATED WITH CREATING THE
C       TABLES IS INSIGNIFICANT.  SEE THE ROUTINE GGCFFT.FOR FOR
C       THE TABLE INITIALIZATION ALGORITHMS.  WHEN SETTING UP FOR
C       AN INVERSE TRANSFORM AFTER DOING A NUMBER OF FORWARD
C       TRANSFORMS WITH THE SAME N AND INC, IT IS ONLY NECESSARY
C       TO CHANGE THE SIGNS OF THE VALUES IN STABLE AND SOME OF
C       THE CONSTANTS IN CNST.
C
C       THE CODE IN THESE SUBROUTINES WAS DESIGNED TO PROVIDE A CLEAR
C       MODEL FOR A TRANSLATION INTO MICROCODE OR ASSEMBLY LANGUAGE.
C       THE AUTHOR DOES NOT CLAIM THAT THIS IS THE BEST WAY TO
C       IMPLEMENT THE ALGORITHM FOR A GENERAL FORTRAN MACHINE.
C       THE DESIGN ALSO ASSUMES THAT A LARGE CACHE OR FAST MEMORY
C       IS AVAILABLE TO STORE FULL LENGTH SINE AND COSINE TABLES AND
C       PERMUTATION VECTORS. OBVIOUSLY, MEMORY REQUIREMENTS FOR THE
C       TWIDDLE FACTORS TABLES COULD BE REDUCED, BUT ONLY AT THE
C       EXPENSE OF INCREASED COMPUTATION TO DERIVE THEM AT RUN TIME.
C       REGARDING THE PERMUTATION VECTORS, NOTE THAT IN THE SORTING
C       LOOP AT THE END OF THIS ROUTINE THERE IS A CONDITIONAL TEST.
C       THE RESULT OF THIS TEST DEPENDS ONLY ON THE PRECOMPUTED
C       VALUES IN THE ARRAYS ISRC AND IDST.  IF IT PROVES MORE
C       EFFICIENT ON THE TARGET MACHINE, THE LOGICAL VALUE OF THE
C       TEST COULD BE ENCODED IN A THIRD PERMUTATION VECTOR, OR IN
C       THE HIGH BITS OF THE PRESENT PERMUTATION VECTORS.
C
C  SUBPROGRAMS CALLED:
C       MATH ADVANTAGE: VSMUL
C       OTHERS        :
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
        SUBROUTINE FGCFFT (A, B, INC, N, IFLG, NFAC, M, CNST, STABLE,
     &                     CTABLE, ISRC, IDST, NPERM)
C
        REAL A(*), B(*), CNST(11), STABLE(*), CTABLE(*)
        INTEGER INC, N, IFLG, NFAC(*), M, ISRC(*), IDST(*), NPERM
C
        INTEGER INCD,THETA1,THETA2
C
        IF (N .LT. 2 .OR. M .LE. 0) RETURN
C
C-------------------------------------
C  If forward transform, scale by 1/N
C-------------------------------------
C
        IF (IFLG .GE. 0) THEN
C
                AK = 1.0/FLOAT(N)
                CALL VSMUL(A,INC,AK,A,INC,N)
                CALL VSMUL(B,INC,AK,B,INC,N)
C
        ENDIF
C
C---------------------------------
C  Initialize indexing variables
C---------------------------------
C
        NT = INC*N
        KSPAN = NT
        NN = NT - INC
        I = 0
        INCD = 1
C
C-------------------------------------
C  Top of the main loop, one pass of
C  this loop for each factor in NFAC
C-------------------------------------
C
20      KK = 1
        IF (I .GT. 0) INCD = INCD * NFAC(I)
        I = I + 1
        K = NFAC(I)
        KSPNN = KSPAN
        KSPAN = KSPAN/K
C
C------------------------------------------------------------------
C  Radix 2 pass, this code includes twiddle factor multiplications.
C  Note that there are two loops here, the first one is used when
C  there are no twiddle factors.
C------------------------------------------------------------------
C
        IF (K .NE. 2) GOTO 80
        K1 = KSPAN + 2

  30    K2 = KK + KSPAN
        AK = A(K2)
        BK = B(K2)
        A(K2) = A(KK) - AK
        B(K2) = B(KK) - BK
        A(KK) = A(KK) + AK
        B(KK) = B(KK) + BK
        KK = K2 + KSPAN
        IF (KK .LE. NN) GO TO 30
C
        KK = KK - NN
        IF (KK .LE. INC) GO TO 30
C
        IF (KK .GT. KSPAN) GO TO 190

  40    THETA1 = INCD
        GO TO 60

  50    THETA1 = THETA1 + INCD
        IF (THETA1 .GT. N) THETA1 = THETA1 - N
C
  60    C1 = CTABLE(THETA1)
        S1 = STABLE(THETA1)

  70    K2 = KK + KSPAN
        AK = A(KK) - A(K2)
        BK = B(KK) - B(K2)
        A(KK) = A(KK) + A(K2)
        B(KK) = B(KK) + B(K2)
        A(K2) = C1*AK - S1*BK
        B(K2) = S1*AK + C1*BK
        KK = K2 + KSPAN
        IF (KK .LT. NT) GO TO 70
C
        K2 = KK - NT
        THETA1 = N/2 - THETA1
        IF (THETA1 .LE. 0) THETA1 = THETA1 + N
        KK = K1 - K2
        IF (KK .GT. K2) GO TO 60
        KK = KK + INC
        IF (KK .LE. K1/2) GO TO 50
C
        K1 = K1 + INC + INC
        KK = (K1-KSPAN)/2 + INC
        IF (KK .LE. INC+INC) GO TO 40
        GO TO 20
C
C----------------------------------------------------------------
C  Radix 3 Pass.  Note that this pass does not include twiddle
C  factor multiplication.  See code at label 130.
C----------------------------------------------------------------
C
80      IF (K .NE. 3) GOTO 100
C
90      K1 = KK + KSPAN
        K2 = K1 + KSPAN
        AK = A(KK)
        BK = B(KK)
        AJ = A(K1) + A(K2)
        BJ = B(K1) + B(K2)
        A(KK) = AK + AJ
        B(KK) = BK + BJ
        AK = -0.5 * AJ + AK
        BK = -0.5 * BJ + BK
        AJ = (A(K1) - A(K2)) * CNST(1)
        BJ = (B(K1) - B(K2)) * CNST(1)
        A(K1) = AK - BJ
        B(K1) = BK + AJ
        A(K2) = AK + BJ
        B(K2) = BK - AJ
        KK = K2 + KSPAN
        IF (KK.LT.NN) GO TO 90
C
        KK = KK - NN
        IF (KK.LE.KSPAN) GO TO 90
C
        GO TO 130
C
C-------------------------------------------------------------------
C  Radix 5 Pass. See code at 130 for twiddle factor multiplication
C-------------------------------------------------------------------
C
 100    IF (K .NE. 5) GOTO 120
C
 110    K1 = KK + KSPAN
        K2 = K1 + KSPAN
        K3 = K2 + KSPAN
        K4 = K3 + KSPAN
        AKP = A(K1) + A(K4)
        AKM = A(K1) - A(K4)
        BKP = B(K1) + B(K4)
        BKM = B(K1) - B(K4)
        AJP = A(K2) + A(K3)
        AJM = A(K2) - A(K3)
        BJP = B(K2) + B(K3)
        BJM = B(K2) - B(K3)
        AA = A(KK)
        BB = B(KK)
        A(KK) = AA + AKP + AJP
        B(KK) = BB + BKP + BJP
        AK = AKP * CNST(4) + AJP * CNST(2) + AA
        BK = BKP * CNST(4) + BJP * CNST(2) + BB
        AJ = AKM * CNST(5) + AJM * CNST(3)
        BJ = BKM * CNST(5) + BJM * CNST(3)
        A(K1) = AK - BJ
        A(K4) = AK + BJ
        B(K1) = BK + AJ
        B(K4) = BK - AJ
        AK = AKP * CNST(2) + AJP * CNST(4) + AA
        BK = BKP * CNST(2) + BJP * CNST(4) + BB
        AJ = AKM * CNST(3) - AJM * CNST(5)
        BJ = BKM * CNST(3) - BJM * CNST(5)
        A(K2) = AK - BJ
        A(K3) = AK + BJ
        B(K2) = BK + AJ
        B(K3) = BK - AJ
        KK = K4 + KSPAN
        IF (KK.LT.NN) GO TO 110
C
        KK = KK - NN
        IF (KK.LE.KSPAN) GO TO 110
C
        GO TO 130
C
C--------------------------------------------
C  Radix 7 Pass.  See code at label 130 for
C  twiddle factor multiplication.
C--------------------------------------------
C
120     K1 = KK + KSPAN
        K2 = K1 + KSPAN
        K3 = K2 + KSPAN
        K4 = K3 + KSPAN
        K5 = K4 + KSPAN
        K6 = K5 + KSPAN
        AT2 = A(K1) + A(K6)
        BT2 = B(K1) + B(K6)
        AT3 = A(K1) - A(K6)
        BT3 = B(K1) - B(K6)
        AT4 = A(K2) + A(K5)
        BT4 = B(K2) + B(K5)
        AT5 = A(K2) - A(K5)
        BT5 = B(K2) - B(K5)
        AT6 = A(K3) + A(K4)
        BT6 = B(K3) + B(K4)
        AT7 = A(K3) - A(K4)
        BT7 = B(K3) - B(K4)
C
        AA = A(KK)
        BB = B(KK)
        A(KK) = AA + AT2 + AT4 + AT6
        B(KK) = BB + BT2 + BT4 + BT6
C
        AK = AA + AT2*CNST(6) + AT4*CNST(8) + AT6*CNST(10)
        BK = BB + BT2*CNST(6) + BT4*CNST(8) + BT6*CNST(10)
        AJ = AT3*CNST(7) + AT5*CNST(9) + AT7*CNST(11)
        BJ = BT3*CNST(7) + BT5*CNST(9) + BT7*CNST(11)
        A(K1) = AK - BJ
        B(K1) = BK + AJ
        A(K6) = AK + BJ
        B(K6) = BK - AJ
C
        AK = AA + AT2*CNST(8) + AT4*CNST(10) + AT6*CNST(6)
        BK = BB + BT2*CNST(8) + BT4*CNST(10) + BT6*CNST(6)
        AJ = AT3*CNST(9) - AT5*CNST(11) - AT7*CNST(7)
        BJ = BT3*CNST(9) - BT5*CNST(11) - BT7*CNST(7)
        A(K2) = AK - BJ
        B(K2) = BK + AJ
        A(K5) = AK + BJ
        B(K5) = BK - AJ
C
        AK = AA + AT2*CNST(10) + AT4*CNST(6) + AT6*CNST(8)
        BK = BB + BT2*CNST(10) + BT4*CNST(6) + BT6*CNST(8)
        AJ = AT3*CNST(11) - AT5*CNST(7) + AT7*CNST(9)
        BJ = BT3*CNST(11) - BT5*CNST(7) + BT7*CNST(9)
        A(K3) = AK - BJ
        B(K3) = BK + AJ
        A(K4) = AK + BJ
        B(K4) = BK - AJ
C
        KK = KK + KSPNN
        IF (KK.LE.NN) GO TO 120
C
        KK = KK - NN
        IF (KK.LE.KSPAN) GO TO 120
C
C----------------------------------
C  Twiddle Factor Multiplications
C----------------------------------
C
130     IF (I.EQ.M) GO TO 190
        KK = INC + 1
C
140     THETA2 = INCD
        GO TO 160
C
150     THETA2 = THETA1 + INCD
        IF (THETA2 .GT. N) THETA2 = THETA2 - N
C
160     KK = KK + KSPAN
        THETA1 = THETA2
C
170     C2 = CTABLE(THETA2)
        S2 = STABLE(THETA2)
C
180     AK = A(KK)
        A(KK) = C2*AK - S2*B(KK)
        B(KK) = S2*AK + C2*B(KK)
        KK = KK + KSPNN
        IF (KK.LE.NT) GO TO 180
C
        THETA2 = THETA2 + THETA1
        IF (THETA2 .GT. N) THETA2 = THETA2 - N
        KK = KK - NT + KSPAN
        IF (KK.LE.KSPNN) GO TO 170
C
        KK = KK - KSPNN + INC
        IF (KK .LE. KSPAN) GO TO 150
C
        KK = KK - KSPAN
        IF (KK.GT.0) GO TO 20
C
        KK = KK + INC + INC
C       GOTO 140
C
C--------------------------------------------
C  Sort the arrays A and B according to the
C  index values stored in ISRC and IDST.
C--------------------------------------------
C
190     IF (NPERM .EQ. 0) RETURN
C
        AT1 = A(IDST(1))
        BT1 = B(IDST(1))
        A(IDST(1)) = A(ISRC(1))
        B(IDST(1)) = B(ISRC(1))
C
        DO 200 I=2,NPERM
                AT2 = A(IDST(I))
                BT2 = B(IDST(I))
                IF (IDST(I-1) .EQ. ISRC(I)) THEN
                        A(IDST(I)) = AT1
                        B(IDST(I)) = BT1
                ELSE
                        A(IDST(I)) = A(ISRC(I))
                        B(IDST(I)) = B(ISRC(I))
                ENDIF
                AT1 = AT2
                BT1 = BT2
200     CONTINUE
C
        RETURN
        END
C********************************************************************C
C NAME: GGCFFT  INITIALIZE TABLES FOR FGCFFT    REV 1.0     DEC 86   C
C********************************************************************C
C
C  PURPOSE:
C       INITIALIZES CONSTANT, TWIDDLE FACTOR, FACTOR, AND
C       PERMUTATION TABLES NEEDED BY FGCFFT.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C
C  CALLING FORMAT:
C       CALL GGCFFT (INC, N, IFLG, NFAC, M, CNST, STABLE, CTABLE,
C      &             ISRC, IDST, NPERM)
C
C  PARAMETERS:
C
C       INC     INTEGER INPUT SCALAR
C               STRIDE OF DATA ARRAYS USED BY FGCFFT.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF DATA ARRAYS USED BY FGCFFT.
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORMS, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       NFAC    INTEGER OUTPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N.
C
C       M       INTEGER OUTPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C       CNST    REAL OUTPUT ARRAY OF LENGTH 11
C               CONSTANTS USED BY FGCFFT, DEPENDENT
C               ON IFLG.
C
C       STABLE  REAL OUTPUT ARRAY OF LENGTH N
C               SINE TWIDDLE FACTORS, DEPENDENT
C               ON IFLG.
C
C       CTABLE  REAL OUTPUT ARRAY OF LENGTH N
C               COSINE TWIDDLE FACTORS.
C
C       ISRC    INTEGER OUTPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       IDST    INTEGER OUTPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       NPERM   INTEGER OUTPUT SCALAR
C               NUMBER OF INDICIES IN ISRC AND IDST,
C               ALWAYS LESS THAN N.
C
C  DESCRIPTION:
C       THIS ROUTINE FACTORS N, LOADS THE CONSTANT AND TWIDDLE
C       FACTOR TABLES, AND LOADS THE PERMUTATION ARRAYS.
C       IT MUST BE CALLED ONCE BEFORE ANY NUMBER OF CALLS TO
C       FGCFFT THAT USE THE SAME N, INC, AND IFLG.
C
C  SUBPROGRAMS CALLED:
C       MATH ADVANTAGE:
C       OTHERS        : FACTORS, DIGREV
C
C  ERROR CONDITIONS:
C       IF M .EQ. 0, N IS NOT FACTORABLE BY 2, 3, 5, OR 7
C       AND THE TABLES ARE NOT INITIALIZED.
C
C---------------------------------------------------------------------
C
        SUBROUTINE GGCFFT (INC, N, IFLG, NFAC, M, CNST, STABLE,
     &                     CTABLE, ISRC, IDST, NPERM)
C
c       REAL CNST(11), STABLE(1), CTABLE(1)
c       INTEGER INC, N, IFLG, NFAC(1), M, ISRC(1), IDST(1), NPERM
        REAL CNST(11), STABLE(*), CTABLE(*)
        INTEGER INC, N, IFLG, NFAC(*), M, ISRC(*), IDST(*), NPERM
C
C---------------------------------------------------------
C  Find the M prime factors of N, returning them in NFAC.
C  If N can't be factored with 2,3,5, & 7,  FACTORS will
C  return M = 0.
C---------------------------------------------------------
C
        CALL FACTORS (N, NFAC, M)
C
        IF (M .EQ. 0) RETURN
C
C------------------------------------------------------
C  Using the prime factor array, load the array STABLE
C  with digit reversed values of it's indicies.  Note
C  that STABLE is just used as a temporary arrray here.
C  It will be loaded with sine values before the end
C  of this routine.
C------------------------------------------------------
C
        CALL DIGREV (STABLE, NFAC, M)
C
C---------------------------------------------------
C  Convert the digit reversed values in STABLE by
C  subtracting them from N + 2.  This adjusts for
C  reversed coefficient ordering of Singleton's
C  algorithm.
C--------------------------------------------------
C
       DO 10 I=2,N
               STABLE(I) = FLOAT(N+2) - STABLE(I)
10     CONTINUE
C
C-------------------------------------------------------------
C  Load the arrays ISRC and IDST using the indicies of STABLE
C  as sources and the values in STABLE as destinations.  We
C  load them in order so that ISRC(J) = IDST(J-1) as frequently
C  as possible.  This technique allows us to only have one
C  (complex) temporary storage location to sort the A and B
C  arrays in place.  As we load ISRC and IDST, count the number
C  of source - destination pairs and store the total in NPERM.
C-------------------------------------------------------------
C
        NPERM = 0
        I = 1
20      I = I + 1
        IF (I .GE. N) GOTO 40
        IF (STABLE(I) .EQ. FLOAT(I)) GOTO 20
        ICYC = I

30      NPERM = NPERM + 1
        ISRC(NPERM) = I
        IDST(NPERM) = INT( STABLE(I) )
        J = I
        I = IDST(NPERM)
        STABLE(J) = FLOAT(J)
        IF (I .NE. ICYC) GOTO 30
        GOTO 20
C
C--------------------------------------------
C  If INC is greater than 1, we must correct
C  the indicies stored in ISRC and IDST.
C--------------------------------------------
C
40      IF (INC .GT. 1) THEN
C
                DO 50 I=1,NPERM
                        ISRC(I) = (ISRC(I) - 1) * INC + 1
                        IDST(I) = (IDST(I) - 1) * INC + 1
50              CONTINUE
        ENDIF
C
C---------------------------------
C  Initialize the constant array
C---------------------------------
C
        RAD = ATAN(1.0)
        S1 = RAD / 0.625
        CNST(1) = SQRT(0.75)
        CNST(4) = COS(S1)
        CNST(5) = SIN(S1)
        CNST(2) = CNST(4)**2 - CNST(5)**2
        CNST(3) = 2.0 * CNST(4) * CNST(5)
        S2 = RAD / 0.875
        S3 = S2 + S2
        S4 = S3 + S2
        CNST(6) = COS(S2)
        CNST(7) = SIN(S2)
        CNST(8) = COS(S3)
        CNST(9) = SIN(S3)
        CNST(10) = COS(S4)
        CNST(11) = SIN(S4)
C
C----------------------------
C  If an inverse transform,
C  correct constants.
C----------------------------
C
        IF (IFLG .LT. 0) THEN
                CNST(1) = -CNST(1)
                CNST(3) = -CNST(3)
                CNST(5) = -CNST(5)
                CNST(7) = -CNST(7)
                CNST(9) = -CNST(9)
                CNST(11) = -CNST(11)
                RAD = -RAD
        ENDIF
C
C-----------------------------------------
C  Initialize the sine and cosine tables.
C  Note that direction of transform affects
C  sign of STABLE values.
C-----------------------------------------
C
        AK = (RAD * 8.0) / FLOAT(N)
        DO 60 I=1,N
                C2 = AK * FLOAT(I)
                STABLE(I) = SIN( C2 )
                CTABLE(I) = COS( C2 )
60      CONTINUE
C
        RETURN
        END
C
C=======================================================================
C
C       FACTORS - Find prime factors
C
C       (c) 1986 - Quantitative Technology Corporation
C
C       Author:  Dan Benua
C       History: 12/4/86        Dan Benua       Original
C
C  This routine finds the prime factors of N, less than or equal to 7.
C  If N cannot be factored with the primes 2, 3, 5, and 7 the routine
C  returns M = 0.  Otherwise, the prime factors of N are loaded into the
C  array NFAC().  M is the number of factors.  This routine is called
C  by GGCFFT to initialize the factor table.
C
C       INPUT DATA:
C
C               N       Integer number to be factored.
C
C       OUTPUT DATA:
C
C               NFAC    Integer array loaded with the factors
C                       of N.
C
C               M       Integer number of prime factors loaded
C                       into NFAC.
C
C-----------------------------------------------------------------------
C
        SUBROUTINE FACTORS (N, NFAC, M)
C
        INTEGER NFAC(*)
        INTEGER N, M, NTMP
C
        NTMP = N
        M = 0
C
10      IF ((NTMP/2)*2 .NE. NTMP) GOTO 20
                NTMP = NTMP / 2
                M = M + 1
                NFAC(M) = 2
                GOTO 10
C
20      IF ((NTMP/3)*3 .NE. NTMP) GOTO 30
                NTMP = NTMP / 3
                M = M + 1
                NFAC(M) = 3
                GOTO 20
C
30      IF ((NTMP/5)*5 .NE. NTMP) GOTO 40
                NTMP = NTMP / 5
                M = M + 1
                NFAC(M) = 5
                GOTO 30
C
40      IF ((NTMP/7)*7 .NE. NTMP) GOTO 50
                NTMP = NTMP / 7
                M = M + 1
                NFAC(M) = 7
                GOTO 40
C
50      IF (NTMP .EQ. 1) RETURN
C
        M = 0
        RETURN
C
        END
C
C======================================================================
C
C       DIGREV - Compute digit reverse
C
C       (c) 1986 - Quantitative Technology Corporation
C
C       History: 12/4/86        Dan Benua       Original.
C
C  This routine computes the digit reversed values of the indicies
C  of the array INDX and stores them in the array.  The order and
C  range of each "digit" is given by the prime factors stored in
C  the array NFAC.
C
C  For example, if NF = 2 and the values in NFAC are:
C
C       NFAC(1) = 2, NFAC(2) = 3
C
C  Then we know that INDX will contain six values (the product of
C  2 and 3) and that the non-reversed indicies can be represented
C  by:
C       INDX(1) = 0  -> 0, 0
C       INDX(2) = 1  -> 0, 1
C       INDX(3) = 2  -> 0, 2
C       INDX(4) = 3  -> 1, 0
C       INDX(5) = 4  -> 1, 1
C       INDX(6) = 5  -> 1, 2
C
C  When we digit reverse the factored indices we get:
C
C       INDX(1) = 0  <- 0, 0
C       INDX(2) = 2  <- 1, 0
C       INDX(3) = 4  <- 2, 0
C       INDX(4) = 1  <- 0, 1
C       INDX(5) = 3  <- 1, 1
C       INDX(6) = 5  <- 2, 1
C
C  The actual values stored in the output array are one greater than
C  the values shown here to account for Fortran array indicies starting
C  at 1.  Note also that INDX is a real array only because we have an
C  extra real array hanging around.  The values stored in it are
C  integers.
C
C       INPUT DATA:
C
C               NFAC    Integer array containing prime factors.
C
C               M       Integer number of values in NFAC.
C
C       OUTPUT DATA:
C
C               INDX    Real array containing digit reversed
C                       indicies.
C
C-----------------------------------------------------------------------
C
        SUBROUTINE DIGREV (INDX, NFAC, M)
C
        REAL INDX(*)
        INTEGER NFAC(*),M
        INTEGER DIGIT(50)
        INTEGER MULT(50)
        INTEGER N
C
C-----------------------------
C  Clear DIGIT and load MULT
C  with products of NFAC.
C----------------------------
C
        DIGIT(M) = 0
        MULT(1) = 1
        DO 10 I=1, M-1
                MULT(I+1) = MULT(I) * NFAC(I)
                DIGIT(I) = 0
10      CONTINUE
C
C-----------------------------------------
C  N is the product of entries in NFAC.
C  We also know that the first and last
C  values in INDX will be equal to their
C  indicies, they are invariant under
C  digit reversal.
C----------------------------------------
C
        N = NFAC(M) * MULT(M)
        INDX(1) = 1.0
        INDX(N) = FLOAT(N)
C
C--------------------------------------------------------------------
C  Main Loop - Here we use the DIGIT array to represent the factoring
C  of the indicies of INDX.  The last digit is incremented by one
C  on each pass through the main loop and any carry bits are propagated
C  down through the other digits by the loop at label 30.  The
C  digit reversed value is then computed by the loop at label 40 by
C  multiplying the digits by the appropriate multiplicand in MULT and
C  adding.  Finally, the result is incremented to account for Fortran
C  array indexing and floated before storing in INDX.
C--------------------------------------------------------------------
C
        DO 40 I=2,(N-1)
C
                DIGIT(M) = DIGIT(M) + 1
                DO 20 J=M,1,-1
                        IF (DIGIT(J) .EQ. NFAC(J)) THEN
                                DIGIT(J) = 0
                                DIGIT(J-1) = DIGIT(J-1) + 1
                        ENDIF
20              CONTINUE
C
                ITMP = 0
                DO 30 J=1,M
                        ITMP = ITMP + DIGIT(J) * MULT(J)
30              CONTINUE
                INDX(I) = FLOAT( ITMP + 1 )
C
40      CONTINUE
C
        RETURN
        END
      SUBROUTINE ccexit(ICODE)
      STOP 100
      END
      SUBROUTINE daclos(LU)
      CLOSE(LU)
      RETURN
      END
      SUBROUTINE daread(IRECNO,ARRAY,LU,NBYT)
      DIMENSION ARRAY(*)
	integer icount, jcount
	real    itime, jtime
	common /debug/icount, jcount, itime, jtime
#ifdef CRAYSYSTEM
	real    x, y
        call second( x )
#endif
      READ(LU,REC=IRECNO)(ARRAY(I),I=1,NBYT/4)
#ifdef CRAYSYSTEM
	call second( y )
	itime = itime + (y - x)
	icount = icount + 1
#endif
      RETURN
      END
      SUBROUTINE dawrte(IRECNO,ARRAY,LU,NBYT)
	integer icount, jcount
	real    itime, jtime
	common /debug/icount, jcount, itime, jtime
      DIMENSION ARRAY(*)
#ifdef CRAYSYSTEM
	real    x, y
	call second( x )
#endif
      WRITE(LU,REC=IRECNO)(ARRAY(I),I=1,NBYT/4)
#ifdef CRAYSYSTEM
	call second( y )
	itime = itime + (y - x)
	jcount = jcount + 1
#endif
      RETURN
      END
      subroutine cmdlin(ntpv,ntap,otap,input,model,ipipi,ipipo,ltrm,
     &dxtap,dztap,ipipiv,msk,iextrp)
      INTEGER ARGIS
      LOGICAL HELP
      CHARACTER*128 NTPV,NTAP,OTAP,INPUT,MODEL
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      IPIPIV=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS -- fxcmmig'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]  .. INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap]  .. OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-VEL[ntpv] .. input velocity dataset name'
         WRITE(LTRM,*)'-C[input] .. CARD FILE FOR INTERACTIVE EXECUTION'
         WRITE(LTRM,*)'-DZT[]     .. dz veloc tape (default-use tape)'
         WRITE(LTRM,*)'-DXT[]     .. dx veloc tape (default-use tape)'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'fxcmmig -N[] -O[] -C[] -VEL[]'
         WRITE(LTRM,*)'           or          '
         WRITE(LTRM,*)'-fxcmmig.crd"\          '
         WRITE(LTRM,*)'-parameter cards here-'
         WRITE(LTRM,*)'"                     '
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGSTR('-VEL',NTPV,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGR4 ('-DZT',DZTAP,0.0,0.0)
      CALL ARGR4 ('-DXT',DXTAP,0.0,0.0)
      call argi4 ('-msk',msk,1,1)
      call argi4 ('-iextrp',iextrp,0,0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
C     INVALID 'NO INPUT'
      IF(NTPV.EQ.' ' ) IPIPIV=1
      RETURN
      END
      subroutine scnmtx(index,nx,nz,map,nv)
      integer index(nx,nz), map(*)

c     create list of indices appearing in index

      call vclr(map,1,nv)
      do 20 jz=1,nz
       do 30 jx=1,nx
   30  map(index(jx,jz)) = 1
   20 continue

      return
      end
      subroutine rampt(tramp,n1,n2,n3,nt)
c     builds a time ramp for input data
      real tramp(*)
      do 10 j=1,n1
  10  tramp(j) = float(j-1)/float(n1-1)
      do 20 j=n1+1,n2
  20  tramp(j) = 1.0
      do 30 j=n2+1,n3-1
  30  tramp(j) = float(j-n2+1)/float(n3-n2+1)
      do 40 j=n3,nt
  40  tramp(j) = 0.0
      return
      end
