C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    NAME: fxpclean
c PURPOSE: shift traces and headers to centered position
c          supply missing traces and headers
c***********************************************************************
c
      subroutine fxpclean( LER, jrec, nsmp, ntrc, nrec, ntrcb2, nlive
     &    , istalv, live, soptnm, headr, data, dataout, headrout, ierr )
c
      implicit none
      integer  MAXTRACE
      parameter (MAXTRACE = 4096)
      logical livetrace(-MAXTRACE:MAXTRACE)
c
c input parameters:
c
      integer   nrec            ! number of records in input dataset
      integer   ntrc            ! number of traces per record in input
      integer   LER             ! logical unit number, error file
      integer   jrec            ! index of current input record
      integer   nsmp            ! number of samples per trace in input
      integer   ntrcb2          ! ntrc2(out)/2
      integer   nlive(nrec)     ! number of live stations in shot
      integer   istalv(ntrc,nrec)! station index (of live stations)
      logical   live(ntrc,nrec) ! station live or dead?
      integer   soptnm(nrec)    ! station number of shot
      integer*2 headr(128,ntrc) ! trace headers, current record
      real      data(nsmp,ntrc) ! input record
c
c output parameters:
c
      integer*2 headrout(128,-ntrcb2:ntrcb2) ! trace headers output
      real      dataout(nsmp,-ntrcb2:ntrcb2) ! output record, modified
      integer   ierr            ! error flag
c
c local variables:
c
      integer jtin, jtout, js, jh, nlive_chk
      integer jt1, jt2
c***********************************************************************
c
c===  clear the output arrays dataout and headrout, livetrace
c
      call vclr( dataout, 1, (ntrc+1)*nsmp )
c
      do jtout = -ntrcb2, ntrcb2
         do jh = 1, 128
            headrout(jh,jtout) = 0
            headrout(125,jtout) = 30000
         enddo
         livetrace(jtout) = .false.
      enddo
c
c=== shift to centered position the good data traces and headers
c
      nlive_chk = 0
      do jtin = 1, ntrc
         if( live(jtin, jrec) ) then
            nlive_chk = nlive_chk + 1
            jtout = istalv(jtin,jrec) - soptnm(jrec)
            livetrace(jtout) = .true.
            do js = 1, nsmp
               dataout(js,jtout) = data(js,jtin)
            enddo
            do jh = 1, 128
               headrout(jh,jtout) = headr(jh,jtin)
            enddo
         endif
      enddo
c
c===  an error check
c
      if( nlive_chk .ne. nlive(jrec) ) then
         write( LER, * )' ERROR: nlive bad check for jrec = ', jrec
         ierr = 1
         go to 800
      endif
c
c===  fix up the headers
c
      do jtout = -ntrcb2, ntrcb2
c
         if( .not. livetrace(jtout) ) then
c
c========  find nearest live neighbors to use for fixing
c
           call findtwo( livetrace(-ntrcb2)
     &                 , 2*ntrcb2+1
     &                 , jtout + ntrcb2+1, jt1, jt2, ierr  )
           if( ierr .ne. 0 ) then
              write( LER, * ) ' ERROR: COULDNT FIND TWO LIVE NEIGHBORS'
              go to 800
           endif
c
c========  fix the header by interpolating from its neighbors
c========  note: trace number and record number fixed by wrrec
c
           do jh = 1, 128
              headrout(jh,jtout) = nint(
     &           float(jt1 * headrout(jh, jtout + jt2)
     &               - jt2 * headrout(jh, jtout + jt1) )
     &           / float( jt1 - jt2 ) )
cmat
           enddo
cadd next line
           headrout(125,jtout) = 30000
c
c========  header now fixed; make it a live one
c
           livetrace(jtout) = .true.
c
         endif
      enddo
c***********************************************************************
800   continue
      return
      end
c***********************************************************************
c***********************************************************************
c    NAME: findtwo
c PURPOSE: find nearest live neighbors to use for fixing
c***********************************************************************
c
      subroutine findtwo( livetrace, ntraces, j0, jt1, jt2, ierr  )
c
      implicit none
c
c input parameters:
c
      logical livetrace(*)
      integer ntraces, j0
c
c output parameters
c
      integer jt1, jt2, ierr
c
c local parameters
c
      integer j
c***********************************************************************
      ierr = 0
      jt1 = 0
      jt2 = 0
c
      do j = 1, max0( ntraces-j0, j0-1 )
c
         if( j0+j .le. ntraces) then
            if( livetrace(j0+j) ) then
               if ( jt1 .eq. 0 ) then
                  jt1 = j
               else
                  jt2 = j
                  go to 2000
               endif
            endif
         endif
c
         if( j0-j .ge. 1) then
            if( livetrace(j0-j) ) then
               if ( jt1 .eq. 0 ) then
                  jt1 = -j
               else
                  jt2 = -j
                  go to 2000
               endif
            endif
         endif
      enddo
c
c===  should not reach this point
c
      ierr = 1
c
c***********************************************************************
2000  continue
      return
      end
c***********************************************************************
