C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE stimag (JBLK, IXS, IMG, PRCNT, EPSLN,
     & INDREC, CINC, CRFL, BMWTHI, BMWTHR, IDIPZ,VMIN,VMAX,
     & iextrp , ixtap , ciwork, crwork ,
     & numvel , slop  , maxna, maxnv, gwrk1, gwrk2, gwrk3,
     & gwrk4, gwrk5, work, ivv2, ivv, ixp, ivp2, ixp2, map,
     & gxr1, gxr2, sxr1, sxr2, rimage, gxi1, gxi2, sxi1, sxi2,
     & pwpr,pwnr,pwni,pwpi )
C
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C      maxnt should be maxna * maxnv + 1
       parameter (maxnt = 4096)
C
C  PARAMETERS:
C
      INTEGER JBLK
C                        INPUT BLOCK (RECORD) INDEX
      INTEGER IXS
C                        INPUT HORIZONTAL SEGMENT INDEX
      INTEGER IMG
C                        INPUT IMAGING FLAG
      REAL    PRCNT
C                        INPUT RAMP PERCENT VALUE
      REAL    EPSLN
C                        INPUT EPSILON VALUE
      INTEGER INDREC(*)
C                        SCRATCH INDEX RECORD
      COMPLEX CINC  (*)
C                        SCRATCH INCIDENT FIELD
      COMPLEX CRFL  (*)
C                        SCRATCH REFLECTED FIELD
      REAL    BMWTHI
C                        INCIDENT BEAM WIDTH
      REAL    BMWTHR
C                        REFLECTED BEAM WIDTH
      INTEGER IDIPZ
C                        DIP FILTER RATE ( EVERY IDIPZ Z ROW )
      REAL VMIN(*)
C                        MINIMUM VELOCITIES
      REAL VMAX(*)
C                        MAXIMUM VELOCITIES
C
C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=100,IZSEGM=20)
C
      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)
C
      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------
C
C
C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=200,IXSEGM=5,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C
      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ----------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ----------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS ---------------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS----------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)
C
      INTEGER ihead(1500)
ccms  INTEGER*2 THEAD(3000),ITRH(128)
CCRAY
      INTEGER THEAD(3000)
      INTEGER*2 ITRH(LNTRHD)
ccms  REAL TRACE(NSMAX+64),DATA(NSMAX)
CCRAY
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
ccms  EQUIVALENCE (TRACE(65),DATA(1))
CCRAY
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ----------------------------------------------------
C
C
C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------



C * * * PWMBS COMMON (END) * * * *
C
C
C  LOCAL DECLARATIONS:
C
      REAL    FINC(2*IXMAX), FRFL(2*IXMAX), PARM(5)
C
C  VERSION F01
C
      REAL    RIMAGE(IXMAX*IZMAX*IZSEGM)
CCRAY  2*izmax*izsegm must be >= ixmax
      REAL    WRK1(NSMAX), WRK2(2*IZMAX*IZSEGM)
      REAL    WRK3(8*IZMAX*IZSEGM+2),WRK4(18*IZMAX*IZSEGM+8)
      INTEGER IWRK(NSMAX)
C
C  VERSION F02
C
      REAL    RII(IXMAX*IZMAX), RRI(IXMAX*IZMAX)
C
C  VERSION F04
C
      INTEGER INDEX(IXMAX*IZMAX)
C
C  VERSION F8a
C
      REAL    GWRK1( 3*maxnv*(maxna+1) ),
     &        GWRK2( 2*maxna-1 ),
     &        GWRK3( maxnv*(maxna+1) ),
     &        GWRK4( maxnv*(maxna+1) ),
     &        GWRK5( maxna*maxna ), WORK(4*IXMAX)
c
c  version x01
c
c     Green's function tables
cv7
      integer ivp (izmax+1),      ivv (izmax*maxnv),
     &        ivp2(izmax+1),      ivv2(izmax*maxnv),
     &        ixp (izmax*maxnv+1),ixx (ixmax*izmax),
     &        ixp2(izmax*maxnv+1),ixx2(ixmax*izmax)

      real str1(maxnt),           str2(maxnt), 
     &     sti1(maxnt),           sti2(maxnt),
     &     gti1(maxnt),           gti2(maxnt),
     &     gtr1(maxnt),           gtr2(maxnt),
     &     sxi1(ixmax+1, maxna),  sxi2(ixmax+1,maxna),
     &     sxr1(ixmax+1, maxna),  sxr2(ixmax+1,maxna),
     &     gxi1(ixmax+1, maxna),  gxi2(ixmax+1,maxna),
     &     gxr1(ixmax+1, maxna),  gxr2(ixmax+1,maxna)

C     pointer (pwpr,wpr),(pwnr,wnr),(pwni,wni),(pwpi,wpi)

      real wrwk1(ixmax), wrwk2(ixmax), wiwk1(ixmax), wiwk2(ixmax)
cv8b
      integer map(maxnv)

c     fft table
      real ffttab(5*ixmax)

c     number of velocities per depth segment
      integer numvel(izsegm)

c     reciprocical of velocities per depth segment
      real slop(maxnv,izsegm)

CVXZ1 MEMORY MAP ARRAYS FOR INC AND REFLECTED FIELDS
      complex ciwork(ixmax,iwmax),crwork(ixmax,iwmax)
C
      DATA DIRINC, DIRRFL / -1.0, 1.0 /
C
C---------------------------------------------------------------------
C
CCC   INITIALIZE AND VALIDATE DIMENSIONS
C
      NX     = IXLN0(IXS)
      NXLN   = IXLN(IXS)
      NXLN1  = IXLN1(IXS)
      JXOFF  = IXST0(IXS)
      JXST   = IXST(IXS)-1
      JXBIAS = IXBIAS(IXS)
      NXBYTE = 4 * IXLEN
      NT2    = 2 * NV * NA
      NX2    = 2 * NX
      NX8    = 8 * NX
      NP     = 2 * NA + NV + 17
cv8c  set maximum width
      xmax = dx*nxln1

cv7   set na2 = msk
      na2 =msk

cv8c  clear rimage:
      lrimag = 0
      do 10 izs=1,izseg
   10 lrimag = lrimag + jzrow(izs)
      lrimag = lrimag * nxln1
C     rimage(1:lrimag) = 0.
      call vclr(rimage,1,lrimag) 

cv8c  check for maximum realizable depth
      call maxdep(dz,vmin,vmax,izseg,izsegm,pray,tend,xmax,zmaxd,jzrow,
     &            luprt)


C
C     COMPUTE CONSTANTS FOR DIP FILTER K LIMITS
C
      PIRAD = PI / 180.0
      CALL PWROF2 (NX, IPWR2)
      NXPW2  = 2 ** IPWR2
      DKOVER = ( DX0 * NXPW2 ) / (2.0 * PI)
C
C     COMPUTE LARGEST AND SMALLEST ANGLES TO PASS
C
      PID2  = PI / 2.0
      ANGR1 = AMAX1( -PID2, ( ANGL(JBLK) - BMWTHR) * PIRAD )
      ANGR2 = AMIN1(  PID2, ( ANGL(JBLK) + BMWTHR) * PIRAD )
      ANGI1 = AMAX1( -PID2, (-ANGL(JBLK) - BMWTHI) * PIRAD )
      ANGI2 = AMIN1(  PID2, (-ANGL(JBLK) + BMWTHI) * PIRAD )
C
C     COMPUTE SLOWNESS LIMITS FOR DIP FILTER K LIMITS
C
      P1R =  SIN( ANGR1 ) / VELREF
      P2R =  SIN( ANGR2 ) / VELREF
      P1I =  SIN( ANGI1 ) / VELREF
      P2I =  SIN( ANGI2 ) / VELREF
C
C     SET INITIAL K LIMITS
C
      K1I = 0
      K2I = 0
      K1R = 0
      K2R = 0
      KR  = 25
      KFF = IDIPZ
C
      PARM(1) = DX0
      PARM(2) = DX
      PARM(3) = EPSLN

      idflg = 0
      idbeg = jzln-1
      idend = jzln
C
CCC   LOOP 130: VERTICAL SEGMENTS
C
      DO 130 IZS = 1, IZSEG
C
cv8d     WRITE (LUPRT, *) 'BEGIN VERTICAL SEGMENT ', IZS
cv8d     IF(JBLK.EQ.1) CALL PWPRTC (LUPRT, IXS, IZS, 1)
C
         KFF = 0    
         IF((IZS-1)/4*4 .EQ. (IZS-1)) KFF = IDIPZ
         NZ  = JZROW(IZS)
         NXZ = NX * NZ
         JZB = IZB(IZS)
         DZ0 = DZ(IZS)

cv8c     if the starting depth in this segment is greater than the
cv8c     maximum realizable depth, do not image
cvf3

c        compute the limits of taper of output trace
         if(idflg.eq.0) then
          if(ztable(jzb+1).ge.zmaxd) then
           iprev = 1
           if(izs.gt.1) iprev = izb(izs-1) + 1
           idbeg = ztable(iprev)/dzout+1
           if(idbeg.lt.1) idbeg = 1
           ipres = izb(izs) + 1
           idend = ztable(ipres)/dzout+10
           if(idend.gt.jzln) idend = jzln
           idflg = 1
          endif
         endif

          if(ztable(jzb+1).ge.zmaxd) go to 130
C
CCC      FETCH VELOCITY INDEX TABLE FROM DISK
C
         KZ = 1 - NX
         DO 110 JZ = 1, NZ
            KZ = KZ + NX
            LZ = JZ + JZB
            CALL DAREAD (LZ, INDREC, LUMTX, NXBYTE)
            CALL VMOV (INDREC(JXOFF), 1, INDEX(KZ), 1, NX)
  110    CONTINUE
CCRAY     scan index matrix for horizontal changes
         call xgenix(nx, nz, index, iwrk, ivp, ivv, ixp, ixx)
         call xgenix(nx, nz, index, iwrk,ivp2,ivv2,ixp2,ixx2)
cf8b     scan index matrix for indices that occur in this segment
         call scnmtx(index,nx,nz,map,nv)

C
CCC      PERFORM CONTINUATION AND IMAGING FOR EACH OMEGA

         DO 120 JW = 1, NW
cvs2
cvs2       check for spatial aliasing
cvs2
           wnyqp = ommax
           if(pray.ne.0.) then
           wnyqp = pi/(2.*dx0*abs(pray))
           endif
           if(wnyqp.lt.omega(jw)) go to 120

C
CCC         FETCH THE WAVEFIELDS AT TOP OF Z SEGMENT FROM DISK
C
CVXZ1       CALL DAREAD (JW, CINC, LUINC, NX8) (memory map from ciwork)
            call vmov(ciwork(1,jw),1,cinc,1,nx*2)
CVXZ1       CALL DAREAD (JW, CRFL, LURFL, NX8) (memory map from crwork)
            call vmov(crwork(1,jw),1,crfl,1,nx*2)
C
CCC         COMPUTE GREEN'S FUNCTION TABLES
C
            MSK1 = PI * VMIN(IZS) / OMEGA(JW) / DX0 -1
            IF (MSK1 .LE. 0) MSK1 = 1
            IF(MSK1.GT.8) MSK1 =  8
            DX1 = DX0 * FLOAT( MSK1 )
            mskbig = 8
C
cv6***
            dz1 = dz0
            izskp = 1
            if(iextrp.gt.0) then
             theta = angl(jblk) * pirad
             izskp = iextrp * ommax / omega(jw) / abs(cos(theta))
c***         if(izskp.gt.6) izskp = 6
c***         if(izskp.eq.5) izskp = 4
             if(izskp.gt.3) izskp = 3
             dz1 = dz0 * izskp
            endif
cv6***
C
CNDW12-3-86 COMPUTE NA1 FROM VMAX,OMEGA,ETC
c**       NA1 =  5.0*VMAX(IZS)/( OMEGA(JW)/(2.*PI) )/(MSK1* DX0)
c**       IF(NA1.GT.NA) NA1=NA
c**       NA1 = NA
          na1 = nabot
          if(izseg.gt.1) na1 =
     &    nabot - (izseg-izs)/(izseg-1)*(nabot-natop)

          prcnt = 70
          if(izseg.gt.1) prcnt =
     &    85.- (izseg-izs)/(izseg-1)*(85.-70.)
cv8b
            nvs = numvel(izs)
            CALL XGTABM(PRCNT,OMEGA(JW),DX1,DZ1,DIRINC,SLOP(1,izs),map,
     &          GWRK1, GWRK2, GWRK3, GWRK4, GWRK5, gti1, gti2, NVS,NA1)
            CALL XGTABM(PRCNT,OMEGA(JW),DX1,DZ1,DIRRFL,SLOP(1,izs),map,
     &           GWRK1, GWRK2, GWRK3, GWRK4, GWRK5, gtr1, gtr2,NVS,NA1)
           if(izskp.gt.1) then
            CALL XGTABM(PRCNT,OMEGA(JW),DX1,DZ0,DIRINC,SLOP(1,izs),map,
     &           GWRK1, GWRK2, GWRK3, GWRK4, GWRK5, sti1, sti2, NVS,na2)
            CALL XGTABM(PRCNT,OMEGA(JW),DX1,DZ0,DIRRFL,SLOP(1,izs),map,
     &           GWRK1, GWRK2, GWRK3, GWRK4, GWRK5, str1, str2, NVS,na2)
           endif
cv6
C
C           GENERATE WAVEFIELD FILTERS
C
            K1I = DKOVER * OMEGA(JW) * P1I
            K2I = DKOVER * OMEGA(JW) * P2I
            K1R = DKOVER * OMEGA(JW) * P1R
            K2R = DKOVER * OMEGA(JW) * P2R
cvs2
CVXZ1
            krrfl  = 0.5* dkover * omega(jw) / velref
            krinc  = 0.5* dkover * omega(jw) / velref

C
            CALL GCFILT (0.0, 1.0, K1I, K2I, KRINC, FINC, NX, MX)
            CALL GCFILT (0.0, 1.0, K1R, K2R, KRRFL, FRFL, NX, MX)
C
C
CCC         DOWNWARD CONTINUE WAVEFIELDS AND IMAGE OVER THE Z SEGMENT
CCRAY
cv7
            nalarg = max0(na,natop,nabot,na1,na2)
            CALL XDCIM6 (NA1,na2,NX,NZ,JW, MSK1, IMG, KFF, FINC, FRFL,
     &           gti1, gti2, gtr1, gtr2, gxi1, gxi2, gxr1, gxr2,
     &           ivp, ivv, ixp, ixx, cinc, crfl,
     &           wrk1, wrk2, wrk3, wrk4, ffttab, rii, rri,
     &           sti1, sti2, str1, str2, sxi1, sxi2, sxr1, sxr2,
     &           ivp2, ivv2, ixp2, ixx2,
     &           wrwk1, wrwk2, wiwk1, wiwk2, izskp , ixtap ,na1,izs,
     &           mskbig, pwpr,pwnr,pwni,pwpi,nalarg) 
cv7
C
CCC         STORE THE WAVEFIELDS AT BOTTOM OF Z SEGMENT ON DISK
C
CVXZ1       CALL DAWRTE (JW, CINC, LUINC, NX8) (memory map to ciwork)
            call vmov(cinc,1,ciwork(1,jw),1,nx*2)
CVXZ1       CALL DAWRTE (JW, CRFL, LURFL, NX8) (memory map to crwork)
            call vmov(crfl,1,crwork(1,jw),1,nx*2)
C
  120    CONTINUE
C
CCC      COMPUTE REFLECTIVITY, RESAMPLE, AND TRANSPOSE
C
         CALL FRRST (NX, NZ, NXLN, IZLN, JZB, IMG, PARM, RII, RRI,
     &               RIMAGE)
  130 CONTINUE
C
CCC   RESAMPLE DEPTH SECTION, APPEND TRACE HEADERS + OUTPUT TO OTAP
C
      PARM(1) = ZTABLE(1)
      PARM(2) = DZOUT
      PARM(3) = 0.5
      PARM(4) = 0.5
      PARM(5) = 0.0
C
      IFLAG  = 0
      ICINIT = 1
ccms  NBYTES = 256 + 4 * JZLN
CCRAY  tapeio actually writes bytes
      nbytes = (JZLN + ITRWRD) * ISZBYT
      KX     = (JXBIAS -JXST) * IZLN + 1
cvf3
      do 319 jz = 1,jzln
 319  wrk4(jz) = float(jz-1)*dzout


      DO 210 JX = 1, NXLN1
cvf3     CALL XFSMP (ZTABLE, RIMAGE(KX), IZLN, DATA, JZLN, PARM,
cvf3 &               IWRK, WRK1, WRK2, WRK3, WRK4,IFLAG)
cdan10/29/93 set first sample to zero and interpolate starting with data(2)
      data(1) = 0.0
      CALL
     &CCUINT(ZTABLE,RIMAGE(KX),IZLN,WRK4,data(2),jzln,iwrk,wrk1,ICINIT)

      if(jx.eq.1) then
      do 212 jz=1,idend-idbeg+1
212   rii(jz) = 1.- float(jz)/float(idend-idbeg+1)
      endif

      do 213 jz=idbeg,idend
213   data(jz) = rii(jz-idbeg+1)*data(jz)


         IFLAG = 1
         ICINIT = 0
C
         JNTR = JX + JXBIAS
CCRAY     CALL DAREAD (JNTR, ITRH, LUHDR, 256)
         CALL DAREAD (JNTR, ITRH, LUHDR, ITRWRD*4)
C
         CALL SAVEW(ITRH, 'RecNum', JBLK, TRCHED)
         CALL SAVEW(ITRH, 'TrcNum', JNTR, TRCHED)
cmat     ITRH(106) = JBLK
cmat     ITRH(107) = JNTR

         CALL WRTAPE (lu24, TRACE, nbytes)
CCRAY     CALL WRTAPE (lu24, TRACE, NBYTES)
C
         KX = KX + IZLN
  210 CONTINUE
C
      RETURN
      END
