C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    NAME: fxscoef                                                         *
c PURPOSE: fxscoef computes 1-d extrapolation coefficients
c          for f-x downward continuation.
c
c***********************************************************************
c
      subroutine fxscoef( table, nap, nawov, awov0, dawov, dx, dz,
     &                   switch, nkx )
c
      implicit none
c
c parameters:
c
      real      pi              !
      integer   atten           !
      integer   maxnawov        !
      integer   nkxmax          !
      parameter ( pi = 3.14159265358979 )
      parameter ( maxnawov = 1024, nkxmax = 1024, atten = 10 )
c
      integer nkx, nap, nawov
      integer mkx, ikx, jkx, ia, ixkx
c
      complex table(nap,nawov), c_op(nkxmax), c_test(nkxmax)
      complex flata, myflata, scale
      real    kx(nkxmax), wind(nkxmax)
      real    disc1, fit_aa, fit_bb, xkx, rxprime, switch
      real    dawov, awov0, awov, rawovsq, rxkx2
      real    dz, dx, phi, amp
c***********************************************************************
c     print *, 'vmax, vmin      = ', vmax, vmin
c     print *, 'wmax, wmin      = ', wmax, wmin
c     print *, 'nawov, nap, nkx = ', nawov, nap, nkx
c     print *, 'dx, dz          = ', dx, dz
c     print *, 'switch          = ', switch
c***********************************************************************
      if( nawov .eq. 0 ) nawov = maxnawov
      mkx = nkx / 2 + 1
c
c===  using an inverse fft,  make the extrapolators for a range
c     of indices
c
      do ikx = 2, nkx/2
         jkx     = nkx + 2 - ikx
         kx(ikx) = 2.0 * pi * ( ikx - 1 ) / ( nkx * dx )
         kx(jkx) = - kx(ikx)
      enddo
c
      kx(1)   = 0.0
      kx(mkx) = pi / dx
c
c===  construct the window function: raised cosine
c
      do ikx = 1, nkx
         wind(ikx) = 0.0
      enddo
c
      wind(1) = 1.0
      do ikx = 2, min( nap, nkx/2+1 )
         jkx       = nkx + 2 - ikx
         wind(ikx) = 0.5 * ( cos( ( ikx-1 ) * pi / nap ) + 1.0 )
         wind(jkx) = 0.5 * ( cos( ( ikx-1 ) * pi / nap ) + 1.0 )
      enddo
c
c===  loop over "awov's", build phase shift ops (awov = omega/vel)
c
      do ia = 1, nawov
c
         awov = ( ia - 1 ) * dawov + awov0
c
         if( awov .eq. 0.0 ) then
            do ikx = 1, nkx
               c_op(ikx) = cmplx( 0.0, 0.0 )
            enddo
         else
c
c=========  figure out where the appropriate point to switch is
c
            rawovsq = 1.0 / ( awov * awov )
            xkx     = switch * awov
            rxkx2   = 1.0 / ( 2.0 * xkx )
            ixkx    = int( xkx / kx(2) ) + 1
            rxprime = xkx / awov
            fit_aa  = -0.5 / sqrt( 1.0 - rxprime**2 )
            fit_bb  = sqrt( 1.0 - rxprime**2 )
     &                + 0.5 * rxprime**2 / sqrt( 1.0 - rxprime**2 )
c
            if( ixkx .ge. 5 ) then
               do ikx = 2, nkx/2
                  jkx = nkx + 2 - ikx
c
                  if( ikx .le. ixkx ) then
                     disc1 = 1.0 - kx(ikx) * kx(ikx) * rawovsq
                     amp   = 1.0 / ( 1.0 + ( kx(ikx) * rxkx2 )**atten )
                     phi   = dz * awov * sqrt( disc1 )
                     c_op(ikx) = cmplx( amp * cos( phi ),
     &                                  amp * sin( phi ) )
                     c_op(jkx) = c_op(ikx)
                  else
                     disc1 = kx(ikx) * kx(ikx) * rawovsq
                     amp   = 1.0 / ( 1.0 + ( kx(ikx) * rxkx2 )**atten )
                     phi   = dz * awov * ( fit_bb + fit_aa * disc1 )
                     c_op(ikx) = cmplx( amp * cos( phi ),
     &                                  amp * sin( phi ) )
                     c_op(jkx) = c_op(ikx)
                  endif
c
               enddo
c
c============  fix up zero kx
c
               phi = dz * awov
               c_op(1) = cmplx( cos( phi ), sin( phi ) )
	       flata = c_op(1)
c
c=========     fix up nyquist
c
               if( mkx .le. ixkx ) then
                  disc1 = 1.0 - kx(mkx) * kx(mkx) * rawovsq
                  amp   = 1.0 / ( 1.0 + ( kx(mkx) * rxkx2 )**atten )
                  phi   = dz * awov * sqrt( disc1 )
                  c_op(mkx) = cmplx( amp * cos( phi ), amp * sin( phi ))
               else
                  disc1 = kx(mkx) * kx(mkx) * rawovsq
                  amp   = 1.0 / ( 1.0 + ( kx(mkx) * rxkx2 )**atten )
                  phi   = dz * awov * ( fit_bb + fit_aa * disc1 )
                  c_op(mkx) = cmplx( amp * cos( phi ), amp * sin( phi ))
               endif
c
            else
c
               do ikx = 1, nkx
                  c_op(ikx) = cmplx( 0.0, 0.0 )
               enddo
c
	       flata = cmplx( 1.0, 0.0 )
c
            endif
c
c======     end check on 0 frequency
c
         endif
c
c======  bring the operator to the space domain
c
         call cefftp( c_op, nkx, 1 )
c
c======  apply the correct window function to each
c
         do ikx = 2, nkx/2
            jkx       = nkx + 2 - ikx
            c_op(ikx) = c_op(ikx) * wind(ikx)
            c_op(jkx) = c_op(jkx) * wind(jkx)
         enddo
c
         c_op(1)   = c_op(1)   * wind(1)
         c_op(mkx) = c_op(mkx) * wind(mkx)
c
c======  make a copy of the operator in x to transform back to kx
c        transform it back and select off the kx value
c        do nothing for the very low frequency case
c
	 if( ixkx .ge. 5 ) then
	    do ikx = 1, nkx
	       c_test(ikx) = c_op(ikx)
	    enddo
c
	    call cefftp( c_test, nkx, -1 )
	    myflata = c_test(1)
	 else
	    myflata = cmplx( 1.0, 0.0 )
	 endif
c
c======  load the extrapolators into the table
c
         scale = flata / myflata
         do ikx = 1, nap
            table(ikx,ia) = scale * c_op(ikx)
         enddo
c
c===  ok,  end for this "awov"
c
      enddo
c
c===  all done
c
c***********************************************************************
      return
      end
c***********************************************************************
c    NAME: cefft
c PURPOSE: cefftp performs a 1-D, radix-2 complex to complex Fourier
c          transform.  Based on Les Hattons coding of the routine "fork"
c          from FGDP.
c
c-----------------------------------------------------------------------
c
C   cefftp( x, n1, sign ): n1 complex to n1 complex
C
C   arguments:
C
C      x        input output complex array
C      n1       number of complex elements in array; must be a power of
C               two
C      sign     sign of sqrt(-1); +1 is forward transform, -1 inverse
C               transform
C
C      scaling by (1/n1) is done on forward transform (sign=1)
C
C***********************************************************************
C
      subroutine cefftp( x, n1, sign )
C
      implicit none
C
      integer           i         !loop counter
      integer           sign      !direction flag for fft.
      integer           istep     !loop increment.
      integer           j         !loop counter
      integer           l         !work variable
      integer           n1        !number of samples in rarray.
      integer           m         !work variable
C
      doubleprecision   factlt    !1./n1
      doubleprecision   pi        !mathematical constant
C
      complex*16        carg      !work variable.
      complex*16        ctemp     !work variable
      complex*16        cw        !work variables.
      complex           x(n1)     !data array.
C
      parameter (pi = 3.14159265358979323846)
C
C-----------------------------------------------------------------------
C
      if( sign .eq. 1 )  then
C
C        forward transform, scale the time series.
C
         factlt = 1.0 / n1
C
         do 5 i = 1, n1
            x(i) = x(i) * factlt
    5    continue
C
      endif
C
C     initialize the pointers.
C
      j    = 1
C
C     do the bit-reverse addressing.
C     ==============================
      do 10 i = 1, n1                                 !do
         if (i .lt. j)  then                          !
C                                                     !
C             swap.                                   !
C                                                     !
              ctemp  = x(j)                           !
              x(j)   = x(i)                           !
              x(i)   = ctemp                          !
C                                                     !
         endif                                        !
C                                                     !
         m = n1 / 2                                   !
C                                                     !
    7    continue                                     !  @do forever
              if( j .le. m ) go to 8                  !  @..exitdo
              j = j - m                               !  @
              m = m / 2                               !  @
              if( m .lt. 1 )  go to 8                 !  @..exitdo
              go to 7                                 !  @
    8    continue                                     !  @enddo
C                                                     !
         j = j + m                                    !
C                                                     !
   10 continue                                        !enddo
C
C     now do the transform.
C     =====================
      l       = 1
C
   20 continue                                        !do forever
         istep = 2*l                                  !
         do 40 i = 1, l                               !   @do
              carg = (0.,1.) * (pi*sign*(i-1)) / l    !   @
              cw   = exp( carg )                      !   @
              do 30 j = i, n1, istep                  !   @   @do
                   ctemp  = cw   * x(j+l)             !   @   @
                   x(j+l) = x(j) - ctemp              !   @   @
                   x(j  ) = x(j) + ctemp              !   @   @
   30         continue                                !   @   @enddo
C                                                     !   @
   40    continue                                     !   @enddo
C                                                     !
         l = istep                                    !
         if( l .ge. n1 )  go to 50                    !..exitdo
         go to 20                                     !
   50 continue                                        !enddo
C
      return
      end
