C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c
      subroutine fxsgeom( LER, LUGEOM, gtape, nxv, ntrc, nrec, dx
     &             , nshift, nlive, nsta, soptnm, nxldata, nxrdata
     &             , zsta, ierr )
c
      implicit none
c
c input parameters:
c
      character gtape*(*)       ! name of geometry file
      integer   LER             ! logical unit number, error file
      integer   LUGEOM          ! logical unit number, geometry file
      real      dx              ! delta x
      integer   nrec            ! number of records in input dataset
      integer   ntrc            ! number of traces per record in input
      integer   nxv             ! number of x's in velocity file
c
c output parameters:
c
      integer   ierr            ! error flag
      integer   nlive(nrec)     ! number of live stations in shot
      integer   nshift          ! offset number between station numbers
                                ! and velocity model
      integer   nsta            ! total number of stations in data
      integer   nxldata(nrec)   ! # of traces to left of shot in data
      integer   nxrdata(nrec)   ! # of traces to right of shot in data
      integer   soptnm(nrec)    ! station number of shot
      real      zsta(*)         ! depth at receiving stations
c
c local variables:
c
      real      dstation        ! distance between stations
      integer   is              ! shot (record) or station index
      integer   isleft          ! station number, first live trace
      integer   isright         ! station number, last live trace
      integer   ischk           ! shot (record) or station index, check
      integer   nshot           ! number of shots (records) in geo file
      integer   ntrace          ! number of traces per shot in geo file
c
c***********************************************************************
      ierr = 0
      open( unit = LUGEOM, file = gtape, status = 'old', iostat=ierr )
      if( ierr .ne. 0 ) then
         write( LER,'('' ***** ERROR: Unable to open geometry file: ''
     &              ,(a))') gtape
         go to 800
      endif
c
      read( LUGEOM, *) ntrace, nshot, nshift, nsta, dstation
c
c===  sanity checking
c
      if( ntrace .ne. ntrc ) then
         write( LER, * ) ' ***** ERROR IN GEOMETRY FILE: '
     &                  , 'ntrace must equal ntrc *****'
     &                  , ' ntrace, ntrc = ', ntrace, ntrc
         ierr = 1
      endif
c
      if( nshot .ne. nrec ) then
         write( LER, * ) ' ***** ERROR IN GEOMETRY FILE: '
     &                  , 'nshot must equal nrec *****'
     &                  , ' nshot, nrec = ', nshot, nrec
         ierr = 1
      endif
c
      if( nxv .ne. nsta )then
         write( LER, * ) ' ***** WARNING: IN GEOMETRY FILE ***** '
         write( LER, * ) '       nxv not equal to nsta, '
     &                  , '  nxv = ', nxv, ' not = ', nsta
         if( nxv. gt. nsta ) then
            write( LER, * ) '   proceed assuming extra '
     &      , 'pads to right of velocity model ****'
         else
            write( LER, * ) ' ******* ABORTING ******'
            ierr = 1
         endif
      endif
c
      if( dstation .ne. dx ) then
         write( LER, * ) ' ***** ERROR IN GEOMETRY FILE: '
     &                  , 'dstation must equal dx *****'
     &                  , ' dstation, dx = ', dstation, dx
         ierr = 1
      endif
c
      if(ierr.ne.0 ) go to 800
c
c===  get receiver depths
c
      do is = 1, nsta
         read( LUGEOM , * ) ischk, zsta(is)
         if( is .ne. ischk ) then
            write( LER, * ) ' ***** ERROR IN GEOMETRY FILE: '
     &                  , 'is .ne. issta *****'
            ierr = 1
            go to 800
         endif
      enddo
c
c===  read shot parameters
c
      do is = 1, nshot
         read( LUGEOM, * ) ischk, nlive(is), soptnm(is), isleft, isright
         if( is .ne. ischk ) then
            write( LER, * ) ' ***** ERROR IN GEOMETRY FILE: '
     &                  , 'is .ne. isshot *****'
            ierr = 1
            go to 800
         endif
         nxldata(is) = max0( soptnm(is) - isleft, 0 )
         nxrdata(is) = max0( isright - soptnm(is), 0 )
      enddo
c***********************************************************************
800   continue
      close(LUGEOM)
      return
      end
c***********************************************************************
