/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>

#ifdef CRAY
#define POLYFT POLYFT
#else
#if defined( SUNSYSTEM ) || defined( LINUXSYSTEM ) || defined( CONVEXSYSTEM ) || defined (SGISYSTEM)
#define POLYFT polyft_
#else
#define POLYFT polyft
#endif
#endif

#define SLOP 10
double pow();
 
void fspline(picks,ntr,order)
int ntr,order;
float *picks;
{
  float *a, *b, *c, *d;
  float *wrk, *wrk1, *iwrk, ztol, chisq, *dataval;
  static int stride=1;
  int i, ierr, k;
 
  a= (float *)malloc(ntr*sizeof(float));
  b= (float *)malloc(ntr*sizeof(float));
  c= (float *)malloc(ntr*sizeof(float));
  d= (float *)malloc((order+1)*sizeof(float));
  wrk= (float *)malloc((order+1)*(order+1)*sizeof(float));
  wrk1= (float *)malloc( (ntr>(2*(order+1))?ntr:(2*(order+1)) )
                   *sizeof(float));
  iwrk= (float *)malloc((order+1)*sizeof(int));
 
  ztol = 0.0;
  ierr = 0;
 
  for(i=0;i<ntr;i++) {
       *(a+i)=(float)i;
       *(b+i)=*(picks+i);
       *(c+i)=1.0;
  }
  POLYFT(a,&stride,b,&stride,c,&stride,&ntr,&order,
           d,wrk,wrk1,iwrk,&ztol,&chisq,&ierr);
  for(k=0;k<ntr;k++){
    dataval = &picks[k];
    *dataval = 0.0;
    for (i=0; i<order; i++) {
      *dataval+=(*(d+i))*(float)pow((double)k,(double)(order-i));
    }
    *dataval += (*(d+order));
  }
  free(a); free(b); free(c); free(d); free(wrk); free(wrk1); free(iwrk);
}

void fspline_( curve, npts, order )             /* FORTRAN interface */
        float           *curve;
        unsigned        *npts, *order;
{
        fspline( curve, *npts, *order );
}
