C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                       
C     SUBROUTINE - SHELL2                ENTRY POINT - SHELL2           
C                                                                       
C     LANGUAGE - FORTRAN 77                                             
C     SYSTEM - IBM                                                      
C     AUTHOR - DOUGLAS BODDY                                            
C     DATE WRITTEN - MAY 1983                                           
C                                                                       
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE 
C                                                                       
C     ABSTRACT - SORT A VECTOR V OF N ELEMENTS ALONG WITH AN INDEX      
C                VECTOR.                                                
C                                                                       
C     USAGE                                                             
C                                                                       
C          CALL SHELL2 (V,W,N)                                          
C                                                                       
C              V      =  VECTOR TO SORT.                                
C              W      =  WORK ARRAY.                                    
C              N      =  NUMBER OF V ELEMENTS TO SORT.                  
C                                                                       
C    SUBROUTINES CALLED - NONE                                          
C                                                                       
C    FILES REQUIRED/GENERATED - NONE                                    
C                                                                       
C    ERROR FILE AND MNEUMONIC - NONE                                    
C                                                                       
C    ERROR/RETURN CODES - NONE                                          
C                                                                       
CX**********************************************************************
C                                                                       
C***********************************************************************
      SUBROUTINE SHELL2 (V,V1,V2,V3,N)                                         
C                                                                       
      REAL V(*),V1(*),V2(*),V3(*),X,X1,X2,X3

C                                                                       
      IGAP = N / 2                                                      
 10   IF (IGAP.GT.0) THEN                                               
         IPGAP = IGAP + 1                                               
C                                                                       
         DO 30 I = IPGAP,N                                              
            J = I - IGAP                                                
 20         IF (J.GT.0) THEN                                            
               JG = J + IGAP                                            
               IF (V(J).GT.V(JG)) THEN                                  
                  X = V(J)                                              
                  X1 = V1(J)                                              
                  X2 = V2(J)                                              
                  X3 = V3(J)                                              
                  V(J) = V(JG)                                          
                  V1(J) = V1(JG)                                          
                  V2(J) = V2(JG)                                          
                  V3(J) = V3(JG)                                          
                  V(JG) = X                                             
                  V1(JG) = X1
                  V2(JG) = X2
                  V3(JG) = X3
               ENDIF                                                    
               J = J - IGAP                                             
               GO TO 20                                                 
            ENDIF                                                       
 30      CONTINUE                                                       
C                                                                       
         IGAP = IGAP / 2                                                
         GO TO 10                                                       
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                              

