C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine anmut0 (v, nzmax, nxmax, nzgrid, nxgrid, nzout, dzout,
     &                   dzgrid, dxout, angle, nzst, nap, velmax,vmute)

#include <f77/iounit.h>

c     Compute angle dependent mute - D. Whitmore

      real    v(nzmax,nxmax), work(5000), velmax, slo(5000)
      integer nzst(*)

c     v              = velocity matrix
c     nzmax, nxmax   = max dimensions of v
c     nzgrid, nxgrid = actual dimensions of v
c     nzout          = max no of z samples at dzout
c     dzgrid, dxgrid = sample, trace spacings of v
c     dzout          = migration depth spacing
c     angle          = emergent angle
c     nzst           = returned z index for each x
c     2*nap+1        = number of x coordinates in nzst
c     velmax         = maximum velocity
c
      data pi / 3.141592653589793 /

c-----------------------------------------------------------------------
c
      radian = pi / 180.0

c     initialize nzst = 1

      do 10 jx = 1, 2*nap+1
         nzst(jx) = 1
   10 continue

c     produce average velocity trace in work

      velmax  = -99999.
      scale = 1.0 / float( nxgrid )
      write(LERR,*)' '
      write(LERR,*)'anmute: nzgrid,nxgrid= ',nzgrid,nxgrid
      write(LERR,*)'anmute: nzmax,nxmax= ',nzmax,nxmax
      do 30 jz = 1, nzgrid
         velmin = 999999.0
cdan     work(jz) = 0.0
         do 20 jx = 1, nxgrid
            if (v(jz,jx) .gt. velmax) velmax = v(jz,jx)
            if (v(jz,jx) .lt. velmin) velmin = v(jz,jx)
cdan        work(jz) = work(jz) + v(jz,jx)
   20    continue
cdan     work(jz) = work(jz) * scale
         work(jz) = velmin
   30 continue
      
c     smooth reference slowness trace
      do js=1,20

       do jz = 1, nzgrid
       slo(jz) = 1./work(jz)
       enddo
       do jz = 2, nzgrid-1
        work(jz) = 3. / (slo(jz-1)+slo(jz)+slo(jz+1)) 
       enddo

      enddo

      write(LERR,*)'anmute: velmax= ', velmax

      if (abs( angle ) .ge. 90.0) go to 100

c     compute ray parameter

      pray = abs( sin( angle * radian ) )/work(1)

      if (abs( pray ) .lt. 0.00000001) go to 100

c     compute the dz0 = cot(angle)*dxout as a function of z

      if(vmute.le.0.0) then 
       do jz = 1, nzgrid
          temp = pray * work(jz)
          if (abs( temp ) .gt. 1.0) temp = 1.0
          work(jz) = dxout * sqrt( 1.0 - temp ** 2 ) / temp
       enddo

      else 

       temp = pray * vmute
       if (abs( temp ) .gt. 1.0) temp = 1.0
       do jz = 1, nzgrid
          work(jz) = dxout * sqrt( 1.0 - temp ** 2 ) / temp
       enddo
      
      endif

c     determine nzst as a function of x

      z = dzgrid + 0.000001
      do 50 jx = nap+1, 2*nap+1
         indz = z / dzgrid
         nzst(jx) = z / dzout
         if (nzst(jx) .lt. 1     ) nzst(jx) = 1
         if (nzst(jx) .gt. nzout ) nzst(jx) = nzout
         if (indz     .gt. nzgrid) indz     = nzgrid
         z = z + work(indz)
   50 continue

c     fill first half of nzst with reciprocal mute pattern

      nbig = 2 * nap + 2
      do 60 jx = 1, nap
         nzst(jx) = nzst(nbig-jx)
   60 continue

  100 continue

      return
      end
