C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GENTIME                                              *
C  DAN WHITMORE                      DATE:  3/07/96                    *
C                                                                      *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C     Memory Space Allocation

      parameter (lhead=6000)
      parameter (llist = 27,  lcrd=25, ltmp= 28)
      parameter (nzmax=2500,len_trace =itrwrd+nzmax,nzpad=2,nxpad=2)

c     header and traces arrays
      dimension ihead(lhead)
      dimension trace(len_trace),rtrd(nzmax)
      integer*2 itrh(itrwrd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))

      real veloc(1)
      real partx(1),partz(1),vdt(1),datao(1)
      real xray(1),zray(1),theta(1)
      pointer (pveloc,veloc), (pdatao,datao)
      pointer (ppartx,partx), (ppartz,partz), (pvdt,vdt)
      pointer (pxray,xray), (pzray,zray), (ptheta,theta)
      integer nzst(1)
      pointer (pnzst,nzst)

      character*1 parr(66)
      character*2 pname
      character*4 version
      character*7 ppname

      character*128 otap,ntap
      equivalence (pname,ppname)

      logical verbos

      data version/' 1.0'/
      data ppname/'GENTIME'/
      data parr/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ',' ',' ',' ',' ','G','E','N',' ','T','I','M','E','S',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/

c     Get Command Line Arguments
      ltrm  = 0
      write(ltrm,*) 'before cmdlin'

      call cmdlin(ntap,otap,ipipi,ipipo,ltrm,verbos,hlfap,nrsmp,
     &vmute,angle,xbeg,xend,xinc,dt,nt,nang,zsrc,ismoo,tmax,ntskip,
     &isec,noint)
      write(ltrm,*) 'noint=',noint

c     Open Input Dataset
      if(ipipi.eq.0) then
C        luin is an input dataset
         call lbopen(luin,ntap,'r')
      else
C        we know luin is a pipe
         luin = 0
         ltrm = 2
      endif

c     Open Output Dataset
      if(ipipo.eq.0)then
C        luout is an output dataset
         call lbopen(luout,otap,'w')
      else
C        we know luout is a pipe
         luout=1
      endif

C     Open printout
      call openpr(llist,lprt,pname,jerr)
      if(jerr.ne.0)stop 200
#include <mbsdate.h>
      nlin=1
      call gamoco(parr,nlin,lprt)
      write(lprt,38)ntap,otap
   38 format(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)

C     Open Input Tape, Get parameters
      lhbyt = 0
      call rtape(luin,ihead,lhbyt)
        if(lhbyt.le.0) then
           call lbclos(luin)
           call lbclos(luout)
           write(0,*)'error in reading input line header'
           stop 73
        endif
      len=7

c     Update Historical Line Header
      call hlhprt(ihead,lhbyt,ppname,len,lprt)

c     Bring in Input Line Header Values
      call saver(ihead, 'NumSmp', num_smp, linhed)
      call saver(ihead, 'NumTrc', num_trc, linhed)
      call saver(ihead, 'SmpInt', ismp_int, linhed)
      call saver(ihead, 'Format', iform, linhed)
      call saver(ihead, 'Dx1000', idx_1000, linhed)
      call saver(ihead, 'Dz1000', idz_1000, linhed)

      if(iform.ne.3)then
         write(lprt,*)'  INPUT TAPE MUST BE FORMAT 3'
         stop 100
      endif

c     
c     Process parameters
c


      dx = float(idx_1000)/1000.
      dz = float(idz_1000)/1000.
      xover = 1./dx
      zover = 1./dz
      if( xend.le.0.0 ) xend = (num_trc)*dx - xbeg
      nap = hlfap/dx + .5
      ntr_out = 2*nap+1
      nx = num_trc+2*nxpad+1
      nxo = ntr_out
      nz = num_smp + nzpad
      zmax = (nz+200)*dz
      nzo = nz
      nrec = nint( (xend - xbeg) / xinc ) + 1
      num_rec = nrec
      nray = 2*nang+1
      ismp_int = dt*1000.
      init  = 0
      xbias = float(nxpad)*dx

c 
c     allocate arrays 
c

c
      jerr1= 0
      jerr2= 0
      jerr3= 0
      jerr4= 0
      jerr5= 0
      jerr6= 0
      jerr7= 0
      jerr8= 0
      jerr9= 0
      isize_veloc = (nz+3)*(num_trc+2*nxpad+3)
      isize_datao = (nzo)*(nxo+3)
      call galloc( pveloc, isize_veloc*iszbyt, jerr1, 'ABORT' )
      call galloc( ppartx, isize_veloc*iszbyt, jerr2, 'ABORT' )
      call galloc( ppartz, isize_veloc*iszbyt, jerr3, 'ABORT' )
      call galloc( pvdt, isize_veloc*iszbyt, jerr4, 'ABORT' )
      call galloc( pdatao,isize_datao*iszbyt, jerr5, 'ABORT' )
      call galloc( pxray, nray*(nt+15)*iszbyt, jerr6, 'ABORT' )
      call galloc( pzray, nray*(nt+15)*iszbyt, jerr7, 'ABORT' )
      call galloc( ptheta, nray*iszbyt, jerr8, 'ABORT' )
      call galloc( pnzst, (2*nap+1)*iszbyt, jerr9, 'ABORT' )
c

c        Read velocities from the input dataset

c        read 1st trace and copy into first nxpad traces of veloc
         if(nap.gt.0) then
          call rtape(luin,trace,jeof)
            if(jeof.le.0) then
              call lbclos(luin)
              call lbclos(luout)
              write(0,*)'error in reading input'
              write(0,*)'rec,trace=',jrec,jtrc
              stop 74
            endif
          jcnt=0
          do jtrc=1,1+nxpad
           jcnt=jcnt+1
           izx2d = nz*(jcnt-1) 
           call vmov(rtrd,1,veloc(1+izx2d) ,1,num_smp)
           do jz=num_smp+1,num_smp+nzpad
           veloc(jz+izx2d) = rtrd(num_smp)
           enddo
          enddo
         endif
 
c        read the additional num_trc-1 traces into veloc
         do jtrc=2,num_trc
            jcnt=jcnt+1
            jeof=0
            call rtape(luin,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(0,*)'error in reading input'
                 write(0,*)'rec,trace=',jrec,jcnt
                 stop 74
              endif
            izx2d = nz*(jcnt-1) 
            call vmov(rtrd,1,veloc(1+izx2d),1,num_smp)
            do jz=num_smp+1,num_smp+nzpad
             veloc(jz+izx2d) = rtrd(num_smp)
            enddo
         enddo

c        pad nap more traces to veloc
         do jtrc=1,1+nxpad
         jcnt=jcnt+1
          izx2d = nz*(jcnt-1) 
          call vmov(rtrd,1,veloc(1+izx2d),1,num_smp)
          do jz=num_smp+1,num_smp+nzpad
           veloc(jz+izx2d) = rtrd(num_smp)
          enddo
         enddo
         nvel_trc = jcnt

 
c        compute mute lines
         nxvel = nvel_trc
         nzvel = num_smp+nzpad
         angl0 = abs(angle)+.5
         call anmut0 (veloc, nzvel, nxvel, nzvel, nxvel, num_smp, dz,
     &                   dz, dx, angl0, nzst, nap, velmax, vmute)

C
C     Set Output Header Info
C

c     line headers words out:
      call savew(ihead, 'NumSmp', num_smp, LINHED)
      call savew(ihead, 'NumTrc', ntr_out, LINHED)
      call savew(ihead, 'NumRec', num_rec, LINHED)
      call savew(ihead, 'SmpInt', ismp_int, LINHED)
      call savew(ihead, 'Format', iform, LINHED)
c     for a kludge, save spatial tt map increment in Dy1000 
c     for potenial later use                                     
      idx_1000 = nint(dx*1000.)
      idy_1000 = nint(xinc*1000.)
      call savew(ihead, 'Dx1000', idx_1000, LINHED)
      call savew(ihead, 'Dy1000', idy_1000, LINHED)
      call savew(ihead, 'Dz1000', idz_1000, LINHED)
      call wrtape(luout,ihead,lhbyt)
 
C     Process output records
     
      do jrec = 1,nrec

C     Build initial conditions for rays        
         p      = 0.
         prtol  = 0.0
c        NOTE: the ray tolerance in rkrayx is commented out
         nray   = 2*nang+1
         dang   = abs(angle)/nang
         angray = -abs(angle)-dang
         xsrc   = xbeg + (jrec-1)*xinc + xbias
         ixsrc  = xsrc/dx + .5
         do jray=1,nray
         angray = angray+dang
         zray(jray) = zsrc 
         xray(jray) = xsrc
           if(angray.gt.179.0 .or. angray.lt.-179.0) then
           write(lprt,*) 'angle out of range'
           stop 100
           endif
         theta(jray) =  angray*3.141592653589793/180.
         enddo

c
c     Trace Rays
c
     

      write(0,*) 'generating tt maps, rec ',jrec,' x = ', xsrc-xbias
      
      call       rkrayx( nz   ,nx     ,nray ,nt   ,
     &                   nz   ,nx     ,nray ,nt   , ntskip ,
     &                   dz   ,dx           ,dt   ,
     &                   veloc,ismoo  ,
     &                   partz,partx  ,vdt  ,init ,
     &                   theta,
     &                   zray ,xray   ,p    ,prtol,      dz,dx )
      init = 1

C     Process Output Records

      tdead = tmax*1000.
      do jj = 1,nxo*nzo
      datao(jj) = tdead
      enddo

      jbeg = 1
      jend = tmax/dt


c       grid rays
        do jt = jend,jbeg,-1
          ratz = 0
          ratx = 0
          do jray = 1, nray-1
           j2d = jray+(jt-1)*nray
           diffz= abs(zray(j2d+1)-zray(j2d))
           diffx= abs(xray(j2d+1)-xray(j2d))
           if(ratz.lt.diffz) ratz = diffz
           if(ratx.lt.diffx) ratx = diffx
          enddo
         nzrat = ratz*zover
         nxrat = ratx*xover
         nrsmp1 = max0(nzrat,nxrat) + 2
         if(nrsmp1 .gt. nrsmp+1) nrsmp1 = nrsmp+1

         time  = dt*float(jt)
         nrsmp2 = nrsmp1 - 1
         if(noint.ne.0) nrsmp2=0
         if(nrsmp2.ge.0) then
          step   = 1.0 / float( nrsmp1 )
          stepz  = zover * step
          stepx  = xover * step
          alphaz = zover
          alphax = xover
          betaz  = 0.0
          betax  = 0.0
          do i = 0, nrsmp2
          alphaz = alphaz - stepz
          alphax = alphax - stepx
          betaz  = betaz  + stepz
          betax  = betax  + stepx
           do jray = 1, nray-1
           j2d = jray+(jt-1)*nray
           z1 = zray(j2d)
           z2 = zray(j2d+1)
           if(z1.ge.dz .and. z2.ge.dz) then
            izloc=alphaz*z1 + betaz*z2 +.5
            ixloc=alphax*xray(j2d) +betax*xray(j2d+1)+.5
            ixloc=ixloc - ixsrc + nap + 1
            if(izloc.le.nzo.and.ixloc.ge.1.and.ixloc.le.ntr_out) then
             datao(izloc+(ixloc-1)*nzo) = time*1000.
            endif
           endif
           enddo
          enddo
         endif
        enddo

        tbig = tmax*1000.
        if(noint.eq.0) call fillmap(nzo,ntr_out,datao,tdead,tbig)

c        write out gridded rays for this time block
         ixbias = 1
         do jtrc=1,ntr_out
            call vmov(datao( ixbias+nzo*(jtrc-1) ),1,rtrd,1,num_smp)
            if(nzst(jtrc).gt.1) then
             do jz=1,nzst(jtrc)
              rtrd(jz) = tmax*1000.
             enddo
            endif

            if(isec.ne.0) then
             do jz=1,num_smp
              rtrd(jz) = rtrd(jz)/1000.
             enddo
            endif

            call savew(itrh, 'RecNum', jrec, TRCHED)
            call savew(itrh, 'TrcNum', jtrc, TRCHED)
            call savew(itrh, 'StaCor',    0, TRCHED)
            call wrtape(luout,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(0,*)'error in writing output'
                 write(0,*)'rec,trace=',jrec,jtrc
                 stop 75
              endif
         enddo

C      end record loop
       enddo


 
C     Close Seismic Datasets

      call lbclos(luin)
      call lbclos(luout)
 
c     End Of Job

      stop
      End
C***********************************************************************
      subroutine cmdlin(ntap,otap,ipipi,ipipo,ltrm,verbos,hlfap,nrsmp,
     &vmute,angle,xbeg,xend,xinc,dt,nt,nang,zsrc,ismoo,tmax,ntskip,
     &isec,noint)
      integer argis
      logical help,verbos
      character*128 ntap,otap
      help  = (argis( '-h' ).gt.0) .OR. (argis( '-?').gt.0)
      if(help)then
      write(ltrm,*)'# GENTIME -  Generate traveltimes'
      write(ltrm,*)'# '
      write(ltrm,*)'#-N[]      .. input velocity dataset '
      write(ltrm,*)'#-O[]      .. output travel times '
      write(ltrm,*)'#-xbeg[]   .. first x location (f or m) '
      write(ltrm,*)'#-xend[]   .. last x location (f or m) '

      write(ltrm,*)
     &  '#-xinc[]   .. x inc between travel time maps (f or m)'

      write(ltrm,*)'#-hlfap[]  .. half aperture (ft or m)'
      write(ltrm,*)'#-zsrc[]   .. depth of source (def=0) '
      write(ltrm,*)'#-vmute[]  .. muting velocity (def=use rays)'
      write(ltrm,*)'#-ang[]    .. max emergence angle (deg) (def=45)'
      write(ltrm,*)'#-dang[]   .. angle increment (deg)  (def=0.5)'
      write(ltrm,*)'#-nrsmp[]  .. max ray interpolation inc (def=50)'
      write(ltrm,*)'#-tray []  .. max 2-way time(ms) (def=4000)'
      write(ltrm,*)'#-dtray[]  .. ray-trace dt incr (ms) (def=2)'
      write(ltrm,*)'#-ismoo[]  .. # times to smooth model (def=0)'
      write(ltrm,*)'#-isec[]   .. set > 0, for ttmaps to be in secs'
      stop
      endif

      call argstr('-N',NTAP,' ',' ')
      call argstr('-O',OTAP,' ',' ')
      call argr4  ('-xbeg', xbeg, 0.0, 0.0)
      call argr4  ('-xinc', xinc, 0.0, 0.0)
      call argr4  ('-xend', xend, 0.0, 0.0)
      call argr4  ('-zsrc', zsrc, 0.0, 0.0)
      call argr4  ('-vmute', vmute, 0.0, 0.0)
      call argr4  ('-ang', angle, 45.0, 45.0)
      call argr4  ('-hlfap', hlfap, 2000.0, 2000.0)
      call argr4  ('-dang', dangle, 1.0, 1.0)
      call argi4 ('-nrsmp',nrsmp,0,0)
      call argi4  ('-isec',isec,1,0)
      call argi4  ('-noint',noint,1,0)
c     this parameter is hidden from the user
      call argi4 ('-ntskip',ntskip,4,4)
      if(nrsmp.le.0) nrsmp=0
      call argr4  ('-dtray', dtray, 2.0, 2.0)
      call argr4  ('-tray', tray, 4000.0, 4000.0)
      call argi4 ('-ismoo',ismoo,0,0)
      nang = ifix(abs(angle/dangle))
      if(nang.lt.1) nang=1
cdan  tmax   = tray/2000.
      tmax   = tray/1000.
      dt     = dtray/1000.
      nt     = tmax/dt
      verbos = (argis( '-V' ).GT.0)
c
c     set pipe flags (0=no pipe,1=pipe)
      ipipi=0
      ipipo=0
      if(ntap.eq.' ' ) ipipi=1
      if(otap.eq.' ' ) ipipo=1
c
      RETURN
      END
c
      subroutine rkrayx (nzmax, nxmax, nrmax, ntmax, nz, nx, nray, nt,
     &                   ntskip, dz, dx, dt, v, ismoo, vdsz, vdsx, vdt,
     &                   init, theta, zray, xray, pray, prtol,
     &                   zrjct,xrjct)                         
c
c     FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA -- RUNGE-KUTTA
c     N. D. Whitmore

c     MAXIMUM DIMENSIONS:
c             maxtab = max # entries in cos/sin table   - declared
      integer maxtab
      parameter (maxtab = 240001)
c             nzmax  = max # nz                         - input
      integer nzmax
c             nxmax  = max # nx                         - input
      integer nxmax
c             ntmax  = max # nt                         - input
      integer ntmax
c             nrmax  = max # of rays                    - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction        - input
      integer nx
c             nz = max # of nodes in z direction        - input
      integer nz
c             nray = # of rays to trace                 - input
      integer nray
c             nt = # time steps                         - input
      integer nt
c             ntskip = output time increment            - input
      integer ntskip

c     GRID SIZES:
c             dz = z grid spacing                       - input
      real    dz
c             dx = x grid spacing                       - input
      real    dx
c             dt = time increment                       - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model            - input

      real    v(nzmax,nxmax)
c             ismoo = # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt   - computed
      real    vdsx(nzmax,nxmax)
c             vdsz  = v*v * partial(d( 1/v )/dz) * dt   - computed
      real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                           - computed
      real    vdt(nzmax,nxmax)
c             init   = initialization flag              - input
c                    = 0 intialize vdsx, vdsz, vdt
c                    = 1 do not intialize vdsx, vdsz, vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                    - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt   - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt   - input / output
              real zray(nrmax,ntmax)

c     CONSTANT ANGLE RAY PARAMETER AND TOLERANCE
c             pray  = ray parameter                     - input
      real    pray
c             prtol = ray parameter tolerance           - input
      real    prtol
c             zrjct = z spacing for purging rays        - input
      real    zrjct
c             xrjct = x spacing for purging rays        - input
      real    xrjct

c     LOCAL DECLARATIONS (assume that:  max # rays < 15000)
      real   wcos(15000), wsin(15000), work(15000)
      data wcos/15000*0./, wsin/15000*0./, work/15000*0./
      save wcos, wsin
c
      integer ierr
      real*8  cstab(maxtab+5), xmax, xmin, dmy
      save cstab, first, xmax, xmin, dmy, ierr
      logical first

      data first / .true. /, dmy / 0. /, ierr / 0 /
      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c
c     program outline:
c
c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)
c
c     1. initialize starting parameters
c        a. find starting node indices
c        b. table starting sin, cos
c
c     2. loop over time steps, at each time step
c      a. compute node indices of previous ray endpoints
c      b. gather vdt->work
c      c. compute dtheta, thetmp
c         dtheta = cos(theta(n-1))*vdsx - sin(theta(n-1))*vdsz
c      b. gather cos(thetmp)->wcos sin(thetmp)->wsin
c      d. compute temp wavefronts
c         XT(t(n)) = X(t(n-1)) + sin( thetmp )*Vdt
c         ZT(t(n)) = Z(t(n-1)) + cos( thetmp )*Vdt
c      e. compute temp node indices
c      f. compute Runge-Kutta update of theta
c      g. gather cos(theta)->wcos sin(theta)->wsin
c      h. update wavefront with an Euler recursion:
c         X(t(n)) = X(t(n-1)) + sin(theta(n))*Vdt
c         Z(t(n)) = Z(t(n-1)) + cos(theta(n))*Vdt
c     end time step loop
c
c-----------------------------------------------------------------------
c
c  if first entry to this routine, build cos/sin table
c
      if (first) then
         first = .false.
         xmax  =  3.0 * pi
         xmin  = -3.0 * pi
         call gcftlp (dmy, dmy, 0, maxtab, xmin, xmax, 1, cstab, ierr)
      endif

c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)

      if (init .eq. 0) then
         dtray = dt * ntskip
         if (ismoo .gt. 0) then
            do 110 jsmoo = 1, ismoo
               call smoothk (v, vdt, nz, nx, nzmax, nxmax)
  110       continue
         endif

c        interior dsz

         do 125 j2 = 1, nx
            do 120 j1 = 2, nz-1
               temp        = 1.0 / v(j1+1,j2) - 1.0 / v(j1-1,j2)
               vdsz(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dz  * dtray
  120       continue
  125    continue

         if (ismoo .gt. 0) then
            do 130 jsmoo = 1, ismoo
               call zsmoo (vdsz, vdt, nz, nx, nzmax, nxmax)
  130       continue
         endif

c        interior dsx

         do 145 j2 = 2, nx-1
            do 140 j1 = 1, nz
               temp        = 1.0 / v(j1,j2+1) - 1.0 / v(j1,j2-1)
               vdsx(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dx * dtray
  140       continue
  145    continue

         if (ismoo .gt. 0) then
            do 150 jsmoo = 1, ismoo
               call xsmoo (vdsx, vdt, nz, nx, nzmax, nxmax)
  150       continue
         endif

c        compute vdt

         do 165 j2 = 2, nx-1
            do 160 j1 = 1, nz-1
               vdt(j1,j2) = v(j1,j2) * dtray
  160       continue
  165    continue

c        set vdsx and vdsz and vdt on model edges

         do 180 j1 = 1, nzmax
            vdt(j1,1)   = vdt(j1,2)
            vdt(j1,nx)  = vdt(j1,nx-1)
            vdsx(j1,1)  = vdsx(j1,2)
            vdsx(j1,nx) = vdsx(j1,nx-1)
  180    continue

         do 190 j2 = 1, nx
            vdt(nzmax,j2)  = vdt(nzmax-1,j2)
            vdt(1,j2)      = vdt(2,j2)
            vdsz(1,j2)     = vdsz(2,j2)
            vdsz(nz,j2)    = vdsz(nz-1,j2)
  190    continue

c        reset init

         init = 1
      endif

c     1. initialize starting parameters
c     a. find starting node indices

      dtray  = dt * ntskip
      prdt   = pray / dtray
      dxover = 1.0 / dx
      dzover = 1.0 / dz


c     gather cos(theta)->wcos sin(theta)->wsin

      call ccftlp (cstab, theta, 1, wcos, wsin, 1, nray, 0, ierr)

c     2. loop over time steps
c
c     compute number of time steps

      nt1 = (nt + ntskip) / ntskip * ntskip

      jtkont = 0
      do 220 jt = 1+ntskip, nt1+ntskip, ntskip
         jtkont = jtkont + 1

         call rkrayn (nrmax, nzmax, nray, ntskip, jt, 
     &                 dxover, dzover, vdsx, vdsz, vdt, cstab, 
     &                 theta, wcos, wsin, work, xray, zray, nxmax)

c        d. purge rays that are not within prtol of a Snell ray
c           (discard if sin(theta) is not close to pray*V)

c        if (prtol .gt. 0.0) then
c           if ((jtkont/8)*8 .eq. jtkont) then
c              do 210 j = 1, nray
c                 if (abs( wsin(j) - prdt * work(j) ) .gt. prtol ) then
c                    xray(j,jt) = 0.51*xrjct
c                    zray(j,jt) = 0.51*zrjct
c                 endif
c 210          continue
c           endif
c        endif

c     end time step loop
  220 continue

c     Interpolate ntskip time steps

      if (ntskip .gt. 1) then
         do 330 jt = 1, nt1, ntskip
            do 320 jt1 = 1, ntskip-1
               beta  = float( jt1 ) / float( ntskip )
               alpha = 1.0 - beta
               do 310 j = 1, nray
                  xray(j,jt+jt1) = alpha * xray(j,jt) +
     &                             beta  * xray(j,jt+ntskip)
                  zray(j,jt+jt1) = alpha * zray(j,jt) +
     &                             beta  * zray(j,jt+ntskip)
  310          continue
  320       continue
  330    continue

      endif

c     end time interpolation

      return
      end
      subroutine xsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      integer jx, jz

c-----------------------------------------------------------------------

      scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz,jx-1) + a(jz,jx) + a(jz,jx+1) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end
      subroutine smoothk (v, slow, nz, nx, nzmax, nxmax)

C     CALCULATES A 9 POINT RECIPROCAL SMOOTHING OF A VELOCITY MATRIX
C     INPUT  V  - VELOCITY MATRIX
C     OUTPUT V  - SMOOTHED VELOCITY MATRIX
C     WORKSPACE SLOW

      implicit none
      integer nzmax, nxmax, nz, nx
      real v(nzmax,nxmax), slow(nzmax,nxmax)

      real scale
      integer jx, jz
c
c-----------------------------------------------------------------------
c
      scale = 1.0 / 9.0

      do 20 jx = 2, nx-1
         do 10 jz = 2, nz-1
            slow(jz,jx) =
     &         scale *
     &         ( 1.0/v(jz-1,jx-1) + 1.0/v(jz,jx-1) + 1.0/v(jz+1,jx-1)
     &         + 1.0/v(jz-1,jx  ) + 1.0/v(jz,jx  ) + 1.0/v(jz+1,jx  )
     &         + 1.0/v(jz-1,jx+1) + 1.0/v(jz,jx+1) + 1.0/v(jz+1,jx+1)  )
   10    continue
   20 continue

      do 40 jx = 2, nx-1
         do 30 jz = 2, nz-1
            v(jz,jx) = 1.0 / slow(jz,jx)
   30    continue
   40 continue

       return
       end
      subroutine zsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      implicit none
      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      integer jx, jz

c-----------------------------------------------------------------------

      scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz-1,jx) + a(jz,jx) + a(jz+1,jx) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end

C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C NAME: CFTLP     COMPLEX FUNCTION TABLE LOOK-UP       REV 2.0  APR 92 *
C***********************************************************************
C
C  PURPOSE:                                                            *
C       FINDS A VECTOR OF VALUES OF A COMPLEX VALUED FUNCTION OF A     *
C       REAL VARIABLE BY MEANS OF A TABLE LOOK-UP.                     *
C                                                                      *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/07/23  *
C        1  2 VERSION:  1 -2 ASSEMBLY LANGUAGE                         *
C        1  XEA VERSION:  1  FORTRAN 77 (CFT77)                        *
C       OTHERS: FORTAN 77                                              *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 90          R.D. COLEMAN, QTC      *
C       REVISION 2.0            APR 92          T.C. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  CFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)         *
C       CALL CCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)         *
C       CALL XCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)         *
C                                                                      *
C  PARAMETERS:                                                         *
C       TABLE   WORD INPUT VECTOR OF IMPLIED LENGTH                    *
C               TABLE OF PACKED VALUES AND PARAMETERS:                 *
C                 WORD  FORMAT   CONTENTS                              *
C                    1  INTEGER  NTAB   - TOTAL LENGTH OF TABLE        *
C                    2  REAL     SCALE  - INDEX SCALE FACTOR           *
C                    3  REAL     OFFSET - INDEX OFFSET VALUE           *
C                    4  REAL     XMIN   - MINIMUM VALID ARGUMENT       *
C                    5  REAL     XMAX   - MAXIMUM VALID ARGUMENT       *
C               6:NTAB  PACKED   COMPLEX FUNCTION VALUES               *
C                                                                      *
C       X       REAL INPUT VECTOR OF LENGTH N                          *
C               SOURCE VECTOR                                          *
C                                                                      *
C       IX      INTEGER INPUT SCALAR                                   *
C               STRIDE OF VECTOR X                                     *
C                                                                      *
C       ZR      REAL OUTPUT VECTOR OF LENGTH N                         *
C               REAL COMPONENT OF RESULT VECTOR                        *
C                                                                      *
C       ZI      REAL OUTPUT VECTOR OF LENGTH N                         *
C               IMAGINARY COMPONENT OF RESULT VECTOR                   *
C                                                                      *
C       IZ      INTEGER INPUT SCALAR                                   *
C               STRIDE OF VECTORS ZR AND ZI                            *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               LENGTH OF VECTORS X, ZR, AND ZI.                       *
C                                                                      *
C       ICFLG   INTEGER INPUT SCALAR                                   *
C               CONJUGATE FLAG:                                        *
C                  = 0  FUNCTION VALUE RETURNED                        *
C                 != 0  CONJUGATE OF FUNCTION VALUE RETURNED           *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               COMPLETION CODE.  VALUES ARE:                          *
C                  0 - NORMAL COMPLETION                               *
C                  1 - ONE OR MORE INPUT VALUES ARE LESS THAN XMIN     *
C                  2 - ONE OR MORE INPUT VALUES ARE GREATER THAN XMAX  *
C                  3 - BOTH CONDITIONS 1 AND 2 OCCURRED.               *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THIS ROUTINE FINDS A VECTOR OF VALUES OF A COMPLEX VALUED      *
C       FUNCTION OF A REAL VARIABLE BY MEANS OF A TABLE LOOK-UP.       *
C       THE FUNCTION IS OF THE FORM Z = F(X), WHERE X IS REAL AND Z IS *
C       COMPLEX.  THE TABLE CONTAINS N = NTAB-5 VALUES OF THE FUNCTION *
C       CORRESPONDING TO N EQUALLY SPACED VALUES OF X BETWEEN XMIN AND *
C       XMAX, INCLUSELY. THE REAL AND IMAGINARY COMPONENTS OF EACH     *
C       COMPLEX VALUE ARE PACKED INTO A SINGLE 64-BIT WORD.  THE REAL  *
C       COMPONENT IS CONTAINED IN THE MOST SIGNIFICANT 32 BITS AND THE *
C       IMAGINARY COMPONENT IS CONTAINED IN THE LEAST SIGNIFICANT 32   *
C       BITS.  THE FORMAT OF EACH COMPONENT IS THE SAME AS THE  1      *
C       REAL FORMAT EXCEPT THAT THE MANTISSA IS 16 BITS INSTEAD OF 48  *
C       BITS.                                                          *
C                                                                      *
C       FOR EACH ELEMENT OF THE SOURCE VECTOR, X(J), A TABLE INDEX IS  *
C       CALCULTED: I = IFIX( SCALE * X(J) + OFFSET ).   IF X(J) < XMIN,*
C       THEN I IS SET TO THE FIRST TABLE ENTRY (6) AND BIT 0 OF IERR IS*
C       SET TO 1.  IF X(J) > XMAX, THEN I IS SET TO THE LAST TABLE ENTR*
C       (NTAB) AND BIT 1 OF IERR IS SET TO 1.  TABLE(I) IS THEN UNPACKE*
C       AND THE REAL AND IMAGINARY CONPONENTS PLACED IN ZR(J) AND ZI(J)*
C       RESPECTIVELY.                                                  *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       CFT77 INTRINSICS: AND, SHIFTL (IN  1  VERSIONS ONLY)           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF ANY ELEMENT OF THE SOURCE VECTOR HAS A VALUE OUTSIDE THE    *
C       VALID RANGE, THEN THE APPROPRIATE COMPLETION CODE IS SET (SEE  *
C       ABOVE), A DEFAULT RESULT IS SUPPLIED (SEE ABOVE), AND PROCESSIN*
C       CONTINUES.                                                     *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
      SUBROUTINE  CFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)
      ENTRY      CCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)
      ENTRY      XCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)
C
C  PARAMETERS:
C
      INTEGER IX, IZ, N, ICFLG, IERR
      REAL    X(*), ZR(*), ZI(*)
#ifdef CRAY
      REAL    TABLE(*)
#else
      REAL*8  TABLE(*)
#endif
C
C  LOCAL VARIABLES:
C
      INTEGER NTAB, I, J, JX, JZ
      REAL    SCALE, OFFSET, XMIN, XMAX, SGN
      LOGICAL LO, HI, ERRLO, ERRHI
C
#ifdef CRAY
      INTEGER MASK
      REAL    XNTAB, TABI
C
      EQUIVALENCE (NTAB, XNTAB)
C
      PARAMETER (MASK = x'FFFFFFFF00000000')
#else
      REAL    TABI2(2)
      REAL*8  TABI, XNTAB
C
      EQUIVALENCE (TABI, TABI2), (NTAB, XNTAB)
#endif
C
C-----------------------------------------------------------------------
C
      IERR = 0
      IF (N .LE. 0) RETURN
C
      XNTAB  = TABLE(1)
      SCALE  = TABLE(2)
      OFFSET = TABLE(3)
      XMIN   = TABLE(4)
      XMAX   = TABLE(5)
C
      IF (ICFLG .EQ. 0) THEN
         SGN = 1.0
      ELSE
         SGN = -1.0
      ENDIF
C
      ERRLO = .FALSE.
      ERRHI = .FALSE.
      JX    = 1
      JZ    = 1
      DO 110 J = 1, N
         LO    = X(JX) .LT. XMIN
         HI    = X(JX) .GT. XMAX
         ERRLO = ERRLO .OR. LO
         ERRHI = ERRHI .OR. HI
C
         I = IFIX( SCALE * X(JX) + OFFSET )
#ifdef CRAY
         I = CVMGT(    6, I, LO )
         I = CVMGT( NTAB, I, HI )
#else
         IF( LO ) I = 6
         IF( HI ) I = NTAB
#endif
C
         TABI   = TABLE(I)
#ifdef CRAY
         ZR(JZ) = AND( TABI, MASK )
         ZI(JZ) = SHIFTL( TABI, 32 ) * SGN
#else
         ZR(JZ) = TABI2(1)
         ZI(JZ) = TABI2(2) * SGN
#endif
C
         JX = JX + IX
         JZ = JZ + IZ
  110 CONTINUE
C
      IF (ERRLO) IERR = IERR + 1
      IF (ERRHI) IERR = IERR + 2
      RETURN
      END
 
