C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GSCL                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:       PROGRAM GSCL IS A GENERALIZED SCALING PROGRAM        *
C                 THE FIRST OPTION WILL SCAL BY A CONSTANT USER INPUT  *
C                 VALUE  - 1 OVER T(TIME) TO A USER SPECIFIED VALUE.   *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:    lajuanta young                  ORIGIN DATE:  83/03/14   *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/12/12  *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/08/19  *
C            - ADDED ABILITY TO ENTER COMMAND LINE ARGUMENTS AND       *
C            - AND A PID-TAGGED PRINTOUT                               *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/10/05  *
C            - ALLOW ALL PARAMETERS INPUT ON COMMAND LINE OR A CARD    *
C            - FILE IF PARAMETERS ARE MISSING                          *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 87/12/16  *
C            - ADDED PRINTOUT CORRELATION AND JOB ACCOUNTING           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/05/05  *
C            - CALL HLHPRT, ICOPEN, USE NEW LIBRARIES, ETC.            *
C            - MAKE SURE ALL FILES OPENED CORRECTLY                    *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/06/15  *
C            - make the defaults to be scale all the records.  when    *
C            - doing selective record/trace scaling, the records must  *
C            - be in the proper order coming in                        *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/06/15  *
C            - Move code to sun to maintain & distribute from sun      *
C  REVISED BY:  MARY ANN THORNTON   V: 2.1    REVISION DATE: 92/03/02  *
C            - Remove saver,savew calls from inside trace loops        *
C            - Call openpr with full program name for OS 6.1           *
C            - Corrected bug found when using -J and -I on the command
C            - line.
C  REVISED BY:  MARY ANN THORNTON   V: 2.2    REVISION DATE: 92/04/22  *
C            - initialize ibeg,iend before using                       *
C  REVISED BY:  MARY ANN THORNTON   V: 2.3    REVISION DATE: 92/07/01  *
C            - move zeroes in when a trace is dead before writing it   *
c  REVISED BY:  MARY ANN THORNTON   V: 2.4    REVISION DATE: 93/05/18  *
C            - Change line header size, add logical unit for HP, add to*
C            - help information
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:                                                     *
C  GENERAL DESCRIPTION:                                                *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
      PARAMETER (LPRT = 26, LCRD = 25, LLIST=27)
      PARAMETER (MXSMP = 6000, MXTOT = 6000+ITRWRD)

      DIMENSION RXX(MXTOT),DATA(MXSMP),OUTPUT(MXTOT)
      DIMENSION SCAL(MXSMP),OUTDAT(MXSMP)
      INTEGER IHEAD(SZLNHD)
      INTEGER*2 IRX(LNTRHD), IRXO(LNTRHD)

      LOGICAL VERBOS
      CHARACTER*128 NTAP,OTAP,INPUT
      CHARACTER*4  VERSION
      CHARACTER*4  PPNAME

      CHARACTER*1  PARR(66)
      CHARACTER*1  NAME(35)
      CHARACTER*1  CARD(80)
      CHARACTER * 80 CRDD

      EQUIVALENCE (RXX(1),IRX(1))
      EQUIVALENCE (RXX(ITHWP1),DATA(1))
      EQUIVALENCE (OUTPUT(ITHWP1),OUTDAT(1))
      EQUIVALENCE (OUTPUT(1),IRXO(1))
      EQUIVALENCE (CARD(1),CRDD)

      DATA  PARR/6*' ','G','S','C','L',' ',
     1' ','G','E','N','E','R','A','L','I','Z','E','D',' ','S','C',
     2'A','L','I','N','G',' ','P','R','O','G','R','A','M',' ',' ',' ',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4' ',' ',' ',6*' '/
      DATA NAME/'G','S','C','L','(','S','C','A','L','A','R','S',' ',
     1'=',' ',' ',' ',' ',' ',' ',',',' ',' ',' ',' ',' ',',',' ',' ',
     2' ',' ',' ',' ',' ',')'/

      DATA VERSION/' 2.4'/
      DATA PPNAME/'GSCL'/

      LTRM = ler
      CALL cmdlin(NTAP,OTAP,INPUT,IPIPI,IPIPO,LTRM,VERBOS,
     1ALPHA,XMULT,EXPNT,IRI,NRI)
      IF(IPIPI.EQ.0)THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN = 0
         LTRM = 2
      ENDIF
      IF(IPIPO.EQ.0)THEN
C        LUOUT IS A OUTPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        LUOUT IS A PIPE
         LUOUT = 1
      ENDIF
C***********************************************************************
C     OPEN PRINTOUT
C     CALL GAMOCO
C     READ INPUT CARDS WITH ICOPEN IF THERE ARE INPUT CARDS
C***********************************************************************
C     OPEN PRINT FILE
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)THEN
         WRITE(LPRT,*)' ERROR OPENING PRINTOUT'
         STOP 200
      ENDIF
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      IBEG = 0
      IEND = 0
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      N = ICOPEN('-gscl.crd',LCRD)
      IF(N.NE.0)THEN
         READ(LCRD,5001)CARD
 5001    FORMAT(80A1)
         READ(LCRD,5002)ALPHA,XMULT,EXPNT,IBEG,IEND
 5002    FORMAT(F10.0,F6.0,F6.0,I9,I10)
      ENDIF
C***********************************************************************
C     READ INPUT SIS LINE HEADER
C***********************************************************************
      IEOF=0
      CALL RTAPE(LUIN,IHEAD,IEOF)
      IF(IEOF.NE.0)GO TO 707
      WRITE(LPRT,779)
  779 FORMAT(1X,'BAD READ ON INPUT LINEIHEADER')
      GO TO 999
  707 CONTINUE
      CALL SAVER(IHEAD, 'NumTrc', NTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', NREC, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', NSAMP, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'Format', IFORM, LINHED)
      NBYTES = (NSAMP + ITRWRD) * ISZBYT
C***********************************************************************
C                    UPDATE HISTORICAL LINE IHEADER                *****
C                    INITIALIZE SIS ACCOUNTING                     *****
C                    WRITE OUTPUT LINE IHEADER                     *****
C***********************************************************************
C * * * SET VALUES IN LINEIHEADER NAME ARRAY TO PRINT SCALAR VALUES
      NAME(16) = CARD(6)
      NAME(17) = CARD(7)
      NAME(18) = CARD(8)
      NAME(19) = CARD(9)
      NAME(20) = CARD(10)
      NAME(22) = CARD(11)
      NAME(23) = CARD(12)
      NAME(24) = CARD(13)
      NAME(25) = CARD(14)
      NAME(26) = CARD(15)
      NAME(28) = CARD(16)
      NAME(29) = CARD(17)
      NAME(30) = CARD(18)
      NAME(31) = CARD(19)
      NAME(32) = CARD(20)
C * * * * SET DEFAULTS
      IF(ALPHA .EQ. 0.)ALPHA = 0.
      IF(XMULT .EQ. 0.)XMULT = 1.
C     IRI and NRI can be command line arguments,or they can be picked
C     up from the input cards with IBEG and IEND.
      IF(IBEG .NE. 0)IRI = IBEG
      IF(IEND .NE. 0)NRI = IEND
      IF(IRI.le.0 .or. IRI.gt.NREC)IRI = 1
      IF(NRI.le.0)NRI = NREC
      IF(NRI.GT.NREC)NRI=NREC

      CALL SAVEW(IHEAD, 'NumRec', (NRI-IRI+1), LINHED)
      LEN = 35
      CALL HLHPRT(IHEAD,IEOF,NAME,LEN,LPRT)
      CALL WRTAPE (LUOUT, IHEAD, IEOF )

      WRITE(LPRT,32) ALPHA,XMULT,EXPNT,IRI,NRI
   32 FORMAT (/////, 27X, 'PROGRAM PARAMETERS',//,
     *' TIME EXPONENT                          ', 10X,'=', F10.3, //,
     *' CONSTANT MULTIPLIER                    ', 10X,'=', F10.3, //,
     *' EXPONENT FOR POWER OF 10 MULTIPLIER    ', 10X,'=', F10.3, //,
     *' STARTING RECORD TO PROCESS             ', 10X,'=', I10, //,
     *' ENDING RECORD TO PROCESS               ', 10X,'=', I10, //)

C***********************************************************************
C                      BUILD VECTOR FOR SCALING                    *****
C***********************************************************************
      DT = FLOAT(ISI)/1000.
      ACON = XMULT * DT ** (-ALPHA)
      DO 89 IVEC = 1,NSAMP
         TEMP = ACON*((IVEC * DT)**ALPHA)
         SCAL(IVEC) = TEMP * (10.**EXPNT)
   89 CONTINUE
      IF(VERBOS)WRITE(LPRT,567)
  567 FORMAT(1X,' SCALE TRACE HAS FOLLOWING VALUES:',/)
      IF(VERBOS)WRITE(LPRT,566)(SCAL(IX),IX=1,NSAMP)
  566 FORMAT(1X,10E10.2)
C***********************************************************************
C                      READ INPUT TRACES                           *****
C***********************************************************************
      CALL VCLR(OUTPUT,1,MXTOT)
      if(iri.gt.1)then
        ntrc = (iri-1)*ntr
C       cray data on tape is ibm-word-sized (4 bytes)
        LBYTES = 4 * NSAMP + 256
        call skipt(luin, ntrc)
      endif
      DO 100 J = IRI,NRI
         write(lprt,777)J
         DO 101 I = 1,NTR
            JEOF=0
            CALL RTAPE(LUIN,RXX,JEOF)
            CALL VMOV(IRX,1,IRXO,1,ITRWRD)
            IF(IRX(125) .EQ. 30000) then      
               call vclr(data,1,nsamp)
               go to 103
            endif
            CALL VMUL(DATA,1,SCAL,1,OUTDAT,1,NSAMP)
  103       CONTINUE
            CALL WRTAPE(LUOUT,OUTPUT,NBYTES)
  101    CONTINUE
  777    FORMAT(5X,/,' PROCESSING R.I. ',I5)
  100 CONTINUE
  708 CONTINUE
  999 CONTINUE
      WRITE(LPRT,45)
   45 FORMAT(1X,'  END OF JOB ')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,OTAP,INPUT,IPIPI,IPIPO,LTRM,VERBOS,ALPHA,XMULT,    *
C              EXPNT,IRI,NRI)                                          *
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,OTAP,INPUT,IPIPI,IPIPO,LTRM,VERBOS,
     1ALPHA,XMULT,EXPNT,IRI,NRI)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER *128 NTAP,OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--GENERALIZED SCALING'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap] .. INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap] .. OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-A[alpha].. TIME EXPONENT-Default is .5'
         WRITE(LTRM,*)'-X[XMULT].. CONSTANT MULTIPLIER-Default is 1.'
         WRITE(LTRM,*)'         .. (Gain curve value at 1 second    '
         WRITE(LTRM,*)'-E[expnt].. EXPONENT FOR POWER OF 10 MULTIPLIER'
         WRITE(LTRM,*)'            (for exponential gain curve)'
         WRITE(LTRM,*)'            Default is 0.'
         WRITE(LTRM,*)'-I[iri]  .. STARTING RECORD-Default is 1'
         WRITE(LTRM,*)'-J[nri]  .. ENDING RECORD-Default is all'
         WRITE(LTRM,*)'-V       .. VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'gscl -N[] -O[] -A[] -X[] -E[] -I[] -J[] -V'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGR4 ('-A',ALPHA,0.5,0.5)
      CALL ARGR4 ('-X',XMULT,1.0,1.0)
      CALL ARGR4 ('-E',EXPNT,0.0,0.0)
      CALL ARGI4 ('-I',IRI,1,1)
      CALL ARGI4 ('-J',NRI,0,0)
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
